/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.thrift.TException;

public class TestHiveMetaStoreChecker
extends TestCase {
    private Hive hive;
    private FileSystem fs;
    private HiveMetaStoreChecker checker = null;
    private final String dbName = "testhivemetastorechecker_db";
    private final String tableName = "testhivemetastorechecker_table";
    private final String partDateName = "partdate";
    private final String partCityName = "partcity";
    private List<FieldSchema> partCols;
    private List<Map<String, String>> parts;

    protected void setUp() throws Exception {
        super.setUp();
        this.hive = Hive.get();
        this.checker = new HiveMetaStoreChecker(this.hive);
        this.partCols = new ArrayList<FieldSchema>();
        this.partCols.add(new FieldSchema("partdate", "string", ""));
        this.partCols.add(new FieldSchema("partcity", "string", ""));
        this.parts = new ArrayList<Map<String, String>>();
        HashMap<String, String> part1 = new HashMap<String, String>();
        part1.put("partdate", "2008-01-01");
        part1.put("partcity", "london");
        this.parts.add(part1);
        HashMap<String, String> part2 = new HashMap<String, String>();
        part2.put("partdate", "2008-01-02");
        part2.put("partcity", "stockholm");
        this.parts.add(part2);
        this.dropDbTable();
    }

    private void dropDbTable() {
        try {
            this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
            this.hive.dropDatabase("testhivemetastorechecker_db", true, true, true);
        }
        catch (NoSuchObjectException e) {
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        this.dropDbTable();
        super.tearDown();
        Hive.closeCurrent();
    }

    public void testTableCheck() throws HiveException, MetaException, IOException, TException, AlreadyExistsException {
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getTablesNotInMs().size());
        TestHiveMetaStoreChecker.assertEquals((String)"testhivemetastorechecker_table", (String)((String)result.getTablesNotInMs().get(0)));
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(table.getPath(), true);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getTablesNotOnFs().size());
        TestHiveMetaStoreChecker.assertEquals((String)"testhivemetastorechecker_table", (String)((String)result.getTablesNotOnFs().get(0)));
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        this.fs.mkdirs(table.getPath());
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getTablesNotInMs().size());
        TestHiveMetaStoreChecker.assertEquals((String)fakeTable.getName(), (String)((String)result.getTablesNotInMs().get(0)));
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setProperty("EXTERNAL", "TRUE");
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
    }

    public void testPartitionsCheck() throws HiveException, MetaException, IOException, TException, AlreadyExistsException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        for (Map<String, String> partSpec : this.parts) {
            this.hive.createPartition(table, partSpec);
        }
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        List partitions = this.hive.getPartitions(table);
        TestHiveMetaStoreChecker.assertEquals((int)2, (int)partitions.size());
        Partition partToRemove = (Partition)partitions.get(0);
        Path partToRemovePath = partToRemove.getDataLocation();
        this.fs = partToRemovePath.getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(partToRemovePath, true);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getPartitionsNotOnFs().size());
        TestHiveMetaStoreChecker.assertEquals((String)partToRemove.getName(), (String)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().get(0)).getPartitionName());
        TestHiveMetaStoreChecker.assertEquals((String)partToRemove.getTable().getTableName(), (String)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().get(0)).getTableName());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        ArrayList<LinkedHashMap> partsCopy = new ArrayList<LinkedHashMap>();
        partsCopy.add(((Partition)partitions.get(1)).getSpec());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", partsCopy, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        this.fs.mkdirs(partToRemovePath);
        Path fakePart = new Path(table.getDataLocation().toString(), "fakepartition=fakevalue");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getPartitionsNotInMs().size());
        TestHiveMetaStoreChecker.assertEquals((String)fakePart.getName(), (String)((CheckResult.PartitionResult)result.getPartitionsNotInMs().get(0)).getPartitionName());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptyList(), (Object)result.getPartitionsNotInMs());
        System.err.println("Test completed - partition check");
    }

    public void testDataDeletion() throws HiveException, MetaException, IOException, TException, AlreadyExistsException, NoSuchObjectException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs = fakeTable.getFileSystem((Configuration)this.hive.getConf());
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        Path fakePart = new Path(table.getDataLocation().toString(), "fakepartition=fakevalue");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        TestHiveMetaStoreChecker.assertFalse((boolean)this.fs.exists(fakePart));
        this.hive.dropDatabase("testhivemetastorechecker_db");
        TestHiveMetaStoreChecker.assertFalse((boolean)this.fs.exists(fakeTable));
    }
}

