/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Before;
import org.junit.Test;

public class TestVectorizedORCReader {
    private Configuration conf;
    private FileSystem fs;
    private Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.fs.setWorkingDirectory(workDir);
        this.testFilePath = new Path("TestVectorizedORCReader.testDump.orc");
        this.fs.delete(this.testFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createFile() throws Exception {
        Class<TestVectorizedORCReader> clazz = TestVectorizedORCReader.class;
        synchronized (TestVectorizedORCReader.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            String[] dates = new String[]{"1991-02-28", "1970-01-31", "1950-04-23"};
            String[] decimalStrings = new String[]{"234.443", "10001000", "0.3333367", "67788798.0", "-234.443", "-10001000", "-0.3333367", "-67788798.0", "0"};
            for (int i = 0; i < 21000; ++i) {
                if (i % 7 != 0) {
                    writer.addRow((Object)new MyRecord(i % 3 == 0, (byte)(i % 5), i, 200L, (short)(300 + i), Double.valueOf(400 + i), words[r1.nextInt(words.length)], new Timestamp(Calendar.getInstance().getTime().getTime()), Date.valueOf(dates[i % 3]), HiveDecimal.create((String)decimalStrings[i % decimalStrings.length])));
                    continue;
                }
                writer.addRow((Object)new MyRecord(null, null, i, 200L, null, null, null, null, null, null));
            }
            writer.close();
            this.checkVectorizedReader();
            return;
        }
    }

    private void checkVectorizedReader() throws Exception {
        Reader vreader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
        RecordReaderImpl vrr = (RecordReaderImpl)vreader.rows();
        RecordReaderImpl rr = (RecordReaderImpl)reader.rows();
        VectorizedRowBatch batch = null;
        OrcStruct row = null;
        while (vrr.hasNext()) {
            batch = vrr.nextBatch(batch);
            for (int i = 0; i < batch.size; ++i) {
                row = (OrcStruct)rr.next(row);
                for (int j = 0; j < batch.cols.length; ++j) {
                    Object a = row.getFieldValue(j);
                    Writable b = batch.cols[j].getWritableObject(i);
                    if (a instanceof BooleanWritable) {
                        Long temp = ((BooleanWritable)a).get() ? 1 : 0;
                        Assert.assertEquals((boolean)true, (boolean)temp.toString().equals(b.toString()));
                        continue;
                    }
                    if (a instanceof TimestampWritable) {
                        TimestampWritable t = (TimestampWritable)a;
                        Long timeInNanoSec = t.getTimestamp().getTime() * 1000000L + (long)(t.getTimestamp().getNanos() % 1000000);
                        Assert.assertEquals((boolean)true, (boolean)timeInNanoSec.toString().equals(b.toString()));
                        continue;
                    }
                    if (a instanceof DateWritable) {
                        DateWritable adt = (DateWritable)a;
                        Assert.assertEquals((long)adt.get().getTime(), (long)DateWritable.daysToMillis((int)((int)((LongWritable)b).get())));
                        continue;
                    }
                    if (a instanceof HiveDecimalWritable) {
                        HiveDecimalWritable dec = (HiveDecimalWritable)a;
                        Assert.assertEquals((Object)dec, (Object)b);
                    }
                    if (null == a) {
                        Assert.assertEquals((boolean)true, (b == null || b instanceof NullWritable ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertEquals((boolean)true, (boolean)b.toString().equals(a.toString()));
                }
            }
            Assert.assertEquals((boolean)false, (boolean)batch.cols[0].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[1].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[2].isRepeating);
            Assert.assertEquals((boolean)true, (boolean)batch.cols[3].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[4].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[5].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[6].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[7].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[8].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[9].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[0].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[1].noNulls);
            Assert.assertEquals((boolean)true, (boolean)batch.cols[2].noNulls);
            Assert.assertEquals((boolean)true, (boolean)batch.cols[3].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[4].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[5].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[6].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[7].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[8].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[9].noNulls);
        }
        Assert.assertEquals((boolean)false, (boolean)rr.hasNext());
    }

    static class MyRecord {
        private final Boolean bo;
        private final Byte by;
        private final Integer i;
        private final Long l;
        private final Short s;
        private final Double d;
        private final String k;
        private final Timestamp t;
        private final Date dt;
        private final HiveDecimal hd;

        MyRecord(Boolean bo, Byte by, Integer i, Long l, Short s, Double d, String k, Timestamp t, Date dt, HiveDecimal hd) {
            this.bo = bo;
            this.by = by;
            this.i = i;
            this.l = l;
            this.s = s;
            this.d = d;
            this.k = k;
            this.t = t;
            this.dt = dt;
            this.hd = hd;
        }
    }
}

