/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.TestSearchArgumentImpl;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class TestRecordReaderImpl {
    private final MockSettings settings = Mockito.withSettings().verboseLogging();

    @Test
    public void testMaxLengthToReader() throws Exception {
        Configuration conf = new Configuration();
        OrcProto.Type rowType = OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).build();
        OrcProto.Footer footer = OrcProto.Footer.newBuilder().setHeaderLength(0L).setContentLength(0L).setNumberOfRows(0L).setRowIndexStride(0).addTypes(rowType).build();
        OrcProto.PostScript ps = OrcProto.PostScript.newBuilder().setCompression(OrcProto.CompressionKind.NONE).setFooterLength((long)footer.getSerializedSize()).setMagic("ORC").addVersion(0).addVersion(11).build();
        DataOutputBuffer buffer = new DataOutputBuffer();
        footer.writeTo((OutputStream)buffer);
        ps.writeTo((OutputStream)buffer);
        buffer.write(ps.getSerializedSize());
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)this.settings);
        FSDataInputStream file = new FSDataInputStream((InputStream)new BufferInStream(buffer.getData(), buffer.getLength()));
        Path p = new Path("/dir/file.orc");
        Mockito.when((Object)fs.open(p)).thenReturn((Object)file);
        OrcFile.ReaderOptions options = OrcFile.readerOptions((Configuration)conf);
        options.filesystem(fs);
        options.maxLength((long)buffer.getLength());
        Mockito.when((Object)fs.getFileStatus(p)).thenReturn((Object)new FileStatus(10L, false, 3, 3000L, 0L, p));
        Reader reader = OrcFile.createReader((Path)p, (OrcFile.ReaderOptions)options);
    }

    @Test
    public void testCompareToRangeInt() throws Exception {
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(19L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(41L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(20L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIDDLE, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(21L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MAX, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(40L), (Object)20L, (Object)40L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(0L), (Object)1L, (Object)1L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(1L), (Object)1L, (Object)1L));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)Long.valueOf(2L), (Object)1L, (Object)1L));
    }

    @Test
    public void testCompareToRangeString() throws Exception {
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"a"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"d"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"b"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIDDLE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"bb"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MAX, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"c"), (Object)"b", (Object)"c"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"a"), (Object)"b", (Object)"b"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"b"), (Object)"b", (Object)"b"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"c"), (Object)"b", (Object)"b"));
    }

    @Test
    public void testCompareToCharNeedConvert() throws Exception {
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"apple"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"zombie"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"hello"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIDDLE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"pilot"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MAX, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"world"), (Object)"hello", (Object)"world"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.BEFORE, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"apple"), (Object)"hello", (Object)"hello"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.MIN, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"hello"), (Object)"hello", (Object)"hello"));
        junit.framework.Assert.assertEquals((Object)RecordReaderImpl.Location.AFTER, (Object)RecordReaderImpl.compareToRange((Comparable)((Object)"zombie"), (Object)"hello", (Object)"hello"));
    }

    @Test
    public void testGetMin() throws Exception {
        junit.framework.Assert.assertEquals((Object)10L, (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 100L))));
        junit.framework.Assert.assertEquals((Object)10.0, (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(10.0).setMaximum(100.0).build()).build())));
        junit.framework.Assert.assertEquals(null, (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().build()).build())));
        junit.framework.Assert.assertEquals((Object)"a", (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().setMinimum("a").setMaximum("b").build()).build())));
        junit.framework.Assert.assertEquals((Object)"hello", (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("hello", "world"))));
        junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"111.1"), (Object)RecordReaderImpl.getMin((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("111.1", "112.1"))));
    }

    private static OrcProto.ColumnStatistics createIntStats(Long min, Long max) {
        OrcProto.IntegerStatistics.Builder intStats = OrcProto.IntegerStatistics.newBuilder();
        if (min != null) {
            intStats.setMinimum(min.longValue());
        }
        if (max != null) {
            intStats.setMaximum(max.longValue());
        }
        return OrcProto.ColumnStatistics.newBuilder().setIntStatistics(intStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createIntStats(int min, int max) {
        OrcProto.IntegerStatistics.Builder intStats = OrcProto.IntegerStatistics.newBuilder();
        intStats.setMinimum((long)min);
        intStats.setMaximum((long)max);
        return OrcProto.ColumnStatistics.newBuilder().setIntStatistics(intStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDoubleStats(double min, double max) {
        OrcProto.DoubleStatistics.Builder dblStats = OrcProto.DoubleStatistics.newBuilder();
        dblStats.setMinimum(min);
        dblStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDoubleStatistics(dblStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createStringStats(String min, String max) {
        OrcProto.StringStatistics.Builder strStats = OrcProto.StringStatistics.newBuilder();
        strStats.setMinimum(min);
        strStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setStringStatistics(strStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDateStats(int min, int max) {
        OrcProto.DateStatistics.Builder dateStats = OrcProto.DateStatistics.newBuilder();
        dateStats.setMinimum(min);
        dateStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDateStatistics(dateStats.build()).build();
    }

    private static OrcProto.ColumnStatistics createDecimalStats(String min, String max) {
        OrcProto.DecimalStatistics.Builder decStats = OrcProto.DecimalStatistics.newBuilder();
        decStats.setMinimum(min);
        decStats.setMaximum(max);
        return OrcProto.ColumnStatistics.newBuilder().setDecimalStatistics(decStats.build()).build();
    }

    @Test
    public void testGetMax() throws Exception {
        junit.framework.Assert.assertEquals((Object)100L, (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 100L))));
        junit.framework.Assert.assertEquals((Object)100.0, (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(10.0).setMaximum(100.0).build()).build())));
        junit.framework.Assert.assertEquals(null, (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().build()).build())));
        junit.framework.Assert.assertEquals((Object)"b", (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)OrcProto.ColumnStatistics.newBuilder().setStringStatistics(OrcProto.StringStatistics.newBuilder().setMinimum("a").setMaximum("b").build()).build())));
        junit.framework.Assert.assertEquals((Object)"world", (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("hello", "world"))));
        junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"112.1"), (Object)RecordReaderImpl.getMax((ColumnStatistics)ColumnStatisticsImpl.deserialize((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("111.1", "112.1"))));
    }

    @Test
    public void testPredEvalWithIntStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", HiveDecimal.create((int)15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10, 100), (PredicateLeaf)pred));
    }

    @Test
    public void testPredEvalWithDoubleStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", HiveDecimal.create((int)15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDoubleStats(10.0, 100.0), (PredicateLeaf)pred));
    }

    @Test
    public void testPredEvalWithStringStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.INTEGER, "x", 100, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 100.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "100", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(100), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", HiveDecimal.create((int)100), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createStringStats("10", "1000"), (PredicateLeaf)pred));
    }

    @Test
    public void testPredEvalWithDateStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "1970-01-11", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15.1", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "__a15__1", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "2000-01-16", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "1970-01-16", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(150), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", HiveDecimal.create((int)15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDateStats(10, 100), (PredicateLeaf)pred));
    }

    @Test
    public void testPredEvalWithDecimalStats() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.FLOAT, "x", 15.0, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.STRING, "x", "15", null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DATE, "x", new DateWritable(15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred));
        pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.DECIMAL, "x", HiveDecimal.create((int)15), null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createDecimalStats("10.0", "100.0"), (PredicateLeaf)pred));
    }

    @Test
    public void testEquals() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 15L), (PredicateLeaf)pred));
    }

    @Test
    public void testNullSafeEquals() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.NULL_SAFE_EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 15L), (PredicateLeaf)pred));
    }

    @Test
    public void testLessThan() throws Exception {
        PredicateLeaf lessThan = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.LESS_THAN, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)lessThan));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)lessThan));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)lessThan));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)lessThan));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)lessThan));
    }

    @Test
    public void testLessThanEquals() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.LESS_THAN_EQUALS, PredicateLeaf.Type.INTEGER, "x", 15L, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 15L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 10L), (PredicateLeaf)pred));
    }

    @Test
    public void testIn() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(10L);
        args.add(20L);
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IN, PredicateLeaf.Type.INTEGER, "x", null, args);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 20L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(30L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 30L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(12L, 18L), (PredicateLeaf)pred));
    }

    @Test
    public void testBetween() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(10L);
        args.add(20L);
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.BETWEEN, PredicateLeaf.Type.INTEGER, "x", null, args);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(0L, 5L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(30L, 40L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(5L, 15L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(15L, 25L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(5L, 25L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(10L, 20L), (PredicateLeaf)pred));
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(12L, 18L), (PredicateLeaf)pred));
    }

    @Test
    public void testIsNull() throws Exception {
        PredicateLeaf pred = TestSearchArgumentImpl.createPredicateLeaf(PredicateLeaf.Operator.IS_NULL, PredicateLeaf.Type.INTEGER, "x", null, null);
        junit.framework.Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)RecordReaderImpl.evaluatePredicate((OrcProto.ColumnStatistics)TestRecordReaderImpl.createIntStats(20L, 30L), (PredicateLeaf)pred));
    }

    @Test
    public void testOverlap() throws Exception {
        Assert.assertTrue((!RecordReaderImpl.overlap((long)0L, (long)10L, (long)-10L, (long)-1L) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)-1L, (long)0L));
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)-1L, (long)1L));
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)2L, (long)8L));
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)5L, (long)10L));
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)10L, (long)11L));
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)0L, (long)10L));
        Assert.assertTrue((boolean)RecordReaderImpl.overlap((long)0L, (long)10L, (long)-1L, (long)11L));
        Assert.assertTrue((!RecordReaderImpl.overlap((long)0L, (long)10L, (long)11L, (long)12L) ? 1 : 0) != 0);
    }

    private static List<RecordReaderImpl.DiskRange> diskRanges(Integer ... points) {
        ArrayList<RecordReaderImpl.DiskRange> result = new ArrayList<RecordReaderImpl.DiskRange>();
        for (int i = 0; i < points.length; i += 2) {
            result.add(new RecordReaderImpl.DiskRange((long)points[i].intValue(), (long)points[i + 1].intValue()));
        }
        return result;
    }

    @Test
    public void testMergeDiskRanges() throws Exception {
        List<RecordReaderImpl.DiskRange> list = TestRecordReaderImpl.diskRanges(new Integer[0]);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(new Integer[0])));
        list = TestRecordReaderImpl.diskRanges(100, 200, 300, 400, 500, 600);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(100, 200, 300, 400, 500, 600)));
        list = TestRecordReaderImpl.diskRanges(100, 200, 150, 300, 400, 500);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(100, 300, 400, 500)));
        list = TestRecordReaderImpl.diskRanges(100, 200, 300, 400, 400, 500);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(100, 200, 300, 500)));
        list = TestRecordReaderImpl.diskRanges(100, 200, 0, 300);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(0, 300)));
        list = TestRecordReaderImpl.diskRanges(0, 500, 200, 400);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(0, 500)));
        list = TestRecordReaderImpl.diskRanges(0, 100, 100, 200, 200, 300, 300, 400);
        RecordReaderImpl.mergeDiskRanges(list);
        Assert.assertThat(list, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(0, 400)));
    }

    @Test
    public void testGetIndexPosition() throws Exception {
        junit.framework.Assert.assertEquals((int)0, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.PRESENT, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)0, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.INT, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)false));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DICTIONARY, (OrcProto.Type.Kind)OrcProto.Type.Kind.STRING, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)6, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.LENGTH, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.BINARY, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.LENGTH, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)6, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.DECIMAL, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)4, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)3, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.DATA, (boolean)false, (boolean)true));
        junit.framework.Assert.assertEquals((int)7, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)true, (boolean)true));
        junit.framework.Assert.assertEquals((int)5, (int)RecordReaderImpl.getIndexPosition((OrcProto.ColumnEncoding.Kind)OrcProto.ColumnEncoding.Kind.DIRECT, (OrcProto.Type.Kind)OrcProto.Type.Kind.TIMESTAMP, (OrcProto.Stream.Kind)OrcProto.Stream.Kind.SECONDARY, (boolean)false, (boolean)true));
    }

    @Test
    public void testPartialPlan() throws Exception {
        ArrayList<OrcProto.Stream> streams = new ArrayList<OrcProto.Stream>();
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(1).setLength(1000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(1).setLength(99000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(2).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(2).setLength(98000L).build());
        boolean[] columns = new boolean[]{true, true, false};
        boolean[] rowGroups = new boolean[]{true, true, false, false, true, false};
        OrcProto.RowIndex[] indexes = new OrcProto.RowIndex[columns.length];
        indexes[1] = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(-1L).addPositions(-1L).addPositions(0L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(100L).addPositions(-1L).addPositions(-1L).addPositions(10000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(200L).addPositions(-1L).addPositions(-1L).addPositions(20000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(300L).addPositions(-1L).addPositions(-1L).addPositions(30000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(400L).addPositions(-1L).addPositions(-1L).addPositions(40000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(500L).addPositions(-1L).addPositions(-1L).addPositions(50000L).build()).build();
        ArrayList<OrcProto.ColumnEncoding> encodings = new ArrayList<OrcProto.ColumnEncoding>();
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addFieldNames("x").addFieldNames("y").build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        List result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(0, 1000, 100, 1000, 400, 1000, 1000, 15098, 11000, 25098, 41000, 55098)));
        rowGroups = new boolean[]{false, false, false, false, false, false};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(new Integer[0])));
        rowGroups = null;
        columns = new boolean[]{true, false, true};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, null, (boolean)false, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(100000, 102000, 102000, 200000)));
        rowGroups = new boolean[]{false, true, false, false, false, false};
        indexes[2] = indexes[1];
        indexes[1] = null;
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(100100, 102000, 112000, 126098)));
        rowGroups = new boolean[]{false, false, false, false, false, true};
        indexes[1] = indexes[2];
        columns = new boolean[]{true, true, true};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(500, 1000, 51000, 100000, 100500, 102000, 152000, 200000)));
    }

    @Test
    public void testPartialPlanCompressed() throws Exception {
        ArrayList<OrcProto.Stream> streams = new ArrayList<OrcProto.Stream>();
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(1).setLength(1000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(1).setLength(99000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(2).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(2).setLength(98000L).build());
        boolean[] columns = new boolean[]{true, true, false};
        boolean[] rowGroups = new boolean[]{true, true, false, false, true, false};
        OrcProto.RowIndex[] indexes = new OrcProto.RowIndex[columns.length];
        indexes[1] = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(0L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(100L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(10000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(200L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(20000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(300L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(30000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(400L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(40000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(500L).addPositions(-1L).addPositions(-1L).addPositions(-1L).addPositions(50000L).build()).build();
        ArrayList<OrcProto.ColumnEncoding> encodings = new ArrayList<OrcProto.ColumnEncoding>();
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addFieldNames("x").addFieldNames("y").build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        List result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)true, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(0, 1000, 100, 1000, 400, 1000, 1000, 76542, 11000, 86542, 41000, 100000)));
        rowGroups = new boolean[]{false, false, false, false, false, true};
        result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)true, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(500, 1000, 51000, 100000)));
    }

    @Test
    public void testPartialPlanString() throws Exception {
        ArrayList<OrcProto.Stream> streams = new ArrayList<OrcProto.Stream>();
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(1).setLength(1000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(1).setLength(94000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.LENGTH).setColumn(1).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DICTIONARY_DATA).setColumn(1).setLength(3000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.PRESENT).setColumn(2).setLength(2000L).build());
        streams.add(OrcProto.Stream.newBuilder().setKind(OrcProto.Stream.Kind.DATA).setColumn(2).setLength(98000L).build());
        boolean[] columns = new boolean[]{true, true, false};
        boolean[] rowGroups = new boolean[]{false, true, false, false, true, true};
        OrcProto.RowIndex[] indexes = new OrcProto.RowIndex[columns.length];
        indexes[1] = OrcProto.RowIndex.newBuilder().addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(0L).addPositions(-1L).addPositions(-1L).addPositions(0L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(100L).addPositions(-1L).addPositions(-1L).addPositions(10000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(200L).addPositions(-1L).addPositions(-1L).addPositions(20000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(300L).addPositions(-1L).addPositions(-1L).addPositions(30000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(400L).addPositions(-1L).addPositions(-1L).addPositions(40000L).build()).addEntry(OrcProto.RowIndexEntry.newBuilder().addPositions(500L).addPositions(-1L).addPositions(-1L).addPositions(50000L).build()).build();
        ArrayList<OrcProto.ColumnEncoding> encodings = new ArrayList<OrcProto.ColumnEncoding>();
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DICTIONARY).build());
        encodings.add(OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT).build());
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addFieldNames("x").addFieldNames("y").build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRING).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        List result = RecordReaderImpl.planReadPartialDataStreams(streams, (OrcProto.RowIndex[])indexes, (boolean[])columns, (boolean[])rowGroups, (boolean)false, encodings, types, (int)32768);
        Assert.assertThat((Object)result, (Matcher)Is.is(TestRecordReaderImpl.diskRanges(100, 1000, 400, 1000, 500, 1000, 11000, 25098, 41000, 55098, 51000, 95000, 95000, 97000, 97000, 100000)));
    }

    static class BufferInStream
    extends InputStream
    implements PositionedReadable,
    Seekable {
        private final byte[] buffer;
        private final int length;
        private int position = 0;

        BufferInStream(byte[] bytes, int length) {
            this.buffer = bytes;
            this.length = length;
        }

        @Override
        public int read() {
            if (this.position < this.length) {
                return this.buffer[this.position++];
            }
            return -1;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) {
            int lengthToRead = Math.min(length, this.length - this.position);
            if (lengthToRead >= 0) {
                for (int i = 0; i < lengthToRead; ++i) {
                    bytes[offset + i] = this.buffer[this.position++];
                }
                return lengthToRead;
            }
            return -1;
        }

        public int read(long position, byte[] bytes, int offset, int length) {
            this.position = (int)position;
            return this.read(bytes, offset, length);
        }

        public void readFully(long position, byte[] bytes, int offset, int length) throws IOException {
            this.position = (int)position;
            while (length > 0) {
                int result = this.read(bytes, offset, length);
                offset += result;
                length -= result;
                if (result >= 0) continue;
                throw new IOException("Read past end of buffer at " + offset);
            }
        }

        public void readFully(long position, byte[] bytes) throws IOException {
            this.readFully(position, bytes, 0, bytes.length);
        }

        public void seek(long position) {
            this.position = (int)position;
        }

        public long getPos() {
            return this.position;
        }

        public boolean seekToNewSource(long position) throws IOException {
            this.position = (int)position;
            return false;
        }
    }
}

