/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DynamicByteArray;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OutStream;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.PositionRecorder;
import org.apache.hadoop.hive.ql.io.orc.ZlibCodec;
import org.junit.Test;

public class TestInStream {
    @Test
    public void testUncompressed() throws Exception {
        int i;
        int i2;
        OutputCollector collect = new OutputCollector();
        OutStream out = new OutStream("test", 100, null, (OutStream.OutputReceiver)collect);
        PositionCollector[] positions = new PositionCollector[1024];
        for (i2 = 0; i2 < 1024; ++i2) {
            positions[i2] = new PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            out.write(i2);
        }
        out.flush();
        Assert.assertEquals((int)1024, (int)collect.buffer.size());
        for (i2 = 0; i2 < 1024; ++i2) {
            Assert.assertEquals((byte)((byte)i2), (byte)collect.buffer.get(i2));
        }
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        InStream in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)100);
        Assert.assertEquals((String)"uncompressed stream test position: 0 length: 1024 range: 0 offset: 0 limit: 0", (String)in.toString());
        for (i = 0; i < 1024; ++i) {
            int x = in.read();
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        for (i = 1023; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            Assert.assertEquals((int)(i & 0xFF), (int)in.read());
        }
    }

    @Test
    public void testCompressed() throws Exception {
        int i;
        OutputCollector collect = new OutputCollector();
        ZlibCodec codec = new ZlibCodec();
        OutStream out = new OutStream("test", 300, (CompressionCodec)codec, (OutStream.OutputReceiver)collect);
        PositionCollector[] positions = new PositionCollector[1024];
        for (int i2 = 0; i2 < 1024; ++i2) {
            positions[i2] = new PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            out.write(i2);
        }
        out.flush();
        Assert.assertEquals((String)"test", (String)out.toString());
        Assert.assertEquals((int)961, (int)collect.buffer.size());
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        InStream in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), (CompressionCodec)codec, (int)300);
        Assert.assertEquals((String)"compressed stream test position: 0 length: 961 range: 0 offset: 0 limit: 0 range 0 = 0 to 961", (String)in.toString());
        for (i = 0; i < 1024; ++i) {
            int x = in.read();
            Assert.assertEquals((int)(i & 0xFF), (int)x);
        }
        Assert.assertEquals((int)0, (int)in.available());
        for (i = 1023; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            Assert.assertEquals((int)(i & 0xFF), (int)in.read());
        }
    }

    @Test
    public void testCorruptStream() throws Exception {
        OutputCollector collect = new OutputCollector();
        ZlibCodec codec = new ZlibCodec();
        OutStream out = new OutStream("test", 500, (CompressionCodec)codec, (OutStream.OutputReceiver)collect);
        PositionCollector[] positions = new PositionCollector[1024];
        for (int i = 0; i < 1024; ++i) {
            positions[i] = new PositionCollector();
            out.getPosition((PositionRecorder)positions[i]);
            out.write(i);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        InStream in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), (CompressionCodec)codec, (int)100);
        byte[] contents = new byte[1024];
        try {
            in.read(contents);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        inBuf.clear();
        inBuf.put((byte)32);
        inBuf.put((byte)0);
        inBuf.flip();
        in = InStream.create((String)"test2", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), (CompressionCodec)codec, (int)300);
        try {
            in.read();
            Assert.fail();
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
    }

    @Test
    public void testDisjointBuffers() throws Exception {
        int i;
        OutputCollector collect = new OutputCollector();
        ZlibCodec codec = new ZlibCodec();
        OutStream out = new OutStream("test", 400, (CompressionCodec)codec, (OutStream.OutputReceiver)collect);
        PositionCollector[] positions = new PositionCollector[1024];
        DataOutputStream stream = new DataOutputStream((OutputStream)out);
        for (int i2 = 0; i2 < 1024; ++i2) {
            positions[i2] = new PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            stream.writeInt(i2);
        }
        out.flush();
        Assert.assertEquals((String)"test", (String)out.toString());
        Assert.assertEquals((int)1674, (int)collect.buffer.size());
        ByteBuffer[] inBuf = new ByteBuffer[]{ByteBuffer.allocate(500), ByteBuffer.allocate(1200), ByteBuffer.allocate(500)};
        collect.buffer.setByteBuffer(inBuf[0], 0, 483);
        collect.buffer.setByteBuffer(inBuf[1], 483, 1142);
        collect.buffer.setByteBuffer(inBuf[2], 1625, 49);
        for (int i3 = 0; i3 < inBuf.length; ++i3) {
            inBuf[i3].flip();
        }
        InStream in = InStream.create((String)"test", (ByteBuffer[])inBuf, (long[])new long[]{0L, 483L, 1625L}, (long)1674L, (CompressionCodec)codec, (int)400);
        Assert.assertEquals((String)"compressed stream test position: 0 length: 1674 range: 0 offset: 0 limit: 0 range 0 = 0 to 483;  range 1 = 483 to 1142;  range 2 = 1625 to 49", (String)in.toString());
        DataInputStream inStream = new DataInputStream((InputStream)in);
        for (i = 0; i < 1024; ++i) {
            int x = inStream.readInt();
            Assert.assertEquals((int)i, (int)x);
        }
        Assert.assertEquals((int)0, (int)in.available());
        for (i = 1023; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
        in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf[1], inBuf[2]}, (long[])new long[]{483L, 1625L}, (long)1674L, (CompressionCodec)codec, (int)400);
        inStream = new DataInputStream((InputStream)in);
        positions[303].reset();
        in.seek((PositionProvider)positions[303]);
        for (i = 303; i < 1024; ++i) {
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
        in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf[0], inBuf[2]}, (long[])new long[]{0L, 1625L}, (long)1674L, (CompressionCodec)codec, (int)400);
        inStream = new DataInputStream((InputStream)in);
        positions[1001].reset();
        for (i = 0; i < 300; ++i) {
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
        in.seek((PositionProvider)positions[1001]);
        for (i = 1001; i < 1024; ++i) {
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
    }

    @Test
    public void testUncompressedDisjointBuffers() throws Exception {
        int i;
        OutputCollector collect = new OutputCollector();
        OutStream out = new OutStream("test", 400, null, (OutStream.OutputReceiver)collect);
        PositionCollector[] positions = new PositionCollector[1024];
        DataOutputStream stream = new DataOutputStream((OutputStream)out);
        for (int i2 = 0; i2 < 1024; ++i2) {
            positions[i2] = new PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            stream.writeInt(i2);
        }
        out.flush();
        Assert.assertEquals((String)"test", (String)out.toString());
        Assert.assertEquals((int)4096, (int)collect.buffer.size());
        ByteBuffer[] inBuf = new ByteBuffer[]{ByteBuffer.allocate(1100), ByteBuffer.allocate(2200), ByteBuffer.allocate(1100)};
        collect.buffer.setByteBuffer(inBuf[0], 0, 1024);
        collect.buffer.setByteBuffer(inBuf[1], 1024, 2048);
        collect.buffer.setByteBuffer(inBuf[2], 3072, 1024);
        for (int i3 = 0; i3 < inBuf.length; ++i3) {
            inBuf[i3].flip();
        }
        InStream in = InStream.create((String)"test", (ByteBuffer[])inBuf, (long[])new long[]{0L, 1024L, 3072L}, (long)4096L, null, (int)400);
        Assert.assertEquals((String)"uncompressed stream test position: 0 length: 4096 range: 0 offset: 0 limit: 0", (String)in.toString());
        DataInputStream inStream = new DataInputStream((InputStream)in);
        for (i = 0; i < 1024; ++i) {
            int x = inStream.readInt();
            Assert.assertEquals((int)i, (int)x);
        }
        Assert.assertEquals((int)0, (int)in.available());
        for (i = 1023; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
        in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf[1], inBuf[2]}, (long[])new long[]{1024L, 3072L}, (long)4096L, null, (int)400);
        inStream = new DataInputStream((InputStream)in);
        positions[256].reset();
        in.seek((PositionProvider)positions[256]);
        for (i = 256; i < 1024; ++i) {
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
        in = InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf[0], inBuf[2]}, (long[])new long[]{0L, 3072L}, (long)4096L, null, (int)400);
        inStream = new DataInputStream((InputStream)in);
        positions[768].reset();
        for (i = 0; i < 256; ++i) {
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
        in.seek((PositionProvider)positions[768]);
        for (i = 768; i < 1024; ++i) {
            Assert.assertEquals((int)i, (int)inStream.readInt());
        }
    }

    static class PositionCollector
    implements PositionProvider,
    PositionRecorder {
        private List<Long> positions = new ArrayList<Long>();
        private int index = 0;

        PositionCollector() {
        }

        public long getNext() {
            return this.positions.get(this.index++);
        }

        public void addPosition(long offset) {
            this.positions.add(offset);
        }

        public void reset() {
            this.index = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("position: ");
            for (int i = 0; i < this.positions.size(); ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(this.positions.get(i));
            }
            return builder.toString();
        }
    }

    static class OutputCollector
    implements OutStream.OutputReceiver {
        DynamicByteArray buffer = new DynamicByteArray();

        OutputCollector() {
        }

        public void output(ByteBuffer buffer) throws IOException {
            this.buffer.add(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
    }
}

