/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.OutputStream;
import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.FlatFileInputFormat;
import org.apache.hadoop.hive.ql.io.JavaTestObjFlatFileInputFormat;
import org.apache.hadoop.hive.ql.io.RecordTestObj;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class TestFlatFileInputFormat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlatFileInputJava() throws Exception {
        try {
            Configuration conf = new Configuration();
            JobConf job = new JobConf(conf);
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            Path dir = new Path(System.getProperty("test.tmp.dir", ".") + "/mapred");
            Path file = new Path(dir, "test.txt");
            Reporter reporter = Reporter.NULL;
            fs.delete(dir, true);
            job.setClass("mapred.input.serialization.implKey", JavaSerialization.class, Serialization.class);
            job.setClass("mapred.input.serialization.subclassKey", JavaTestObjFlatFileInputFormat.class, Serializable.class);
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
            FSDataOutputStream ds = fs.create(file);
            Serializer serializer = new JavaSerialization().getSerializer(null);
            serializer.open((OutputStream)ds);
            for (int i = 0; i < 10; ++i) {
                serializer.serialize((Object)new JavaTestObjFlatFileInputFormat("Hello World! " + String.valueOf(i), i));
            }
            serializer.close();
            FlatFileInputFormat format = new FlatFileInputFormat();
            InputSplit[] splits = format.getSplits(job, 1);
            RecordReader reader = format.getRecordReader(splits[0], job, reporter);
            Void key = (Void)reader.createKey();
            FlatFileInputFormat.RowContainer value = (FlatFileInputFormat.RowContainer)reader.createValue();
            int count = 0;
            while (reader.next((Object)key, (Object)value)) {
                TestFlatFileInputFormat.assertTrue((key == null ? 1 : 0) != 0);
                TestFlatFileInputFormat.assertTrue((boolean)((JavaTestObjFlatFileInputFormat)value.row).s.equals("Hello World! " + String.valueOf(count)));
                TestFlatFileInputFormat.assertTrue((((JavaTestObjFlatFileInputFormat)value.row).num == count ? 1 : 0) != 0);
                ++count;
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.println("caught: " + e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlatFileInputRecord() throws Exception {
        try {
            Configuration conf = new Configuration();
            JobConf job = new JobConf(conf);
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            Path dir = new Path(System.getProperty("test.tmp.dir", ".") + "/mapred");
            Path file = new Path(dir, "test.txt");
            Reporter reporter = Reporter.NULL;
            fs.delete(dir, true);
            job.setClass("mapred.input.serialization.implKey", WritableSerialization.class, Serialization.class);
            job.setClass("mapred.input.serialization.subclassKey", RecordTestObj.class, Writable.class);
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{dir});
            FSDataOutputStream ds = fs.create(file);
            Serializer serializer = new WritableSerialization().getSerializer(Writable.class);
            serializer.open((OutputStream)ds);
            for (int i = 0; i < 10; ++i) {
                serializer.serialize((Object)new RecordTestObj("Hello World! " + String.valueOf(i), i));
            }
            serializer.close();
            FlatFileInputFormat format = new FlatFileInputFormat();
            InputSplit[] splits = format.getSplits(job, 1);
            RecordReader reader = format.getRecordReader(splits[0], job, reporter);
            Void key = (Void)reader.createKey();
            FlatFileInputFormat.RowContainer value = (FlatFileInputFormat.RowContainer)reader.createValue();
            int count = 0;
            while (reader.next((Object)key, (Object)value)) {
                TestFlatFileInputFormat.assertTrue((key == null ? 1 : 0) != 0);
                TestFlatFileInputFormat.assertTrue((boolean)((RecordTestObj)((Object)value.row)).getS().equals("Hello World! " + String.valueOf(count)));
                TestFlatFileInputFormat.assertTrue((((RecordTestObj)((Object)value.row)).getNum() == (long)count ? 1 : 0) != 0);
                ++count;
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.println("caught: " + e);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestFlatFileInputFormat().testFlatFileInputJava();
        new TestFlatFileInputFormat().testFlatFileInputRecord();
    }
}

