/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColRegExpStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringConcatColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringConcatColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringConcatScalarCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLTrim;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLength;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLower;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringRTrim;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringSubstrColStart;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringSubstrColStartLen;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrim;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUpper;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColEqualStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColGreaterEqualStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColLessStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColLessStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringScalarEqualStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringScalarGreaterStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringScalarLessEqualStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringColEqualStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringColLessStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringScalarEqualStringColumn;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestVectorStringExpressions {
    private static byte[] red;
    private static byte[] redred;
    private static byte[] red2;
    private static byte[] green;
    private static byte[] greenred;
    private static byte[] redgreen;
    private static byte[] greengreen;
    private static byte[] blue;
    private static byte[] emptyString;
    private static byte[] mixedUp;
    private static byte[] mixedUpLower;
    private static byte[] mixedUpUpper;
    private static byte[] multiByte;
    private static byte[] mixPercentPattern;
    private static byte[] blanksLeft;
    private static byte[] blanksRight;
    private static byte[] blanksBoth;
    private static byte[] blankString;

    static void addMultiByteChars(byte[] b) {
        int i = 0;
        b[i++] = 65;
        b[i++] = -61;
        b[i++] = -128;
        b[i++] = -30;
        b[i++] = -126;
        b[i++] = -84;
        b[i++] = -16;
        b[i++] = -92;
        b[i++] = -83;
        b[i++] = -94;
    }

    @Test
    public void testLoadBytesColumnVectorByValueLargeData() {
        BytesColumnVector bcv = new BytesColumnVector(1024);
        bcv.initBuffer(10);
        String s = "0123456789";
        while (s.length() < 500) {
            s = s + s;
        }
        byte[] b = null;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (int i = 0; i != 1024; ++i) {
            bcv.setVal(i, b, 0, b.length);
        }
        Assert.assertTrue((bcv.bufferSize() >= b.length * 1024 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBytesColumnVectorByRef() {
        BytesColumnVector bcv = new BytesColumnVector(1024);
        String s = "red";
        byte[] b = null;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (int i = 0; i != 1024; ++i) {
            bcv.setRef(i, b, 0, b.length);
        }
        byte[] v = new byte[b.length];
        for (int i = 0; i != 1024; ++i) {
            Assert.assertTrue((bcv.length[i] == b.length ? 1 : 0) != 0);
            System.arraycopy(bcv.vector[i], bcv.start[i], v, 0, b.length);
            Assert.assertTrue((boolean)Arrays.equals(b, v));
        }
    }

    @Test
    public void testStringColCompareStringScalarFilter() {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterStringColEqualStringScalar expr = new FilterStringColEqualStringScalar(0, red2);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringColLessStringScalar(0, red2);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringColGreaterEqualStringScalar(0, green);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringColCompareStringScalarProjection() {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringColEqualStringScalar expr = new StringColEqualStringScalar(0, red2, 2);
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new StringColEqualStringScalar(0, green, 2);
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testStringScalarCompareStringCol() {
        VectorizedRowBatch batch = this.makeStringBatch();
        FilterStringScalarEqualStringColumn expr = new FilterStringScalarEqualStringColumn(red2, 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringScalarGreaterStringColumn(red2, 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 1 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 1 ? 1 : 0) != 0);
        batch = this.makeStringBatch();
        expr = new FilterStringScalarLessEqualStringColumn(green, 0);
        expr.evaluate(batch);
        Assert.assertTrue((batch.size == 2 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((batch.selected[1] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringScalarCompareStringColProjection() {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringScalarEqualStringColumn expr = new StringScalarEqualStringColumn(red2, 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        LongColumnVector outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)1L, (long)outVector.vector[0]);
        Assert.assertEquals((long)0L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
        batch = this.makeStringBatch();
        expr = new StringScalarEqualStringColumn(green, 0, 2);
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        outVector = (LongColumnVector)batch.cols[2];
        Assert.assertEquals((long)0L, (long)outVector.vector[0]);
        Assert.assertEquals((long)1L, (long)outVector.vector[1]);
        Assert.assertEquals((long)0L, (long)outVector.vector[2]);
    }

    @Test
    public void testStringColCompareStringColFilter() {
        VectorizedRowBatch batch = this.makeStringBatchForColColCompare();
        FilterStringColLessStringColumn expr = new FilterStringColLessStringColumn(0, 1);
        expr.evaluate(batch);
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertEquals((int)0, (int)batch.selected[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)2, (int)batch.size);
        Assert.assertEquals((int)3, (int)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertEquals((int)0, (int)batch.selected[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[3] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertEquals((int)0, (int)batch.selected[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((int)3, (int)batch.selected[2]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)2, (int)batch.size);
        Assert.assertEquals((int)1, (int)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((int)3, (int)batch.selected[2]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)0, (int)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)2, (int)batch.size);
        Assert.assertEquals((int)0, (int)batch.selected[0]);
        Assert.assertEquals((int)1, (int)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)2, (int)batch.size);
        Assert.assertEquals((int)3, (int)batch.selected[1]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((int)3, (int)batch.selected[2]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)0, (int)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)0, (int)batch.size);
    }

    @Test
    public void testStringColCompareStringColProjection() {
        VectorizedRowBatch batch = this.makeStringBatchForColColCompare();
        StringColLessStringColumn expr = new StringColLessStringColumn(0, 1, 3);
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        long[] outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[3] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)0L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertTrue((boolean)batch.cols[3].isNull[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[1]);
        Assert.assertEquals((long)1L, (long)outVector[1]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[2]);
        Assert.assertEquals((long)0L, (long)outVector[2]);
        Assert.assertFalse((boolean)batch.cols[3].isNull[3]);
        Assert.assertEquals((long)1L, (long)outVector[3]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        outVector = ((LongColumnVector)batch.cols[3]).vector;
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertFalse((boolean)batch.cols[3].isNull[0]);
        Assert.assertEquals((long)1L, (long)outVector[0]);
        batch = this.makeStringBatchForColColCompare();
        batch.cols[0].isRepeating = true;
        batch.cols[1].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)4, (int)batch.size);
        Assert.assertFalse((boolean)batch.cols[3].noNulls);
        Assert.assertTrue((boolean)batch.cols[3].isRepeating);
        Assert.assertTrue((boolean)batch.cols[3].isNull[0]);
    }

    VectorizedRowBatch makeStringBatch() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        batch.cols[1] = new BytesColumnVector();
        batch.cols[2] = new LongColumnVector(batch.size);
        v.setRef(0, red, 0, red.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        batch.size = 3;
        return batch;
    }

    VectorizedRowBatch makeStringBatchMixedCase() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1024);
        BytesColumnVector v = new BytesColumnVector(1024);
        batch.cols[0] = v;
        BytesColumnVector outV = new BytesColumnVector(1024);
        outV.initBuffer();
        batch.cols[1] = outV;
        v.setRef(0, mixedUp, 0, mixedUp.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        batch.size = 3;
        return batch;
    }

    VectorizedRowBatch makeStringBatchMixedCharSize() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1024);
        BytesColumnVector v = new BytesColumnVector(1024);
        batch.cols[0] = v;
        LongColumnVector outV = new LongColumnVector(1024);
        batch.cols[1] = outV;
        v.setRef(0, mixedUp, 0, mixedUp.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        v.setRef(3, multiByte, 0, 10);
        v.isNull[3] = false;
        batch.size = 4;
        return batch;
    }

    @Test
    public void testColLower() {
        VectorizedRowBatch batch = this.makeStringBatchMixedCase();
        StringLower expr = new StringLower(0, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])green, (int)0, (int)green.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        batch = this.makeStringBatchMixedCase();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.noNulls);
        batch = this.makeStringBatchMixedCase();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertFalse((boolean)outCol.noNulls);
        batch = this.makeStringBatchMixedCase();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])mixedUpLower, (int)0, (int)mixedUpLower.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testColUpper() {
        VectorizedRowBatch batch = this.makeStringBatchMixedCase();
        StringUpper expr = new StringUpper(0, 1);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])mixedUpUpper, (int)0, (int)mixedUpUpper.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testStringLength() {
        VectorizedRowBatch batch = this.makeStringBatchMixedCharSize();
        StringLength expr = new StringLength(0, 1);
        expr.evaluate(batch);
        LongColumnVector outCol = (LongColumnVector)batch.cols[1];
        Assert.assertEquals((long)5L, (long)outCol.vector[1]);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        Assert.assertEquals((long)4L, (long)outCol.vector[3]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (LongColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)4L, (long)outCol.vector[3]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (LongColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertEquals((long)7L, (long)outCol.vector[0]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (LongColumnVector)batch.cols[1];
        Assert.assertEquals((long)7L, (long)outCol.vector[0]);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    private VectorizedRowBatch makeStringBatch2In1Out() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector v2 = new BytesColumnVector();
        batch.cols[1] = v2;
        batch.cols[2] = new BytesColumnVector();
        v.setRef(0, red, 0, red.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, emptyString, 0, emptyString.length);
        v.isNull[2] = true;
        v.noNulls = false;
        v2.setRef(0, red, 0, red.length);
        v2.isNull[0] = false;
        v2.setRef(1, green, 0, green.length);
        v2.isNull[1] = false;
        v2.setRef(2, emptyString, 0, emptyString.length);
        v2.isNull[2] = true;
        v2.noNulls = false;
        batch.size = 3;
        return batch;
    }

    private VectorizedRowBatch makeStringBatchForColColCompare() {
        VectorizedRowBatch batch = new VectorizedRowBatch(4);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector v2 = new BytesColumnVector();
        batch.cols[1] = v2;
        batch.cols[2] = new BytesColumnVector();
        batch.cols[3] = new LongColumnVector();
        v.setRef(0, blue, 0, blue.length);
        v.isNull[0] = false;
        v.setRef(1, green, 0, green.length);
        v.isNull[1] = false;
        v.setRef(2, red, 0, red.length);
        v.isNull[2] = false;
        v.setRef(3, emptyString, 0, emptyString.length);
        v.isNull[3] = true;
        v.noNulls = false;
        v2.setRef(0, red, 0, red.length);
        v2.isNull[0] = false;
        v2.setRef(1, green, 0, green.length);
        v2.isNull[1] = false;
        v2.setRef(2, blue, 0, blue.length);
        v2.isNull[2] = false;
        v2.setRef(3, red, 0, red.length);
        v2.isNull[3] = false;
        v2.noNulls = false;
        batch.size = 4;
        return batch;
    }

    @Test
    public void testStringLike() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCharSize();
        Text pattern = new Text(mixPercentPattern);
        FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, mixPercentPattern);
        expr.evaluate(batch);
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertEquals((int)0, (int)batch.selected[0]);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertEquals((int)0, (int)batch.selected[0]);
        batch = this.makeStringBatchMixedCharSize();
        int initialBatchSize = batch.size;
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)initialBatchSize, (int)batch.size);
        batch = this.makeStringBatchMixedCharSize();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)0, (int)batch.size);
        batch = this.makeStringBatchMixedCharSize();
        initialBatchSize = batch.size;
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)initialBatchSize, (int)batch.size);
    }

    public void testStringLikePatternType() throws UnsupportedEncodingException, HiveException {
        FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, "abc%".getBytes());
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.BeginChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc".getBytes("UTF-8"));
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.EndChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc%".getBytes());
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.MiddleChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "%abc%de".getBytes());
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.ComplexChecker.class, expr.checker.getClass());
        expr = new FilterStringColLikeStringScalar(0, "abc".getBytes());
        Assert.assertEquals(AbstractFilterStringColLikeStringScalar.NoneChecker.class, expr.checker.getClass());
    }

    public void testStringLikeMultiByte() throws HiveException {
        VectorizedRowBatch batch = this.makeStringBatchMixedCharSize();
        FilterStringColLikeStringScalar expr = new FilterStringColLikeStringScalar(0, ("%" + multiByte + "%").getBytes());
        expr.evaluate(batch);
        Assert.assertEquals((int)batch.size, (int)1);
        batch = this.makeStringBatchMixedCharSize();
        expr = new FilterStringColLikeStringScalar(0, ("%" + multiByte + "x").getBytes());
        expr.evaluate(batch);
        Assert.assertEquals((int)batch.size, (int)0);
    }

    @Test
    public void testColConcatScalar() {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringConcatColScalar expr = new StringConcatColScalar(0, red, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        cmp2 = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((int)0, (int)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertFalse((boolean)outCol.noNulls);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testScalarConcatCol() {
        VectorizedRowBatch batch = this.makeStringBatch();
        StringConcatScalarCol expr = new StringConcatScalarCol(red, 0, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        cmp2 = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        int cmp3 = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((int)0, (int)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertFalse((boolean)outCol.noNulls);
        batch = this.makeStringBatch();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
    }

    @Test
    public void testColConcatCol() {
        VectorizedRowBatch batch = this.makeStringBatch2In1Out();
        StringConcatColCol expr = new StringConcatColCol(0, 1, 2);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[2];
        int cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertTrue((boolean)outCol.isNull[2]);
        int cmp2 = StringExpr.compare((byte[])greengreen, (int)0, (int)greengreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        cmp2 = StringExpr.compare((byte[])greengreen, (int)0, (int)greengreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp2);
        int cmp3 = StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((int)0, (int)cmp3);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((boolean)true, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)true, (boolean)outCol.isNull[0]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((boolean)false, (boolean)outCol.isRepeating);
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
        Assert.assertEquals((boolean)true, (boolean)outCol.isNull[2]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[1].isRepeating = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((boolean)true, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)true, (boolean)outCol.isNull[0]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].isNull[0] = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((boolean)true, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)true, (boolean)outCol.isNull[0]);
        batch = this.makeStringBatch2In1Out();
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((boolean)false, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)false, (boolean)outCol.isNull[0]);
        Assert.assertEquals((boolean)false, (boolean)outCol.noNulls);
        Assert.assertEquals((boolean)true, (boolean)outCol.isNull[2]);
        cmp = StringExpr.compare((byte[])greenred, (int)0, (int)greenred.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((boolean)false, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)true, (boolean)outCol.noNulls);
        cmp = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]);
        Assert.assertEquals((int)0, (int)cmp);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((boolean)false, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)false, (boolean)outCol.isNull[0]);
        Assert.assertEquals((boolean)false, (boolean)outCol.noNulls);
        Assert.assertEquals((boolean)true, (boolean)outCol.isNull[2]);
        cmp = StringExpr.compare((byte[])redgreen, (int)0, (int)redgreen.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]);
        Assert.assertEquals((int)0, (int)cmp);
        batch = this.makeStringBatch2In1Out();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        batch.cols[1].isRepeating = true;
        batch.cols[1].noNulls = true;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[2];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((boolean)true, (boolean)outCol.isRepeating);
        Assert.assertEquals((boolean)false, (boolean)outCol.isNull[0]);
        cmp = StringExpr.compare((byte[])redred, (int)0, (int)redred.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]);
        Assert.assertEquals((int)0, (int)cmp);
    }

    @Test
    public void testSubstrStart() throws UnsupportedEncodingException {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector outV = new BytesColumnVector();
        batch.cols[1] = outV;
        byte[] data1 = "abcd string".getBytes("UTF-8");
        byte[] data2 = "efgh string".getBytes("UTF-8");
        byte[] data3 = "efgh".getBytes("UTF-8");
        batch.size = 3;
        v.noNulls = true;
        v.setRef(0, data1, 0, data1.length);
        v.isNull[0] = false;
        v.setRef(1, data2, 0, data2.length);
        v.isNull[1] = false;
        v.setRef(2, data3, 0, data3.length);
        v.isNull[2] = false;
        StringSubstrColStart expr = new StringSubstrColStart(0, 6, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        byte[] expected = "string".getBytes("UTF-8");
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outCol.noNulls = false;
        outCol.isRepeating = true;
        expr = new StringSubstrColStart(0, -6, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outCol.noNulls = false;
        outCol.isRepeating = true;
        expr = new StringSubstrColStart(0, 1, 1);
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data1, (int)0, (int)data1.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data2, (int)0, (int)data2.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data3, (int)0, (int)data3.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.noNulls = false;
        outV.isRepeating = true;
        expr = new StringSubstrColStart(0, 6, 1);
        v.noNulls = false;
        v.isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertFalse((boolean)outV.noNulls);
        Assert.assertTrue((boolean)outV.isNull[0]);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outCol.noNulls = false;
        outCol.isRepeating = false;
        outV = new BytesColumnVector();
        v = new BytesColumnVector();
        v.isRepeating = true;
        v.noNulls = true;
        v.setRef(0, data1, 0, data1.length);
        batch = new VectorizedRowBatch(2);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        expected = "string".getBytes("UTF-8");
        Assert.assertTrue((boolean)outV.isRepeating);
        Assert.assertTrue((boolean)outV.noNulls);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        v.setRef(0, multiByte, 0, 10);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStart(0, 3, 1);
        batch.size = 1;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertTrue((boolean)outV.noNulls);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])multiByte, (int)3, (int)7, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        v.setRef(0, multiByte, 3, 7);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        outCol = (BytesColumnVector)batch.cols[1];
        expr = new StringSubstrColStart(0, 2, 1);
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertTrue((boolean)outV.noNulls);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])multiByte, (int)6, (int)4, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
    }

    @Test
    public void testSubstrStartLen() throws UnsupportedEncodingException {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector v = new BytesColumnVector();
        batch.cols[0] = v;
        BytesColumnVector outV = new BytesColumnVector();
        batch.cols[1] = outV;
        byte[] data1 = "abcd string".getBytes("UTF-8");
        byte[] data2 = "efgh string".getBytes("UTF-8");
        byte[] data3 = "efgh".getBytes("UTF-8");
        batch.size = 3;
        v.noNulls = true;
        v.setRef(0, data1, 0, data1.length);
        v.isNull[0] = false;
        v.setRef(1, data2, 0, data2.length);
        v.isNull[1] = false;
        v.setRef(2, data3, 0, data3.length);
        v.isNull[2] = false;
        outV.isRepeating = true;
        outV.noNulls = false;
        StringSubstrColStartLen expr = new StringSubstrColStartLen(0, 6, 6, 1);
        expr.evaluate(batch);
        BytesColumnVector outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        byte[] expected = "string".getBytes("UTF-8");
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, -6, 6, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 1, 0, 1);
        outCol = (BytesColumnVector)batch.cols[1];
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data1, (int)1, (int)0, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data2, (int)1, (int)0, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data3, (int)1, (int)0, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 0, 11, 1);
        outCol = (BytesColumnVector)batch.cols[1];
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data1, (int)0, (int)data1.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data2, (int)0, (int)data2.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])data3, (int)0, (int)data3.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 6, 10, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV.isRepeating = true;
        outV.noNulls = true;
        v.noNulls = false;
        v.isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((int)3, (int)batch.size);
        Assert.assertFalse((boolean)outV.noNulls);
        Assert.assertTrue((boolean)outV.isNull[0]);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[1], (int)outCol.start[1], (int)outCol.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)emptyString.length, (byte[])outCol.vector[2], (int)outCol.start[2], (int)outCol.length[2]));
        outV = new BytesColumnVector();
        v = new BytesColumnVector();
        outV.isRepeating = false;
        outV.noNulls = true;
        v.isRepeating = true;
        v.noNulls = false;
        v.setRef(0, data1, 0, data1.length);
        batch = new VectorizedRowBatch(2);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])expected, (int)0, (int)expected.length, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        batch.size = 1;
        v.setRef(0, multiByte, 0, 10);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 3, 2, 1);
        expr.evaluate(batch);
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertTrue((boolean)outV.noNulls);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])multiByte, (int)3, (int)7, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
        v = new BytesColumnVector();
        v.isRepeating = false;
        v.noNulls = true;
        outV = new BytesColumnVector();
        batch.size = 1;
        v.setRef(0, multiByte, 3, 7);
        batch.cols[0] = v;
        batch.cols[1] = outV;
        outV.isRepeating = true;
        outV.noNulls = false;
        expr = new StringSubstrColStartLen(0, 2, 2, 1);
        expr.evaluate(batch);
        outCol = (BytesColumnVector)batch.cols[1];
        Assert.assertEquals((int)1, (int)batch.size);
        Assert.assertFalse((boolean)outV.isRepeating);
        Assert.assertTrue((boolean)outV.noNulls);
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])multiByte, (int)6, (int)4, (byte[])outCol.vector[0], (int)outCol.start[0], (int)outCol.length[0]));
    }

    @Test
    public void testVectorLTrim() {
        VectorizedRowBatch b = this.makeTrimBatch();
        StringLTrim expr = new StringLTrim(0, 1);
        expr.evaluate(b);
        BytesColumnVector outV = (BytesColumnVector)b.cols[1];
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)0, (byte[])outV.vector[0], (int)0, (int)0));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksLeft, (int)2, (int)3, (byte[])outV.vector[1], (int)outV.start[1], (int)outV.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksRight, (int)0, (int)5, (byte[])outV.vector[2], (int)outV.start[2], (int)outV.length[2]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksBoth, (int)2, (int)5, (byte[])outV.vector[3], (int)outV.start[3], (int)outV.length[3]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])red, (int)0, (int)3, (byte[])outV.vector[4], (int)outV.start[4], (int)outV.length[4]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blankString, (int)0, (int)0, (byte[])outV.vector[5], (int)outV.start[5], (int)outV.length[5]));
    }

    @Test
    public void testVectorRTrim() {
        VectorizedRowBatch b = this.makeTrimBatch();
        StringRTrim expr = new StringRTrim(0, 1);
        expr.evaluate(b);
        BytesColumnVector outV = (BytesColumnVector)b.cols[1];
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)0, (byte[])outV.vector[0], (int)0, (int)0));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksLeft, (int)0, (int)5, (byte[])outV.vector[1], (int)outV.start[1], (int)outV.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksRight, (int)0, (int)3, (byte[])outV.vector[2], (int)outV.start[2], (int)outV.length[2]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksBoth, (int)0, (int)5, (byte[])outV.vector[3], (int)outV.start[3], (int)outV.length[3]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])red, (int)0, (int)3, (byte[])outV.vector[4], (int)outV.start[4], (int)outV.length[4]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blankString, (int)0, (int)0, (byte[])outV.vector[5], (int)outV.start[5], (int)outV.length[5]));
    }

    @Test
    public void testVectorTrim() {
        VectorizedRowBatch b = this.makeTrimBatch();
        StringTrim expr = new StringTrim(0, 1);
        expr.evaluate(b);
        BytesColumnVector outV = (BytesColumnVector)b.cols[1];
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])emptyString, (int)0, (int)0, (byte[])outV.vector[0], (int)0, (int)0));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksLeft, (int)2, (int)3, (byte[])outV.vector[1], (int)outV.start[1], (int)outV.length[1]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksRight, (int)0, (int)3, (byte[])outV.vector[2], (int)outV.start[2], (int)outV.length[2]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blanksBoth, (int)2, (int)3, (byte[])outV.vector[3], (int)outV.start[3], (int)outV.length[3]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])red, (int)0, (int)3, (byte[])outV.vector[4], (int)outV.start[4], (int)outV.length[4]));
        Assert.assertEquals((int)0, (int)StringExpr.compare((byte[])blankString, (int)0, (int)0, (byte[])outV.vector[5], (int)outV.start[5], (int)outV.length[5]));
    }

    private VectorizedRowBatch makeTrimBatch() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        BytesColumnVector inV = new BytesColumnVector();
        BytesColumnVector outV = new BytesColumnVector();
        b.cols[0] = inV;
        b.cols[1] = outV;
        inV.setRef(0, emptyString, 0, 0);
        inV.setRef(1, blanksLeft, 0, blanksLeft.length);
        inV.setRef(2, blanksRight, 0, blanksRight.length);
        inV.setRef(3, blanksBoth, 0, blanksBoth.length);
        inV.setRef(4, red, 0, red.length);
        inV.setRef(5, blankString, 0, blankString.length);
        b.size = 5;
        return b;
    }

    @Test
    public void testStringInExpr() {
        VectorizedRowBatch b = this.makeStringBatch();
        b.size = 2;
        b.cols[0].noNulls = true;
        byte[][] inVals = new byte[][]{red, blue};
        StringColumnInList expr = new StringColumnInList(0, 2);
        expr.setInListValues((byte[][])inVals);
        expr.evaluate(b);
        LongColumnVector outV = (LongColumnVector)b.cols[2];
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = this.makeStringBatch();
        b.size = 2;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        outV = (LongColumnVector)b.cols[2];
        Assert.assertEquals((boolean)true, (!outV.noNulls && outV.isNull[0] && !outV.isNull[1] ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = this.makeStringBatch();
        b.size = 2;
        b.cols[0].noNulls = true;
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        outV = (LongColumnVector)b.cols[2];
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((boolean)true, (boolean)outV.isRepeating);
    }

    @Test
    public void testRegex() throws HiveException {
        VectorizedRowBatch b = this.makeStringBatch();
        FilterStringColRegExpStringScalar expr = new FilterStringColRegExpStringScalar(0, "a.*".getBytes());
        b.size = 5;
        b.selectedInUse = false;
        BytesColumnVector v = (BytesColumnVector)b.cols[0];
        v.isRepeating = false;
        v.noNulls = false;
        String s1 = "4kMasVoB7lX1wc5i64bNk";
        String s2 = "a27V63IL7jK3o";
        String s3 = "27V63IL7jK3oa";
        String s4 = "27V63IL7jK3o";
        v.isNull[0] = false;
        v.setRef(0, s1.getBytes(), 0, s1.getBytes().length);
        v.isNull[1] = true;
        v.vector[1] = null;
        v.isNull[2] = false;
        v.setRef(2, s2.getBytes(), 0, s2.getBytes().length);
        v.isNull[3] = false;
        v.setRef(3, s3.getBytes(), 0, s3.getBytes().length);
        v.isNull[4] = false;
        v.setRef(4, s4.getBytes(), 0, s4.getBytes().length);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((int)3, (int)b.size);
        Assert.assertEquals((int)0, (int)b.selected[0]);
        Assert.assertEquals((int)2, (int)b.selected[1]);
        Assert.assertEquals((int)3, (int)b.selected[2]);
    }

    static {
        try {
            blue = "blue".getBytes("UTF-8");
            red = "red".getBytes("UTF-8");
            redred = "redred".getBytes("UTF-8");
            green = "green".getBytes("UTF-8");
            greenred = "greenred".getBytes("UTF-8");
            redgreen = "redgreen".getBytes("UTF-8");
            greengreen = "greengreen".getBytes("UTF-8");
            emptyString = "".getBytes("UTF-8");
            mixedUp = "mixedUp".getBytes("UTF-8");
            mixedUpLower = "mixedup".getBytes("UTF-8");
            mixedUpUpper = "MIXEDUP".getBytes("UTF-8");
            mixPercentPattern = "mix%".getBytes("UTF-8");
            multiByte = new byte[100];
            TestVectorStringExpressions.addMultiByteChars(multiByte);
            blanksLeft = "  foo".getBytes("UTF-8");
            blanksRight = "foo  ".getBytes("UTF-8");
            blanksBoth = "  foo  ".getBytes("UTF-8");
            blankString = "  ".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        red2 = new byte[red.length];
        System.arraycopy(red, 0, red2, 0, red.length);
    }
}

