/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.sql.Timestamp;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;

public class TestUtilities
extends TestCase {
    public void testGetFileExtension() {
        JobConf jc = new JobConf();
        TestUtilities.assertEquals((String)"No extension for uncompressed unknown format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        TestUtilities.assertEquals((String)"No extension for compressed unknown format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        TestUtilities.assertEquals((String)"No extension for uncompressed text format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        TestUtilities.assertEquals((String)"Deflate for uncompressed text format", (String)".deflate", (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        TestUtilities.assertEquals((String)"No extension for uncompressed default format", (String)"", (String)Utilities.getFileExtension((JobConf)jc, (boolean)false));
        TestUtilities.assertEquals((String)"Deflate for uncompressed default format", (String)".deflate", (String)Utilities.getFileExtension((JobConf)jc, (boolean)true));
        String extension = ".myext";
        jc.set("hive.output.file.extension", extension);
        TestUtilities.assertEquals((String)"Custom extension for uncompressed unknown format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        TestUtilities.assertEquals((String)"Custom extension for compressed unknown format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        TestUtilities.assertEquals((String)"Custom extension for uncompressed text format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        TestUtilities.assertEquals((String)"Custom extension for uncompressed text format", (String)extension, (String)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
    }

    public void testSerializeTimestamp() {
        Timestamp ts = new Timestamp(1374554702000L);
        ts.setNanos(123456);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((Object)ts);
        ArrayList<ExprNodeConstantDesc> children = new ArrayList<ExprNodeConstantDesc>(1);
        children.add(constant);
        ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFFromUtcTimestamp(), children);
        TestUtilities.assertEquals((String)desc.getExprString(), (String)Utilities.deserializeExpression((String)Utilities.serializeExpression((ExprNodeGenericFuncDesc)desc)).getExprString());
    }

    public void testgetDbTableName() throws HiveException {
        SessionState.start((HiveConf)new HiveConf(((Object)((Object)this)).getClass()));
        String curDefaultdb = SessionState.get().getCurrentDatabase();
        String tablename = "tab1";
        String[] dbtab = Utilities.getDbTableName((String)tablename);
        TestUtilities.assertEquals((String)"db name", (String)curDefaultdb, (String)dbtab[0]);
        TestUtilities.assertEquals((String)"table name", (String)tablename, (String)dbtab[1]);
        tablename = "dab1.tab1";
        dbtab = Utilities.getDbTableName((String)tablename);
        TestUtilities.assertEquals((String)"db name", (String)"dab1", (String)dbtab[0]);
        TestUtilities.assertEquals((String)"table name", (String)"tab1", (String)dbtab[1]);
        tablename = "dab1.tab1.x1";
        try {
            dbtab = Utilities.getDbTableName((String)tablename);
            TestUtilities.fail((String)"exception was expected for invalid table name");
        }
        catch (HiveException ex) {
            TestUtilities.assertEquals((String)("Invalid table name " + tablename), (String)ex.getMessage());
        }
    }
}

