/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.JobConf;

public class TestPlan
extends TestCase {
    public void testPlan() throws Exception {
        String F1 = "#affiliations";
        String F2 = "friends[0].friendid";
        try {
            ExprNodeColumnDesc expr1 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "#affiliations", "", false);
            ExprNodeColumnDesc expr2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "friends[0].friendid", "", false);
            ExprNodeDesc filterExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"==", (ExprNodeDesc[])new ExprNodeDesc[]{expr1, expr2});
            FilterDesc filterCtx = new FilterDesc(filterExpr, false);
            Operator op = OperatorFactory.get(FilterDesc.class);
            op.setConf((OperatorDesc)filterCtx);
            ArrayList<String> aliasList = new ArrayList<String>();
            aliasList.add("a");
            LinkedHashMap<String, ArrayList<String>> pa = new LinkedHashMap<String, ArrayList<String>>();
            pa.put("/tmp/testfolder", aliasList);
            TableDesc tblDesc = Utilities.defaultTd;
            PartitionDesc partDesc = new PartitionDesc(tblDesc, null);
            LinkedHashMap<String, PartitionDesc> pt = new LinkedHashMap<String, PartitionDesc>();
            pt.put("/tmp/testfolder", partDesc);
            LinkedHashMap<String, Operator> ao = new LinkedHashMap<String, Operator>();
            ao.put("a", op);
            MapredWork mrwork = new MapredWork();
            mrwork.getMapWork().setPathToAliases(pa);
            mrwork.getMapWork().setPathToPartitionInfo(pt);
            mrwork.getMapWork().setAliasToWork(ao);
            JobConf job = new JobConf(TestPlan.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utilities.serializePlan((Object)mrwork, (OutputStream)baos, (Configuration)job);
            baos.close();
            String v1 = baos.toString();
            job.set("fs.default.name", "file:///");
            Utilities.setMapRedWork((Configuration)job, (MapredWork)mrwork, (Path)new Path(System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + File.separator + "hive"));
            MapredWork mrwork2 = Utilities.getMapRedWork((Configuration)job);
            Utilities.clearWork((Configuration)job);
            baos.reset();
            Utilities.serializePlan((Object)mrwork2, (OutputStream)baos, (Configuration)job);
            baos.close();
            TestPlan.assertEquals((String)v1, (String)baos.toString());
        }
        catch (Exception excp) {
            excp.printStackTrace();
            throw excp;
        }
        System.out.println("Serialization/Deserialization of plan successful");
    }
}

