/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.TestExecDriver;
import org.apache.hadoop.hive.ql.exec.TextRecordReader;
import org.apache.hadoop.hive.ql.exec.TextRecordWriter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.CollectDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;

public class TestOperators
extends TestCase {
    protected InspectableObject[] r;

    protected void setUp() {
        this.r = new InspectableObject[5];
        ArrayList<String> names = new ArrayList<String>(3);
        names.add("col0");
        names.add("col1");
        names.add("col2");
        ArrayList<JavaStringObjectInspector> objectInspectors = new ArrayList<JavaStringObjectInspector>(3);
        objectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        objectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        objectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        for (int i = 0; i < 5; ++i) {
            ArrayList<String> data = new ArrayList<String>();
            data.add("" + i);
            data.add("" + (i + 1));
            data.add("" + (i + 2));
            try {
                this.r[i] = new InspectableObject();
                this.r[i].o = data;
                this.r[i].oi = ObjectInspectorFactory.getStandardStructObjectInspector(names, objectInspectors);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void testBaseFilterOperator() throws Throwable {
        try {
            System.out.println("Testing Filter Operator");
            ExprNodeColumnDesc col0 = TestExecDriver.getStringColumn("col0");
            ExprNodeColumnDesc col1 = TestExecDriver.getStringColumn("col1");
            ExprNodeColumnDesc col2 = TestExecDriver.getStringColumn("col2");
            ExprNodeConstantDesc zero = new ExprNodeConstantDesc((Object)"0");
            ExprNodeDesc func1 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)">", (ExprNodeDesc[])new ExprNodeDesc[]{col2, col1});
            ExprNodeDesc func2 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"==", (ExprNodeDesc[])new ExprNodeDesc[]{col0, zero});
            ExprNodeDesc func3 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"and", (ExprNodeDesc[])new ExprNodeDesc[]{func1, func2});
            assert (func3 != null);
            FilterDesc filterCtx = new FilterDesc(func3, false);
            Operator op = OperatorFactory.get(FilterDesc.class);
            op.setConf((OperatorDesc)filterCtx);
            op.initialize((Configuration)new JobConf(TestOperators.class), new ObjectInspector[]{this.r[0].oi});
            for (InspectableObject oner : this.r) {
                op.processOp(oner.o, 0);
            }
            Map results = op.getStats();
            System.out.println("filtered = " + results.get(FilterOperator.Counter.FILTERED));
            TestOperators.assertEquals((Object)4L, results.get(FilterOperator.Counter.FILTERED));
            System.out.println("passed = " + results.get(FilterOperator.Counter.PASSED));
            TestOperators.assertEquals((Object)1L, results.get(FilterOperator.Counter.PASSED));
            System.out.println("Filter Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void testTaskIds(String[] taskIds, String expectedAttemptId, String expectedTaskId) {
        JobConf conf = new JobConf(TestOperators.class);
        for (String one : taskIds) {
            conf.set("mapred.task.id", one);
            String attemptId = Utilities.getTaskId((Configuration)conf);
            TestOperators.assertEquals((String)expectedAttemptId, (String)attemptId);
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)attemptId), (String)expectedTaskId);
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)(attemptId + ".gz")), (String)expectedTaskId);
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)Utilities.toTempPath((Path)new Path(attemptId + ".gz")).toString()), (String)expectedTaskId);
        }
    }

    public void testFileSinkOperator() throws Throwable {
        try {
            this.testTaskIds(new String[]{"attempt_200707121733_0003_m_000005_0", "attempt_local_0001_m_000005_0", "task_200709221812_0001_m_000005_0", "task_local_0001_m_000005_0"}, "000005_0", "000005");
            this.testTaskIds(new String[]{"job_local_0001_map_000005", "job_local_0001_reduce_000005"}, "000005", "000005");
            this.testTaskIds(new String[]{"1234567"}, "1234567", "1234567");
            TestOperators.assertEquals((String)Utilities.getTaskIdFromFilename((String)"/mnt/dev005/task_local_0001_m_000005_0"), (String)"000005");
            System.out.println("FileSink Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testScriptOperatorEnvVarsProcessing() throws Throwable {
        try {
            ScriptOperator scriptOperator = new ScriptOperator();
            TestOperators.assertEquals((String)"a_b_c", (String)scriptOperator.safeEnvVarName("a.b.c"));
            TestOperators.assertEquals((String)"a_b_c", (String)scriptOperator.safeEnvVarName("a-b-c"));
            TestOperators.assertEquals((String)"value", (String)scriptOperator.safeEnvVarValue("value", "name", false));
            TestOperators.assertEquals((String)"value", (String)scriptOperator.safeEnvVarValue("value", "name", true));
            char[] array = new char[20481];
            Arrays.fill(array, 'a');
            String hugeEnvVar = new String(array);
            TestOperators.assertEquals((int)20481, (int)hugeEnvVar.length());
            TestOperators.assertEquals((int)20481, (int)scriptOperator.safeEnvVarValue(hugeEnvVar, "name", false).length());
            TestOperators.assertEquals((int)20480, (int)scriptOperator.safeEnvVarValue(hugeEnvVar, "name", true).length());
            JobConf hconf = new JobConf(ScriptOperator.class);
            hconf.set("name", hugeEnvVar);
            HashMap env = new HashMap();
            HiveConf.setBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESCRIPTTRUNCATEENV, (boolean)false);
            scriptOperator.addJobConfToEnvironment((Configuration)hconf, env);
            TestOperators.assertEquals((int)20481, (int)((String)env.get("name")).length());
            HiveConf.setBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESCRIPTTRUNCATEENV, (boolean)true);
            scriptOperator.addJobConfToEnvironment((Configuration)hconf, env);
            TestOperators.assertEquals((int)20480, (int)((String)env.get("name")).length());
            System.out.println("Script Operator Environment Variables processing ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testScriptOperator() throws Throwable {
        try {
            System.out.println("Testing Script Operator");
            ExprNodeColumnDesc exprDesc1 = TestExecDriver.getStringColumn("col1");
            ExprNodeColumnDesc expr1 = TestExecDriver.getStringColumn("col0");
            ExprNodeConstantDesc expr2 = new ExprNodeConstantDesc((Object)"1");
            ExprNodeDesc exprDesc2 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{expr1, expr2});
            ArrayList<Object> earr = new ArrayList<Object>();
            earr.add(exprDesc1);
            earr.add(exprDesc2);
            ArrayList<String> outputCols = new ArrayList<String>();
            for (int i = 0; i < earr.size(); ++i) {
                outputCols.add("_col" + i);
            }
            SelectDesc selectCtx = new SelectDesc(earr, outputCols);
            Operator op = OperatorFactory.get(SelectDesc.class);
            op.setConf((OperatorDesc)selectCtx);
            TableDesc scriptOutput = PlanUtils.getDefaultTableDesc((String)"9", (String)"a,b");
            TableDesc scriptInput = PlanUtils.getDefaultTableDesc((String)"9", (String)"a,b");
            ScriptDesc sd = new ScriptDesc("cat", scriptOutput, TextRecordWriter.class, scriptInput, TextRecordReader.class, TextRecordReader.class, PlanUtils.getDefaultTableDesc((String)"9", (String)"key"));
            Operator sop = OperatorFactory.getAndMakeChild((OperatorDesc)sd, (Operator[])new Operator[]{op});
            CollectDesc cd = new CollectDesc(Integer.valueOf(10));
            CollectOperator cdop = (CollectOperator)OperatorFactory.getAndMakeChild((OperatorDesc)cd, (Operator[])new Operator[]{sop});
            op.initialize((Configuration)new JobConf(TestOperators.class), new ObjectInspector[]{this.r[0].oi});
            for (int i = 0; i < 5; ++i) {
                op.processOp(this.r[i].o, 0);
            }
            op.close(false);
            InspectableObject io = new InspectableObject();
            for (int i = 0; i < 5; ++i) {
                cdop.retrieve(io);
                System.out.println("[" + i + "] io.o=" + io.o);
                System.out.println("[" + i + "] io.oi=" + io.oi);
                StructObjectInspector soi = (StructObjectInspector)io.oi;
                assert (soi != null);
                StructField a = soi.getStructFieldRef("a");
                StructField b = soi.getStructFieldRef("b");
                TestOperators.assertEquals((Object)("" + (i + 1)), (Object)((PrimitiveObjectInspector)a.getFieldObjectInspector()).getPrimitiveJavaObject(soi.getStructFieldData(io.o, a)));
                TestOperators.assertEquals((Object)(i + "1"), (Object)((PrimitiveObjectInspector)b.getFieldObjectInspector()).getPrimitiveJavaObject(soi.getStructFieldData(io.o, b)));
            }
            System.out.println("Script Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testMapOperator() throws Throwable {
        try {
            System.out.println("Testing Map Operator");
            JobConf hconf = new JobConf(TestOperators.class);
            HiveConf.setVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HADOOPMAPFILENAME, (String)"hdfs:///testDir/testFile");
            IOContext.get().setInputPath(new Path("hdfs:///testDir/testFile"));
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add("a");
            aliases.add("b");
            LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
            pathToAliases.put("hdfs:///testDir", aliases);
            TableDesc td = Utilities.defaultTd;
            PartitionDesc pd = new PartitionDesc(td, null);
            LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<String, PartitionDesc>();
            pathToPartitionInfo.put("hdfs:///testDir", pd);
            CollectDesc cd = new CollectDesc(Integer.valueOf(1));
            CollectOperator cdop1 = (CollectOperator)OperatorFactory.get(CollectDesc.class);
            cdop1.setConf((OperatorDesc)cd);
            CollectOperator cdop2 = (CollectOperator)OperatorFactory.get(CollectDesc.class);
            cdop2.setConf((OperatorDesc)cd);
            LinkedHashMap<String, CollectOperator> aliasToWork = new LinkedHashMap<String, CollectOperator>();
            aliasToWork.put("a", cdop1);
            aliasToWork.put("b", cdop2);
            MapredWork mrwork = new MapredWork();
            mrwork.getMapWork().setPathToAliases(pathToAliases);
            mrwork.getMapWork().setPathToPartitionInfo(pathToPartitionInfo);
            mrwork.getMapWork().setAliasToWork(aliasToWork);
            MapOperator mo = new MapOperator();
            mo.initializeAsRoot((Configuration)hconf, mrwork.getMapWork());
            Text tw = new Text();
            InspectableObject io1 = new InspectableObject();
            InspectableObject io2 = new InspectableObject();
            for (int i = 0; i < 5; ++i) {
                String answer = "[[" + i + ", " + (i + 1) + ", " + (i + 2) + "]]";
                tw.set("" + i + "\u0001" + (i + 1) + "\u0001" + (i + 2));
                mo.process((Writable)tw);
                cdop1.retrieve(io1);
                cdop2.retrieve(io2);
                System.out.println("io1.o.toString() = " + io1.o.toString());
                System.out.println("io2.o.toString() = " + io2.o.toString());
                System.out.println("answer.toString() = " + answer.toString());
                TestOperators.assertEquals((String)answer.toString(), (String)io1.o.toString());
                TestOperators.assertEquals((String)answer.toString(), (String)io2.o.toString());
            }
            System.out.println("Map Operator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

