/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

public class TestExpressionEvaluator
extends TestCase {
    protected InspectableObject r;
    ArrayList<Text> col1;
    TypeInfo col1Type;
    ArrayList<Text> cola;
    TypeInfo colaType;
    ArrayList<Object> data;
    ArrayList<String> names;
    ArrayList<TypeInfo> typeInfos;
    TypeInfo dataType;

    public TestExpressionEvaluator() {
        SessionState ss = new SessionState(new HiveConf());
        SessionState.setCurrentSessionState((SessionState)ss);
        this.col1 = new ArrayList();
        this.col1.add(new Text("0"));
        this.col1.add(new Text("1"));
        this.col1.add(new Text("2"));
        this.col1.add(new Text("3"));
        this.col1Type = TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.cola = new ArrayList();
        this.cola.add(new Text("a"));
        this.cola.add(new Text("b"));
        this.cola.add(new Text("c"));
        this.colaType = TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
        try {
            this.data = new ArrayList();
            this.data.add(this.col1);
            this.data.add(this.cola);
            this.names = new ArrayList();
            this.names.add("col1");
            this.names.add("cola");
            this.typeInfos = new ArrayList();
            this.typeInfos.add(this.col1Type);
            this.typeInfos.add(this.colaType);
            this.dataType = TypeInfoFactory.getStructTypeInfo(this.names, this.typeInfos);
            this.r = new InspectableObject();
            this.r.o = this.data;
            this.r.oi = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)this.dataType);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void setUp() {
    }

    public void testExprNodeColumnEvaluator() throws Throwable {
        try {
            ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(this.colaType, "cola", "", false);
            ExprNodeEvaluator eval = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc);
            ObjectInspector resultOI = eval.initialize(this.r.oi);
            Object resultO = eval.evaluate(this.r.o);
            Object standardResult = ObjectInspectorUtils.copyToStandardObject((Object)resultO, (ObjectInspector)resultOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            TestExpressionEvaluator.assertEquals(this.cola, (Object)standardResult);
            System.out.println("ExprNodeColumnEvaluator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static ExprNodeDesc getListIndexNode(ExprNodeDesc node, int index) {
        return TestExpressionEvaluator.getListIndexNode(node, (ExprNodeDesc)new ExprNodeConstantDesc((Object)index));
    }

    private static ExprNodeDesc getListIndexNode(ExprNodeDesc node, ExprNodeDesc index) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        children.add(node);
        children.add(index);
        return new ExprNodeGenericFuncDesc(((ListTypeInfo)node.getTypeInfo()).getListElementTypeInfo(), FunctionRegistry.getGenericUDFForIndex(), children);
    }

    public void testExprNodeFuncEvaluator() throws Throwable {
        try {
            ExprNodeColumnDesc col1desc = new ExprNodeColumnDesc(this.col1Type, "col1", "", false);
            ExprNodeColumnDesc coladesc = new ExprNodeColumnDesc(this.colaType, "cola", "", false);
            ExprNodeDesc col11desc = TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)col1desc, 1);
            ExprNodeDesc cola0desc = TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)coladesc, 0);
            ExprNodeDesc func1 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{col11desc, cola0desc});
            ExprNodeEvaluator eval = ExprNodeEvaluatorFactory.get((ExprNodeDesc)func1);
            ObjectInspector resultOI = eval.initialize(this.r.oi);
            Object resultO = eval.evaluate(this.r.o);
            TestExpressionEvaluator.assertEquals((Object)"1a", (Object)ObjectInspectorUtils.copyToStandardObject((Object)resultO, (ObjectInspector)resultOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
            System.out.println("ExprNodeFuncEvaluator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testExprNodeConversionEvaluator() throws Throwable {
        try {
            ExprNodeColumnDesc col1desc = new ExprNodeColumnDesc(this.col1Type, "col1", "", false);
            ExprNodeDesc col11desc = TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)col1desc, 1);
            ExprNodeDesc func1 = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"double", (ExprNodeDesc[])new ExprNodeDesc[]{col11desc});
            ExprNodeEvaluator eval = ExprNodeEvaluatorFactory.get((ExprNodeDesc)func1);
            ObjectInspector resultOI = eval.initialize(this.r.oi);
            Object resultO = eval.evaluate(this.r.o);
            TestExpressionEvaluator.assertEquals((Object)Double.valueOf("1"), (Object)ObjectInspectorUtils.copyToStandardObject((Object)resultO, (ObjectInspector)resultOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
            System.out.println("testExprNodeConversionEvaluator ok");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void measureSpeed(String expr, int times, ExprNodeEvaluator eval, InspectableObject input, Object standardJavaOutput) throws HiveException {
        System.out.println("Evaluating " + expr + " for " + times + " times");
        new InspectableObject();
        ObjectInspector resultOI = eval.initialize(input.oi);
        Object resultO = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            resultO = eval.evaluate(input.o);
        }
        long end = System.currentTimeMillis();
        TestExpressionEvaluator.assertEquals((Object)standardJavaOutput, (Object)ObjectInspectorUtils.copyToStandardObject((Object)resultO, (ObjectInspector)resultOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
        System.out.println("Evaluation finished: " + String.format("%2.3f", (double)(end - start) * 0.001) + " seconds, " + String.format("%2.3f", (double)(end - start) * 1000.0 / (double)times) + " seconds/million call.");
    }

    public void testExprNodeSpeed() throws Throwable {
        try {
            int basetimes = 100000;
            TestExpressionEvaluator.measureSpeed("1 + 2", basetimes * 100, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"+", (ExprNodeDesc[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)1), new ExprNodeConstantDesc((Object)2)})), this.r, 3);
            TestExpressionEvaluator.measureSpeed("1 + 2 - 3", basetimes * 100, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"-", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"+", (ExprNodeDesc[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)1), new ExprNodeConstantDesc((Object)2)}), new ExprNodeConstantDesc((Object)3)})), this.r, 0);
            TestExpressionEvaluator.measureSpeed("1 + 2 - 3 + 4", basetimes * 100, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"+", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"-", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"+", (ExprNodeDesc[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)1), new ExprNodeConstantDesc((Object)2)}), new ExprNodeConstantDesc((Object)3)}), new ExprNodeConstantDesc((Object)4)})), this.r, 4);
            TestExpressionEvaluator.measureSpeed("concat(\"1\", \"2\")", basetimes * 100, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)"1"), new ExprNodeConstantDesc((Object)"2")})), this.r, "12");
            TestExpressionEvaluator.measureSpeed("concat(concat(\"1\", \"2\"), \"3\")", basetimes * 100, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)"1"), new ExprNodeConstantDesc((Object)"2")}), new ExprNodeConstantDesc((Object)"3")})), this.r, "123");
            TestExpressionEvaluator.measureSpeed("concat(concat(concat(\"1\", \"2\"), \"3\"), \"4\")", basetimes * 100, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{new ExprNodeConstantDesc((Object)"1"), new ExprNodeConstantDesc((Object)"2")}), new ExprNodeConstantDesc((Object)"3")}), new ExprNodeConstantDesc((Object)"4")})), this.r, "1234");
            ExprNodeConstantDesc constant1 = new ExprNodeConstantDesc((Object)1);
            ExprNodeConstantDesc constant2 = new ExprNodeConstantDesc((Object)2);
            TestExpressionEvaluator.measureSpeed("concat(col1[1], cola[1])", basetimes * 10, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.col1Type, "col1", "", false), (ExprNodeDesc)constant1), TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.colaType, "cola", "", false), (ExprNodeDesc)constant1)})), this.r, "1b");
            TestExpressionEvaluator.measureSpeed("concat(concat(col1[1], cola[1]), col1[2])", basetimes * 10, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.col1Type, "col1", "", false), (ExprNodeDesc)constant1), TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.colaType, "cola", "", false), (ExprNodeDesc)constant1)}), TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.col1Type, "col1", "", false), (ExprNodeDesc)constant2)})), this.r, "1b2");
            TestExpressionEvaluator.measureSpeed("concat(concat(concat(col1[1], cola[1]), col1[2]), cola[2])", basetimes * 10, ExprNodeEvaluatorFactory.get((ExprNodeDesc)TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc((String)"concat", (ExprNodeDesc[])new ExprNodeDesc[]{TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.col1Type, "col1", "", false), (ExprNodeDesc)constant1), TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.colaType, "cola", "", false), (ExprNodeDesc)constant1)}), TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.col1Type, "col1", "", false), (ExprNodeDesc)constant2)}), TestExpressionEvaluator.getListIndexNode((ExprNodeDesc)new ExprNodeColumnDesc(this.colaType, "cola", "", false), (ExprNodeDesc)constant2)})), this.r, "1b2c");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

