/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezSession;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTezTask {
    DagUtils utils;
    MapWork[] mws;
    ReduceWork[] rws;
    TezWork work;
    TezTask task;
    TezSession session;
    TezSessionState sessionState;
    JobConf conf;
    LocalResource appLr;
    Operator<?> op;
    Path path;
    FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.utils = (DagUtils)Mockito.mock(DagUtils.class);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        this.path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.path.getFileSystem((Configuration)Matchers.any(Configuration.class))).thenReturn((Object)this.fs);
        Mockito.when((Object)this.utils.getTezDir((Path)Matchers.any(Path.class))).thenReturn((Object)this.path);
        Mockito.when((Object)this.utils.createVertex((JobConf)Matchers.any(JobConf.class), (BaseWork)Matchers.any(BaseWork.class), (Path)Matchers.any(Path.class), (LocalResource)Matchers.any(LocalResource.class), (List)Matchers.any(List.class), (FileSystem)Matchers.any(FileSystem.class), (Context)Matchers.any(Context.class), Matchers.anyBoolean(), (TezWork)Matchers.any(TezWork.class))).thenAnswer((Answer)new Answer<Vertex>(){

            public Vertex answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return new Vertex(((BaseWork)args[1]).getName(), (ProcessorDescriptor)Mockito.mock(ProcessorDescriptor.class), 0, (Resource)Mockito.mock(Resource.class));
            }
        });
        Mockito.when((Object)this.utils.createEdge((JobConf)Matchers.any(JobConf.class), (Vertex)Matchers.any(Vertex.class), (JobConf)Matchers.any(JobConf.class), (Vertex)Matchers.any(Vertex.class), (TezEdgeProperty)Matchers.any(TezEdgeProperty.class))).thenAnswer((Answer)new Answer<Edge>(){

            public Edge answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return new Edge((Vertex)args[1], (Vertex)args[3], (EdgeProperty)Mockito.mock(EdgeProperty.class));
            }
        });
        this.work = new TezWork("");
        this.mws = new MapWork[]{new MapWork(), new MapWork()};
        this.rws = new ReduceWork[]{new ReduceWork(), new ReduceWork()};
        this.work.addAll((BaseWork[])this.mws);
        this.work.addAll((BaseWork[])this.rws);
        int i = 0;
        for (BaseWork w : this.work.getAllWork()) {
            w.setName("Work " + ++i);
        }
        this.op = (Operator)Mockito.mock(Operator.class);
        LinkedHashMap map = new LinkedHashMap();
        map.put("foo", this.op);
        this.mws[0].setAliasToWork(map);
        this.mws[1].setAliasToWork(map);
        LinkedHashMap pathMap = new LinkedHashMap();
        ArrayList<String> aliasList = new ArrayList<String>();
        aliasList.add("foo");
        pathMap.put("foo", aliasList);
        this.mws[0].setPathToAliases(pathMap);
        this.mws[1].setPathToAliases(pathMap);
        this.rws[0].setReducer(this.op);
        this.rws[1].setReducer(this.op);
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        this.work.connect((BaseWork)this.mws[0], (BaseWork)this.rws[0], edgeProp);
        this.work.connect((BaseWork)this.mws[1], (BaseWork)this.rws[0], edgeProp);
        this.work.connect((BaseWork)this.rws[0], (BaseWork)this.rws[1], edgeProp);
        this.task = new TezTask(this.utils);
        this.task.setWork((Serializable)this.work);
        this.task.setConsole((SessionState.LogHelper)Mockito.mock(SessionState.LogHelper.class));
        this.conf = new JobConf();
        this.appLr = (LocalResource)Mockito.mock(LocalResource.class);
        this.session = (TezSession)Mockito.mock(TezSession.class);
        this.sessionState = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)this.sessionState.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.submitDAG((DAG)Matchers.any(DAG.class))).thenThrow(new Throwable[]{new SessionNotRunning("")}).thenReturn(Mockito.mock(DAGClient.class));
    }

    @After
    public void tearDown() throws Exception {
        this.utils = null;
        this.work = null;
        this.task = null;
        this.path = null;
        this.fs = null;
    }

    @Test
    public void testBuildDag() throws IllegalArgumentException, IOException, Exception {
        DAG dag = this.task.build(this.conf, this.work, this.path, this.appLr, null, new Context((Configuration)this.conf));
        for (BaseWork w : this.work.getAllWork()) {
            Vertex v = dag.getVertex(w.getName());
            Assert.assertNotNull((Object)v);
            List outs = v.getOutputVertices();
            for (BaseWork x : this.work.getChildren(w)) {
                boolean found = false;
                for (Vertex u : outs) {
                    if (!u.getVertexName().equals(x.getName())) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
        }
    }

    @Test
    public void testEmptyWork() throws IllegalArgumentException, IOException, Exception {
        DAG dag = this.task.build(this.conf, new TezWork(""), this.path, this.appLr, null, new Context((Configuration)this.conf));
        Assert.assertEquals((long)dag.getVertices().size(), (long)0L);
    }

    @Test
    public void testSubmit() throws LoginException, IllegalArgumentException, IOException, TezException, InterruptedException, URISyntaxException, HiveException {
        DAG dag = new DAG("test");
        this.task.submit(this.conf, dag, this.path, this.appLr, this.sessionState);
        ((TezSessionState)Mockito.verify((Object)this.sessionState, (VerificationMode)Mockito.times((int)1))).open((HiveConf)Matchers.any(HiveConf.class));
        ((TezSessionState)Mockito.verify((Object)this.sessionState, (VerificationMode)Mockito.times((int)1))).close(Matchers.eq((boolean)true));
        ((TezSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)2))).submitDAG((DAG)Matchers.any(DAG.class));
    }

    @Test
    public void testClose() throws HiveException {
        this.task.close(this.work, 0);
        ((Operator)Mockito.verify(this.op, (VerificationMode)Mockito.times((int)4))).jobClose((Configuration)Matchers.any(Configuration.class), Matchers.eq((boolean)true));
    }
}

