/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColNotEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColNotEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarNotEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleScalarNotEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColNotEqualDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColNotEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarNotEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarNotEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnScalarFilterVectorExpressionEvaluation {
    private static final int BATCH_SIZE = 100;
    private static final long SEED = 64087L;

    @Test
    public void testFilterLongColEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColEqualDoubleScalar vectorExpression = new FilterLongColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColEqualDoubleScalar vectorExpression = new FilterDoubleColEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColNotEqualDoubleScalar vectorExpression = new FilterLongColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColNotEqualDoubleScalar vectorExpression = new FilterDoubleColNotEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessDoubleScalar vectorExpression = new FilterLongColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessDoubleScalar vectorExpression = new FilterDoubleColLessDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColLessEqualDoubleScalar vectorExpression = new FilterLongColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColLessEqualDoubleScalar vectorExpression = new FilterDoubleColLessEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterDoubleScalar vectorExpression = new FilterLongColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterDoubleScalar vectorExpression = new FilterDoubleColGreaterDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterLongColGreaterEqualDoubleScalar vectorExpression = new FilterLongColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleColGreaterEqualDoubleScalar vectorExpression = new FilterDoubleColGreaterEqualDoubleScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColEqualLongScalar vectorExpression = new FilterLongColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColEqualLongScalar vectorExpression = new FilterDoubleColEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] == (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] != (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "==" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColNotEqualLongScalar vectorExpression = new FilterLongColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColNotEqualLongScalar vectorExpression = new FilterDoubleColNotEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] != (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] == (double)scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "!=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessLongScalar vectorExpression = new FilterLongColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] >= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessLongScalar vectorExpression = new FilterDoubleColLessLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] < (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] < (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColLessEqualLongScalar vectorExpression = new FilterLongColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] > scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColLessEqualLongScalar vectorExpression = new FilterDoubleColLessEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] <= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] <= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + "<=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterLongScalar vectorExpression = new FilterLongColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] <= scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterLongScalar vectorExpression = new FilterDoubleColGreaterLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] > (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] > (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalar() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongColGreaterEqualLongScalar vectorExpression = new FilterLongColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || inputColumnVector.vector[i] < scalarValue) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalarColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalarColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalar() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongScalarColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterDoubleColGreaterEqualLongScalar vectorExpression = new FilterDoubleColGreaterEqualLongScalar(0, scalarValue);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && inputColumnVector.vector[i] >= (double)scalarValue ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(inputColumnVector.vector[i] >= (double)scalarValue)) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector.vector[i] + ">=" + scalarValue + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualDoubleColumn vectorExpression = new FilterLongScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualDoubleColumn vectorExpression = new FilterDoubleScalarEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualDoubleColumn vectorExpression = new FilterLongScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || (double)scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualDoubleColumn vectorExpression = new FilterDoubleScalarNotEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessDoubleColumn vectorExpression = new FilterLongScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessDoubleColumn vectorExpression = new FilterDoubleScalarLessDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualDoubleColumn vectorExpression = new FilterLongScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualDoubleColumn vectorExpression = new FilterDoubleScalarLessEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterDoubleColumn vectorExpression = new FilterLongScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterDoubleColumn vectorExpression = new FilterDoubleScalarGreaterDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualDoubleColumn vectorExpression = new FilterLongScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && (double)scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !((double)scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumnColNulls() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumn() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualDoubleColumnColRepeats() {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualDoubleColumn vectorExpression = new FilterDoubleScalarGreaterEqualDoubleColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarEqualLongColumn vectorExpression = new FilterLongScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarEqualLongColumn vectorExpression = new FilterDoubleScalarEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue == (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue != (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "==" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarNotEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarNotEqualLongColumn vectorExpression = new FilterLongScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarNotEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarNotEqualLongColumn vectorExpression = new FilterDoubleScalarNotEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue != (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue == (double)inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "!=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessLongColumn vectorExpression = new FilterLongScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue >= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessLongColumn vectorExpression = new FilterDoubleScalarLessLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue < (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue < (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarLessEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarLessEqualLongColumn vectorExpression = new FilterLongScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue > inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarLessEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarLessEqualLongColumn vectorExpression = new FilterDoubleScalarLessEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue <= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue <= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + "<=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterLongColumn vectorExpression = new FilterLongScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue <= inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterLongColumn vectorExpression = new FilterDoubleScalarGreaterLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue > (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue > (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongScalarGreaterEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        long scalarValue = 0L;
        while ((scalarValue = rand.nextLong()) == 0L) {
        }
        FilterLongScalarGreaterEqualLongColumn vectorExpression = new FilterLongScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || scalarValue < inputColumnVector.vector[i]) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumnColNullsRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumnColNulls() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumn() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleScalarGreaterEqualLongColumnColRepeats() {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(1, 100);
        rowBatch.cols[0] = inputColumnVector;
        double scalarValue = 0.0;
        while ((scalarValue = rand.nextDouble()) == 0.0) {
        }
        FilterDoubleScalarGreaterEqualLongColumn vectorExpression = new FilterDoubleScalarGreaterEqualLongColumn(scalarValue, 0);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        int i = 0;
        if (inputColumnVector.isRepeating) {
            selectedIndex = !inputColumnVector.isNull[i] && scalarValue >= (double)inputColumnVector.vector[i] ? 100 : 0;
        } else {
            for (i = 0; i < 100; ++i) {
                if (inputColumnVector.isNull[i] || !(scalarValue >= (double)inputColumnVector.vector[i])) continue;
                Assert.assertEquals((String)("Vector index that passes filter " + scalarValue + ">=" + inputColumnVector.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
                ++selectedIndex;
            }
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }
}

