/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.junit.Test;

public class TestDecimalUtil {
    @Test
    public void testFloor() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        Decimal128 expected1 = new Decimal128(19L, 0);
        DecimalUtil.floor((int)0, (Decimal128)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected1.compareTo(dcv.vector[0]));
        Decimal128 d2 = new Decimal128(23.0, 5);
        Decimal128 expected2 = new Decimal128(23L, 0);
        DecimalUtil.floor((int)0, (Decimal128)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected2.compareTo(dcv.vector[0]));
        Decimal128 d3 = new Decimal128(-25.34567, 5);
        Decimal128 expected3 = new Decimal128(-26L, 0);
        DecimalUtil.floor((int)0, (Decimal128)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected3.compareTo(dcv.vector[0]));
        Decimal128 d4 = new Decimal128(-17L, 5);
        Decimal128 expected4 = new Decimal128(-17L, 0);
        DecimalUtil.floor((int)0, (Decimal128)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected4.compareTo(dcv.vector[0]));
        Decimal128 d5 = new Decimal128(-0.3, 5);
        Decimal128 expected5 = new Decimal128(-1L, 0);
        DecimalUtil.floor((int)0, (Decimal128)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected5.compareTo(dcv.vector[0]));
        Decimal128 d6 = new Decimal128(0.3, 5);
        Decimal128 expected6 = new Decimal128(0L, 0);
        DecimalUtil.floor((int)0, (Decimal128)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected6.compareTo(dcv.vector[0]));
    }

    @Test
    public void testCeiling() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        Decimal128 expected1 = new Decimal128(20L, 0);
        DecimalUtil.ceiling((int)0, (Decimal128)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected1.compareTo(dcv.vector[0]));
        Decimal128 d2 = new Decimal128(23.0, 5);
        Decimal128 expected2 = new Decimal128(23L, 0);
        DecimalUtil.ceiling((int)0, (Decimal128)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected2.compareTo(dcv.vector[0]));
        Decimal128 d3 = new Decimal128(-25.34567, 5);
        Decimal128 expected3 = new Decimal128(-25L, 0);
        DecimalUtil.ceiling((int)0, (Decimal128)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected3.compareTo(dcv.vector[0]));
        Decimal128 d4 = new Decimal128(-17L, 5);
        Decimal128 expected4 = new Decimal128(-17L, 0);
        DecimalUtil.ceiling((int)0, (Decimal128)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected4.compareTo(dcv.vector[0]));
        Decimal128 d5 = new Decimal128(-0.3, 5);
        Decimal128 expected5 = new Decimal128(0L, 0);
        DecimalUtil.ceiling((int)0, (Decimal128)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected5.compareTo(dcv.vector[0]));
        Decimal128 d6 = new Decimal128(0.3, 5);
        Decimal128 expected6 = new Decimal128(1L, 0);
        DecimalUtil.ceiling((int)0, (Decimal128)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected6.compareTo(dcv.vector[0]));
    }

    @Test
    public void testAbs() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        DecimalUtil.abs((int)0, (Decimal128)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)d1.compareTo(dcv.vector[0]));
        Decimal128 d2 = new Decimal128(-25.34567, 5);
        Decimal128 expected2 = new Decimal128(25.34567, 5);
        DecimalUtil.abs((int)0, (Decimal128)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected2.compareTo(dcv.vector[0]));
    }

    @Test
    public void testRound() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 0);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        Decimal128 expected1 = new Decimal128(20L, 0);
        DecimalUtil.round((int)0, (Decimal128)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected1.compareTo(dcv.vector[0]));
        Decimal128 d2 = new Decimal128(23.0, 5);
        Decimal128 expected2 = new Decimal128(23L, 0);
        DecimalUtil.round((int)0, (Decimal128)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected2.compareTo(dcv.vector[0]));
        Decimal128 d3 = new Decimal128(-25.34567, 5);
        Decimal128 expected3 = new Decimal128(-25L, 0);
        DecimalUtil.round((int)0, (Decimal128)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected3.compareTo(dcv.vector[0]));
        Decimal128 d4 = new Decimal128(-17L, 5);
        Decimal128 expected4 = new Decimal128(-17L, 0);
        DecimalUtil.round((int)0, (Decimal128)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected4.compareTo(dcv.vector[0]));
        Decimal128 d5 = new Decimal128(19.36778, 5);
        Decimal128 expected5 = new Decimal128(19L, 0);
        DecimalUtil.round((int)0, (Decimal128)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected5.compareTo(dcv.vector[0]));
        Decimal128 d6 = new Decimal128(-25.54567, 5);
        Decimal128 expected6 = new Decimal128(-26L, 0);
        DecimalUtil.round((int)0, (Decimal128)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected6.compareTo(dcv.vector[0]));
    }

    @Test
    public void testRoundWithDigits() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 3);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        Decimal128 expected1 = new Decimal128(19.568, 3);
        DecimalUtil.round((int)0, (Decimal128)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected1.compareTo(dcv.vector[0]));
        Decimal128 d2 = new Decimal128(23.567, 5);
        Decimal128 expected2 = new Decimal128(23.567, 3);
        DecimalUtil.round((int)0, (Decimal128)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected2.compareTo(dcv.vector[0]));
        Decimal128 d3 = new Decimal128(-25.34567, 5);
        Decimal128 expected3 = new Decimal128(-25.346, 3);
        DecimalUtil.round((int)0, (Decimal128)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected3.compareTo(dcv.vector[0]));
        Decimal128 d4 = new Decimal128(-17.234, 5);
        Decimal128 expected4 = new Decimal128(-17.234, 3);
        DecimalUtil.round((int)0, (Decimal128)d4, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected4.compareTo(dcv.vector[0]));
        Decimal128 d5 = new Decimal128(19.36748, 5);
        Decimal128 expected5 = new Decimal128(19.367, 3);
        DecimalUtil.round((int)0, (Decimal128)d5, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected5.compareTo(dcv.vector[0]));
        Decimal128 d6 = new Decimal128(-25.54537, 5);
        Decimal128 expected6 = new Decimal128(-25.545, 3);
        DecimalUtil.round((int)0, (Decimal128)d6, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected6.compareTo(dcv.vector[0]));
    }

    @Test
    public void testNegate() {
        DecimalColumnVector dcv = new DecimalColumnVector(4, 20, 13);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        Decimal128 expected1 = new Decimal128(-19.56778, 5);
        DecimalUtil.negate((int)0, (Decimal128)d1, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected1.compareTo(dcv.vector[0]));
        Decimal128 d2 = new Decimal128(-25.34567, 5);
        Decimal128 expected2 = new Decimal128(25.34567, 5);
        DecimalUtil.negate((int)0, (Decimal128)d2, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected2.compareTo(dcv.vector[0]));
        Decimal128 d3 = new Decimal128(0L, 5);
        Decimal128 expected3 = new Decimal128(0L, 0);
        DecimalUtil.negate((int)0, (Decimal128)d3, (DecimalColumnVector)dcv);
        Assert.assertEquals((int)0, (int)expected3.compareTo(dcv.vector[0]));
    }

    @Test
    public void testSign() {
        LongColumnVector lcv = new LongColumnVector(4);
        Decimal128 d1 = new Decimal128(19.56778, 5);
        DecimalUtil.sign((int)0, (Decimal128)d1, (LongColumnVector)lcv);
        Assert.assertEquals((long)1L, (long)lcv.vector[0]);
        Decimal128 d2 = new Decimal128(-25.34567, 5);
        DecimalUtil.sign((int)0, (Decimal128)d2, (LongColumnVector)lcv);
        Assert.assertEquals((long)-1L, (long)lcv.vector[0]);
        Decimal128 d3 = new Decimal128(0L, 5);
        DecimalUtil.sign((int)0, (Decimal128)d3, (LongColumnVector)lcv);
        Assert.assertEquals((long)0L, (long)lcv.vector[0]);
    }
}

