/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestConstantVectorExpression {
    @Test
    public void testConstantExpression() {
        ConstantVectorExpression longCve = new ConstantVectorExpression(0, 17L);
        ConstantVectorExpression doubleCve = new ConstantVectorExpression(1, 17.34);
        String str = "alpha";
        ConstantVectorExpression bytesCve = new ConstantVectorExpression(2, str.getBytes());
        Decimal128 decVal = new Decimal128(25.8, 1);
        ConstantVectorExpression decimalCve = new ConstantVectorExpression(3, decVal);
        int size = 20;
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(size, 4, 0);
        LongColumnVector lcv = (LongColumnVector)vrg.cols[0];
        DoubleColumnVector dcv = new DoubleColumnVector(size);
        BytesColumnVector bcv = new BytesColumnVector(size);
        DecimalColumnVector dv = new DecimalColumnVector(5, 1);
        vrg.cols[1] = dcv;
        vrg.cols[2] = bcv;
        vrg.cols[3] = dv;
        longCve.evaluate(vrg);
        doubleCve.evaluate(vrg);
        bytesCve.evaluate(vrg);
        decimalCve.evaluate(vrg);
        Assert.assertTrue((boolean)lcv.isRepeating);
        Assert.assertTrue((boolean)dcv.isRepeating);
        Assert.assertTrue((boolean)bcv.isRepeating);
        Assert.assertEquals((long)17L, (long)lcv.vector[0]);
        Assert.assertTrue((17.34 == dcv.vector[0] ? 1 : 0) != 0);
        byte[] alphaBytes = "alpha".getBytes();
        Assert.assertTrue((bcv.length[0] == alphaBytes.length ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.sameFirstKBytes(alphaBytes, bcv.vector[0], alphaBytes.length));
        ((BytesColumnVector)vrg.cols[2]).vector[0] = "beta".getBytes();
        bytesCve.evaluate(vrg);
        Assert.assertTrue((bcv.length[0] == alphaBytes.length ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.sameFirstKBytes(alphaBytes, bcv.vector[0], alphaBytes.length));
        Assert.assertTrue((25.8 == dv.vector[0].doubleValue() ? 1 : 0) != 0);
        ((DecimalColumnVector)vrg.cols[3]).vector[0] = new Decimal128(39.7, 1);
        decimalCve.evaluate(vrg);
        Assert.assertTrue((25.8 == dv.vector[0].doubleValue() ? 1 : 0) != 0);
    }

    private boolean sameFirstKBytes(byte[] o1, byte[] o2, int k) {
        for (int i = 0; i != k; ++i) {
            if (o1[i] == o2[i]) continue;
            return false;
        }
        return true;
    }
}

