/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.io.orc.RedBlackTree;
import org.apache.hadoop.hive.ql.io.orc.StringRedBlackTree;
import org.apache.hadoop.hive.ql.io.orc.TestBitFieldReader;
import org.apache.hadoop.hive.ql.io.orc.TestDynamicArray;
import org.apache.hadoop.hive.ql.io.orc.TestFileDump;
import org.apache.hadoop.hive.ql.io.orc.TestInStream;
import org.apache.hadoop.hive.ql.io.orc.TestInputOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.TestOrcStruct;
import org.apache.hadoop.hive.ql.io.orc.TestRunLengthByteReader;
import org.apache.hadoop.hive.ql.io.orc.TestRunLengthIntegerReader;
import org.apache.hadoop.hive.ql.io.orc.TestSerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.TestStreamName;
import org.apache.hadoop.hive.ql.io.orc.TestZlib;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.junit.Test;

public class TestStringRedBlackTree {
    private int checkSubtree(RedBlackTree tree, int node, IntWritable count) throws IOException {
        int right_depth;
        int left_depth;
        if (node == -1) {
            return 1;
        }
        count.set(count.get() + 1);
        boolean is_red = tree.isRed(node);
        int left = tree.getLeft(node);
        int right = tree.getRight(node);
        if (is_red) {
            if (tree.isRed(left)) {
                this.printTree(tree, "", tree.root);
                throw new IllegalStateException("Left node of " + node + " is " + left + " and both are red.");
            }
            if (tree.isRed(right)) {
                this.printTree(tree, "", tree.root);
                throw new IllegalStateException("Right node of " + node + " is " + right + " and both are red.");
            }
        }
        if ((left_depth = this.checkSubtree(tree, left, count)) != (right_depth = this.checkSubtree(tree, right, count))) {
            this.printTree(tree, "", tree.root);
            throw new IllegalStateException("Lopsided tree at node " + node + " with depths " + left_depth + " and " + right_depth);
        }
        if (is_red) {
            return left_depth;
        }
        return left_depth + 1;
    }

    void checkTree(RedBlackTree tree) throws IOException {
        IntWritable count = new IntWritable(0);
        if (tree.isRed(tree.root)) {
            this.printTree(tree, "", tree.root);
            throw new IllegalStateException("root is red");
        }
        this.checkSubtree(tree, tree.root, count);
        if (count.get() != tree.size) {
            this.printTree(tree, "", tree.root);
            throw new IllegalStateException("Broken tree! visited= " + count.get() + " size=" + tree.size);
        }
    }

    void printTree(RedBlackTree tree, String indent, int node) throws IOException {
        if (node == -1) {
            System.err.println(indent + "NULL");
        } else {
            System.err.println(indent + "Node " + node + " color " + (tree.isRed(node) ? "red" : "black"));
            this.printTree(tree, indent + "  ", tree.getLeft(node));
            this.printTree(tree, indent + "  ", tree.getRight(node));
        }
    }

    void checkContents(StringRedBlackTree tree, int[] order, String ... params) throws IOException {
        tree.visit((StringRedBlackTree.Visitor)new MyVisitor(params, order));
    }

    StringRedBlackTree buildTree(String ... params) throws IOException {
        StringRedBlackTree result = new StringRedBlackTree(1000);
        for (String word : params) {
            result.add(word);
            this.checkTree((RedBlackTree)result);
        }
        return result;
    }

    @Test
    public void test1() throws Exception {
        StringRedBlackTree tree = new StringRedBlackTree(5);
        Assert.assertEquals((long)0L, (long)tree.getSizeInBytes());
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)0, (int)tree.add("owen"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)1, (int)tree.add("ashutosh"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)0, (int)tree.add("owen"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)2, (int)tree.add("alan"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)2, (int)tree.add("alan"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)1, (int)tree.add("ashutosh"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)3, (int)tree.add("greg"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)4, (int)tree.add("eric"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)5, (int)tree.add("arun"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)6, (int)tree.size());
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)6, (int)tree.add("eric14"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)7, (int)tree.add("o"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)8, (int)tree.add("ziggy"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)9, (int)tree.add("z"));
        this.checkTree((RedBlackTree)tree);
        this.checkContents(tree, new int[]{2, 5, 1, 4, 6, 3, 7, 0, 9, 8}, "alan", "arun", "ashutosh", "eric", "eric14", "greg", "o", "owen", "z", "ziggy");
        Assert.assertEquals((long)32888L, (long)tree.getSizeInBytes());
        Assert.assertEquals((int)3, (int)tree.add("greg"));
        Assert.assertEquals((int)41, (int)tree.getCharacterSize());
        Assert.assertEquals((int)10, (int)tree.add("zak"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)11, (int)tree.add("eric1"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)12, (int)tree.add("ash"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)13, (int)tree.add("harry"));
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((int)14, (int)tree.add("john"));
        this.checkTree((RedBlackTree)tree);
        tree.clear();
        this.checkTree((RedBlackTree)tree);
        Assert.assertEquals((long)0L, (long)tree.getSizeInBytes());
        Assert.assertEquals((int)0, (int)tree.getCharacterSize());
    }

    @Test
    public void test2() throws Exception {
        StringRedBlackTree tree = this.buildTree("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
        Assert.assertEquals((int)26, (int)tree.size());
        this.checkContents(tree, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25}, "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
    }

    @Test
    public void test3() throws Exception {
        StringRedBlackTree tree = this.buildTree("z", "y", "x", "w", "v", "u", "t", "s", "r", "q", "p", "o", "n", "m", "l", "k", "j", "i", "h", "g", "f", "e", "d", "c", "b", "a");
        Assert.assertEquals((int)26, (int)tree.size());
        this.checkContents(tree, new int[]{25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}, "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
    }

    public static void main(String[] args) throws Exception {
        TestStringRedBlackTree test = new TestStringRedBlackTree();
        test.test1();
        test.test2();
        test.test3();
        TestSerializationUtils serUtils = new TestSerializationUtils();
        serUtils.testDoubles();
        TestDynamicArray test6 = new TestDynamicArray();
        test6.testByteArray();
        test6.testIntArray();
        TestZlib zlib = new TestZlib();
        zlib.testCorrupt();
        zlib.testNoOverflow();
        TestInStream inStreamTest = new TestInStream();
        inStreamTest.testUncompressed();
        inStreamTest.testCompressed();
        inStreamTest.testCorruptStream();
        TestRunLengthByteReader rleByte = new TestRunLengthByteReader();
        rleByte.testUncompressedSeek();
        rleByte.testCompressedSeek();
        rleByte.testSkips();
        TestRunLengthIntegerReader rleInt = new TestRunLengthIntegerReader();
        rleInt.testUncompressedSeek();
        rleInt.testCompressedSeek();
        rleInt.testSkips();
        TestBitFieldReader bit = new TestBitFieldReader();
        bit.testUncompressedSeek();
        bit.testCompressedSeek();
        bit.testBiggerItems();
        bit.testSkips();
        TestOrcFile test1 = new TestOrcFile(false);
        test1.test1();
        test1.emptyFile();
        test1.metaData();
        test1.testUnionAndTimestamp();
        test1.columnProjection();
        test1.testSnappy();
        test1.testWithoutIndex();
        test1.testSeek();
        TestFileDump test2 = new TestFileDump();
        test2.testDump();
        TestStreamName test3 = new TestStreamName();
        test3.test1();
        TestInputOutputFormat test4 = new TestInputOutputFormat();
        test4.testInOutFormat();
        test4.testMROutput();
        test4.testEmptyFile();
        test4.testDefaultTypes();
        TestOrcStruct test5 = new TestOrcStruct();
        test5.testStruct();
        test5.testInspectorFromTypeInfo();
        test5.testUnion();
    }

    private static class MyVisitor
    implements StringRedBlackTree.Visitor {
        private final String[] words;
        private final int[] order;
        private final DataOutputBuffer buffer = new DataOutputBuffer();
        int current = 0;

        MyVisitor(String[] args, int[] order) {
            this.words = args;
            this.order = order;
        }

        public void visit(StringRedBlackTree.VisitorContext context) throws IOException {
            String word = context.getText().toString();
            Assert.assertEquals((String)("in word " + this.current), (String)this.words[this.current], (String)word);
            Assert.assertEquals((String)("in word " + this.current), (int)this.order[this.current], (int)context.getOriginalPosition());
            this.buffer.reset();
            context.writeBytes((OutputStream)this.buffer);
            Assert.assertEquals((String)word, (String)new String(this.buffer.getData(), 0, this.buffer.getLength()));
            ++this.current;
        }
    }
}

