/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedColumnarSerDe;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.junit.Before;
import org.junit.Test;

public class TestVectorizedRowBatchCtx {
    private Configuration conf;
    private FileSystem fs;
    private Path testFilePath;
    private int colCount;
    private ColumnarSerDe serDe;
    private Properties tbl;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.fs.setWorkingDirectory(workDir);
        this.testFilePath = new Path("TestVectorizedRowBatchCtx.testDump.rc");
        this.fs.delete(this.testFilePath, false);
    }

    private void initSerde() {
        this.tbl = new Properties();
        this.tbl.setProperty("serialization.format", "6");
        this.tbl.setProperty("columns", "ashort,aint,along,adouble,afloat,astring,abyte,aboolean,atimestamp");
        this.tbl.setProperty("columns.types", "smallint:int:bigint:double:float:string:tinyint:boolean:timestamp");
        this.colCount = 9;
        this.tbl.setProperty("serialization.null.format", "NULL");
        try {
            this.serDe = new ColumnarSerDe();
            this.serDe.initialize(this.conf, this.tbl);
        }
        catch (SerDeException e) {
            new RuntimeException(e);
        }
    }

    private void WriteRCFile(FileSystem fs, Path file, Configuration conf) throws IOException, SerDeException {
        fs.delete(file, true);
        RCFileOutputFormat.setColumnNumber((Configuration)conf, (int)this.colCount);
        RCFile.Writer writer = new RCFile.Writer(fs, conf, file, null, null, (CompressionCodec)new DefaultCodec());
        for (int i = 0; i < 10; ++i) {
            Timestamp t;
            BytesRefWritable cu;
            BytesRefArrayWritable bytes = new BytesRefArrayWritable(this.colCount);
            if (i % 3 != 0) {
                cu = new BytesRefWritable((i + "").getBytes("UTF-8"), 0, (i + "").getBytes("UTF-8").length);
                bytes.set(0, cu);
                cu = new BytesRefWritable((i + 100 + "").getBytes("UTF-8"), 0, (i + 100 + "").getBytes("UTF-8").length);
                bytes.set(1, cu);
                cu = new BytesRefWritable((i + 200 + "").getBytes("UTF-8"), 0, (i + 200 + "").getBytes("UTF-8").length);
                bytes.set(2, cu);
                cu = new BytesRefWritable(((double)i + 1.23 + "").getBytes("UTF-8"), 0, ((double)i + 1.23 + "").getBytes("UTF-8").length);
                bytes.set(3, cu);
                cu = new BytesRefWritable(((double)i + 2.23 + "").getBytes("UTF-8"), 0, ((double)i + 2.23 + "").getBytes("UTF-8").length);
                bytes.set(4, cu);
                cu = new BytesRefWritable("Test string".getBytes("UTF-8"), 0, "Test string".getBytes("UTF-8").length);
                bytes.set(5, cu);
                cu = new BytesRefWritable("1".getBytes("UTF-8"), 0, "1".getBytes("UTF-8").length);
                bytes.set(6, cu);
                cu = new BytesRefWritable("true".getBytes("UTF-8"), 0, "true".getBytes("UTF-8").length);
                bytes.set(7, cu);
                t = new Timestamp(Calendar.getInstance().getTime().getTime());
                cu = new BytesRefWritable(t.toString().getBytes("UTF-8"), 0, t.toString().getBytes("UTF-8").length);
                bytes.set(8, cu);
            } else {
                cu = new BytesRefWritable((i + "").getBytes("UTF-8"), 0, (i + "").getBytes("UTF-8").length);
                bytes.set(0, cu);
                cu = new BytesRefWritable(new byte[0], 0, 0);
                bytes.set(1, cu);
                cu = new BytesRefWritable(new byte[0], 0, 0);
                bytes.set(2, cu);
                cu = new BytesRefWritable(new byte[0], 0, 0);
                bytes.set(3, cu);
                cu = new BytesRefWritable(new byte[0], 0, 0);
                bytes.set(4, cu);
                cu = new BytesRefWritable("Test string".getBytes("UTF-8"), 0, "Test string".getBytes("UTF-8").length);
                bytes.set(5, cu);
                cu = new BytesRefWritable(new byte[0], 0, 0);
                bytes.set(6, cu);
                cu = new BytesRefWritable(new byte[0], 0, 0);
                bytes.set(7, cu);
                t = new Timestamp(Calendar.getInstance().getTime().getTime());
                cu = new BytesRefWritable(t.toString().getBytes("UTF-8"), 0, t.toString().getBytes("UTF-8").length);
                bytes.set(8, cu);
            }
            writer.append((Writable)bytes);
        }
        writer.close();
    }

    private VectorizedRowBatch GetRowBatch() throws SerDeException, HiveException, IOException {
        RCFile.Reader reader = new RCFile.Reader(this.fs, this.testFilePath, this.conf);
        DataOutputBuffer buffer = new DataOutputBuffer();
        StructObjectInspector oi = (StructObjectInspector)this.serDe.getObjectInspector();
        List fieldRefs = oi.getAllStructFieldRefs();
        Assert.assertEquals((String)"Field size should be 9", (int)this.colCount, (int)fieldRefs.size());
        VectorizedRowBatchCtx ctx = new VectorizedRowBatchCtx(oi, oi, (Deserializer)this.serDe, null, null);
        VectorizedRowBatch batch = ctx.createVectorizedRowBatch();
        VectorizedBatchUtil.setNoNullFields((VectorizedRowBatch)batch);
        LongWritable rowID = new LongWritable();
        for (int i = 0; i < 10; ++i) {
            reader.next(rowID);
            BytesRefArrayWritable cols = new BytesRefArrayWritable();
            reader.getCurrentRow(cols);
            cols.resetValid(this.colCount);
            ctx.addRowToBatch(i, (Writable)cols, batch, buffer);
        }
        reader.close();
        batch.size = 10;
        return batch;
    }

    void ValidateRowBatch(VectorizedRowBatch batch) throws IOException, SerDeException {
        LongWritable rowID = new LongWritable();
        RCFile.Reader reader = new RCFile.Reader(this.fs, this.testFilePath, this.conf);
        for (int i = 0; i < batch.size; ++i) {
            reader.next(rowID);
            BytesRefArrayWritable cols = new BytesRefArrayWritable();
            reader.getCurrentRow(cols);
            cols.resetValid(this.colCount);
            Object row = this.serDe.deserialize((Writable)cols);
            StructObjectInspector oi = (StructObjectInspector)this.serDe.getObjectInspector();
            List fieldRefs = oi.getAllStructFieldRefs();
            for (int j = 0; j < fieldRefs.size(); ++j) {
                Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(j));
                ObjectInspector foi = ((StructField)fieldRefs.get(j)).getFieldObjectInspector();
                Assert.assertEquals((boolean)true, (foi.getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0) != 0);
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)foi;
                Object writableCol = poi.getPrimitiveWritableObject(fieldData);
                if (writableCol != null) {
                    switch (poi.getPrimitiveCategory()) {
                        case BOOLEAN: {
                            LongColumnVector lcv = (LongColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (lcv.vector[i] == (long)(((BooleanWritable)writableCol).get() ? 1 : 0) ? 1 : 0) != 0);
                            break;
                        }
                        case BYTE: {
                            LongColumnVector lcv = (LongColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (lcv.vector[i] == (long)((ByteWritable)writableCol).get() ? 1 : 0) != 0);
                            break;
                        }
                        case SHORT: {
                            LongColumnVector lcv = (LongColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (lcv.vector[i] == (long)((ShortWritable)writableCol).get() ? 1 : 0) != 0);
                            break;
                        }
                        case INT: {
                            LongColumnVector lcv = (LongColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (lcv.vector[i] == (long)((IntWritable)writableCol).get() ? 1 : 0) != 0);
                            break;
                        }
                        case LONG: {
                            LongColumnVector lcv = (LongColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (lcv.vector[i] == ((LongWritable)writableCol).get() ? 1 : 0) != 0);
                            break;
                        }
                        case FLOAT: {
                            DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (dcv.vector[i] == (double)((FloatWritable)writableCol).get() ? 1 : 0) != 0);
                            break;
                        }
                        case DOUBLE: {
                            DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[j];
                            Assert.assertEquals((boolean)true, (dcv.vector[i] == ((DoubleWritable)writableCol).get() ? 1 : 0) != 0);
                            break;
                        }
                        case STRING: {
                            BytesColumnVector bcv = (BytesColumnVector)batch.cols[j];
                            Text colText = (Text)writableCol;
                            Text batchText = (Text)bcv.getWritableObject(i);
                            String a = colText.toString();
                            String b = batchText.toString();
                            Assert.assertEquals((boolean)true, (boolean)a.equals(b));
                            break;
                        }
                        case TIMESTAMP: {
                            LongColumnVector tcv = (LongColumnVector)batch.cols[j];
                            Timestamp t = ((TimestampWritable)writableCol).getTimestamp();
                            long timeInNanoSec = t.getTime() * 1000000L + (long)(t.getNanos() % 1000000);
                            Assert.assertEquals((boolean)true, (tcv.vector[i] == timeInNanoSec ? 1 : 0) != 0);
                            break;
                        }
                        default: {
                            Assert.assertEquals((Object)"Unknown type", (Object)false);
                            break;
                        }
                    }
                    continue;
                }
                Assert.assertEquals((boolean)true, (boolean)batch.cols[j].isNull[i]);
            }
            Assert.assertEquals((boolean)false, (boolean)batch.cols[0].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[1].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[2].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[3].isRepeating);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[4].isRepeating);
            Assert.assertEquals((boolean)true, (boolean)batch.cols[0].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[1].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[2].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[3].noNulls);
            Assert.assertEquals((boolean)false, (boolean)batch.cols[4].noNulls);
        }
        reader.close();
    }

    @Test
    public void TestCtx() throws Exception {
        this.initSerde();
        this.WriteRCFile(this.fs, this.testFilePath, this.conf);
        VectorizedRowBatch batch = this.GetRowBatch();
        this.ValidateRowBatch(batch);
        VectorizedColumnarSerDe vcs = new VectorizedColumnarSerDe();
        vcs.initialize(this.conf, this.tbl);
        Writable w = vcs.serializeVector(batch, (ObjectInspector)((StructObjectInspector)this.serDe.getObjectInspector()));
        BytesRefArrayWritable[] refArray = (BytesRefArrayWritable[])((ObjectWritable)w).get();
        vcs.deserializeVector((Object)refArray, 10, batch);
        this.ValidateRowBatch(batch);
    }
}

