/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import junit.framework.Assert;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQBJoinTreeApplyPredicate {
    static HiveConf conf;
    SemanticAnalyzer sA;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException {
        this.sA = new SemanticAnalyzer(conf);
    }

    static ASTNode constructIdentifier(String nm) {
        return (ASTNode)ParseDriver.adaptor.create(26, nm);
    }

    static ASTNode constructTabRef(String tblNm) {
        ASTNode table = (ASTNode)ParseDriver.adaptor.create(848, "TOK_TABLE_OR_COL");
        ASTNode id = TestQBJoinTreeApplyPredicate.constructIdentifier(tblNm);
        table.addChild((Tree)id);
        return table;
    }

    static ASTNode constructColRef(String tblNm, String colNm) {
        ASTNode table = TestQBJoinTreeApplyPredicate.constructTabRef(tblNm);
        ASTNode col = TestQBJoinTreeApplyPredicate.constructIdentifier(colNm);
        ASTNode dot = (ASTNode)ParseDriver.adaptor.create(17, ".");
        dot.addChild((Tree)table);
        dot.addChild((Tree)col);
        return dot;
    }

    static ASTNode constructEqualityCond(String lTbl, String lCol, String rTbl, String rCol) {
        ASTNode lRef = TestQBJoinTreeApplyPredicate.constructColRef(lTbl, lCol);
        ASTNode rRef = TestQBJoinTreeApplyPredicate.constructColRef(rTbl, rCol);
        ASTNode eq = (ASTNode)ParseDriver.adaptor.create(20, "=");
        eq.addChild((Tree)lRef);
        eq.addChild((Tree)rRef);
        return eq;
    }

    QBJoinTree createJoinTree(JoinType type, String leftAlias, QBJoinTree leftTree, String rightAlias) {
        QBJoinTree jT = new QBJoinTree();
        JoinCond[] condn = new JoinCond[]{new JoinCond(0, 1, type)};
        if (leftTree == null) {
            jT.setLeftAlias(leftAlias);
            String[] leftAliases = new String[]{leftAlias};
            jT.setLeftAliases(leftAliases);
        } else {
            jT.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            String[] leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            jT.setLeftAliases(leftAliases);
        }
        String[] rightAliases = new String[]{rightAlias};
        jT.setRightAliases(rightAliases);
        String[] children = new String[]{leftAlias, rightAlias};
        jT.setBaseSrc(children);
        ArrayList expressions = new ArrayList();
        expressions.add(new ArrayList());
        expressions.add(new ArrayList());
        jT.setExpressions(expressions);
        ArrayList nullsafes = new ArrayList();
        jT.setNullSafes(nullsafes);
        ArrayList filters = new ArrayList();
        filters.add(new ArrayList());
        filters.add(new ArrayList());
        jT.setFilters(filters);
        jT.setFilterMap((int[][])new int[2][]);
        ArrayList filtersForPushing = new ArrayList();
        filtersForPushing.add(new ArrayList());
        filtersForPushing.add(new ArrayList());
        jT.setFiltersForPushing(filtersForPushing);
        return jT;
    }

    ASTNode applyEqPredicate(QBJoinTree jT, String lTbl, String lCol, String rTbl, String rCol) throws SemanticException {
        ASTNode joinCond = TestQBJoinTreeApplyPredicate.constructEqualityCond(lTbl, lCol, rTbl, rCol);
        ASTNode leftCondn = (ASTNode)joinCond.getChild(0);
        ASTNode rightCondn = (ASTNode)joinCond.getChild(1);
        ArrayList leftSrc = new ArrayList();
        ArrayList leftCondAl1 = new ArrayList();
        ArrayList leftCondAl2 = new ArrayList();
        ArrayList rightCondAl1 = new ArrayList();
        ArrayList rightCondAl2 = new ArrayList();
        this.sA.parseJoinCondPopulateAlias(jT, leftCondn, leftCondAl1, leftCondAl2, null, null);
        this.sA.parseJoinCondPopulateAlias(jT, rightCondn, rightCondAl1, rightCondAl2, null, null);
        this.sA.applyEqualityPredicateToQBJoinTree(jT, JoinType.INNER, leftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
        return joinCond;
    }

    @Test
    public void testSimpleCondn() throws SemanticException {
        QBJoinTree jT = this.createJoinTree(JoinType.INNER, "a", null, "b");
        ASTNode joinCond = this.applyEqPredicate(jT, "a", "x", "b", "y");
        Assert.assertEquals(((ArrayList)jT.getExpressions().get(0)).get(0), (Object)joinCond.getChild(0));
        Assert.assertEquals(((ArrayList)jT.getExpressions().get(1)).get(0), (Object)joinCond.getChild(1));
    }

    @Test
    public void test3WayJoin() throws SemanticException {
        QBJoinTree jT1 = this.createJoinTree(JoinType.INNER, "a", null, "b");
        QBJoinTree jT = this.createJoinTree(JoinType.INNER, "b", jT1, "c");
        ASTNode joinCond1 = this.applyEqPredicate(jT, "a", "x", "b", "y");
        ASTNode joinCond2 = this.applyEqPredicate(jT, "b", "y", "c", "z");
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(0)).get(0), (Object)joinCond1.getChild(0));
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(1)).get(0), (Object)joinCond1.getChild(1));
        Assert.assertEquals(((ArrayList)jT.getExpressions().get(0)).get(0), (Object)joinCond2.getChild(0));
        Assert.assertEquals(((ArrayList)jT.getExpressions().get(1)).get(0), (Object)joinCond2.getChild(1));
    }

    @Test
    public void test3WayJoinSwitched() throws SemanticException {
        QBJoinTree jT1 = this.createJoinTree(JoinType.INNER, "a", null, "b");
        QBJoinTree jT = this.createJoinTree(JoinType.INNER, "b", jT1, "c");
        ASTNode joinCond1 = this.applyEqPredicate(jT, "b", "y", "a", "x");
        ASTNode joinCond2 = this.applyEqPredicate(jT, "b", "y", "c", "z");
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(0)).get(0), (Object)joinCond1.getChild(1));
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(1)).get(0), (Object)joinCond1.getChild(0));
        Assert.assertEquals(((ArrayList)jT.getExpressions().get(0)).get(0), (Object)joinCond2.getChild(0));
        Assert.assertEquals(((ArrayList)jT.getExpressions().get(1)).get(0), (Object)joinCond2.getChild(1));
    }

    @Test
    public void test4WayJoin() throws SemanticException {
        QBJoinTree jT1 = this.createJoinTree(JoinType.INNER, "a", null, "b");
        QBJoinTree jT2 = this.createJoinTree(JoinType.INNER, "b", jT1, "c");
        QBJoinTree jT = this.createJoinTree(JoinType.INNER, "c", jT2, "d");
        ASTNode joinCond1 = this.applyEqPredicate(jT, "a", "x", "b", "y");
        ASTNode joinCond2 = this.applyEqPredicate(jT, "b", "y", "c", "z");
        ASTNode joinCond3 = this.applyEqPredicate(jT, "a", "x", "c", "z");
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(0)).get(0), (Object)joinCond1.getChild(0));
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(1)).get(0), (Object)joinCond1.getChild(1));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(0)).get(0), (Object)joinCond2.getChild(0));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(1)).get(0), (Object)joinCond2.getChild(1));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(0)).get(1), (Object)joinCond3.getChild(0));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(1)).get(1), (Object)joinCond3.getChild(1));
    }

    @Test
    public void test4WayJoinSwitched() throws SemanticException {
        QBJoinTree jT1 = this.createJoinTree(JoinType.INNER, "a", null, "b");
        QBJoinTree jT2 = this.createJoinTree(JoinType.INNER, "b", jT1, "c");
        QBJoinTree jT = this.createJoinTree(JoinType.INNER, "c", jT2, "d");
        ASTNode joinCond1 = this.applyEqPredicate(jT, "b", "y", "a", "x");
        ASTNode joinCond2 = this.applyEqPredicate(jT, "b", "y", "c", "z");
        ASTNode joinCond3 = this.applyEqPredicate(jT, "c", "z", "a", "x");
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(0)).get(0), (Object)joinCond1.getChild(1));
        Assert.assertEquals(((ArrayList)jT1.getExpressions().get(1)).get(0), (Object)joinCond1.getChild(0));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(0)).get(0), (Object)joinCond2.getChild(0));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(1)).get(0), (Object)joinCond2.getChild(1));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(0)).get(1), (Object)joinCond3.getChild(1));
        Assert.assertEquals(((ArrayList)jT2.getExpressions().get(1)).get(1), (Object)joinCond3.getChild(0));
    }
}

