/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.FileDump;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileDump {
    Path workDir = new Path(System.getProperty("test.tmp.dir"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.setWorkingDirectory(this.workDir);
        this.testFilePath = new Path("TestFileDump.testDump.orc");
        this.fs.delete(this.testFilePath, false);
    }

    private static void checkOutput(String expected, String actual) throws Exception {
        BufferedReader eStream = new BufferedReader(new FileReader(HiveTestUtils.getFileFromClasspath((String)expected)));
        BufferedReader aStream = new BufferedReader(new FileReader(actual));
        String expectedLine = eStream.readLine();
        while (expectedLine != null) {
            String actualLine = aStream.readLine();
            System.out.println("actual:   " + actualLine);
            System.out.println("expected: " + expectedLine);
            Assert.assertEquals((Object)expectedLine, (Object)actualLine);
            expectedLine = eStream.readLine();
        }
        Assert.assertNull((Object)eStream.readLine());
        Assert.assertNull((Object)aStream.readLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDump() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            for (int i = 0; i < 21000; ++i) {
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), words[r1.nextInt(words.length)]));
            }
            writer.close();
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-dump.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString()});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDictionaryThreshold() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Configuration conf = new Configuration();
            conf.setFloat(HiveConf.ConfVars.HIVE_ORC_DICTIONARY_KEY_SIZE_THRESHOLD.varname, 0.49f);
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            Random r1 = new Random(1L);
            String[] words = new String[]{"It", "was", "the", "best", "of", "times,", "it", "was", "the", "worst", "of", "times,", "it", "was", "the", "age", "of", "wisdom,", "it", "was", "the", "age", "of", "foolishness,", "it", "was", "the", "epoch", "of", "belief,", "it", "was", "the", "epoch", "of", "incredulity,", "it", "was", "the", "season", "of", "Light,", "it", "was", "the", "season", "of", "Darkness,", "it", "was", "the", "spring", "of", "hope,", "it", "was", "the", "winter", "of", "despair,", "we", "had", "everything", "before", "us,", "we", "had", "nothing", "before", "us,", "we", "were", "all", "going", "direct", "to", "Heaven,", "we", "were", "all", "going", "direct", "the", "other", "way"};
            int nextInt = 0;
            for (int i = 0; i < 21000; ++i) {
                if (i % 2 == 0) {
                    int n = nextInt = r1.nextInt(words.length);
                    words[n] = words[n] + "-" + i;
                }
                writer.addRow((Object)new MyRecord(r1.nextInt(), r1.nextLong(), words[nextInt]));
            }
            writer.close();
            PrintStream origOut = System.out;
            String outputFilename = "orc-file-dump-dictionary-threshold.out";
            FileOutputStream myOut = new FileOutputStream(this.workDir + File.separator + outputFilename);
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{this.testFilePath.toString()});
            System.out.flush();
            System.setOut(origOut);
            TestFileDump.checkOutput(outputFilename, this.workDir + File.separator + outputFilename);
            return;
        }
    }

    static class MyRecord {
        int i;
        long l;
        String s;

        MyRecord(int i, long l, String s) {
            this.i = i;
            this.l = l;
            this.s = s;
        }
    }
}

