/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.io.orc.BitFieldReader;
import org.apache.hadoop.hive.ql.io.orc.BitFieldWriter;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OutStream;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.PositionRecorder;
import org.apache.hadoop.hive.ql.io.orc.PositionedOutputStream;
import org.apache.hadoop.hive.ql.io.orc.TestInStream;
import org.apache.hadoop.hive.ql.io.orc.ZlibCodec;
import org.junit.Test;

public class TestBitFieldReader {
    public void runSeekTest(CompressionCodec codec) throws Exception {
        int x;
        int i;
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        int COUNT = 16384;
        BitFieldWriter out = new BitFieldWriter((PositionedOutputStream)new OutStream("test", 500, codec, (OutStream.OutputReceiver)collect), 1);
        TestInStream.PositionCollector[] positions = new TestInStream.PositionCollector[16384];
        for (int i2 = 0; i2 < 16384; ++i2) {
            positions[i2] = new TestInStream.PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            if (i2 < 8192) {
                out.write(i2 & 1);
                continue;
            }
            out.write(i2 / 3 & 1);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        BitFieldReader in = new BitFieldReader(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), (CompressionCodec)codec, (int)500), 1);
        for (i = 0; i < 16384; ++i) {
            x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 1), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i / 3 & 1), (int)x);
        }
        for (i = 16383; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 1), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i / 3 & 1), (int)x);
        }
    }

    @Test
    public void testUncompressedSeek() throws Exception {
        this.runSeekTest(null);
    }

    @Test
    public void testCompressedSeek() throws Exception {
        this.runSeekTest((CompressionCodec)new ZlibCodec());
    }

    @Test
    public void testBiggerItems() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        int COUNT = 16384;
        BitFieldWriter out = new BitFieldWriter((PositionedOutputStream)new OutStream("test", 500, null, (OutStream.OutputReceiver)collect), 3);
        for (int i = 0; i < 16384; ++i) {
            if (i < 8192) {
                out.write(i & 7);
                continue;
            }
            out.write(i / 3 & 7);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        BitFieldReader in = new BitFieldReader(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)500), 3);
        for (int i = 0; i < 16384; ++i) {
            int x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 7), (int)x);
                continue;
            }
            Assert.assertEquals((int)(i / 3 & 7), (int)x);
        }
    }

    @Test
    public void testSkips() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        BitFieldWriter out = new BitFieldWriter((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect), 1);
        int COUNT = 16384;
        for (int i = 0; i < 16384; ++i) {
            if (i < 8192) {
                out.write(i & 1);
                continue;
            }
            out.write(i / 3 & 1);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        BitFieldReader in = new BitFieldReader(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)100), 1);
        for (int i = 0; i < 16384; i += 5) {
            int x = in.next();
            if (i < 8192) {
                Assert.assertEquals((int)(i & 1), (int)x);
            } else {
                Assert.assertEquals((int)(i / 3 & 1), (int)x);
            }
            if (i < 16379) {
                in.skip(4L);
            }
            in.skip(0L);
        }
    }
}

