/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.TestVectorizedORCReader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

public class OrcFileGenerator {
    private static final Map<Class, BatchGenerator> TYPE_TO_BATCH_GEN_MAP = new HashMap<Class, BatchGenerator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateOrcFile(Configuration conf, FileSystem fs, Path outputPath, Class recordClass) throws IOException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<TestVectorizedORCReader> clazz = TestVectorizedORCReader.class;
        synchronized (TestVectorizedORCReader.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector((Type)recordClass, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)fs, (Path)outputPath, (Configuration)conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.ZLIB, (int)10000, (int)10000);
            try {
                Constructor<?>[] constructors = recordClass.getConstructors();
                if (constructors.length != 1) {
                    throw new UnsupportedOperationException("The provided recordClass must have exactly one constructor.");
                }
                BatchDataDistribution[] dataDist = BatchDataDistribution.values();
                Class<?>[] columns = constructors[0].getParameterTypes();
                for (int i = 0; i < dataDist.length * 3; ++i) {
                    Object[][] rows = new Object[columns.length][1024];
                    for (int c = 0; c < columns.length; ++c) {
                        if (!TYPE_TO_BATCH_GEN_MAP.containsKey(columns[c])) {
                            throw new UnsupportedOperationException("No batch generator defined for type " + columns[c].getName());
                        }
                        rows[c] = TYPE_TO_BATCH_GEN_MAP.get(columns[c]).generateBatch(dataDist[(i + c) % dataDist.length]);
                    }
                    for (int r = 0; r < 1024; ++r) {
                        Object[] row = new Object[columns.length];
                        for (int c = 0; c < columns.length; ++c) {
                            row[c] = rows[c][r];
                        }
                        writer.addRow(constructors[0].newInstance(row));
                    }
                }
            }
            finally {
                writer.close();
            }
            return;
        }
    }

    static {
        TYPE_TO_BATCH_GEN_MAP.put(Boolean.class, new BooleanBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Byte.class, new ByteBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Integer.class, new IntegerBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Long.class, new LongBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Short.class, new ShortBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Float.class, new FloatBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Double.class, new DoubleBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(String.class, new StringBatchGenerator());
        TYPE_TO_BATCH_GEN_MAP.put(Timestamp.class, new TimestampBatchGenerator());
    }

    private static class TimestampBatchGenerator
    extends BatchGenerator<Timestamp> {
        private final ShortBatchGenerator shortGen = new ShortBatchGenerator();

        private TimestampBatchGenerator() {
        }

        @Override
        protected Timestamp generateRandomNonNullValue(Random rand) {
            return new Timestamp(this.shortGen.generateRandomNonNullValue(rand).shortValue());
        }

        protected Timestamp[] initializeFixedPointValues() {
            return new Timestamp[]{new Timestamp(-29071L), new Timestamp(-10669L), new Timestamp(16558L), new Timestamp(31808L)};
        }
    }

    private static class StringBatchGenerator
    extends BatchGenerator<String> {
        private StringBatchGenerator() {
        }

        @Override
        protected String generateRandomNonNullValue(Random rand) {
            int length = rand.nextInt(20) + 5;
            char[] values = new char[length];
            block5: for (int j = 0; j < length; ++j) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        values[j] = (char)(rand.nextInt(25) + 97);
                        continue block5;
                    }
                    case 1: {
                        values[j] = (char)(rand.nextInt(25) + 65);
                        continue block5;
                    }
                    case 2: {
                        values[j] = (char)(rand.nextInt(9) + 48);
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            return new String(values);
        }

        protected String[] initializeFixedPointValues() {
            return new String[]{"a", "b", "ss", "10"};
        }
    }

    private static class BooleanBatchGenerator
    extends BatchGenerator<Boolean> {
        private BooleanBatchGenerator() {
        }

        @Override
        protected Boolean generateRandomNonNullValue(Random rand) {
            return rand.nextBoolean();
        }

        protected Boolean[] initializeFixedPointValues() {
            return null;
        }
    }

    private static class DoubleBatchGenerator
    extends BatchGenerator<Double> {
        private final ShortBatchGenerator shortGenerator = new ShortBatchGenerator();

        private DoubleBatchGenerator() {
        }

        @Override
        protected Double generateRandomNonNullValue(Random rand) {
            return (double)this.shortGenerator.generateRandomNonNullValue(rand);
        }

        protected Double[] initializeFixedPointValues() {
            return new Double[]{-5638.15, -863.257, 2563.58, 9763215.5639};
        }
    }

    private static class FloatBatchGenerator
    extends BatchGenerator<Float> {
        private final ByteBatchGenerator byteGenerator = new ByteBatchGenerator();

        private FloatBatchGenerator() {
        }

        @Override
        protected Float generateRandomNonNullValue(Random rand) {
            return Float.valueOf(this.byteGenerator.generateRandomNonNullValue(rand).byteValue());
        }

        protected Float[] initializeFixedPointValues() {
            return new Float[]{Float.valueOf(-26.28f), Float.valueOf(-1.389f), Float.valueOf(10.175f), Float.valueOf(79.553f)};
        }
    }

    private static class LongBatchGenerator
    extends BatchGenerator<Long> {
        private LongBatchGenerator() {
        }

        @Override
        protected Long generateRandomNonNullValue(Random rand) {
            return rand.nextInt();
        }

        protected Long[] initializeFixedPointValues() {
            return new Long[]{-89010L, -6432L, 3569L, 988888L};
        }
    }

    private static class IntegerBatchGenerator
    extends BatchGenerator<Integer> {
        private IntegerBatchGenerator() {
        }

        @Override
        protected Integer generateRandomNonNullValue(Random rand) {
            return rand.nextInt(Integer.MAX_VALUE) + -1073741824;
        }

        protected Integer[] initializeFixedPointValues() {
            return new Integer[]{-3728, -563, 762, 6981};
        }
    }

    private static class ShortBatchGenerator
    extends BatchGenerator<Short> {
        private ShortBatchGenerator() {
        }

        @Override
        protected Short generateRandomNonNullValue(Random rand) {
            return (short)(rand.nextInt(Short.MAX_VALUE) + -16384);
        }

        protected Short[] initializeFixedPointValues() {
            return new Short[]{(short)-257, (short)-75, (short)197, (short)359};
        }
    }

    private static class ByteBatchGenerator
    extends BatchGenerator<Byte> {
        private ByteBatchGenerator() {
        }

        @Override
        protected Byte generateRandomNonNullValue(Random rand) {
            return (byte)(rand.nextInt(127) - Math.abs(-64));
        }

        protected Byte[] initializeFixedPointValues() {
            return new Byte[]{(byte)-23, (byte)-1, (byte)17, (byte)33};
        }
    }

    private static abstract class BatchGenerator<T> {
        private final Random rand = new Random(64087L);
        private int possibleNonRandomValueGenerated = this.rand.nextInt();
        private final T[] fixedPointValues = this.initializeFixedPointValues();

        protected abstract T[] initializeFixedPointValues();

        protected abstract T generateRandomNonNullValue(Random var1);

        public T[] generateBatch(BatchDataDistribution dist) {
            Object[] batch = new Object[1024];
            block6: for (int i = 0; i < batch.length; ++i) {
                switch (dist) {
                    case AllValues: {
                        batch[i] = this.possibleNonRandomValueGenerated % 73 == 0 ? null : (this.fixedPointValues != null && this.possibleNonRandomValueGenerated % 233 == 0 ? this.fixedPointValues[this.rand.nextInt(this.fixedPointValues.length)] : this.generateRandomNonNullValue(this.rand));
                        ++this.possibleNonRandomValueGenerated;
                        continue block6;
                    }
                    case NoNulls: {
                        batch[i] = this.fixedPointValues != null && this.possibleNonRandomValueGenerated % 233 == 0 ? this.fixedPointValues[this.rand.nextInt(this.fixedPointValues.length)] : this.generateRandomNonNullValue(this.rand);
                        ++this.possibleNonRandomValueGenerated;
                        continue block6;
                    }
                    case RepeatingNull: {
                        batch[i] = null;
                        continue block6;
                    }
                    case RepeatingValue: {
                        if (i == 0) {
                            batch[i] = this.generateRandomNonNullValue(this.rand);
                            continue block6;
                        }
                        batch[i] = batch[0];
                        continue block6;
                    }
                    default: {
                        throw new UnsupportedOperationException(dist.toString() + " data distribution is not implemented.");
                    }
                }
            }
            return batch;
        }
    }

    static enum BatchDataDistribution {
        AllValues,
        NoNulls,
        RepeatingValue,
        RepeatingNull;

    }
}

