/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterLongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColEqualDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColEqualDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColGreaterEqualDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColLessDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalScalarEqualDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalScalarGreaterDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColAddLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorFilterExpressions {
    static byte[] a = null;
    static byte[] b = null;
    static byte[] c = null;

    @Test
    public void testFilterLongColEqualLongScalar() {
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1024, 1, 23);
        FilterLongColEqualLongScalar expr = new FilterLongColEqualLongScalar(0, 46L);
        expr.evaluate(vrg);
        Assert.assertEquals((long)1L, (long)vrg.size);
        Assert.assertEquals((long)1L, (long)vrg.selected[0]);
    }

    @Test
    public void testFilterLongColGreaterLongColumn() {
        int seed = 17;
        VectorizedRowBatch b = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1024, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)b.cols[0];
        LongColumnVector lcv1 = (LongColumnVector)b.cols[1];
        b.size = 3;
        FilterLongColGreaterLongColumn expr = new FilterLongColGreaterLongColumn(0, 1);
        lcv0.vector[0] = 10L;
        lcv0.vector[1] = 10L;
        lcv0.vector[2] = 10L;
        lcv1.vector[0] = 20L;
        lcv1.vector[1] = 1L;
        lcv1.vector[2] = 7L;
        expr.evaluate(b);
        Assert.assertEquals((long)2L, (long)b.size);
        Assert.assertEquals((long)1L, (long)b.selected[0]);
        Assert.assertEquals((long)2L, (long)b.selected[1]);
        lcv0.noNulls = false;
        lcv0.isNull[1] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)b.size);
        Assert.assertEquals((long)2L, (long)b.selected[0]);
        b.size = 3;
        b.selectedInUse = false;
        lcv0.isRepeating = true;
        lcv0.noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((long)2L, (long)b.size);
        b.size = 3;
        b.selectedInUse = false;
        lcv0.isNull[0] = true;
        lcv0.noNulls = false;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b.size = 3;
        b.selectedInUse = false;
        lcv0.isRepeating = false;
        lcv1.noNulls = false;
        lcv1.isNull[2] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
    }

    @Test
    public void testColOpScalarNumericFilterNullAndRepeatingLogic() {
        FilterLongColGreaterLongScalar f = new FilterLongColGreaterLongScalar(0, 1L);
        VectorizedRowBatch batch = this.getSimpleLongBatch();
        batch.cols[0].noNulls = true;
        batch.cols[0].isRepeating = false;
        f.evaluate(batch);
        Assert.assertEquals((long)2L, (long)batch.size);
        Assert.assertTrue((boolean)batch.selectedInUse);
        Assert.assertEquals((long)2L, (long)batch.selected[0]);
        Assert.assertEquals((long)3L, (long)batch.selected[1]);
        f = new FilterLongColGreaterLongScalar(0, -1L);
        batch = this.getSimpleLongBatch();
        f.evaluate(batch);
        Assert.assertFalse((boolean)batch.selectedInUse);
        Assert.assertEquals((long)4L, (long)batch.size);
        batch = this.getSimpleLongBatch();
        f = new FilterLongColGreaterLongScalar(0, 1L);
        batch.cols[0].noNulls = false;
        batch.cols[0].isRepeating = false;
        batch.cols[0].isNull[3] = true;
        f.evaluate(batch);
        Assert.assertTrue((boolean)batch.selectedInUse);
        Assert.assertEquals((long)1L, (long)batch.size);
        Assert.assertEquals((long)2L, (long)batch.selected[0]);
        batch = this.getSimpleLongBatch();
        f = new FilterLongColGreaterLongScalar(0, -1L);
        batch.cols[0].noNulls = true;
        batch.cols[0].isRepeating = true;
        f.evaluate(batch);
        Assert.assertFalse((boolean)batch.selectedInUse);
        Assert.assertEquals((long)4L, (long)batch.size);
        batch = this.getSimpleLongBatch();
        batch.cols[0].noNulls = false;
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        f.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
    }

    private VectorizedRowBatch getSimpleLongBatch() {
        VectorizedRowBatch batch = VectorizedRowGroupGenUtil.getVectorizedRowBatch(4, 1, 1);
        LongColumnVector lcv0 = (LongColumnVector)batch.cols[0];
        lcv0.vector[0] = 0L;
        lcv0.vector[1] = 1L;
        lcv0.vector[2] = 2L;
        lcv0.vector[3] = 3L;
        return batch;
    }

    @Test
    public void testFilterLongColLessLongColumn() {
        int seed = 17;
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 3, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrg.cols[0];
        LongColumnVector lcv1 = (LongColumnVector)vrg.cols[1];
        LongColumnVector lcv2 = (LongColumnVector)vrg.cols[2];
        FilterLongColLessLongColumn expr = new FilterLongColLessLongColumn(2, 1);
        LongColAddLongScalar childExpr = new LongColAddLongScalar(0, 10L, 2);
        expr.setChildExpressions(new VectorExpression[]{childExpr});
        lcv0.vector[0] = 10L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 9L;
        lcv0.vector[3] = 20L;
        lcv0.vector[4] = 10L;
        lcv1.vector[0] = 20L;
        lcv1.vector[1] = 10L;
        lcv1.vector[2] = 20L;
        lcv1.vector[3] = 10L;
        lcv1.vector[4] = 20L;
        expr.evaluate(vrg);
        Assert.assertEquals((long)1L, (long)vrg.size);
        Assert.assertEquals((long)2L, (long)vrg.selected[0]);
    }

    @Test
    public void testFilterLongScalarLessLongColumn() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrb.cols[0];
        FilterLongScalarLessLongColumn expr1 = new FilterLongScalarLessLongColumn(15L, 0);
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        expr1.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
        Assert.assertEquals((long)2L, (long)vrb.selected[1]);
        FilterLongScalarGreaterLongColumn expr2 = new FilterLongScalarGreaterLongColumn(18L, 0);
        expr2.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)2L, (long)vrb.selected[0]);
        VectorizedRowBatch vrb1 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        lcv0 = (LongColumnVector)vrb1.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        lcv0.noNulls = false;
        lcv0.isNull[0] = true;
        lcv0.isNull[2] = true;
        expr1.evaluate(vrb1);
        Assert.assertEquals((long)1L, (long)vrb1.size);
        Assert.assertTrue((boolean)vrb1.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb1.selected[0]);
        VectorizedRowBatch vrb2 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(7, 2, seed);
        vrb2.selectedInUse = true;
        vrb2.selected[0] = 1;
        vrb2.selected[1] = 2;
        vrb2.selected[2] = 4;
        vrb2.size = 3;
        lcv0 = (LongColumnVector)vrb2.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        lcv0.vector[5] = 19L;
        lcv0.vector[6] = 21L;
        lcv0.noNulls = false;
        lcv0.isNull[0] = true;
        lcv0.isNull[2] = true;
        lcv0.isNull[5] = true;
        expr1.evaluate(vrb2);
        Assert.assertEquals((long)1L, (long)vrb2.size);
        Assert.assertTrue((boolean)vrb2.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb2.selected[0]);
        VectorizedRowBatch vrb3 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(7, 2, seed);
        lcv0 = (LongColumnVector)vrb3.cols[0];
        lcv0.isRepeating = true;
        lcv0.vector[0] = 17L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        expr1.evaluate(vrb3);
        Assert.assertEquals((long)7L, (long)vrb3.size);
        Assert.assertFalse((boolean)vrb3.selectedInUse);
        Assert.assertTrue((boolean)lcv0.isRepeating);
        lcv0.noNulls = false;
        lcv0.vector[0] = 17L;
        lcv0.isNull[0] = true;
        expr1.evaluate(vrb3);
        Assert.assertEquals((long)0L, (long)vrb3.size);
    }

    @Test
    public void testFilterLongBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrb.cols[0];
        FilterLongColumnBetween expr1 = new FilterLongColumnBetween(0, 15L, 17L);
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        expr1.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)2L, (long)vrb.selected[0]);
        Assert.assertEquals((long)3L, (long)vrb.selected[1]);
        VectorizedRowBatch vrb1 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        lcv0 = (LongColumnVector)vrb1.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        lcv0.noNulls = false;
        lcv0.isNull[0] = true;
        lcv0.isNull[2] = true;
        expr1.evaluate(vrb1);
        Assert.assertEquals((long)1L, (long)vrb1.size);
        Assert.assertTrue((boolean)vrb1.selectedInUse);
        Assert.assertEquals((long)3L, (long)vrb1.selected[0]);
        VectorizedRowBatch vrb2 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(7, 2, seed);
        vrb2.selectedInUse = true;
        vrb2.selected[0] = 1;
        vrb2.selected[1] = 2;
        vrb2.selected[2] = 4;
        vrb2.size = 3;
        lcv0 = (LongColumnVector)vrb2.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        lcv0.vector[5] = 19L;
        lcv0.vector[6] = 21L;
        lcv0.noNulls = false;
        lcv0.isNull[0] = true;
        lcv0.isNull[2] = true;
        lcv0.isNull[5] = true;
        expr1.evaluate(vrb2);
        Assert.assertEquals((long)0L, (long)vrb2.size);
        VectorizedRowBatch vrb3 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(7, 2, seed);
        lcv0 = (LongColumnVector)vrb3.cols[0];
        lcv0.isRepeating = true;
        lcv0.vector[0] = 17L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        expr1.evaluate(vrb3);
        Assert.assertEquals((long)7L, (long)vrb3.size);
        Assert.assertFalse((boolean)vrb3.selectedInUse);
        Assert.assertTrue((boolean)lcv0.isRepeating);
        lcv0.noNulls = false;
        lcv0.vector[0] = 17L;
        lcv0.isNull[0] = true;
        expr1.evaluate(vrb3);
        Assert.assertEquals((long)0L, (long)vrb3.size);
    }

    @Test
    public void testFilterLongNotBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrb.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        FilterLongColumnNotBetween expr = new FilterLongColumnNotBetween(0, 10L, 20L);
        expr.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)0L, (long)vrb.selected[0]);
    }

    @Test
    public void testFilterDoubleBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        DoubleColumnVector dcv0 = new DoubleColumnVector();
        vrb.cols[0] = dcv0;
        dcv0.vector[0] = 5.0;
        dcv0.vector[1] = 20.0;
        dcv0.vector[2] = 17.0;
        dcv0.vector[3] = 15.0;
        dcv0.vector[4] = 10.0;
        FilterDoubleColumnBetween expr = new FilterDoubleColumnBetween(0, 20.0, 21.0);
        expr.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
    }

    @Test
    public void testFilterDoubleNotBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        vrb.cols[0] = new DoubleColumnVector();
        DoubleColumnVector dcv = (DoubleColumnVector)vrb.cols[0];
        dcv.vector[0] = 5.0;
        dcv.vector[1] = 20.0;
        dcv.vector[2] = 17.0;
        dcv.vector[3] = 15.0;
        dcv.vector[4] = 10.0;
        FilterDoubleColumnNotBetween expr = new FilterDoubleColumnNotBetween(0, 10.0, 20.0);
        expr.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)0L, (long)vrb.selected[0]);
    }

    @Test
    public void testFilterStringBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(3, 2, seed);
        vrb.cols[0] = new BytesColumnVector();
        BytesColumnVector bcv = (BytesColumnVector)vrb.cols[0];
        bcv.initBuffer();
        bcv.setVal(0, a, 0, 1);
        bcv.setVal(1, b, 0, 1);
        bcv.setVal(2, c, 0, 1);
        FilterStringColumnBetween expr = new FilterStringColumnBetween(0, b, c);
        expr.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
        Assert.assertEquals((long)2L, (long)vrb.selected[1]);
        vrb.selectedInUse = false;
        vrb.size = 3;
        bcv.noNulls = false;
        bcv.isNull[2] = true;
        expr.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        vrb.selectedInUse = false;
        vrb.size = 3;
        bcv.noNulls = true;
        bcv.isRepeating = true;
        expr.evaluate(vrb);
        Assert.assertEquals((long)0L, (long)vrb.size);
        vrb.selectedInUse = false;
        vrb.size = 3;
        bcv.noNulls = false;
        bcv.isRepeating = true;
        bcv.isNull[0] = true;
        bcv.setVal(0, b, 0, 1);
        expr.evaluate(vrb);
        Assert.assertEquals((long)0L, (long)vrb.size);
    }

    @Test
    public void testFilterStringNotBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(3, 2, seed);
        vrb.cols[0] = new BytesColumnVector();
        BytesColumnVector bcv = (BytesColumnVector)vrb.cols[0];
        bcv.initBuffer();
        bcv.setVal(0, a, 0, 1);
        bcv.setVal(1, b, 0, 1);
        bcv.setVal(2, c, 0, 1);
        FilterStringColumnNotBetween expr = new FilterStringColumnNotBetween(0, b, c);
        expr.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)0L, (long)vrb.selected[0]);
    }

    @Test
    public void testFilterTimestampBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrb.cols[0];
        long startTS = 0L;
        long endTS = TimestampUtils.getTimeNanoSec((Timestamp)Timestamp.valueOf("2013-11-05 00:00:00.000000000"));
        Timestamp ts0 = Timestamp.valueOf("1963-11-06 00:00:00.000");
        lcv0.vector[0] = TimestampUtils.getTimeNanoSec((Timestamp)ts0);
        Timestamp ts1 = Timestamp.valueOf("1983-11-06 00:00:00.000");
        lcv0.vector[1] = TimestampUtils.getTimeNanoSec((Timestamp)ts1);
        Timestamp ts2 = Timestamp.valueOf("2099-11-06 00:00:00.000");
        lcv0.vector[2] = TimestampUtils.getTimeNanoSec((Timestamp)ts2);
        vrb.size = 3;
        FilterLongColumnBetween expr1 = new FilterLongColumnBetween(0, startTS, endTS);
        expr1.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertEquals((Object)true, (Object)vrb.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
    }

    @Test
    public void testFilterTimestampNotBetween() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrb.cols[0];
        long startTS = TimestampUtils.getTimeNanoSec((Timestamp)Timestamp.valueOf("2013-11-05 00:00:00.000000000"));
        long endTS = TimestampUtils.getTimeNanoSec((Timestamp)Timestamp.valueOf("2013-11-05 00:00:00.000000010"));
        Timestamp ts0 = Timestamp.valueOf("2013-11-04 00:00:00.000000000");
        lcv0.vector[0] = TimestampUtils.getTimeNanoSec((Timestamp)ts0);
        Timestamp ts1 = Timestamp.valueOf("2013-11-05 00:00:00.000000002");
        lcv0.vector[1] = TimestampUtils.getTimeNanoSec((Timestamp)ts1);
        Timestamp ts2 = Timestamp.valueOf("2099-11-06 00:00:00.000");
        lcv0.vector[2] = TimestampUtils.getTimeNanoSec((Timestamp)ts2);
        vrb.size = 3;
        FilterLongColumnNotBetween expr1 = new FilterLongColumnNotBetween(0, startTS, endTS);
        expr1.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertEquals((Object)true, (Object)vrb.selectedInUse);
        Assert.assertEquals((long)0L, (long)vrb.selected[0]);
        Assert.assertEquals((long)2L, (long)vrb.selected[1]);
    }

    @Test
    public void testFilterLongIn() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrb.cols[0];
        long[] inList = new long[]{5L, 20L};
        FilterLongColumnInList f = new FilterLongColumnInList(0);
        f.setInListValues(inList);
        FilterLongColumnInList expr1 = f;
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        expr1.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)0L, (long)vrb.selected[0]);
        Assert.assertEquals((long)1L, (long)vrb.selected[1]);
        VectorizedRowBatch vrb1 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        lcv0 = (LongColumnVector)vrb1.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        lcv0.noNulls = false;
        lcv0.isNull[0] = true;
        lcv0.isNull[2] = true;
        expr1.evaluate(vrb1);
        Assert.assertEquals((long)1L, (long)vrb1.size);
        Assert.assertTrue((boolean)vrb1.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb1.selected[0]);
        VectorizedRowBatch vrb2 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(7, 2, seed);
        vrb2.selectedInUse = true;
        vrb2.selected[0] = 1;
        vrb2.selected[1] = 2;
        vrb2.selected[2] = 4;
        vrb2.size = 3;
        lcv0 = (LongColumnVector)vrb2.cols[0];
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        lcv0.vector[5] = 19L;
        lcv0.vector[6] = 21L;
        lcv0.noNulls = false;
        lcv0.isNull[0] = true;
        lcv0.isNull[2] = true;
        lcv0.isNull[5] = true;
        expr1.evaluate(vrb2);
        Assert.assertEquals((long)1L, (long)vrb2.size);
        Assert.assertEquals((long)1L, (long)vrb2.selected[0]);
        VectorizedRowBatch vrb3 = VectorizedRowGroupGenUtil.getVectorizedRowBatch(7, 2, seed);
        lcv0 = (LongColumnVector)vrb3.cols[0];
        lcv0.isRepeating = true;
        lcv0.vector[0] = 5L;
        lcv0.vector[1] = 20L;
        lcv0.vector[2] = 17L;
        lcv0.vector[3] = 15L;
        lcv0.vector[4] = 10L;
        expr1.evaluate(vrb3);
        Assert.assertEquals((long)7L, (long)vrb3.size);
        Assert.assertFalse((boolean)vrb3.selectedInUse);
        Assert.assertTrue((boolean)lcv0.isRepeating);
        lcv0.noNulls = false;
        lcv0.vector[0] = 5L;
        lcv0.isNull[0] = true;
        expr1.evaluate(vrb3);
        Assert.assertEquals((long)0L, (long)vrb3.size);
    }

    @Test
    public void testFilterDoubleIn() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(5, 2, seed);
        DoubleColumnVector dcv0 = new DoubleColumnVector();
        vrb.cols[0] = dcv0;
        double[] inList = new double[]{5.0, 20.2};
        FilterDoubleColumnInList f = new FilterDoubleColumnInList(0);
        f.setInListValues(inList);
        FilterDoubleColumnInList expr1 = f;
        dcv0.vector[0] = 5.0;
        dcv0.vector[1] = 20.2;
        dcv0.vector[2] = 17.0;
        dcv0.vector[3] = 15.0;
        dcv0.vector[4] = 10.0;
        expr1.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)0L, (long)vrb.selected[0]);
        Assert.assertEquals((long)1L, (long)vrb.selected[1]);
    }

    @Test
    public void testFilterStringIn() {
        int seed = 17;
        VectorizedRowBatch vrb = VectorizedRowGroupGenUtil.getVectorizedRowBatch(3, 2, seed);
        vrb.cols[0] = new BytesColumnVector();
        BytesColumnVector bcv = (BytesColumnVector)vrb.cols[0];
        bcv.initBuffer();
        bcv.setVal(0, a, 0, 1);
        bcv.setVal(1, b, 0, 1);
        bcv.setVal(2, c, 0, 1);
        FilterStringColumnInList expr = new FilterStringColumnInList(0);
        byte[][] inList = new byte[][]{b, c};
        expr.setInListValues((byte[][])inList);
        expr.evaluate(vrb);
        Assert.assertEquals((long)2L, (long)vrb.size);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
        Assert.assertEquals((long)2L, (long)vrb.selected[1]);
        vrb.selectedInUse = false;
        vrb.size = 3;
        bcv.noNulls = false;
        bcv.isNull[2] = true;
        expr.evaluate(vrb);
        Assert.assertEquals((long)1L, (long)vrb.size);
        Assert.assertEquals((long)1L, (long)vrb.selected[0]);
        Assert.assertTrue((boolean)vrb.selectedInUse);
        vrb.selectedInUse = false;
        vrb.size = 3;
        bcv.noNulls = true;
        bcv.isRepeating = true;
        expr.evaluate(vrb);
        Assert.assertEquals((long)0L, (long)vrb.size);
        vrb.selectedInUse = false;
        vrb.size = 3;
        bcv.noNulls = false;
        bcv.isRepeating = true;
        bcv.isNull[0] = true;
        bcv.setVal(0, b, 0, 1);
        expr.evaluate(vrb);
        Assert.assertEquals((long)0L, (long)vrb.size);
    }

    @Test
    public void testFilterDecimalColEqualDecimalScalar() {
        VectorizedRowBatch b = this.getVectorizedRowBatch1DecimalCol();
        Decimal128 scalar = new Decimal128();
        scalar.update("-3.30", (short)2);
        FilterDecimalColEqualDecimalScalar expr = new FilterDecimalColEqualDecimalScalar(0, scalar);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)1L, (long)b.selected[0]);
        Assert.assertEquals((long)1L, (long)b.size);
        b = this.getVectorizedRowBatch1DecimalCol();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch1DecimalCol();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch1DecimalCol();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
    }

    @Test
    public void testFilterDecimalScalarEqualDecimalColumn() {
        VectorizedRowBatch b = this.getVectorizedRowBatch1DecimalCol();
        Decimal128 scalar = new Decimal128();
        scalar.update("-3.30", (short)2);
        FilterDecimalScalarEqualDecimalColumn expr = new FilterDecimalScalarEqualDecimalColumn(scalar, 0);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)1L, (long)b.selected[0]);
        Assert.assertEquals((long)1L, (long)b.size);
        b = this.getVectorizedRowBatch1DecimalCol();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch1DecimalCol();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch1DecimalCol();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
    }

    @Test
    public void testFilterDecimalColumnEqualDecimalColumn() {
        VectorizedRowBatch b = this.getVectorizedRowBatch2DecimalCol();
        FilterDecimalColEqualDecimalColumn expr = new FilterDecimalColEqualDecimalColumn(0, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)1L, (long)b.selected[0]);
        Assert.assertEquals((long)1L, (long)b.size);
        b = this.getVectorizedRowBatch2DecimalCol();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[1] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch2DecimalCol();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch2DecimalCol();
        b.cols[0].isRepeating = true;
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
        b = this.getVectorizedRowBatch2DecimalCol();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        b.cols[1].noNulls = false;
        b.cols[1].isNull[2] = true;
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)b.size);
        b = this.getVectorizedRowBatch2DecimalCol();
        b.cols[0].isRepeating = true;
        b.cols[1].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((long)0L, (long)b.size);
    }

    @Test
    public void testFilterDecimalColLessScalar() {
        VectorizedRowBatch b = this.getVectorizedRowBatch1DecimalCol();
        Decimal128 scalar = new Decimal128();
        scalar.update("0", (short)2);
        FilterDecimalColLessDecimalScalar expr = new FilterDecimalColLessDecimalScalar(0, scalar);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)1L, (long)b.selected[0]);
        Assert.assertEquals((long)1L, (long)b.size);
    }

    @Test
    public void testFilterDecimalScalarGreaterThanColumn() {
        VectorizedRowBatch b = this.getVectorizedRowBatch1DecimalCol();
        Decimal128 scalar = new Decimal128();
        scalar.update("0", (short)2);
        FilterDecimalScalarGreaterDecimalColumn expr = new FilterDecimalScalarGreaterDecimalColumn(scalar, 0);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)1L, (long)b.selected[0]);
        Assert.assertEquals((long)1L, (long)b.size);
    }

    @Test
    public void testFilterDecimalColGreaterEqualCol() {
        VectorizedRowBatch b = this.getVectorizedRowBatch2DecimalCol();
        FilterDecimalColGreaterEqualDecimalColumn expr = new FilterDecimalColGreaterEqualDecimalColumn(0, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)b.selectedInUse);
        Assert.assertEquals((long)0L, (long)b.selected[0]);
        Assert.assertEquals((long)1L, (long)b.selected[1]);
        Assert.assertEquals((long)2L, (long)b.size);
    }

    private VectorizedRowBatch getVectorizedRowBatch1DecimalCol() {
        VectorizedRowBatch b = new VectorizedRowBatch(1);
        DecimalColumnVector v0 = new DecimalColumnVector(18, 2);
        b.cols[0] = v0;
        v0.vector[0].update("1.20", (short)2);
        v0.vector[1].update("-3.30", (short)2);
        v0.vector[2].update("0", (short)2);
        b.size = 3;
        return b;
    }

    private VectorizedRowBatch getVectorizedRowBatch2DecimalCol() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        DecimalColumnVector v0 = new DecimalColumnVector(18, 2);
        b.cols[0] = v0;
        v0.vector[0].update("1.20", (short)2);
        v0.vector[1].update("-3.30", (short)2);
        v0.vector[2].update("0", (short)2);
        DecimalColumnVector v1 = new DecimalColumnVector(18, 2);
        b.cols[1] = v1;
        v1.vector[0].update("-1", (short)2);
        v1.vector[1].update("-3.30", (short)2);
        v1.vector[2].update("10", (short)2);
        b.size = 3;
        return b;
    }

    static {
        try {
            a = "a".getBytes("UTF-8");
            b = "b".getBytes("UTF-8");
            c = "c".getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

