/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.CompactionTxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.TException;

public abstract class CompactorTest {
    private static final String CLASS_NAME = CompactorTest.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected CompactionTxnHandler txnHandler;
    protected IMetaStoreClient ms;
    protected long sleepTime = 1000L;
    private final MetaStoreThread.BooleanPointer stop = new MetaStoreThread.BooleanPointer();
    private final File tmpdir;

    protected CompactorTest() throws Exception {
        HiveConf conf = new HiveConf();
        TxnDbUtil.setConfValues((HiveConf)conf);
        TxnDbUtil.cleanDb();
        this.ms = new HiveMetaStoreClient(conf);
        this.txnHandler = new CompactionTxnHandler(conf);
        this.tmpdir = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "compactor_test_tables");
        this.tmpdir.mkdir();
        this.tmpdir.deleteOnExit();
    }

    protected void startInitiator(HiveConf conf) throws Exception {
        this.startThread('i', conf);
    }

    protected void startWorker(HiveConf conf) throws Exception {
        this.startThread('w', conf);
    }

    protected void startCleaner(HiveConf conf) throws Exception {
        this.startThread('c', conf);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned) throws TException {
        return this.newTable(dbName, tableName, partitioned, new HashMap<String, String>(), null);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned, Map<String, String> parameters) throws TException {
        return this.newTable(dbName, tableName, partitioned, parameters, null);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned, Map<String, String> parameters, List<Order> sortCols) throws TException {
        Table table = new Table();
        table.setTableName(tableName);
        table.setDbName(dbName);
        table.setOwner("me");
        table.setSd(this.newStorageDescriptor(this.getLocation(tableName, null), sortCols));
        ArrayList<FieldSchema> partKeys = new ArrayList<FieldSchema>(1);
        if (partitioned) {
            partKeys.add(new FieldSchema("ds", "string", "no comment"));
            table.setPartitionKeys(partKeys);
        }
        table.setParameters(parameters);
        this.ms.createTable(table);
        return table;
    }

    protected Partition newPartition(Table t, String value) throws Exception {
        return this.newPartition(t, value, null);
    }

    protected Partition newPartition(Table t, String value, List<Order> sortCols) throws Exception {
        Partition part = new Partition();
        part.addToValues(value);
        part.setDbName(t.getDbName());
        part.setTableName(t.getTableName());
        part.setSd(this.newStorageDescriptor(this.getLocation(t.getTableName(), value), sortCols));
        part.setParameters(new HashMap());
        this.ms.add_partition(part);
        return part;
    }

    protected long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, System.getProperty("user.name"), Worker.hostname())).getTxn_ids();
        return (Long)txns.get(0);
    }

    protected void addDeltaFile(HiveConf conf, Table t, Partition p, long minTxn, long maxTxn, int numRecords) throws Exception {
        this.addFile(conf, t, p, minTxn, maxTxn, numRecords, FileType.DELTA, 2, true);
    }

    protected void addBaseFile(HiveConf conf, Table t, Partition p, long maxTxn, int numRecords) throws Exception {
        this.addFile(conf, t, p, 0L, maxTxn, numRecords, FileType.BASE, 2, true);
    }

    protected void addLegacyFile(HiveConf conf, Table t, Partition p, int numRecords) throws Exception {
        this.addFile(conf, t, p, 0L, 0L, numRecords, FileType.LEGACY, 2, true);
    }

    protected void addDeltaFile(HiveConf conf, Table t, Partition p, long minTxn, long maxTxn, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(conf, t, p, minTxn, maxTxn, numRecords, FileType.DELTA, numBuckets, allBucketsPresent);
    }

    protected void addBaseFile(HiveConf conf, Table t, Partition p, long maxTxn, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(conf, t, p, 0L, maxTxn, numRecords, FileType.BASE, numBuckets, allBucketsPresent);
    }

    protected void addLegacyFile(HiveConf conf, Table t, Partition p, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(conf, t, p, 0L, 0L, numRecords, FileType.LEGACY, numBuckets, allBucketsPresent);
    }

    protected List<Path> getDirectories(HiveConf conf, Table t, Partition p) throws Exception {
        String partValue = p == null ? null : (String)p.getValues().get(0);
        String location = this.getLocation(t.getTableName(), partValue);
        Path dir = new Path(location);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stats = fs.listStatus(dir);
        ArrayList<Path> paths = new ArrayList<Path>(stats.length);
        for (int i = 0; i < stats.length; ++i) {
            paths.add(stats[i].getPath());
        }
        return paths;
    }

    protected void burnThroughTransactions(int num) throws MetaException, NoSuchTxnException, TxnAbortedException {
        OpenTxnsResponse rsp = this.txnHandler.openTxns(new OpenTxnRequest(num, "me", "localhost"));
        Iterator i$ = rsp.getTxn_ids().iterator();
        while (i$.hasNext()) {
            long tid = (Long)i$.next();
            this.txnHandler.commitTxn(new CommitTxnRequest(tid));
        }
    }

    private StorageDescriptor newStorageDescriptor(String location, List<Order> sortCols) {
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(2);
        cols.add(new FieldSchema("a", "varchar(25)", "still no comment"));
        cols.add(new FieldSchema("b", "int", "comment"));
        sd.setCols(cols);
        sd.setLocation(location);
        sd.setInputFormat(MockInputFormat.class.getName());
        sd.setOutputFormat(MockOutputFormat.class.getName());
        sd.setNumBuckets(1);
        SerDeInfo serde = new SerDeInfo();
        serde.setSerializationLib(LazySimpleSerDe.class.getName());
        sd.setSerdeInfo(serde);
        ArrayList<String> bucketCols = new ArrayList<String>(1);
        bucketCols.add("a");
        sd.setBucketCols(bucketCols);
        if (sortCols != null) {
            sd.setSortCols(sortCols);
        }
        return sd;
    }

    private void startThread(char type, HiveConf conf) throws Exception {
        TxnDbUtil.setConfValues((HiveConf)conf);
        Initiator t = null;
        switch (type) {
            case 'i': {
                t = new Initiator();
                break;
            }
            case 'w': {
                t = new Worker();
                break;
            }
            case 'c': {
                t = new Cleaner();
                break;
            }
            default: {
                throw new RuntimeException("Huh? Unknown thread type.");
            }
        }
        t.setThreadId((int)t.getId());
        t.setHiveConf(conf);
        this.stop.boolVal = true;
        t.init(this.stop);
        t.run();
    }

    private String getLocation(String tableName, String partValue) {
        String location = this.tmpdir.getAbsolutePath() + System.getProperty("file.separator") + tableName;
        if (partValue != null) {
            location = location + System.getProperty("file.separator") + "ds=" + partValue;
        }
        return location;
    }

    private void addFile(HiveConf conf, Table t, Partition p, long minTxn, long maxTxn, int numRecords, FileType type, int numBuckets, boolean allBucketsPresent) throws Exception {
        String partValue = p == null ? null : (String)p.getValues().get(0);
        Path location = new Path(this.getLocation(t.getTableName(), partValue));
        String filename = null;
        switch (type) {
            case BASE: {
                filename = "base_" + maxTxn;
                break;
            }
            case DELTA: {
                filename = "delta_" + minTxn + "_" + maxTxn;
                break;
            }
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (int bucket = 0; bucket < numBuckets; ++bucket) {
            if (bucket == 0 && !allBucketsPresent) continue;
            Path partFile = null;
            if (type == FileType.LEGACY) {
                partFile = new Path(location, String.format("%05d", bucket) + "_0");
            } else {
                Path dir = new Path(location, filename);
                fs.mkdirs(dir);
                partFile = AcidUtils.createBucketFile((Path)dir, (int)bucket);
            }
            FSDataOutputStream out = fs.create(partFile);
            for (int i = 0; i < numRecords; ++i) {
                RecordIdentifier ri = new RecordIdentifier(maxTxn - 1L, bucket, (long)i);
                ri.write((DataOutput)out);
                out.writeBytes("mary had a little lamb its fleece was white as snow\n");
            }
            out.close();
        }
    }

    static class MockRecordWriter
    implements FileSinkOperator.RecordWriter {
        private final FSDataOutputStream os;

        MockRecordWriter(Path basedir, AcidOutputFormat.Options options) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)options.getConfiguration());
            Path p = AcidUtils.createFilename((Path)basedir, (AcidOutputFormat.Options)options);
            this.os = fs.create(p);
        }

        public void write(Writable w) throws IOException {
            Text t = (Text)w;
            this.os.writeBytes(t.toString());
            this.os.writeBytes("\n");
        }

        public void close(boolean abort) throws IOException {
            this.os.close();
        }
    }

    static class MockOutputFormat
    implements AcidOutputFormat<Text> {
        MockOutputFormat() {
        }

        public RecordUpdater getRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
            return null;
        }

        public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
            return new MockRecordWriter(path, options);
        }

        public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            return null;
        }

        public RecordWriter<NullWritable, Text> getRecordWriter(FileSystem fileSystem, JobConf entries, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf entries) throws IOException {
        }
    }

    static class MockRawReader
    implements AcidInputFormat.RawReader<Text> {
        private final Stack<Path> filesToRead = new Stack();
        private final Configuration conf;
        private FSDataInputStream is = null;
        private final FileSystem fs;

        MockRawReader(Configuration conf, List<Path> files) throws IOException {
            for (Path file : files) {
                this.filesToRead.push(file);
            }
            this.conf = conf;
            this.fs = FileSystem.get((Configuration)conf);
        }

        public ObjectInspector getObjectInspector() {
            return null;
        }

        public boolean next(RecordIdentifier identifier, Text text) throws IOException {
            if (this.is == null) {
                if (this.filesToRead.empty()) {
                    return false;
                }
                Path p = this.filesToRead.pop();
                LOG.debug((Object)("Reading records from " + p.toString()));
                this.is = this.fs.open(p);
            }
            String line = null;
            try {
                identifier.readFields((DataInput)this.is);
                line = this.is.readLine();
            }
            catch (EOFException e) {
                // empty catch block
            }
            if (line == null) {
                this.is = null;
                return this.next(identifier, text);
            }
            text.set(line);
            return true;
        }

        public RecordIdentifier createKey() {
            return new RecordIdentifier();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    static class MockInputFormat
    implements AcidInputFormat<Text> {
        MockInputFormat() {
        }

        public AcidInputFormat.RowReader<Text> getReader(InputSplit split, AcidInputFormat.Options options) throws IOException {
            return null;
        }

        public AcidInputFormat.RawReader<Text> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidTxnList validTxnList, Path baseDirectory, Path ... deltaDirectory) throws IOException {
            ArrayList<Path> filesToRead = new ArrayList<Path>();
            if (baseDirectory != null) {
                if (baseDirectory.getName().startsWith("base_")) {
                    Path p = AcidUtils.createBucketFile((Path)baseDirectory, (int)bucket);
                    FileSystem fs = p.getFileSystem(conf);
                    if (fs.exists(p)) {
                        filesToRead.add(p);
                    }
                } else {
                    filesToRead.add(new Path(baseDirectory, "00000_0"));
                }
            }
            for (int i = 0; i < deltaDirectory.length; ++i) {
                Path p = AcidUtils.createBucketFile((Path)deltaDirectory[i], (int)bucket);
                FileSystem fs = p.getFileSystem(conf);
                if (!fs.exists(p)) continue;
                filesToRead.add(p);
            }
            return new MockRawReader(conf, filesToRead);
        }

        public InputSplit[] getSplits(JobConf entries, int i) throws IOException {
            return new InputSplit[0];
        }

        public RecordReader<NullWritable, Text> getRecordReader(InputSplit inputSplit, JobConf entries, Reporter reporter) throws IOException {
            return null;
        }

        public boolean validateInput(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws IOException {
            return false;
        }
    }

    private static enum FileType {
        BASE,
        DELTA,
        LEGACY;

    }
}

