/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import com.google.common.base.Joiner;
import java.util.Collections;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLock;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZookeeperLockManager {
    private static final Joiner SLASH = Joiner.on((String)"/");
    private static final String PARENT = "hive";
    private static final String TABLE = "t1";
    private static final String PARENT_LOCK_PATH = SLASH.join((Object)"", (Object)"hive", new Object[]{"t1"});
    private static final String TABLE_LOCK_PATH = SLASH.join((Object)"", (Object)"hive", new Object[]{"t1", "00001"});
    private HiveConf conf;
    private ZooKeeper zooKeeper;
    private HiveLockObject hiveLock;
    private ZooKeeperHiveLock zLock;

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.zooKeeper = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        this.hiveLock = (HiveLockObject)Mockito.mock(HiveLockObject.class);
        Mockito.when((Object)this.hiveLock.getName()).thenReturn((Object)TABLE);
        this.zLock = new ZooKeeperHiveLock(TABLE_LOCK_PATH, this.hiveLock, HiveLockMode.SHARED);
    }

    @Test
    public void testDeleteNoChildren() throws Exception {
        ZooKeeperHiveLockManager.unlockPrimitive((HiveConf)this.conf, (ZooKeeper)this.zooKeeper, (HiveLock)this.zLock, (String)PARENT);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).delete(TABLE_LOCK_PATH, -1);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).getChildren(PARENT_LOCK_PATH, false);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).delete(PARENT_LOCK_PATH, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.zooKeeper});
    }

    @Test
    public void testDeleteNoChildrenNodeDoesNotExist() throws Exception {
        ((ZooKeeper)Mockito.doThrow((Throwable)new KeeperException.NoNodeException()).when((Object)this.zooKeeper)).delete(PARENT_LOCK_PATH, -1);
        ZooKeeperHiveLockManager.unlockPrimitive((HiveConf)this.conf, (ZooKeeper)this.zooKeeper, (HiveLock)this.zLock, (String)PARENT);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).delete(TABLE_LOCK_PATH, -1);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).getChildren(PARENT_LOCK_PATH, false);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).delete(PARENT_LOCK_PATH, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.zooKeeper});
    }

    @Test
    public void testDeleteWithChildren() throws Exception {
        Mockito.when((Object)this.zooKeeper.getChildren(PARENT_LOCK_PATH, false)).thenReturn(Collections.singletonList("somechild"));
        ZooKeeperHiveLockManager.unlockPrimitive((HiveConf)this.conf, (ZooKeeper)this.zooKeeper, (HiveLock)this.zLock, (String)PARENT);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).delete(TABLE_LOCK_PATH, -1);
        ((ZooKeeper)Mockito.verify((Object)this.zooKeeper)).getChildren(PARENT_LOCK_PATH, false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.zooKeeper});
    }

    @Test
    public void testGetQuorumServers() {
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "node1");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, "9999");
        Assert.assertEquals((Object)"node1:9999", (Object)ZooKeeperHiveLockManager.getQuorumServers((HiveConf)this.conf));
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "node1,node2,node3");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, "9999");
        Assert.assertEquals((Object)"node1:9999,node2:9999,node3:9999", (Object)ZooKeeperHiveLockManager.getQuorumServers((HiveConf)this.conf));
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM, "node1:5666,node2,node3");
        this.conf.setVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT, "9999");
        Assert.assertEquals((Object)"node1:5666,node2:9999,node3:9999", (Object)ZooKeeperHiveLockManager.getQuorumServers((HiveConf)this.conf));
    }
}

