/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.HiveCommand;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.Test;

public class TestCommandProcessorFactory {
    private HiveConf conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HiveConf();
    }

    @Test
    public void testInvalidCommands() throws Exception {
        Assert.assertNull((String)"Null should have returned null", (Object)CommandProcessorFactory.getForHiveCommand(null, (HiveConf)this.conf));
        Assert.assertNull((String)"Blank should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{" "}, (HiveConf)this.conf));
        Assert.assertNull((String)"set role should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{"set role"}, (HiveConf)this.conf));
        Assert.assertNull((String)"SQL should have returned null", (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{"SELECT * FROM TABLE"}, (HiveConf)this.conf));
    }

    @Test
    public void testAvailableCommands() throws Exception {
        String cmd;
        SessionState.start((HiveConf)this.conf);
        for (HiveCommand command : HiveCommand.values()) {
            cmd = command.name();
            Assert.assertNotNull((String)("Cmd " + cmd + " not return null"), (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{cmd}, (HiveConf)this.conf));
        }
        for (HiveCommand command : HiveCommand.values()) {
            cmd = command.name().toLowerCase();
            Assert.assertNotNull((String)("Cmd " + cmd + " not return null"), (Object)CommandProcessorFactory.getForHiveCommand((String[])new String[]{cmd}, (HiveConf)this.conf));
        }
        this.conf.set(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.toString(), "");
        for (HiveCommand command : HiveCommand.values()) {
            cmd = command.name();
            try {
                CommandProcessorFactory.getForHiveCommand((String[])new String[]{cmd}, (HiveConf)this.conf);
                Assert.fail((String)("Expected SQLException for " + cmd + " as available commands is empty"));
            }
            catch (SQLException e) {
                Assert.assertEquals((String)("Insufficient privileges to execute " + cmd), (String)e.getMessage());
                Assert.assertEquals((String)"42000", (String)e.getSQLState());
            }
        }
    }
}

