/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColAndCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColOrCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprOrExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterLongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncLogWithBaseDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncLogWithBaseLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncPowerDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringColumnStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringColumnStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringScalarStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprStringScalarStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IsNotNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IsNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NotCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.RoundWithNumDigitsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsFalse;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsNotNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsTrue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLTrim;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLower;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUpper;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColUnaryMinus;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongScalarGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColGreaterStringColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColGreaterStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRoundDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSinDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleColumnDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleColumnDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleScalarDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleScalarDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprDoubleScalarLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongColumnLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongColumnLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongScalarLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.IfExprLongScalarLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColAddLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColEqualLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColGreaterLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColMultiplyLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColSubtractLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColUnaryMinus;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarSubtractLongColumn;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorizationContext {
    @Test
    public void testVectorExpressionDescriptor() {
        VectorUDFUnixTimeStampLong v1 = new VectorUDFUnixTimeStampLong();
        VectorExpressionDescriptor.Builder builder1 = new VectorExpressionDescriptor.Builder();
        VectorExpressionDescriptor.Descriptor d1 = builder1.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.LONG}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
        junit.framework.Assert.assertEquals((Object)d1, (Object)v1.getDescriptor());
        VectorExpressionDescriptor.Builder builder2 = new VectorExpressionDescriptor.Builder();
        VectorExpressionDescriptor.Descriptor d2 = builder2.setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.LONG, VectorExpressionDescriptor.ArgumentType.DOUBLE}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
        FilterLongColLessDoubleScalar v2 = new FilterLongColLessDoubleScalar();
        junit.framework.Assert.assertEquals((Object)d2, (Object)v2.getDescriptor());
        VectorExpressionDescriptor.Builder builder3 = new VectorExpressionDescriptor.Builder();
        VectorExpressionDescriptor.Descriptor d3 = builder3.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
        StringLower v3 = new StringLower();
        junit.framework.Assert.assertEquals((Object)d3, (Object)v3.getDescriptor());
        VectorExpressionDescriptor.Builder builder4 = new VectorExpressionDescriptor.Builder();
        VectorExpressionDescriptor.Descriptor d4 = builder4.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.ANY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
        StringUpper v4 = new StringUpper();
        junit.framework.Assert.assertEquals((Object)d4, (Object)v4.getDescriptor());
        VectorExpressionDescriptor.Builder builder5 = new VectorExpressionDescriptor.Builder();
        VectorExpressionDescriptor.Descriptor d5 = builder5.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
        IsNull v5 = new IsNull();
        junit.framework.Assert.assertEquals((Object)d5, (Object)v5.getDescriptor());
    }

    @Test
    public void testArithmeticExpressionVectorization() throws HiveException {
        GenericUDFOPPlus udf1 = new GenericUDFOPPlus();
        GenericUDFOPMinus udf2 = new GenericUDFOPMinus();
        GenericUDFOPMultiply udf3 = new GenericUDFOPMultiply();
        GenericUDFOPPlus udf4 = new GenericUDFOPPlus();
        GenericUDFOPMod udf5 = new GenericUDFOPMod();
        ExprNodeGenericFuncDesc sumExpr = new ExprNodeGenericFuncDesc();
        sumExpr.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        sumExpr.setGenericUDF((GenericUDF)udf1);
        ExprNodeGenericFuncDesc minusExpr = new ExprNodeGenericFuncDesc();
        minusExpr.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        minusExpr.setGenericUDF((GenericUDF)udf2);
        ExprNodeGenericFuncDesc multiplyExpr = new ExprNodeGenericFuncDesc();
        multiplyExpr.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        multiplyExpr.setGenericUDF((GenericUDF)udf3);
        ExprNodeGenericFuncDesc sum2Expr = new ExprNodeGenericFuncDesc();
        sum2Expr.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        sum2Expr.setGenericUDF((GenericUDF)udf4);
        ExprNodeGenericFuncDesc modExpr = new ExprNodeGenericFuncDesc();
        modExpr.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        modExpr.setGenericUDF((GenericUDF)udf5);
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Long.class, "col1", "table", false);
        ExprNodeColumnDesc col2Expr = new ExprNodeColumnDesc(Long.class, "col2", "table", false);
        ExprNodeColumnDesc col3Expr = new ExprNodeColumnDesc(Long.class, "col3", "table", false);
        ExprNodeColumnDesc col4Expr = new ExprNodeColumnDesc(Long.class, "col4", "table", false);
        ExprNodeColumnDesc col5Expr = new ExprNodeColumnDesc(Long.class, "col5", "table", false);
        ExprNodeColumnDesc col6Expr = new ExprNodeColumnDesc(Long.class, "col6", "table", false);
        ArrayList<ExprNodeGenericFuncDesc> children1 = new ArrayList<ExprNodeGenericFuncDesc>(2);
        ArrayList<Object> children2 = new ArrayList<Object>(2);
        ArrayList<ExprNodeColumnDesc> children3 = new ArrayList<ExprNodeColumnDesc>(2);
        ArrayList<Object> children4 = new ArrayList<Object>(2);
        ArrayList<ExprNodeColumnDesc> children5 = new ArrayList<ExprNodeColumnDesc>(2);
        children1.add(minusExpr);
        children1.add(multiplyExpr);
        sumExpr.setChildren(children1);
        children2.add(sum2Expr);
        children2.add(col3Expr);
        minusExpr.setChildren(children2);
        children3.add(col1Expr);
        children3.add(col2Expr);
        sum2Expr.setChildren(children3);
        children4.add(col4Expr);
        children4.add(modExpr);
        multiplyExpr.setChildren(children4);
        children5.add(col5Expr);
        children5.add(col6Expr);
        modExpr.setChildren(children5);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        columnMap.put("col3", 3);
        columnMap.put("col4", 4);
        columnMap.put("col5", 5);
        columnMap.put("col6", 6);
        VectorizationContext vc = new VectorizationContext(columnMap, 6);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)sumExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)(ve instanceof LongColAddLongColumn));
        Assert.assertEquals((long)2L, (long)ve.getChildExpressions().length);
        VectorExpression childExpr1 = ve.getChildExpressions()[0];
        VectorExpression childExpr2 = ve.getChildExpressions()[1];
        System.out.println(ve.toString());
        Assert.assertEquals((long)6L, (long)ve.getOutputColumn());
        Assert.assertTrue((boolean)(childExpr1 instanceof LongColSubtractLongColumn));
        Assert.assertEquals((long)1L, (long)childExpr1.getChildExpressions().length);
        Assert.assertTrue((boolean)(childExpr1.getChildExpressions()[0] instanceof LongColAddLongColumn));
        Assert.assertEquals((long)7L, (long)childExpr1.getOutputColumn());
        Assert.assertEquals((long)6L, (long)childExpr1.getChildExpressions()[0].getOutputColumn());
        Assert.assertTrue((boolean)(childExpr2 instanceof LongColMultiplyLongColumn));
        Assert.assertEquals((long)1L, (long)childExpr2.getChildExpressions().length);
        Assert.assertTrue((boolean)(childExpr2.getChildExpressions()[0] instanceof LongColModuloLongColumn));
        Assert.assertEquals((long)8L, (long)childExpr2.getOutputColumn());
        Assert.assertEquals((long)6L, (long)childExpr2.getChildExpressions()[0].getOutputColumn());
    }

    @Test
    public void testStringFilterExpressions() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(String.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)"Alpha");
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc();
        exprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        exprDesc.setChildren(children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterStringColGreaterStringScalar));
    }

    @Test
    public void testFilterStringColCompareStringColumnExpressions() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(String.class, "col1", "table", false);
        ExprNodeColumnDesc col2Expr = new ExprNodeColumnDesc(String.class, "col2", "table", false);
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc();
        exprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<ExprNodeColumnDesc> children1 = new ArrayList<ExprNodeColumnDesc>(2);
        children1.add(col1Expr);
        children1.add(col2Expr);
        exprDesc.setChildren(children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterStringColGreaterStringColumn));
    }

    @Test
    public void testFloatInExpressions() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Float.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(10));
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, (GenericUDF)udf, children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 0);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)ve.getOutputType().equalsIgnoreCase("double"));
    }

    @Test
    public void testVectorizeFilterAndOrExpression() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(10));
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc greaterExprDesc = new ExprNodeGenericFuncDesc();
        greaterExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        greaterExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        greaterExprDesc.setChildren(children1);
        ExprNodeColumnDesc col2Expr = new ExprNodeColumnDesc(Float.class, "col2", "table", false);
        ExprNodeConstantDesc const2Desc = new ExprNodeConstantDesc((Object)new Float(1.0));
        GenericUDFOPLessThan udf2 = new GenericUDFOPLessThan();
        ExprNodeGenericFuncDesc lessExprDesc = new ExprNodeGenericFuncDesc();
        lessExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        lessExprDesc.setGenericUDF((GenericUDF)udf2);
        ArrayList<Object> children2 = new ArrayList<Object>(2);
        children2.add(col2Expr);
        children2.add(const2Desc);
        lessExprDesc.setChildren(children2);
        GenericUDFOPAnd andUdf = new GenericUDFOPAnd();
        ExprNodeGenericFuncDesc andExprDesc = new ExprNodeGenericFuncDesc();
        andExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        andExprDesc.setGenericUDF((GenericUDF)andUdf);
        ArrayList<ExprNodeGenericFuncDesc> children3 = new ArrayList<ExprNodeGenericFuncDesc>(2);
        children3.add(greaterExprDesc);
        children3.add(lessExprDesc);
        andExprDesc.setChildren(children3);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 0);
        columnMap.put("col2", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)andExprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(ve.getClass(), FilterExprAndExpr.class);
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), FilterLongColGreaterLongScalar.class);
        Assert.assertEquals(ve.getChildExpressions()[1].getClass(), FilterDoubleColLessDoubleScalar.class);
        GenericUDFOPOr orUdf = new GenericUDFOPOr();
        ExprNodeGenericFuncDesc orExprDesc = new ExprNodeGenericFuncDesc();
        orExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        orExprDesc.setGenericUDF((GenericUDF)orUdf);
        ArrayList<ExprNodeGenericFuncDesc> children4 = new ArrayList<ExprNodeGenericFuncDesc>(2);
        children4.add(greaterExprDesc);
        children4.add(lessExprDesc);
        orExprDesc.setChildren(children4);
        VectorExpression veOr = vc.getVectorExpression((ExprNodeDesc)orExprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(veOr.getClass(), FilterExprOrExpr.class);
        Assert.assertEquals(veOr.getChildExpressions()[0].getClass(), FilterLongColGreaterLongScalar.class);
        Assert.assertEquals(veOr.getChildExpressions()[1].getClass(), FilterDoubleColLessDoubleScalar.class);
    }

    @Test
    public void testVectorizeAndOrProjectionExpression() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(10));
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc greaterExprDesc = new ExprNodeGenericFuncDesc();
        greaterExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        greaterExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        greaterExprDesc.setChildren(children1);
        ExprNodeColumnDesc col2Expr = new ExprNodeColumnDesc(Boolean.class, "col2", "table", false);
        GenericUDFOPAnd andUdf = new GenericUDFOPAnd();
        ExprNodeGenericFuncDesc andExprDesc = new ExprNodeGenericFuncDesc();
        andExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        andExprDesc.setGenericUDF((GenericUDF)andUdf);
        ArrayList<Object> children3 = new ArrayList<Object>(2);
        children3.add(greaterExprDesc);
        children3.add(col2Expr);
        andExprDesc.setChildren(children3);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 0);
        columnMap.put("col2", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression veAnd = vc.getVectorExpression((ExprNodeDesc)andExprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(veAnd.getClass(), FilterExprAndExpr.class);
        Assert.assertEquals(veAnd.getChildExpressions()[0].getClass(), FilterLongColGreaterLongScalar.class);
        Assert.assertEquals(veAnd.getChildExpressions()[1].getClass(), SelectColumnIsTrue.class);
        veAnd = vc.getVectorExpression((ExprNodeDesc)andExprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(veAnd.getClass(), ColAndCol.class);
        Assert.assertEquals((long)1L, (long)veAnd.getChildExpressions().length);
        Assert.assertEquals(veAnd.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
        Assert.assertEquals((long)2L, (long)((ColAndCol)veAnd).getColNum1());
        Assert.assertEquals((long)1L, (long)((ColAndCol)veAnd).getColNum2());
        Assert.assertEquals((long)3L, (long)((ColAndCol)veAnd).getOutputColumn());
        GenericUDFOPOr orUdf = new GenericUDFOPOr();
        ExprNodeGenericFuncDesc orExprDesc = new ExprNodeGenericFuncDesc();
        orExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        orExprDesc.setGenericUDF((GenericUDF)orUdf);
        ArrayList<Object> children4 = new ArrayList<Object>(2);
        children4.add(greaterExprDesc);
        children4.add(col2Expr);
        orExprDesc.setChildren(children4);
        vc = new VectorizationContext(columnMap, 2);
        VectorExpression veOr = vc.getVectorExpression((ExprNodeDesc)orExprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(veOr.getClass(), FilterExprOrExpr.class);
        Assert.assertEquals(veOr.getChildExpressions()[0].getClass(), FilterLongColGreaterLongScalar.class);
        Assert.assertEquals(veOr.getChildExpressions()[1].getClass(), SelectColumnIsTrue.class);
        veOr = vc.getVectorExpression((ExprNodeDesc)orExprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(veOr.getClass(), ColOrCol.class);
        Assert.assertEquals((long)1L, (long)veAnd.getChildExpressions().length);
        Assert.assertEquals(veAnd.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
        Assert.assertEquals((long)2L, (long)((ColOrCol)veOr).getColNum1());
        Assert.assertEquals((long)1L, (long)((ColOrCol)veOr).getColNum2());
        Assert.assertEquals((long)3L, (long)((ColOrCol)veOr).getOutputColumn());
    }

    @Test
    public void testNotExpression() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(10));
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc greaterExprDesc = new ExprNodeGenericFuncDesc();
        greaterExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        greaterExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        greaterExprDesc.setChildren(children1);
        ExprNodeGenericFuncDesc notExpr = new ExprNodeGenericFuncDesc();
        notExpr.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        GenericUDFOPNot notUdf = new GenericUDFOPNot();
        notExpr.setGenericUDF((GenericUDF)notUdf);
        ArrayList<ExprNodeGenericFuncDesc> childOfNot = new ArrayList<ExprNodeGenericFuncDesc>();
        childOfNot.add(greaterExprDesc);
        notExpr.setChildren(childOfNot);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 0);
        columnMap.put("col2", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)notExpr, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(ve.getClass(), SelectColumnIsFalse.class);
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
        ve = vc.getVectorExpression((ExprNodeDesc)notExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(ve.getClass(), NotCol.class);
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
    }

    @Test
    public void testNullExpressions() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(10));
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc greaterExprDesc = new ExprNodeGenericFuncDesc();
        greaterExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        greaterExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        greaterExprDesc.setChildren(children1);
        ExprNodeGenericFuncDesc isNullExpr = new ExprNodeGenericFuncDesc();
        isNullExpr.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        GenericUDFOPNull isNullUdf = new GenericUDFOPNull();
        isNullExpr.setGenericUDF((GenericUDF)isNullUdf);
        ArrayList<ExprNodeGenericFuncDesc> childOfIsNull = new ArrayList<ExprNodeGenericFuncDesc>();
        childOfIsNull.add(greaterExprDesc);
        isNullExpr.setChildren(childOfIsNull);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 0);
        columnMap.put("col2", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)isNullExpr, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(ve.getClass(), SelectColumnIsNull.class);
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
        Assert.assertEquals((long)2L, (long)ve.getChildExpressions()[0].getOutputColumn());
        Assert.assertEquals((long)2L, (long)((SelectColumnIsNull)ve).getColNum());
        ve = vc.getVectorExpression((ExprNodeDesc)isNullExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(ve.getClass(), IsNull.class);
        Assert.assertEquals((long)2L, (long)((IsNull)ve).getColNum());
        Assert.assertEquals((long)3L, (long)ve.getOutputColumn());
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
    }

    @Test
    public void testNotNullExpressions() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(10));
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc greaterExprDesc = new ExprNodeGenericFuncDesc();
        greaterExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        greaterExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        greaterExprDesc.setChildren(children1);
        ExprNodeGenericFuncDesc isNotNullExpr = new ExprNodeGenericFuncDesc();
        isNotNullExpr.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        GenericUDFOPNotNull notNullUdf = new GenericUDFOPNotNull();
        isNotNullExpr.setGenericUDF((GenericUDF)notNullUdf);
        ArrayList<ExprNodeGenericFuncDesc> childOfNot = new ArrayList<ExprNodeGenericFuncDesc>();
        childOfNot.add(greaterExprDesc);
        isNotNullExpr.setChildren(childOfNot);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 0);
        columnMap.put("col2", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)isNotNullExpr, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(ve.getClass(), SelectColumnIsNotNull.class);
        Assert.assertEquals((long)2L, (long)((SelectColumnIsNotNull)ve).getColNum());
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
        ve = vc.getVectorExpression((ExprNodeDesc)isNotNullExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(ve.getClass(), IsNotNull.class);
        Assert.assertEquals((long)2L, (long)((IsNotNull)ve).getColNum());
        Assert.assertEquals(ve.getChildExpressions()[0].getClass(), LongColGreaterLongScalar.class);
    }

    @Test
    public void testVectorizeScalarColumnExpression() throws HiveException {
        GenericUDFOPMinus gudf = new GenericUDFOPMinus();
        ArrayList<Object> children = new ArrayList<Object>(2);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)20);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(Long.class, "a", "table", false);
        children.add(constDesc);
        children.add(colDesc);
        ExprNodeGenericFuncDesc scalarMinusConstant = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (GenericUDF)gudf, children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("a", 0);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)scalarMinusConstant, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(ve.getClass(), LongScalarSubtractLongColumn.class);
    }

    @Test
    public void testFilterWithNegativeScalar() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(-10));
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc();
        exprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        exprDesc.setChildren(children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterLongColGreaterLongScalar));
    }

    @Test
    public void testUnaryMinusColumnLong() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        GenericUDFOPNegative gudf = new GenericUDFOPNegative();
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>(1);
        children.add(col1Expr);
        ExprNodeGenericFuncDesc negExprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (GenericUDF)gudf, children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 1);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)negExprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)(ve instanceof LongColUnaryMinus));
    }

    @Test
    public void testUnaryMinusColumnDouble() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Float.class, "col1", "table", false);
        GenericUDFOPNegative gudf = new GenericUDFOPNegative();
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>(1);
        children.add(col1Expr);
        ExprNodeGenericFuncDesc negExprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, (GenericUDF)gudf, children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 1);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)negExprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)(ve instanceof DoubleColUnaryMinus));
    }

    @Test
    public void testFilterScalarCompareColumn() throws HiveException {
        ExprNodeGenericFuncDesc scalarGreaterColExpr = new ExprNodeGenericFuncDesc();
        GenericUDFOPGreaterThan gudf = new GenericUDFOPGreaterThan();
        scalarGreaterColExpr.setGenericUDF((GenericUDF)gudf);
        ArrayList<Object> children = new ArrayList<Object>(2);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)20);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(Long.class, "a", "table", false);
        children.add(constDesc);
        children.add(colDesc);
        scalarGreaterColExpr.setChildren(children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("a", 0);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)scalarGreaterColExpr, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(FilterLongScalarGreaterLongColumn.class, ve.getClass());
    }

    @Test
    public void testFilterBooleanColumnCompareBooleanScalar() throws HiveException {
        ExprNodeGenericFuncDesc colEqualScalar = new ExprNodeGenericFuncDesc();
        GenericUDFOPEqual gudf = new GenericUDFOPEqual();
        colEqualScalar.setGenericUDF((GenericUDF)gudf);
        ArrayList<Object> children = new ArrayList<Object>(2);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)20);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(Boolean.class, "a", "table", false);
        children.add(colDesc);
        children.add(constDesc);
        colEqualScalar.setChildren(children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("a", 0);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)colEqualScalar, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(FilterLongColEqualLongScalar.class, ve.getClass());
    }

    @Test
    public void testBooleanColumnCompareBooleanScalar() throws HiveException {
        ExprNodeGenericFuncDesc colEqualScalar = new ExprNodeGenericFuncDesc();
        GenericUDFOPEqual gudf = new GenericUDFOPEqual();
        colEqualScalar.setGenericUDF((GenericUDF)gudf);
        ArrayList<Object> children = new ArrayList<Object>(2);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)20);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(Boolean.class, "a", "table", false);
        children.add(colDesc);
        children.add(constDesc);
        colEqualScalar.setChildren(children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("a", 0);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)colEqualScalar, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertEquals(LongColEqualLongScalar.class, ve.getClass());
    }

    @Test
    public void testUnaryStringExpressions() throws HiveException {
        ExprNodeGenericFuncDesc stringUnary = new ExprNodeGenericFuncDesc();
        stringUnary.setTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(String.class, "a", "table", false);
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>();
        children.add(colDesc);
        stringUnary.setChildren(children);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("b", 0);
        columnMap.put("a", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        GenericUDFLower stringLower = new GenericUDFLower();
        stringUnary.setGenericUDF((GenericUDF)stringLower);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)stringUnary);
        Assert.assertEquals(StringLower.class, ve.getClass());
        Assert.assertEquals((long)1L, (long)((StringLower)ve).getColNum());
        Assert.assertEquals((long)2L, (long)((StringLower)ve).getOutputColumn());
        vc = new VectorizationContext(columnMap, 2);
        ExprNodeGenericFuncDesc anotherUnary = new ExprNodeGenericFuncDesc();
        anotherUnary.setTypeInfo((TypeInfo)TypeInfoFactory.stringTypeInfo);
        ArrayList<ExprNodeGenericFuncDesc> children2 = new ArrayList<ExprNodeGenericFuncDesc>();
        children2.add(stringUnary);
        anotherUnary.setChildren(children2);
        GenericUDFBridge udfbridge = new GenericUDFBridge("ltrim", false, GenericUDFLTrim.class.getName());
        anotherUnary.setGenericUDF((GenericUDF)udfbridge);
        ve = vc.getVectorExpression((ExprNodeDesc)anotherUnary);
        VectorExpression childVe = ve.getChildExpressions()[0];
        Assert.assertEquals(StringLower.class, childVe.getClass());
        Assert.assertEquals((long)1L, (long)((StringLower)childVe).getColNum());
        Assert.assertEquals((long)2L, (long)((StringLower)childVe).getOutputColumn());
        Assert.assertEquals(StringLTrim.class, ve.getClass());
        Assert.assertEquals((long)2L, (long)((StringLTrim)ve).getInputColumn());
        Assert.assertEquals((long)3L, (long)((StringLTrim)ve).getOutputColumn());
    }

    @Test
    public void testMathFunctions() throws HiveException {
        ExprNodeGenericFuncDesc mathFuncExpr = new ExprNodeGenericFuncDesc();
        mathFuncExpr.setTypeInfo((TypeInfo)TypeInfoFactory.doubleTypeInfo);
        ExprNodeColumnDesc colDesc1 = new ExprNodeColumnDesc(Integer.class, "a", "table", false);
        ExprNodeColumnDesc colDesc2 = new ExprNodeColumnDesc(Double.class, "b", "table", false);
        ArrayList<ExprNodeColumnDesc> children1 = new ArrayList<ExprNodeColumnDesc>();
        ArrayList<Object> children2 = new ArrayList<Object>();
        children1.add(colDesc1);
        children2.add(colDesc2);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("b", 0);
        columnMap.put("a", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        GenericUDFBridge gudfBridge = new GenericUDFBridge("sin", false, UDFSin.class.getName());
        mathFuncExpr.setGenericUDF((GenericUDF)gudfBridge);
        mathFuncExpr.setChildren(children2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        junit.framework.Assert.assertEquals(FuncSinDoubleToDouble.class, ve.getClass());
        GenericUDFRound udfRound = new GenericUDFRound();
        mathFuncExpr.setGenericUDF((GenericUDF)udfRound);
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncRoundDoubleToDouble.class, ve.getClass());
        mathFuncExpr.setGenericUDF((GenericUDF)udfRound);
        children2.add(new ExprNodeConstantDesc((Object)4));
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(RoundWithNumDigitsDoubleToDouble.class, ve.getClass());
        junit.framework.Assert.assertEquals((int)4, (int)((RoundWithNumDigitsDoubleToDouble)ve).getDecimalPlaces().get());
        gudfBridge = new GenericUDFBridge("log", false, UDFLog.class.getName());
        mathFuncExpr.setGenericUDF((GenericUDF)gudfBridge);
        children2.clear();
        children2.add(new ExprNodeConstantDesc((Object)4.0));
        children2.add(colDesc2);
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncLogWithBaseDoubleToDouble.class, ve.getClass());
        junit.framework.Assert.assertTrue((4.0 == ((FuncLogWithBaseDoubleToDouble)ve).getBase() ? 1 : 0) != 0);
        children2.clear();
        children2.add(colDesc2);
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncLnDoubleToDouble.class, ve.getClass());
        children2.clear();
        children2.add(new ExprNodeConstantDesc((Object)4.5));
        children2.add(colDesc2);
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncLogWithBaseDoubleToDouble.class, ve.getClass());
        junit.framework.Assert.assertTrue((4.5 == ((FuncLogWithBaseDoubleToDouble)ve).getBase() ? 1 : 0) != 0);
        children2.clear();
        children2.add(new ExprNodeConstantDesc((Object)4.5));
        children2.add(colDesc1);
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncLogWithBaseLongToDouble.class, ve.getClass());
        junit.framework.Assert.assertTrue((4.5 == ((FuncLogWithBaseLongToDouble)ve).getBase() ? 1 : 0) != 0);
        children2.clear();
        children2.add(colDesc2);
        children2.add(new ExprNodeConstantDesc((Object)4.5));
        mathFuncExpr.setGenericUDF((GenericUDF)new GenericUDFPower());
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncPowerDoubleToDouble.class, ve.getClass());
        junit.framework.Assert.assertTrue((4.5 == ((FuncPowerDoubleToDouble)ve).getPower() ? 1 : 0) != 0);
        mathFuncExpr.setGenericUDF((GenericUDF)udfRound);
        children2.clear();
        children2.add(colDesc2);
        mathFuncExpr.setChildren(children2);
        ve = vc.getVectorExpression((ExprNodeDesc)mathFuncExpr);
        junit.framework.Assert.assertEquals(FuncRoundDoubleToDouble.class, ve.getClass());
    }

    @Test
    public void testTimeStampUdfs() throws HiveException {
        ExprNodeGenericFuncDesc tsFuncExpr = new ExprNodeGenericFuncDesc();
        tsFuncExpr.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        ExprNodeColumnDesc colDesc1 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, "a", "table", false);
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>();
        children.add(colDesc1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("b", 0);
        columnMap.put("a", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        GenericUDFBridge gudfBridge = new GenericUDFBridge("year", false, UDFYear.class.getName());
        tsFuncExpr.setGenericUDF((GenericUDF)gudfBridge);
        tsFuncExpr.setChildren(children);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)tsFuncExpr);
        junit.framework.Assert.assertEquals(VectorUDFYearLong.class, ve.getClass());
        GenericUDFToUnixTimeStamp gudf = new GenericUDFToUnixTimeStamp();
        tsFuncExpr.setGenericUDF((GenericUDF)gudf);
        tsFuncExpr.setTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo);
        ve = vc.getVectorExpression((ExprNodeDesc)tsFuncExpr);
        junit.framework.Assert.assertEquals(VectorUDFUnixTimeStampLong.class, ve.getClass());
    }

    @Test
    public void testBetweenFilters() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(String.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)"Alpha");
        ExprNodeConstantDesc constDesc2 = new ExprNodeConstantDesc((Object)"Bravo");
        GenericUDFBetween udf = new GenericUDFBetween();
        ArrayList<Object> children1 = new ArrayList<Object>();
        children1.add(new ExprNodeConstantDesc((Object)new Boolean(false)));
        children1.add(col1Expr);
        children1.add(constDesc);
        children1.add(constDesc2);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)udf, children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterStringColumnBetween));
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(true)));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterStringColumnNotBetween));
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(false)));
        children1.set(1, new ExprNodeColumnDesc(Long.class, "col1", "table", false));
        children1.set(2, new ExprNodeConstantDesc((Object)10));
        children1.set(3, new ExprNodeConstantDesc((Object)20));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterLongColumnBetween));
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(true)));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterLongColumnNotBetween));
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(false)));
        children1.set(1, new ExprNodeColumnDesc(Double.class, "col1", "table", false));
        children1.set(2, new ExprNodeConstantDesc((Object)10.0));
        children1.set(3, new ExprNodeConstantDesc((Object)20.0));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterDoubleColumnBetween));
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(true)));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterDoubleColumnNotBetween));
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(false)));
        children1.set(1, new ExprNodeColumnDesc(Timestamp.class, "col1", "table", false));
        children1.set(2, new ExprNodeConstantDesc((Object)"2013-11-05 00:00:00.000"));
        children1.set(3, new ExprNodeConstantDesc((Object)"2013-11-06 00:00:00.000"));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(FilterStringColumnBetween.class, ve.getClass());
        children1.set(0, new ExprNodeConstantDesc((Object)new Boolean(true)));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertEquals(FilterStringColumnNotBetween.class, ve.getClass());
    }

    @Test
    public void testInFiltersAndExprs() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(String.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)"Alpha");
        ExprNodeConstantDesc constDesc2 = new ExprNodeConstantDesc((Object)"Bravo");
        GenericUDFIn udf = new GenericUDFIn();
        ArrayList<Object> children1 = new ArrayList<Object>();
        children1.add(col1Expr);
        children1.add(constDesc);
        children1.add(constDesc2);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)udf, children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        VectorizationContext vc = new VectorizationContext(columnMap, 2);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterStringColumnInList));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)(ve instanceof StringColumnInList));
        children1.set(0, new ExprNodeColumnDesc(Long.class, "col1", "table", false));
        children1.set(1, new ExprNodeConstantDesc((Object)10));
        children1.set(2, new ExprNodeConstantDesc((Object)20));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterLongColumnInList));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)(ve instanceof LongColumnInList));
        children1.set(0, new ExprNodeColumnDesc(Double.class, "col1", "table", false));
        children1.set(1, new ExprNodeConstantDesc((Object)10.0));
        children1.set(2, new ExprNodeConstantDesc((Object)20.0));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.FILTER);
        Assert.assertTrue((boolean)(ve instanceof FilterDoubleColumnInList));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        Assert.assertTrue((boolean)(ve instanceof DoubleColumnInList));
    }

    @Test
    public void testIfConditionalExprs() throws HiveException {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Long.class, "col1", "table", false);
        ExprNodeColumnDesc col2Expr = new ExprNodeColumnDesc(Long.class, "col2", "table", false);
        ExprNodeColumnDesc col3Expr = new ExprNodeColumnDesc(Long.class, "col3", "table", false);
        ExprNodeConstantDesc constDesc2 = new ExprNodeConstantDesc((Object)new Integer(1));
        ExprNodeConstantDesc constDesc3 = new ExprNodeConstantDesc((Object)new Integer(2));
        GenericUDFIf udf = new GenericUDFIf();
        ArrayList<Object> children1 = new ArrayList<Object>();
        children1.add(col1Expr);
        children1.add(col2Expr);
        children1.add(col3Expr);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)udf, children1);
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        columnMap.put("col2", 2);
        columnMap.put("col3", 3);
        VectorizationContext vc = new VectorizationContext(columnMap, 3);
        VectorExpression ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongColumnLongColumn));
        children1.set(2, new ExprNodeConstantDesc((Object)1L));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongColumnLongScalar));
        children1.set(1, new ExprNodeConstantDesc((Object)1L));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongScalarLongScalar));
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongScalarLongColumn));
        col2Expr = new ExprNodeColumnDesc(Double.class, "col2", "table", false);
        col3Expr = new ExprNodeColumnDesc(Double.class, "col3", "table", false);
        children1.set(1, col2Expr);
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprDoubleColumnDoubleColumn));
        children1.set(2, new ExprNodeConstantDesc((Object)1.0));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprDoubleColumnDoubleScalar));
        children1.set(1, new ExprNodeConstantDesc((Object)1.0));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprDoubleScalarDoubleScalar));
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprDoubleScalarDoubleColumn));
        children1.set(2, new ExprNodeColumnDesc(Long.class, "col3", "table", false));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprDoubleScalarLongColumn));
        col2Expr = new ExprNodeColumnDesc(Timestamp.class, "col2", "table", false);
        col3Expr = new ExprNodeColumnDesc(Timestamp.class, "col3", "table", false);
        children1.set(1, col2Expr);
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongColumnLongColumn));
        ExprNodeGenericFuncDesc f = new ExprNodeGenericFuncDesc();
        f.setGenericUDF((GenericUDF)new GenericUDFTimestamp());
        f.setTypeInfo((TypeInfo)TypeInfoFactory.timestampTypeInfo);
        ArrayList<ExprNodeConstantDesc> children2 = new ArrayList<ExprNodeConstantDesc>();
        f.setChildren(children2);
        children2.add(new ExprNodeConstantDesc((Object)"2013-11-05 00:00:00.000"));
        children1.set(2, f);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((IfExprLongColumnLongColumn.class == ve.getClass() || IfExprLongColumnLongScalar.class == ve.getClass() ? 1 : 0) != 0);
        children1.set(1, f);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((IfExprLongColumnLongColumn.class == ve.getClass() || IfExprLongScalarLongScalar.class == ve.getClass() ? 1 : 0) != 0);
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((IfExprLongColumnLongColumn.class == ve.getClass() || IfExprLongScalarLongColumn.class == ve.getClass() ? 1 : 0) != 0);
        col2Expr = new ExprNodeColumnDesc(Boolean.class, "col2", "table", false);
        col3Expr = new ExprNodeColumnDesc(Boolean.class, "col3", "table", false);
        children1.set(1, col2Expr);
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongColumnLongColumn));
        children1.set(2, new ExprNodeConstantDesc((Object)true));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongColumnLongScalar));
        children1.set(1, new ExprNodeConstantDesc((Object)true));
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongScalarLongScalar));
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprLongScalarLongColumn));
        constDesc2 = new ExprNodeConstantDesc((Object)"Alpha");
        constDesc3 = new ExprNodeConstantDesc((Object)"Bravo");
        col2Expr = new ExprNodeColumnDesc(String.class, "col2", "table", false);
        col3Expr = new ExprNodeColumnDesc(String.class, "col3", "table", false);
        children1.set(1, col2Expr);
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprStringColumnStringColumn));
        children1.set(2, constDesc3);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprStringColumnStringScalar));
        children1.set(1, constDesc2);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprStringScalarStringScalar));
        children1.set(2, col3Expr);
        ve = vc.getVectorExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(ve instanceof IfExprStringScalarStringColumn));
    }

    @Test
    public void testFoldConstantsForUnaryExpression() throws HiveException {
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)new Integer(1));
        GenericUDFToDecimal udf = new GenericUDFToDecimal();
        udf.setTypeInfo(new DecimalTypeInfo(5, 2));
        ArrayList<ExprNodeConstantDesc> children = new ArrayList<ExprNodeConstantDesc>();
        children.add(constDesc);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc();
        exprDesc.setGenericUDF((GenericUDF)udf);
        exprDesc.setChildren(children);
        exprDesc.setTypeInfo((TypeInfo)new DecimalTypeInfo(5, 2));
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        columnMap.put("col1", 1);
        VectorizationContext vc = new VectorizationContext(columnMap, 1);
        ExprNodeDesc constFoldNodeDesc = vc.foldConstantsForUnaryExpression((ExprNodeDesc)exprDesc);
        Assert.assertTrue((boolean)(constFoldNodeDesc instanceof ExprNodeConstantDesc));
        Assert.assertTrue((boolean)((HiveDecimal)((ExprNodeConstantDesc)constFoldNodeDesc).getValue()).toString().equals("1"));
    }
}

