/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.xml;

import javax.xml.xpath.XPathConstants;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestUDFXPathUtil {
    @Test
    public void testEvalIllegalArgs() {
        UDFXPathUtil util = new UDFXPathUtil();
        Assert.assertNull((Object)util.eval(null, "a/text()", XPathConstants.STRING));
        Assert.assertNull((Object)util.eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", null, XPathConstants.STRING));
        Assert.assertNull((Object)util.eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/text()", null));
        Assert.assertNull((Object)util.eval("", "a/text()", XPathConstants.STRING));
        Assert.assertNull((Object)util.eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "", XPathConstants.STRING));
        Assert.assertNull((Object)util.eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/text(", XPathConstants.STRING));
    }

    @Test
    public void testEvalPositive() {
        UDFXPathUtil util = new UDFXPathUtil();
        Object result = util.eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/c[2]/text()", XPathConstants.STRING);
        Assert.assertEquals((Object)"c2", (Object)result);
        result = util.evalBoolean("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[1]/text()");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        result = util.evalBoolean("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[4]");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        result = util.evalString("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[3]/text()");
        Assert.assertEquals((Object)"b3", (Object)result);
        result = util.evalString("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[4]/text()");
        Assert.assertEquals((Object)"", (Object)result);
        result = util.evalString("<a><b>true</b><b k=\"foo\">FALSE</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[2]/@k");
        Assert.assertEquals((Object)"foo", (Object)result);
        result = util.evalNumber("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>-77</c></a>", "a/c[2]");
        Assert.assertEquals((Object)-77.0, (Object)result);
        result = util.evalNumber("<a><b>true</b><b k=\"foo\">FALSE</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[2]/@k");
        Assert.assertEquals((Object)Double.NaN, (Object)result);
        result = util.evalNode("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>-77</c></a>", "a/c[2]");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Node));
        result = util.evalNodeList("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>-77</c></a>", "a/*");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof NodeList));
        Assert.assertEquals((long)5L, (long)((NodeList)result).getLength());
    }
}

