/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.nio.ByteBuffer;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OutStream;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.PositionRecorder;
import org.apache.hadoop.hive.ql.io.orc.PositionedOutputStream;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReaderV2;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerWriterV2;
import org.apache.hadoop.hive.ql.io.orc.TestInStream;
import org.apache.hadoop.hive.ql.io.orc.ZlibCodec;
import org.junit.Test;

public class TestIntegerCompressionReader {
    public void runSeekTest(CompressionCodec codec) throws Exception {
        int x;
        int i;
        int i2;
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthIntegerWriterV2 out = new RunLengthIntegerWriterV2((PositionedOutputStream)new OutStream("test", 1000, codec, (OutStream.OutputReceiver)collect), true);
        TestInStream.PositionCollector[] positions = new TestInStream.PositionCollector[4096];
        Random random = new Random(99L);
        int[] junk = new int[2048];
        for (i2 = 0; i2 < junk.length; ++i2) {
            junk[i2] = random.nextInt();
        }
        for (i2 = 0; i2 < 4096; ++i2) {
            positions[i2] = new TestInStream.PositionCollector();
            out.getPosition((PositionRecorder)positions[i2]);
            if (i2 < 1024) {
                out.write((long)(i2 / 4));
                continue;
            }
            if (i2 < 2048) {
                out.write((long)(2 * i2));
                continue;
            }
            out.write((long)junk[i2 - 2048]);
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthIntegerReaderV2 in = new RunLengthIntegerReaderV2(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), (CompressionCodec)codec, (int)1000), true, new Configuration());
        for (i = 0; i < 2048; ++i) {
            x = (int)in.next();
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4), (int)x);
                continue;
            }
            if (i < 2048) {
                Assert.assertEquals((int)(2 * i), (int)x);
                continue;
            }
            Assert.assertEquals((int)junk[i - 2048], (int)x);
        }
        for (i = 2047; i >= 0; --i) {
            in.seek((PositionProvider)positions[i]);
            x = (int)in.next();
            if (i < 1024) {
                Assert.assertEquals((int)(i / 4), (int)x);
                continue;
            }
            if (i < 2048) {
                Assert.assertEquals((int)(2 * i), (int)x);
                continue;
            }
            Assert.assertEquals((int)junk[i - 2048], (int)x);
        }
    }

    @Test
    public void testUncompressedSeek() throws Exception {
        this.runSeekTest(null);
    }

    @Test
    public void testCompressedSeek() throws Exception {
        this.runSeekTest((CompressionCodec)new ZlibCodec());
    }

    @Test
    public void testSkips() throws Exception {
        TestInStream.OutputCollector collect = new TestInStream.OutputCollector();
        RunLengthIntegerWriterV2 out = new RunLengthIntegerWriterV2((PositionedOutputStream)new OutStream("test", 100, null, (OutStream.OutputReceiver)collect), true);
        for (int i = 0; i < 2048; ++i) {
            if (i < 1024) {
                out.write((long)i);
                continue;
            }
            out.write((long)(256 * i));
        }
        out.flush();
        ByteBuffer inBuf = ByteBuffer.allocate(collect.buffer.size());
        collect.buffer.setByteBuffer(inBuf, 0, collect.buffer.size());
        inBuf.flip();
        RunLengthIntegerReaderV2 in = new RunLengthIntegerReaderV2(InStream.create((String)"test", (ByteBuffer[])new ByteBuffer[]{inBuf}, (long[])new long[]{0L}, (long)inBuf.remaining(), null, (int)100), true, new Configuration());
        for (int i = 0; i < 2048; i += 10) {
            int x = (int)in.next();
            if (i < 1024) {
                Assert.assertEquals((int)i, (int)x);
            } else {
                Assert.assertEquals((int)(256 * i), (int)x);
            }
            if (i < 2038) {
                in.skip(9L);
            }
            in.skip(0L);
        }
    }
}

