/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQBCompact {
    static HiveConf conf;

    @BeforeClass
    public static void init() throws Exception {
        conf = new HiveConf();
        SessionState.start((HiveConf)conf);
        Hive h = Hive.get((HiveConf)conf);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("a");
        ArrayList<String> partCols = new ArrayList<String>();
        partCols.add("ds");
        h.createTable("foo", cols, partCols, OrcInputFormat.class, OrcOutputFormat.class);
        Table t = h.getTable("foo");
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("ds", "today");
        h.createPartition(t, partSpec);
    }

    private AlterTableSimpleDesc parseAndAnalyze(String query) throws Exception {
        ParseDriver hd = new ParseDriver();
        ASTNode head = (ASTNode)hd.parse(query).getChild(0);
        System.out.println("HERE " + head.dump());
        BaseSemanticAnalyzer a = SemanticAnalyzerFactory.get((HiveConf)conf, (ASTNode)head);
        a.analyze(head, new Context((Configuration)conf));
        List roots = a.getRootTasks();
        Assert.assertEquals((int)1, (int)roots.size());
        return ((DDLWork)((Task)roots.get(0)).getWork()).getAlterTblSimpleDesc();
    }

    @Test
    public void testNonPartitionedTable() throws Exception {
        boolean sawException = false;
        AlterTableSimpleDesc desc = this.parseAndAnalyze("alter table foo compact 'major'");
        Assert.assertEquals((String)"major", (String)desc.getCompactionType());
        Assert.assertEquals((String)"foo", (String)desc.getTableName());
        Assert.assertEquals((String)"default", (String)desc.getDbName());
    }

    @Test
    public void testBogusLevel() throws Exception {
        boolean sawException = false;
        try {
            this.parseAndAnalyze("alter table foo partition(ds = 'today') compact 'bogus'");
        }
        catch (SemanticException e) {
            sawException = true;
            Assert.assertEquals((String)ErrorMsg.INVALID_COMPACTION_TYPE.getMsg(), (String)e.getMessage());
        }
        Assert.assertTrue((boolean)sawException);
    }

    @Test
    public void testMajor() throws Exception {
        AlterTableSimpleDesc desc = this.parseAndAnalyze("alter table foo partition(ds = 'today') compact 'major'");
        Assert.assertEquals((String)"major", (String)desc.getCompactionType());
        Assert.assertEquals((String)"foo", (String)desc.getTableName());
        Assert.assertEquals((String)"default", (String)desc.getDbName());
        LinkedHashMap parts = desc.getPartSpec();
        Assert.assertEquals((int)1, (int)parts.size());
        Assert.assertEquals((String)"today", (String)((String)((HashMap)parts).get("ds")));
    }

    @Test
    public void testMinor() throws Exception {
        AlterTableSimpleDesc desc = this.parseAndAnalyze("alter table foo partition(ds = 'today') compact 'minor'");
        Assert.assertEquals((String)"minor", (String)desc.getCompactionType());
        Assert.assertEquals((String)"foo", (String)desc.getTableName());
        Assert.assertEquals((String)"default", (String)desc.getDbName());
        LinkedHashMap parts = desc.getPartSpec();
        Assert.assertEquals((int)1, (int)parts.size());
        Assert.assertEquals((String)"today", (String)((String)((HashMap)parts).get("ds")));
    }

    @Test
    public void showCompactions() throws Exception {
        this.parseAndAnalyze("show compactions");
    }

    @Test
    public void showTxns() throws Exception {
        this.parseAndAnalyze("show transactions");
    }
}

