/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.EnumSet;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProviderBase;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public class StorageBasedAuthorizationProvider
extends HiveAuthorizationProviderBase
implements HiveMetastoreAuthorizationProvider {
    private Warehouse wh;
    private boolean isRunFromMetaStore = false;

    private void initWh() throws MetaException, HiveException {
        if (this.wh == null) {
            if (!this.isRunFromMetaStore) {
                this.hive_db = new HiveAuthorizationProviderBase.HiveProxy(Hive.get(new HiveConf(this.getConf(), StorageBasedAuthorizationProvider.class)));
                this.wh = new Warehouse(this.getConf());
                if (this.wh == null) {
                    throw new IllegalStateException("Unable to initialize Warehouse from clientside.");
                }
            } else {
                throw new IllegalStateException("Uninitialized Warehouse from MetastoreHandler");
            }
        }
    }

    @Override
    public void init(Configuration conf) throws HiveException {
        this.hive_db = new HiveAuthorizationProviderBase.HiveProxy();
    }

    @Override
    public void authorize(Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        throw new AuthorizationException(StorageBasedAuthorizationProvider.class.getName() + " does not allow user-level authorization");
    }

    @Override
    public void authorize(Database db, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        Path path = this.getDbLocation(db);
        this.authorize(path, readRequiredPriv, writeRequiredPriv);
    }

    @Override
    public void authorize(Table table, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        Path path = null;
        try {
            this.initWh();
            String location = table.getTTable().getSd().getLocation();
            path = location == null || location.isEmpty() ? this.wh.getTablePath(this.hive_db.getDatabase(table.getDbName()), table.getTableName()) : new Path(location);
        }
        catch (MetaException ex) {
            throw this.hiveException((Exception)((Object)ex));
        }
        this.authorize(path, readRequiredPriv, writeRequiredPriv);
    }

    @Override
    public void authorize(Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.authorize(part.getTable(), part, readRequiredPriv, writeRequiredPriv);
    }

    private void authorize(Table table, Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        if (part == null || part.getLocation() == null) {
            this.authorize(table, readRequiredPriv, writeRequiredPriv);
        } else {
            this.authorize(part.getPartitionPath(), readRequiredPriv, writeRequiredPriv);
        }
    }

    @Override
    public void authorize(Table table, Partition part, List<String> columns, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        if (part != null && part.getTable() != null) {
            this.authorize(part.getTable(), part, readRequiredPriv, writeRequiredPriv);
        } else {
            this.authorize(table, part, readRequiredPriv, writeRequiredPriv);
        }
    }

    @Override
    public void setMetaStoreHandler(HiveMetaStore.HMSHandler handler) {
        this.hive_db.setHandler(handler);
        this.wh = handler.getWh();
        this.isRunFromMetaStore = true;
    }

    protected FsAction getFsAction(Privilege priv) {
        switch (priv.getPriv()) {
            case ALL: {
                return FsAction.READ_WRITE;
            }
            case ALTER_DATA: {
                return FsAction.WRITE;
            }
            case ALTER_METADATA: {
                return FsAction.WRITE;
            }
            case CREATE: {
                return FsAction.WRITE;
            }
            case DROP: {
                return FsAction.WRITE;
            }
            case INDEX: {
                throw new AuthorizationException("StorageBasedAuthorizationProvider cannot handle INDEX privilege");
            }
            case LOCK: {
                throw new AuthorizationException("StorageBasedAuthorizationProvider cannot handle LOCK privilege");
            }
            case SELECT: {
                return FsAction.READ;
            }
            case SHOW_DATABASE: {
                return FsAction.READ;
            }
        }
        throw new AuthorizationException("Unknown privilege");
    }

    protected EnumSet<FsAction> getFsActions(Privilege[] privs) {
        EnumSet<FsAction> actions = EnumSet.noneOf(FsAction.class);
        if (privs == null) {
            return actions;
        }
        for (Privilege priv : privs) {
            actions.add(this.getFsAction(priv));
        }
        return actions;
    }

    public void authorize(Path path, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        try {
            EnumSet<FsAction> actions = this.getFsActions(readRequiredPriv);
            actions.addAll(this.getFsActions(writeRequiredPriv));
            if (actions.isEmpty()) {
                return;
            }
            this.checkPermissions(this.getConf(), path, actions);
        }
        catch (AccessControlException ex) {
            throw this.authorizationException(ex);
        }
        catch (LoginException ex) {
            throw this.authorizationException(ex);
        }
        catch (IOException ex) {
            throw this.hiveException(ex);
        }
    }

    protected void checkPermissions(Configuration conf, Path path, EnumSet<FsAction> actions) throws IOException, LoginException {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path)) {
            StorageBasedAuthorizationProvider.checkPermissions(fs, path, actions, this.authenticator.getUserName(), this.authenticator.getGroupNames());
        } else if (path.getParent() != null) {
            Path par;
            for (par = path.getParent(); par != null && !fs.exists(par); par = par.getParent()) {
            }
            StorageBasedAuthorizationProvider.checkPermissions(fs, par, actions, this.authenticator.getUserName(), this.authenticator.getGroupNames());
        }
    }

    protected static void checkPermissions(FileSystem fs, Path path, EnumSet<FsAction> actions, String user, List<String> groups) throws IOException, AccessControlException {
        FileStatus stat;
        try {
            stat = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        catch (org.apache.hadoop.fs.permission.AccessControlException ace) {
            throw StorageBasedAuthorizationProvider.accessControlException(ace);
        }
        FsPermission dirPerms = stat.getPermission();
        String grp = stat.getGroup();
        for (FsAction action : actions) {
            if (user.equals(stat.getOwner()) && dirPerms.getUserAction().implies(action) || groups.contains(grp) && dirPerms.getGroupAction().implies(action) || dirPerms.getOtherAction().implies(action)) continue;
            throw new AccessControlException("action " + action + " not permitted on path " + path + " for user " + user);
        }
    }

    protected Path getDbLocation(Database db) throws HiveException {
        try {
            this.initWh();
            String location = db.getLocationUri();
            if (location == null) {
                return this.wh.getDefaultDatabasePath(db.getName());
            }
            return this.wh.getDnsPath(this.wh.getDatabasePath(db));
        }
        catch (MetaException ex) {
            throw this.hiveException((Exception)((Object)ex));
        }
    }

    private HiveException hiveException(Exception e) {
        return new HiveException(e);
    }

    private AuthorizationException authorizationException(Exception e) {
        return new AuthorizationException(e);
    }

    private static AccessControlException accessControlException(org.apache.hadoop.fs.permission.AccessControlException e) {
        AccessControlException ace = new AccessControlException(e.getMessage());
        ace.initCause(e);
        return ace;
    }
}

