/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.DfsProcessor;
import org.apache.hadoop.hive.ql.processors.HiveCommand;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class CommandProcessorFactory {
    private static final Map<HiveConf, Driver> mapDrivers = Collections.synchronizedMap(new HashMap());

    private CommandProcessorFactory() {
    }

    public static CommandProcessor get(String cmd) throws SQLException {
        return CommandProcessorFactory.get(cmd, null);
    }

    public static CommandProcessor getForHiveCommand(String cmd, HiveConf conf) throws SQLException {
        HiveCommand hiveCommand = HiveCommand.find(cmd);
        if (hiveCommand == null || StringUtils.isBlank(cmd)) {
            return null;
        }
        if (conf == null) {
            conf = new HiveConf();
        }
        HashSet<String> availableCommands = new HashSet<String>();
        for (String availableCommand : conf.getVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST).split(",")) {
            availableCommands.add(availableCommand.toLowerCase().trim());
        }
        if (!availableCommands.contains(cmd.trim().toLowerCase())) {
            throw new SQLException("Insufficient privileges to execute " + cmd, "42000");
        }
        switch (hiveCommand) {
            case SET: {
                return new SetProcessor();
            }
            case RESET: {
                return new ResetProcessor();
            }
            case DFS: {
                SessionState ss = SessionState.get();
                return new DfsProcessor(ss.getConf());
            }
            case ADD: {
                return new AddResourceProcessor();
            }
            case DELETE: {
                return new DeleteResourceProcessor();
            }
        }
        throw new AssertionError((Object)("Unknown HiveCommand " + (Object)((Object)hiveCommand)));
    }

    public static CommandProcessor get(String cmd, HiveConf conf) throws SQLException {
        CommandProcessor result = CommandProcessorFactory.getForHiveCommand(cmd, conf);
        if (result != null) {
            return result;
        }
        if (StringUtils.isBlank(cmd)) {
            return null;
        }
        if (conf == null) {
            return new Driver();
        }
        Driver drv = mapDrivers.get((Object)conf);
        if (drv == null) {
            drv = new Driver();
            mapDrivers.put(conf, drv);
        }
        drv.init();
        return drv;
    }

    public static void clean(HiveConf conf) {
        Driver drv = mapDrivers.get((Object)conf);
        if (drv != null) {
            drv.destroy();
        }
        mapDrivers.remove((Object)conf);
    }
}

