/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.stats;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class PartialScanMapper
extends MapReduceBase
implements Mapper<Object, RCFileValueBufferWrapper, Object, Object> {
    private JobConf jc;
    private String statsAggKeyPrefix;
    private long uncompressedFileSize = 0L;
    private long rowNo = 0L;
    private boolean exception = false;
    public static final Log LOG = LogFactory.getLog((String)"PartialScanMapper");

    public void configure(JobConf job) {
        this.jc = job;
        this.statsAggKeyPrefix = HiveConf.getVar((Configuration)job, HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX);
    }

    public void map(Object k, RCFileValueBufferWrapper value, OutputCollector<Object, Object> output, Reporter reporter) throws IOException {
        try {
            int i;
            RCFileKeyBufferWrapper key = (RCFileKeyBufferWrapper)((CombineHiveKey)k).getKey();
            RCFile.KeyBuffer keyBuffer = key.getKeyBuffer();
            long[] uncompressedColumnSizes = new long[keyBuffer.getColumnNumber()];
            for (i = 0; i < keyBuffer.getColumnNumber(); ++i) {
                int n = i;
                uncompressedColumnSizes[n] = uncompressedColumnSizes[n] + (long)keyBuffer.getEachColumnUncompressedValueLen()[i];
            }
            if (uncompressedColumnSizes != null) {
                for (i = 0; i < uncompressedColumnSizes.length; ++i) {
                    this.uncompressedFileSize += uncompressedColumnSizes[i];
                }
            }
            this.rowNo += (long)keyBuffer.getNumberRows();
        }
        catch (Throwable e) {
            this.exception = true;
            this.close();
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        try {
            if (!this.exception) {
                this.publishStats();
            }
        }
        catch (HiveException e) {
            this.exception = true;
            throw new RuntimeException(e);
        }
    }

    private void publishStats() throws HiveException {
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (statsPublisher == null) {
            LOG.error((Object)"StatsPublishing error: StatsPublisher is not initialized.");
            throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
        }
        if (!statsPublisher.connect((Configuration)this.jc)) {
            LOG.error((Object)"StatsPublishing error: cannot connect to database");
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId((Configuration)this.jc));
        String keyPrefix = Utilities.getHashedStatsPrefix(this.statsAggKeyPrefix, HiveConf.getIntVar((Configuration)this.jc, HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX_MAX_LENGTH));
        String key = keyPrefix + taskID;
        HashMap<String, String> statsToPublish = new HashMap<String, String>();
        statsToPublish.put("rawDataSize", Long.toString(this.uncompressedFileSize));
        statsToPublish.put("numRows", Long.toString(this.rowNo));
        if (!statsPublisher.publishStat(key, statsToPublish)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        if (!statsPublisher.closeConnection()) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }
}

