/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeWizard;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.Optimizer;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.MapReduceCompiler;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.parse.TableAccessAnalyzer;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingComponentizer;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.ExtractDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.ForwardDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewForwardDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputFormat;

public class SemanticAnalyzer
extends BaseSemanticAnalyzer {
    private HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner;
    private HashMap<TableScanOperator, PrunedPartitionList> opToPartList;
    private HashMap<String, Operator<? extends OperatorDesc>> topOps;
    private HashMap<String, Operator<? extends OperatorDesc>> topSelOps;
    private LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext> opParseCtx;
    private List<LoadTableDesc> loadTableWork;
    private List<LoadFileDesc> loadFileWork;
    private Map<JoinOperator, QBJoinTree> joinContext;
    private Map<SMBMapJoinOperator, QBJoinTree> smbMapJoinContext;
    private final HashMap<TableScanOperator, Table> topToTable;
    private final Map<FileSinkOperator, Table> fsopToTable;
    private final List<ReduceSinkOperator> reduceSinkOperatorsAddedByEnforceBucketingSorting;
    private final HashMap<TableScanOperator, Map<String, String>> topToTableProps;
    private QB qb;
    private ASTNode ast;
    private int destTableId = 1;
    private UnionProcContext uCtx = null;
    List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoReducer;
    private HashMap<TableScanOperator, FilterDesc.sampleDesc> opToSamplePruner;
    private final Map<TableScanOperator, Map<String, ExprNodeDesc>> opToPartToSkewedPruner;
    private final HashMap<String, SplitSample> nameToSplitSample;
    Map<GroupByOperator, Set<String>> groupOpToInputTables;
    Map<String, PrunedPartitionList> prunedPartitions;
    private List<FieldSchema> resultSchema;
    private CreateViewDesc createVwDesc;
    private ArrayList<String> viewsExpanded;
    private ASTNode viewSelect;
    private final UnparseTranslator unparseTranslator;
    private final GlobalLimitCtx globalLimitCtx = new GlobalLimitCtx();
    private final String autogenColAliasPrfxLbl;
    private final boolean autogenColAliasPrfxIncludeFuncName;
    private final Map<String, ReadEntity> viewAliasToInput = new HashMap<String, ReadEntity>();
    private static final int AUTOGEN_COLALIAS_PRFX_MAXLENGTH = 20;
    protected boolean noscan = false;
    protected boolean partialscan = false;
    private boolean isInsertQueryForOptimize = false;
    private String destClauseForInsertOptimizer;

    public SemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
        this.opToPartPruner = new HashMap();
        this.opToPartList = new HashMap();
        this.opToSamplePruner = new HashMap();
        this.nameToSplitSample = new HashMap();
        this.topOps = new HashMap();
        this.topSelOps = new HashMap();
        this.loadTableWork = new ArrayList<LoadTableDesc>();
        this.loadFileWork = new ArrayList<LoadFileDesc>();
        this.opParseCtx = new LinkedHashMap();
        this.joinContext = new HashMap<JoinOperator, QBJoinTree>();
        this.smbMapJoinContext = new HashMap<SMBMapJoinOperator, QBJoinTree>();
        this.topToTable = new HashMap();
        this.fsopToTable = new HashMap<FileSinkOperator, Table>();
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting = new ArrayList<ReduceSinkOperator>();
        this.topToTableProps = new HashMap();
        this.listMapJoinOpsNoReducer = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        this.groupOpToInputTables = new HashMap<GroupByOperator, Set<String>>();
        this.prunedPartitions = new HashMap<String, PrunedPartitionList>();
        this.unparseTranslator = new UnparseTranslator();
        this.autogenColAliasPrfxLbl = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_LABEL);
        this.autogenColAliasPrfxIncludeFuncName = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_INCLUDEFUNCNAME);
        this.queryProperties = new QueryProperties();
        this.opToPartToSkewedPruner = new HashMap<TableScanOperator, Map<String, ExprNodeDesc>>();
    }

    @Override
    protected void reset() {
        super.reset();
        this.loadTableWork.clear();
        this.loadFileWork.clear();
        this.topOps.clear();
        this.topSelOps.clear();
        this.destTableId = 1;
        this.idToTableNameMap.clear();
        this.qb = null;
        this.ast = null;
        this.uCtx = null;
        this.joinContext.clear();
        this.smbMapJoinContext.clear();
        this.opParseCtx.clear();
        this.groupOpToInputTables.clear();
        this.prunedPartitions.clear();
    }

    public void initParseCtx(ParseContext pctx) {
        this.opToPartPruner = pctx.getOpToPartPruner();
        this.opToPartList = pctx.getOpToPartList();
        this.opToSamplePruner = pctx.getOpToSamplePruner();
        this.topOps = pctx.getTopOps();
        this.topSelOps = pctx.getTopSelOps();
        this.opParseCtx = pctx.getOpParseCtx();
        this.loadTableWork = pctx.getLoadTableWork();
        this.loadFileWork = pctx.getLoadFileWork();
        this.joinContext = pctx.getJoinContext();
        this.smbMapJoinContext = pctx.getSmbMapJoinContext();
        this.ctx = pctx.getContext();
        this.destTableId = pctx.getDestTableId();
        this.idToTableNameMap = pctx.getIdToTableNameMap();
        this.uCtx = pctx.getUCtx();
        this.listMapJoinOpsNoReducer = pctx.getListMapJoinOpsNoReducer();
        this.qb = pctx.getQB();
        this.groupOpToInputTables = pctx.getGroupOpToInputTables();
        this.prunedPartitions = pctx.getPrunedPartitions();
        this.fetchTask = pctx.getFetchTask();
        this.setLineageInfo(pctx.getLineageInfo());
    }

    public ParseContext getParseContext() {
        return new ParseContext(this.conf, this.qb, this.ast, this.opToPartPruner, this.opToPartList, this.topOps, this.topSelOps, this.opParseCtx, this.joinContext, this.smbMapJoinContext, this.topToTable, this.topToTableProps, this.fsopToTable, this.loadTableWork, this.loadFileWork, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.groupOpToInputTables, this.prunedPartitions, this.opToSamplePruner, this.globalLimitCtx, this.nameToSplitSample, this.inputs, this.rootTasks, this.opToPartToSkewedPruner, this.viewAliasToInput, this.reduceSinkOperatorsAddedByEnforceBucketingSorting, this.queryProperties);
    }

    public void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias) throws SemanticException {
        assert (ast.getToken() != null);
        switch (ast.getToken().getType()) {
            case 727: {
                QB qb = new QB(id, alias, true);
                Phase1Ctx ctx_1 = this.initPhase1Ctx();
                this.doPhase1(ast, qb, ctx_1);
                qbexpr.setOpcode(QBExpr.Opcode.NULLOP);
                qbexpr.setQB(qb);
                break;
            }
            case 812: {
                qbexpr.setOpcode(QBExpr.Opcode.UNION);
                assert (ast.getChild(0) != null);
                QBExpr qbexpr1 = new QBExpr(alias + "-subquery1");
                this.doPhase1QBExpr((ASTNode)ast.getChild(0), qbexpr1, id + "-subquery1", alias + "-subquery1");
                qbexpr.setQBExpr1(qbexpr1);
                assert (ast.getChild(0) != null);
                QBExpr qbexpr2 = new QBExpr(alias + "-subquery2");
                this.doPhase1QBExpr((ASTNode)ast.getChild(1), qbexpr2, id + "-subquery2", alias + "-subquery2");
                qbexpr.setQBExpr2(qbexpr2);
            }
        }
    }

    private LinkedHashMap<String, ASTNode> doPhase1GetAggregationsFromSelect(ASTNode selExpr, QB qb, String dest) throws SemanticException {
        LinkedHashMap<String, ASTNode> aggregationTrees = new LinkedHashMap<String, ASTNode>();
        ArrayList<ASTNode> wdwFns = new ArrayList<ASTNode>();
        for (int i = 0; i < selExpr.getChildCount(); ++i) {
            ASTNode function = (ASTNode)selExpr.getChild(i).getChild(0);
            this.doPhase1GetAllAggregations(function, aggregationTrees, wdwFns);
        }
        for (ASTNode wdwFn : wdwFns) {
            WindowingSpec spec = qb.getWindowingSpec(dest);
            if (spec == null) {
                this.queryProperties.setHasWindowing(true);
                spec = new WindowingSpec();
                qb.addDestToWindowingSpec(dest, spec);
            }
            HashMap<String, ASTNode> wExprsInDest = qb.getParseInfo().getWindowingExprsForClause(dest);
            int wColIdx = spec.getWindowExpressions() == null ? 0 : spec.getWindowExpressions().size();
            WindowingSpec.WindowFunctionSpec wFnSpec = this.processWindowFunction(wdwFn, (ASTNode)wdwFn.getChild(wdwFn.getChildCount() - 1));
            if (wExprsInDest != null && wExprsInDest.containsKey(wFnSpec.getExpression().toStringTree())) continue;
            wFnSpec.setAlias("_wcol" + wColIdx++);
            spec.addWindowFunction(wFnSpec);
            qb.getParseInfo().addWindowingExprToClause(dest, wFnSpec.getExpression());
        }
        return aggregationTrees;
    }

    private void doPhase1GetColumnAliasesFromSelect(ASTNode selectExpr, QBParseInfo qbp) {
        for (int i = 0; i < selectExpr.getChildCount(); ++i) {
            ASTNode selExpr = (ASTNode)selectExpr.getChild(i);
            if (selExpr.getToken().getType() != 740 || selExpr.getChildCount() != 2) continue;
            String columnAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText());
            qbp.setExprToColumnAlias((ASTNode)selExpr.getChild(0), columnAlias);
        }
    }

    private void doPhase1GetAllAggregations(ASTNode expressionTree, HashMap<String, ASTNode> aggregations, List<ASTNode> wdwFns) throws SemanticException {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 639 || exprTokenType == 640 || exprTokenType == 641) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(expressionTree.getChildCount() - 1).getType() == 824) {
                wdwFns.add(expressionTree);
                return;
            }
            if (expressionTree.getChild(0).getType() == 26) {
                String functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if (FunctionRegistry.impliesOrder(functionName)) {
                    throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                }
                if (FunctionRegistry.getGenericUDAFResolver(functionName) != null) {
                    if (this.containsLeadLagUDF(expressionTree)) {
                        throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                    }
                    aggregations.put(expressionTree.toStringTree(), expressionTree);
                    FunctionInfo fi = FunctionRegistry.getFunctionInfo(functionName);
                    if (!fi.isNative()) {
                        this.unparseTranslator.addIdentifierTranslation((ASTNode)expressionTree.getChild(0));
                    }
                    return;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            this.doPhase1GetAllAggregations((ASTNode)expressionTree.getChild(i), aggregations, wdwFns);
        }
    }

    private List<ASTNode> doPhase1GetDistinctFuncExprs(HashMap<String, ASTNode> aggregationTrees) throws SemanticException {
        ArrayList<ASTNode> exprs = new ArrayList<ASTNode>();
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            assert (value != null);
            if (value.getToken().getType() != 640) continue;
            exprs.add(value);
        }
        return exprs;
    }

    public static String generateErrorMessage(ASTNode ast, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(ast.getLine());
        sb.append(":");
        sb.append(ast.getCharPositionInLine());
        sb.append(" ");
        sb.append(message);
        sb.append(". Error encountered near token '");
        sb.append(ErrorMsg.getText(ast));
        sb.append("'");
        return sb.toString();
    }

    private String processTable(QB qb, ASTNode tabref) throws SemanticException {
        ASTNode sampleClause;
        int aliasIndex = 0;
        int propsIndex = -1;
        int tsampleIndex = -1;
        int ssampleIndex = -1;
        for (int index = 1; index < tabref.getChildCount(); ++index) {
            ASTNode ct = (ASTNode)tabref.getChild(index);
            if (ct.getToken().getType() == 778) {
                tsampleIndex = index;
                continue;
            }
            if (ct.getToken().getType() == 793) {
                ssampleIndex = index;
                continue;
            }
            if (ct.getToken().getType() == 783) {
                propsIndex = index;
                continue;
            }
            aliasIndex = index;
        }
        ASTNode tableTree = (ASTNode)tabref.getChild(0);
        String tabIdName = SemanticAnalyzer.getUnescapedName(tableTree);
        String alias = aliasIndex != 0 ? SemanticAnalyzer.unescapeIdentifier(tabref.getChild(aliasIndex).getText()) : SemanticAnalyzer.getUnescapedUnqualifiedTableName(tableTree);
        if (propsIndex >= 0) {
            Tree propsAST = tabref.getChild(propsIndex);
            HashMap<String, String> props = DDLSemanticAnalyzer.getProps((ASTNode)propsAST.getChild(0));
            qb.setTabProps(alias, props);
        }
        if (qb.exists(alias)) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(tabref.getChild(aliasIndex)));
        }
        if (tsampleIndex >= 0) {
            sampleClause = (ASTNode)tabref.getChild(tsampleIndex);
            ArrayList<ASTNode> sampleCols = new ArrayList<ASTNode>();
            if (sampleClause.getChildCount() > 2) {
                for (int i = 2; i < sampleClause.getChildCount(); ++i) {
                    sampleCols.add((ASTNode)sampleClause.getChild(i));
                }
            }
            if (sampleCols.size() > 2) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)tabref.getChild(0), ErrorMsg.SAMPLE_RESTRICTION.getMsg()));
            }
            qb.getParseInfo().setTabSample(alias, new TableSample(SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(0).getText()), SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(1).getText()), sampleCols));
            if (this.unparseTranslator.isEnabled()) {
                for (ASTNode sampleCol : sampleCols) {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)sampleCol.getChild(0));
                }
            }
        } else if (ssampleIndex >= 0) {
            SplitSample sample;
            sampleClause = (ASTNode)tabref.getChild(ssampleIndex);
            Tree type = sampleClause.getChild(0);
            Tree numerator = sampleClause.getChild(1);
            String value = SemanticAnalyzer.unescapeIdentifier(numerator.getText());
            if (type.getType() == 711) {
                this.assertCombineInputFormat(numerator, "Percentage");
                Double percent = (double)Double.valueOf(value);
                if (percent < 0.0 || percent > 100.0) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)numerator, "Sampling percentage should be between 0 and 100"));
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVESAMPLERANDOMNUM);
                sample = new SplitSample(percent, seedNum);
            } else if (type.getType() == 737) {
                sample = new SplitSample(Integer.valueOf(value));
            } else {
                assert (type.getType() == 671);
                this.assertCombineInputFormat(numerator, "Total Length");
                long length = Integer.valueOf(value.substring(0, value.length() - 1)).intValue();
                char last = value.charAt(value.length() - 1);
                if (last == 'k' || last == 'K') {
                    length <<= 10;
                } else if (last == 'm' || last == 'M') {
                    length <<= 20;
                } else if (last == 'g' || last == 'G') {
                    length <<= 30;
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVESAMPLERANDOMNUM);
                sample = new SplitSample(length, seedNum);
            }
            String alias_id = this.getAliasId(alias, qb);
            this.nameToSplitSample.put(alias_id, sample);
        }
        qb.setTabAlias(alias, tabIdName);
        qb.addAlias(alias);
        qb.getParseInfo().setSrcForAlias(alias, tableTree);
        this.unparseTranslator.addTableNameTranslation(tableTree, SessionState.get().getCurrentDatabase());
        if (aliasIndex != 0) {
            this.unparseTranslator.addIdentifierTranslation((ASTNode)tabref.getChild(aliasIndex));
        }
        return alias;
    }

    private void assertCombineInputFormat(Tree numerator, String message) throws SemanticException {
        String inputFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEINPUTFORMAT);
        if (!inputFormat.equals(CombineHiveInputFormat.class.getName())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)numerator, message + " sampling is not supported in " + inputFormat));
        }
    }

    private String processSubQuery(QB qb, ASTNode subq) throws SemanticException {
        if (subq.getChildCount() != 2) {
            throw new SemanticException(ErrorMsg.NO_SUBQUERY_ALIAS.getMsg(subq));
        }
        ASTNode subqref = (ASTNode)subq.getChild(0);
        String alias = SemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
        QBExpr qbexpr = new QBExpr(alias);
        this.doPhase1QBExpr(subqref, qbexpr, qb.getId(), alias);
        if (qb.exists(alias)) {
            throw new SemanticException(ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(subq.getChild(1)));
        }
        qb.setSubqAlias(alias, qbexpr);
        qb.addAlias(alias);
        this.unparseTranslator.addIdentifierTranslation((ASTNode)subq.getChild(1));
        return alias;
    }

    private boolean isJoinToken(ASTNode node) {
        return node.getToken().getType() == 666 || node.getToken().getType() == 601 || node.getToken().getType() == 669 || node.getToken().getType() == 734 || node.getToken().getType() == 638 || node.getToken().getType() == 670 || node.getToken().getType() == 814;
    }

    private void processJoin(QB qb, ASTNode join) throws SemanticException {
        int numChildren = join.getChildCount();
        if (numChildren != 2 && numChildren != 3 && join.getToken().getType() != 814) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(join, "Join with multiple children"));
        }
        for (int num = 0; num < numChildren; ++num) {
            ASTNode child = (ASTNode)join.getChild(num);
            if (child.getToken().getType() == 797) {
                this.processTable(qb, child);
                continue;
            }
            if (child.getToken().getType() == 767) {
                this.processSubQuery(qb, child);
                continue;
            }
            if (child.getToken().getType() == 726) {
                String inputAlias;
                this.queryProperties.setHasPTF(true);
                this.processPTF(qb, child);
                PTFInvocationSpec ptfInvocationSpec = qb.getPTFInvocationSpec(child);
                String string = inputAlias = ptfInvocationSpec == null ? null : ptfInvocationSpec.getFunction().getAlias();
                if (inputAlias != null) continue;
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(child, "PTF invocation in a Join must have an alias"));
            }
            if (child.getToken().getType() == 667 || child.getToken().getType() == 668) {
                throw new SemanticException(ErrorMsg.LATERAL_VIEW_WITH_JOIN.getMsg(join));
            }
            if (!this.isJoinToken(child)) continue;
            this.processJoin(qb, child);
        }
    }

    private String processLateralView(QB qb, ASTNode lateralView) throws SemanticException {
        int numChildren = lateralView.getChildCount();
        assert (numChildren == 2);
        ASTNode next = (ASTNode)lateralView.getChild(1);
        String alias = null;
        switch (next.getToken().getType()) {
            case 797: {
                alias = this.processTable(qb, next);
                break;
            }
            case 767: {
                alias = this.processSubQuery(qb, next);
                break;
            }
            case 667: 
            case 668: {
                alias = this.processLateralView(qb, next);
                break;
            }
            default: {
                throw new SemanticException(ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(lateralView));
            }
        }
        alias = alias.toLowerCase();
        qb.getParseInfo().addLateralViewForAlias(alias, lateralView);
        qb.addAlias(alias);
        return alias;
    }

    private boolean hasInsertOptimizeTokens(ASTNode dest) {
        int destTokenType = dest.getToken().getType();
        return destTokenType == 616 && ((ASTNode)dest.getChild(0)).getToken().getType() != 808 && ((ASTNode)dest.getChild(0)).getToken().getType() != 676 || destTokenType == 769;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doPhase1(ASTNode ast, QB qb, Phase1Ctx ctx_1) throws SemanticException {
        boolean phase1Result = true;
        QBParseInfo qbp = qb.getParseInfo();
        boolean skipRecursion = false;
        if (ast.getToken() != null) {
            skipRecursion = true;
            switch (ast.getToken().getType()) {
                case 739: {
                    qb.countSelDi();
                }
                case 738: {
                    qb.countSel();
                    qbp.setSelExprForClause(ctx_1.dest, ast);
                    if (((ASTNode)ast.getChild(0)).getToken().getType() == 652) {
                        qbp.setHints((ASTNode)ast.getChild(0));
                    }
                    LinkedHashMap<String, ASTNode> aggregations = this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest);
                    this.doPhase1GetColumnAliasesFromSelect(ast, qbp);
                    qbp.setAggregationExprsForClause(ctx_1.dest, aggregations);
                    qbp.setDistinctFuncExprsForClause(ctx_1.dest, this.doPhase1GetDistinctFuncExprs(aggregations));
                    break;
                }
                case 821: {
                    qbp.setWhrExprForClause(ctx_1.dest, ast);
                    break;
                }
                case 662: {
                    String currentDatabase = SessionState.get().getCurrentDatabase();
                    String tab_name = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), currentDatabase);
                    qbp.addInsertIntoTable(tab_name);
                }
                case 615: {
                    ASTNode ch;
                    ctx_1.dest = "insclause-" + ctx_1.nextNum;
                    ++ctx_1.nextNum;
                    if (qbp.getIsSubQ() && ((ch = (ASTNode)ast.getChild(0)).getToken().getType() != 616 || ((ASTNode)ch.getChild(0)).getToken().getType() != 808)) {
                        throw new SemanticException(ErrorMsg.NO_INSERT_INSUBQUERY.getMsg(ast));
                    }
                    qbp.setDestForClause(ctx_1.dest, (ASTNode)ast.getChild(0));
                    if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_INSERT_DEST_VOLUME) || !this.hasInsertOptimizeTokens((ASTNode)ast.getChild(0)) || this.isInsertQueryForOptimize) break;
                    this.isInsertQueryForOptimize = true;
                    this.destClauseForInsertOptimizer = ctx_1.dest;
                    break;
                }
                case 637: {
                    int child_count = ast.getChildCount();
                    if (child_count != 1) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Multiple Children " + child_count));
                    }
                    ASTNode frm = (ASTNode)ast.getChild(0);
                    if (frm.getToken().getType() == 797) {
                        this.processTable(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 767) {
                        this.processSubQuery(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 667 || frm.getToken().getType() == 668) {
                        this.processLateralView(qb, frm);
                        break;
                    }
                    if (this.isJoinToken(frm)) {
                        this.queryProperties.setHasJoin(true);
                        this.processJoin(qb, frm);
                        qbp.setJoinExpr(frm);
                        break;
                    }
                    if (frm.getToken().getType() != 726) break;
                    this.queryProperties.setHasPTF(true);
                    this.processPTF(qb, frm);
                    break;
                }
                case 591: {
                    this.queryProperties.setHasClusterBy(true);
                    qbp.setClusterByExprForClause(ctx_1.dest, ast);
                    break;
                }
                case 618: {
                    this.queryProperties.setHasDistributeBy(true);
                    qbp.setDistributeByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.ORDERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                }
                case 760: {
                    this.queryProperties.setHasSortBy(true);
                    qbp.setSortByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_SORTBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.ORDERBY_SORTBY_CONFLICT.getMsg()));
                }
                case 705: {
                    this.queryProperties.setHasOrderBy(true);
                    qbp.setOrderByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_ORDERBY_CONFLICT.getMsg()));
                }
                case 602: 
                case 646: 
                case 647: 
                case 736: {
                    this.queryProperties.setHasGroupBy(true);
                    if (qbp.getJoinExpr() != null) {
                        this.queryProperties.setHasJoinFollowedByGroupBy(true);
                    }
                    if (qbp.getSelForClause(ctx_1.dest).getToken().getType() == 739) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.SELECT_DISTINCT_WITH_GROUPBY.getMsg()));
                    }
                    qbp.setGroupByExprForClause(ctx_1.dest, ast);
                    skipRecursion = true;
                    if (ast.getToken().getType() == 736) {
                        qbp.getDestRollups().add(ctx_1.dest);
                        break;
                    }
                    if (ast.getToken().getType() == 602) {
                        qbp.getDestCubes().add(ctx_1.dest);
                        break;
                    }
                    if (ast.getToken().getType() != 647) break;
                    qbp.getDestGroupingSets().add(ctx_1.dest);
                    break;
                }
                case 649: {
                    qbp.setHavingExprForClause(ctx_1.dest, ast);
                    qbp.addAggregationExprsForClause(ctx_1.dest, this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest));
                    break;
                }
                case 265: {
                    if (!qb.hasWindowingSpec(ctx_1.dest)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Query has no Cluster/Distribute By; but has a Window definition"));
                    }
                    this.handleQueryWindowClauses(qb, ctx_1, ast);
                    break;
                }
                case 673: {
                    qbp.setDestLimit(ctx_1.dest, new Integer(ast.getChild(0).getText()));
                    break;
                }
                case 585: {
                    String table_name = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0));
                    qb.setTabAlias(table_name, table_name);
                    qb.addAlias(table_name);
                    qb.getParseInfo().setIsAnalyzeCommand(true);
                    qb.getParseInfo().setNoScanAnalyzeCommand(this.noscan);
                    qb.getParseInfo().setPartialScanAnalyzeCommand(this.partialscan);
                    HiveConf.setVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
                    HiveConf.setVar(this.conf, HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
                    break;
                }
                case 812: {
                    if (!qbp.getIsSubQ()) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.UNION_NOTIN_SUBQ.getMsg()));
                    }
                }
                case 661: {
                    ASTNode destination = (ASTNode)ast.getChild(0);
                    Tree tab = destination.getChild(0);
                    if (destination.getChildCount() == 2 && tab.getChildCount() == 2 && destination.getChild(1).getType() == 655) {
                        String tableName = tab.getChild(0).getChild(0).getText();
                        Tree partitions = tab.getChild(1);
                        int childCount = partitions.getChildCount();
                        HashMap<String, String> partition = new HashMap<String, String>();
                        for (int i = 0; i < childCount; ++i) {
                            String partitionName = partitions.getChild(i).getChild(0).getText();
                            Tree pvalue = partitions.getChild(i).getChild(1);
                            if (pvalue == null) break;
                            String partitionVal = SemanticAnalyzer.stripQuotes(pvalue.getText());
                            partition.put(partitionName, partitionVal);
                        }
                        if (childCount != partition.size()) throw new SemanticException(ErrorMsg.INSERT_INTO_DYNAMICPARTITION_IFNOTEXISTS.getMsg(partition.toString()));
                        try {
                            Table table = this.db.getTable(tableName);
                            Partition parMetaData = this.db.getPartition(table, partition, false);
                            if (parMetaData != null) {
                                phase1Result = false;
                                skipRecursion = true;
                                this.LOG.info((Object)("Partition already exists so insert into overwrite skipped for partition : " + parMetaData.toString()));
                                break;
                            }
                        }
                        catch (HiveException e) {
                            this.LOG.info((Object)"Error while getting metadata : ", (Throwable)e);
                        }
                    }
                    skipRecursion = false;
                    break;
                }
                case 667: 
                case 668: {
                    assert (ast.getChildCount() == 1);
                    qb.getParseInfo().getDestToLateralView().put(ctx_1.dest, ast);
                    break;
                }
                default: {
                    skipRecursion = false;
                }
            }
        }
        if (skipRecursion) return phase1Result;
        int child_count = ast.getChildCount();
        for (int child_pos = 0; child_pos < child_count && phase1Result; ++child_pos) {
            phase1Result = phase1Result && this.doPhase1((ASTNode)ast.getChild(child_pos), qb, ctx_1);
        }
        return phase1Result;
    }

    private void getMetaData(QBExpr qbexpr) throws SemanticException {
        this.getMetaData(qbexpr, null);
    }

    private void getMetaData(QBExpr qbexpr, ReadEntity parentInput) throws SemanticException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            this.getMetaData(qbexpr.getQB(), parentInput);
        } else {
            this.getMetaData(qbexpr.getQBExpr1(), parentInput);
            this.getMetaData(qbexpr.getQBExpr2(), parentInput);
        }
    }

    public void getMetaData(QB qb) throws SemanticException {
        this.getMetaData(qb, null);
    }

    public void getMetaData(QB qb, ReadEntity parentInput) throws SemanticException {
        try {
            this.LOG.info((Object)"Get metadata for source tables");
            ArrayList<String> tabAliases = new ArrayList<String>(qb.getTabAliases());
            HashMap<String, ObjectPair<String, ReadEntity>> aliasToViewInfo = new HashMap<String, ObjectPair<String, ReadEntity>>();
            for (String alias : tabAliases) {
                QBParseInfo qbpi;
                String tab_name = qb.getTabNameForAlias(alias);
                Table tab = null;
                try {
                    tab = this.db.getTable(tab_name);
                }
                catch (InvalidTableException ite) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(qb.getParseInfo().getSrcForAlias(alias)));
                }
                if (qb.getParseInfo().isInsertIntoTable(tab.getDbName(), tab.getTableName()) && tab.getNumBuckets() > 0) {
                    throw new SemanticException(ErrorMsg.INSERT_INTO_BUCKETIZED_TABLE.getMsg("Table: " + tab_name));
                }
                if (tab.isOffline()) {
                    throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg("Table " + SemanticAnalyzer.getUnescapedName(qb.getParseInfo().getSrcForAlias(alias))));
                }
                if (tab.isView()) {
                    if (qb.getParseInfo().isAnalyzeCommand()) {
                        throw new SemanticException(ErrorMsg.ANALYZE_VIEW.getMsg());
                    }
                    String fullViewName = tab.getDbName() + "." + tab.getTableName();
                    if (this.viewsExpanded.contains(fullViewName)) {
                        throw new SemanticException("Recursive view " + fullViewName + " detected (cycle: " + StringUtils.join(this.viewsExpanded, " -> ") + " -> " + fullViewName + ").");
                    }
                    this.replaceViewReferenceWithDefinition(qb, tab, tab_name, alias);
                    ReadEntity viewInput = new ReadEntity(tab, parentInput);
                    viewInput = PlanUtils.addInput(this.inputs, viewInput);
                    aliasToViewInfo.put(alias, new ObjectPair<String, ReadEntity>(fullViewName, viewInput));
                    this.viewAliasToInput.put(this.getAliasId(alias, qb), viewInput);
                    continue;
                }
                if (!InputFormat.class.isAssignableFrom(tab.getInputFormatClass())) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), ErrorMsg.INVALID_INPUT_FORMAT_TYPE.getMsg()));
                }
                qb.getMetaData().setSrcForAlias(alias, tab);
                if (!qb.getParseInfo().isAnalyzeCommand()) continue;
                BaseSemanticAnalyzer.tableSpec ts = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, (ASTNode)this.ast.getChild(0), true, this.noscan);
                if (ts.specType == BaseSemanticAnalyzer.tableSpec.SpecType.DYNAMIC_PARTITION) {
                    try {
                        ts.partitions = this.db.getPartitionsByNames(ts.tableHandle, ts.partSpec);
                    }
                    catch (HiveException e) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), "Cannot get partitions for " + ts.partSpec), e);
                    }
                }
                if ((qbpi = qb.getParseInfo()).isPartialScanAnalyzeCommand()) {
                    Class<? extends InputFormat> inputFormatClass = null;
                    switch (ts.specType) {
                        case TABLE_ONLY: {
                            inputFormatClass = ts.tableHandle.getInputFormatClass();
                            break;
                        }
                        case STATIC_PARTITION: {
                            inputFormatClass = ts.partHandle.getInputFormatClass();
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    if (!inputFormatClass.equals(RCFileInputFormat.class)) {
                        throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_NON_RCFILE.getMsg());
                    }
                }
                qb.getParseInfo().addTableSpec(alias, ts);
            }
            this.LOG.info((Object)"Get metadata for subqueries");
            for (String alias : qb.getSubqAliases()) {
                boolean wasView = aliasToViewInfo.containsKey(alias);
                ReadEntity newParentInput = null;
                if (wasView) {
                    this.viewsExpanded.add((String)((ObjectPair)aliasToViewInfo.get(alias)).getFirst());
                    newParentInput = (ReadEntity)((ObjectPair)aliasToViewInfo.get(alias)).getSecond();
                }
                QBExpr qbexpr = qb.getSubqForAlias(alias);
                this.getMetaData(qbexpr, newParentInput);
                if (!wasView) continue;
                this.viewsExpanded.remove(this.viewsExpanded.size() - 1);
            }
            BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
            BaseSemanticAnalyzer.AnalyzeCreateCommonVars shared = new BaseSemanticAnalyzer.AnalyzeCreateCommonVars();
            BaseSemanticAnalyzer.StorageFormat storageFormat = new BaseSemanticAnalyzer.StorageFormat();
            this.LOG.info((Object)"Get metadata for destination tables");
            QBParseInfo qbp = qb.getParseInfo();
            block25: for (String name : qbp.getClauseNamesForDest()) {
                ASTNode ast = qbp.getDestForClause(name);
                switch (ast.getToken().getType()) {
                    case 769: {
                        BaseSemanticAnalyzer.tableSpec ts = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, ast);
                        if (ts.tableHandle.isView()) {
                            throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
                        }
                        Class<? extends HiveOutputFormat> outputFormatClass = ts.tableHandle.getOutputFormatClass();
                        if (!HiveOutputFormat.class.isAssignableFrom(outputFormatClass)) {
                            throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg(ast, "The class is " + outputFormatClass.toString()));
                        }
                        if (ts.specType != BaseSemanticAnalyzer.tableSpec.SpecType.STATIC_PARTITION) {
                            qb.getMetaData().setDestForAlias(name, ts.tableHandle);
                            if (ts.partSpec != null && ts.partSpec.size() > 0) {
                                qb.getMetaData().setPartSpecForAlias(name, ts.partSpec);
                            }
                        } else {
                            qb.getMetaData().setDestForAlias(name, ts.partHandle);
                        }
                        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) continue block25;
                        qb.getParseInfo().setIsInsertToTable(true);
                        qb.getParseInfo().addTableSpec(ts.tableName.toLowerCase(), ts);
                        continue block25;
                    }
                    case 616: 
                    case 676: {
                        String fname = SemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
                        if (!qb.getParseInfo().getIsSubQ() && ((ASTNode)ast.getChild(0)).getToken().getType() == 808) {
                            if (qb.isCTAS()) {
                                Path location;
                                qb.setIsQuery(false);
                                this.ctx.setResDir(null);
                                this.ctx.setResFile(null);
                                String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                                Table newTable = this.db.newTable(tableName);
                                try {
                                    Warehouse wh = new Warehouse((Configuration)this.conf);
                                    location = wh.getDatabasePath(this.db.getDatabase(newTable.getDbName()));
                                }
                                catch (MetaException e) {
                                    throw new SemanticException(e);
                                }
                                try {
                                    fname = this.ctx.getExternalTmpFileURI(FileUtils.makeQualified(location, this.conf).toUri());
                                }
                                catch (Exception e) {
                                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Error creating temporary folder on: " + location.toString()), e);
                                }
                                if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                                    BaseSemanticAnalyzer.tableSpec ts = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, this.ast);
                                    qb.getParseInfo().setIsInsertToTable(true);
                                    qb.getParseInfo().addTableSpec(ts.tableName.toLowerCase(), ts);
                                }
                            } else {
                                qb.setIsQuery(true);
                                fname = this.ctx.getMRTmpFileURI();
                                this.ctx.setResDir(new Path(fname));
                            }
                        }
                        qb.getMetaData().setDestForAlias(name, fname, ast.getToken().getType() == 616);
                        CreateTableDesc localDirectoryDesc = new CreateTableDesc();
                        boolean localDirectoryDescIsSet = false;
                        int numCh = ast.getChildCount();
                        block26: for (int num = 1; num < numCh; ++num) {
                            ASTNode child = (ASTNode)ast.getChild(num);
                            if (ast.getChild(num) == null) continue;
                            switch (child.getToken().getType()) {
                                case 786: {
                                    rowFormatParams.analyzeRowFormat(shared, child);
                                    localDirectoryDesc.setFieldDelim(rowFormatParams.fieldDelim);
                                    localDirectoryDesc.setLineDelim(rowFormatParams.lineDelim);
                                    localDirectoryDesc.setCollItemDelim(rowFormatParams.collItemDelim);
                                    localDirectoryDesc.setMapKeyDelim(rowFormatParams.mapKeyDelim);
                                    localDirectoryDesc.setFieldEscape(rowFormatParams.fieldEscape);
                                    localDirectoryDescIsSet = true;
                                    continue block26;
                                }
                                case 791: {
                                    ASTNode serdeChild = (ASTNode)child.getChild(0);
                                    shared.serde = SemanticAnalyzer.unescapeSQLString(serdeChild.getChild(0).getText());
                                    localDirectoryDesc.setSerName(shared.serde);
                                    localDirectoryDescIsSet = true;
                                    continue block26;
                                }
                                case 780: 
                                case 802: 
                                case 803: 
                                case 804: 
                                case 805: {
                                    storageFormat.fillStorageFormat(child, shared);
                                    localDirectoryDesc.setOutputFormat(storageFormat.outputFormat);
                                    localDirectoryDesc.setSerName(shared.serde);
                                    localDirectoryDescIsSet = true;
                                }
                            }
                        }
                        if (!localDirectoryDescIsSet) continue block25;
                        qb.setLocalDirectoryDesc(localDirectoryDesc);
                        continue block25;
                    }
                }
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Unknown Token Type " + ast.getToken().getType()));
            }
        }
        catch (HiveException e) {
            this.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private void replaceViewReferenceWithDefinition(QB qb, Table tab, String tab_name, String alias) throws SemanticException {
        ASTNode viewTree;
        ParseDriver pd = new ParseDriver();
        final ASTNodeOrigin viewOrigin = new ASTNodeOrigin("VIEW", tab.getTableName(), tab.getViewExpandedText(), alias, qb.getParseInfo().getSrcForAlias(alias));
        try {
            String viewText = tab.getViewExpandedText();
            ASTNode tree = pd.parse(viewText, null);
            viewTree = tree = ParseUtils.findRootNonNullToken(tree);
            Dispatcher nodeOriginDispatcher = new Dispatcher(){

                @Override
                public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) {
                    ((ASTNode)nd).setOrigin(viewOrigin);
                    return null;
                }
            };
            DefaultGraphWalker nodeOriginTagger = new DefaultGraphWalker(nodeOriginDispatcher);
            nodeOriginTagger.startWalking(Collections.singleton(viewTree), null);
        }
        catch (ParseException e) {
            this.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage());
            ErrorMsg.renderOrigin(sb, viewOrigin);
            throw new SemanticException(sb.toString(), e);
        }
        QBExpr qbexpr = new QBExpr(alias);
        this.doPhase1QBExpr(viewTree, qbexpr, qb.getId(), alias);
        qb.rewriteViewToSubq(alias, tab_name, qbexpr);
    }

    private boolean isPresent(String[] list, String elem) {
        for (String s : list) {
            if (!s.toLowerCase().equals(elem)) continue;
            return true;
        }
        return false;
    }

    private void parseJoinCondPopulateAlias(QBJoinTree joinTree, ASTNode condn, ArrayList<String> leftAliases, ArrayList<String> rightAliases, ArrayList<String> fields) throws SemanticException {
        switch (condn.getToken().getType()) {
            case 794: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(condn.getChild(0).getText().toLowerCase());
                this.unparseTranslator.addIdentifierTranslation((ASTNode)condn.getChild(0));
                if (this.isPresent(joinTree.getLeftAliases(), tableOrCol)) {
                    if (leftAliases.contains(tableOrCol)) break;
                    leftAliases.add(tableOrCol);
                    break;
                }
                if (this.isPresent(joinTree.getRightAliases(), tableOrCol)) {
                    if (rightAliases.contains(tableOrCol)) break;
                    rightAliases.add(tableOrCol);
                    break;
                }
                throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(condn.getChild(0)));
            }
            case 26: {
                if (fields != null) {
                    fields.add(SemanticAnalyzer.unescapeIdentifier(condn.getToken().getText().toLowerCase()));
                }
                this.unparseTranslator.addIdentifierTranslation(condn);
                break;
            }
            case 7: 
            case 18: 
            case 97: 
            case 242: 
            case 276: 
            case 285: 
            case 286: 
            case 288: 
            case 590: 
            case 765: {
                break;
            }
            case 639: {
                for (int i = 1; i < condn.getChildCount(); ++i) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(i), leftAliases, rightAliases, null);
                }
                break;
            }
            default: {
                if (condn.getChildCount() == 1) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null);
                    break;
                }
                if (condn.getChildCount() == 2) {
                    ArrayList<String> fields1 = null;
                    if (!joinTree.getNoSemiJoin() && condn.getToken().getType() == 17) {
                        fields1 = new ArrayList<String>();
                        int rhssize = rightAliases.size();
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null);
                        String rhsAlias = null;
                        if (rightAliases.size() > rhssize) {
                            rhsAlias = rightAliases.get(rightAliases.size() - 1);
                        }
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1);
                        if (rhsAlias == null || fields1.size() <= 0) break;
                        joinTree.addRHSSemijoinColumns(rhsAlias, condn);
                        break;
                    }
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null);
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1);
                    break;
                }
                throw new SemanticException(condn.toStringTree() + " encountered with " + condn.getChildCount() + " children");
            }
        }
    }

    private void populateAliases(List<String> leftAliases, List<String> rightAliases, ASTNode condn, QBJoinTree joinTree, List<String> leftSrc) throws SemanticException {
        if (leftAliases.size() != 0 && rightAliases.size() != 0) {
            throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_1.getMsg(condn));
        }
        if (rightAliases.size() != 0) {
            assert (rightAliases.size() == 1);
            joinTree.getExpressions().get(1).add(condn);
        } else if (leftAliases.size() != 0) {
            joinTree.getExpressions().get(0).add(condn);
            for (String s : leftAliases) {
                if (leftSrc.contains(s)) continue;
                leftSrc.add(s);
            }
        } else {
            throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_2.getMsg(condn));
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond, List<String> leftSrc) throws SemanticException {
        if (joinCond == null) {
            return;
        }
        JoinCond cond = joinTree.getJoinCond()[0];
        JoinType type = cond.getJoinType();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, type);
        ArrayList<ArrayList<ASTNode>> filters = joinTree.getFilters();
        if (type == JoinType.LEFTOUTER || type == JoinType.FULLOUTER) {
            joinTree.addFilterMapping(cond.getLeft(), cond.getRight(), ((ArrayList)filters.get(0)).size());
        }
        if (type == JoinType.RIGHTOUTER || type == JoinType.FULLOUTER) {
            joinTree.addFilterMapping(cond.getRight(), cond.getLeft(), ((ArrayList)filters.get(1)).size());
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond, List<String> leftSrc, JoinType type) throws SemanticException {
        if (joinCond == null) {
            return;
        }
        switch (joinCond.getToken().getType()) {
            case 164: {
                throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_3.getMsg(joinCond));
            }
            case 32: {
                this.parseJoinCondition(joinTree, (ASTNode)joinCond.getChild(0), leftSrc, type);
                this.parseJoinCondition(joinTree, (ASTNode)joinCond.getChild(1), leftSrc, type);
                break;
            }
            case 20: 
            case 21: {
                ASTNode leftCondn = (ASTNode)joinCond.getChild(0);
                ArrayList<String> leftCondAl1 = new ArrayList<String>();
                ArrayList<String> leftCondAl2 = new ArrayList<String>();
                this.parseJoinCondPopulateAlias(joinTree, leftCondn, leftCondAl1, leftCondAl2, null);
                ASTNode rightCondn = (ASTNode)joinCond.getChild(1);
                ArrayList<String> rightCondAl1 = new ArrayList<String>();
                ArrayList<String> rightCondAl2 = new ArrayList<String>();
                this.parseJoinCondPopulateAlias(joinTree, rightCondn, rightCondAl1, rightCondAl2, null);
                if (leftCondAl1.size() != 0 && leftCondAl2.size() != 0 || rightCondAl1.size() != 0 && rightCondAl2.size() != 0) {
                    throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_1.getMsg(joinCond));
                }
                if (leftCondAl1.size() != 0) {
                    if (rightCondAl1.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                        if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEOUTERJOINSUPPORTSFILTERS)) {
                                joinTree.getFilters().get(0).add(joinCond);
                                break;
                            }
                            this.LOG.warn((Object)ErrorMsg.OUTERJOIN_USES_FILTERS);
                            joinTree.getFiltersForPushing().get(0).add(joinCond);
                            break;
                        }
                        joinTree.getFiltersForPushing().get(0).add(joinCond);
                        break;
                    }
                    if (rightCondAl2.size() == 0) break;
                    this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                    this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                    boolean nullsafe = joinCond.getToken().getType() == 21;
                    joinTree.getNullSafes().add(nullsafe);
                    break;
                }
                if (leftCondAl2.size() != 0) {
                    if (rightCondAl2.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                        if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEOUTERJOINSUPPORTSFILTERS)) {
                                joinTree.getFilters().get(1).add(joinCond);
                                break;
                            }
                            this.LOG.warn((Object)ErrorMsg.OUTERJOIN_USES_FILTERS);
                            joinTree.getFiltersForPushing().get(1).add(joinCond);
                            break;
                        }
                        joinTree.getFiltersForPushing().get(1).add(joinCond);
                        break;
                    }
                    if (rightCondAl1.size() == 0) break;
                    this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                    this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                    boolean nullsafe = joinCond.getToken().getType() == 21;
                    joinTree.getNullSafes().add(nullsafe);
                    break;
                }
                if (rightCondAl1.size() != 0) {
                    if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEOUTERJOINSUPPORTSFILTERS)) {
                            joinTree.getFilters().get(0).add(joinCond);
                            break;
                        }
                        this.LOG.warn((Object)ErrorMsg.OUTERJOIN_USES_FILTERS);
                        joinTree.getFiltersForPushing().get(0).add(joinCond);
                        break;
                    }
                    joinTree.getFiltersForPushing().get(0).add(joinCond);
                    break;
                }
                if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEOUTERJOINSUPPORTSFILTERS)) {
                        joinTree.getFilters().get(1).add(joinCond);
                        break;
                    }
                    this.LOG.warn((Object)ErrorMsg.OUTERJOIN_USES_FILTERS);
                    joinTree.getFiltersForPushing().get(1).add(joinCond);
                    break;
                }
                joinTree.getFiltersForPushing().get(1).add(joinCond);
                break;
            }
            default: {
                int ci;
                boolean isFunction = joinCond.getType() == 639;
                int childrenBegin = isFunction ? 1 : 0;
                ArrayList leftAlias = new ArrayList(joinCond.getChildCount() - childrenBegin);
                ArrayList rightAlias = new ArrayList(joinCond.getChildCount() - childrenBegin);
                for (ci = 0; ci < joinCond.getChildCount() - childrenBegin; ++ci) {
                    ArrayList left = new ArrayList();
                    ArrayList arrayList = new ArrayList();
                    leftAlias.add(left);
                    rightAlias.add(arrayList);
                }
                for (ci = childrenBegin; ci < joinCond.getChildCount(); ++ci) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)joinCond.getChild(ci), (ArrayList)leftAlias.get(ci - childrenBegin), (ArrayList)rightAlias.get(ci - childrenBegin), null);
                }
                boolean leftAliasNull = true;
                for (ArrayList arrayList : leftAlias) {
                    if (arrayList.size() == 0) continue;
                    leftAliasNull = false;
                    break;
                }
                boolean rightAliasNull = true;
                for (ArrayList arrayList : rightAlias) {
                    if (arrayList.size() == 0) continue;
                    rightAliasNull = false;
                    break;
                }
                if (!leftAliasNull && !rightAliasNull) {
                    throw new SemanticException(ErrorMsg.INVALID_JOIN_CONDITION_1.getMsg(joinCond));
                }
                if (!leftAliasNull) {
                    if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEOUTERJOINSUPPORTSFILTERS)) {
                            joinTree.getFilters().get(0).add(joinCond);
                            break;
                        }
                        this.LOG.warn((Object)ErrorMsg.OUTERJOIN_USES_FILTERS);
                        joinTree.getFiltersForPushing().get(0).add(joinCond);
                        break;
                    }
                    joinTree.getFiltersForPushing().get(0).add(joinCond);
                    break;
                }
                if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEOUTERJOINSUPPORTSFILTERS)) {
                        joinTree.getFilters().get(1).add(joinCond);
                        break;
                    }
                    this.LOG.warn((Object)ErrorMsg.OUTERJOIN_USES_FILTERS);
                    joinTree.getFiltersForPushing().get(1).add(joinCond);
                    break;
                }
                joinTree.getFiltersForPushing().get(1).add(joinCond);
            }
        }
    }

    public <T extends OperatorDesc> Operator<T> putOpInsertMap(Operator<T> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.opParseCtx.put(op, ctx);
        op.augmentPlan();
        return op;
    }

    private Operator genHavingPlan(String dest, QB qb, Operator input) throws SemanticException {
        ASTNode havingExpr = qb.getParseInfo().getHavingForClause(dest);
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        Map<ASTNode, String> exprToColumnAlias = qb.getParseInfo().getAllExprToColumnAlias();
        for (ASTNode astNode : exprToColumnAlias.keySet()) {
            if (inputRR.getExpression(astNode) == null) continue;
            inputRR.put("", exprToColumnAlias.get(astNode), inputRR.getExpression(astNode));
        }
        ASTNode condn = (ASTNode)havingExpr.getChild(0);
        Operator<FilterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new FilterDesc(this.genExprNodeDesc(condn, inputRR), false), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        return output;
    }

    private Operator genFilterPlan(String dest, QB qb, Operator input) throws SemanticException {
        ASTNode whereExpr = qb.getParseInfo().getWhrForClause(dest);
        return this.genFilterPlan(qb, (ASTNode)whereExpr.getChild(0), input);
    }

    private Operator genFilterPlan(QB qb, ASTNode condn, Operator input) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        Operator<FilterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new FilterDesc(this.genExprNodeDesc(condn, inputRR), false), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created Filter Plan for " + qb.getId() + " row schema: " + inputRR.toString()));
        }
        return output;
    }

    private Integer genColListRegex(String colRegex, String tabAlias, ASTNode sel, ArrayList<ExprNodeDesc> col_list, RowResolver input, Integer pos, RowResolver output, List<String> aliases, boolean subQuery) throws SemanticException {
        if (tabAlias != null && !input.hasTableAlias(tabAlias)) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(sel));
        }
        Pattern regex = null;
        try {
            regex = Pattern.compile(colRegex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(sel, e.getMessage()));
        }
        StringBuilder replacementText = new StringBuilder();
        int matched = 0;
        if (!aliases.contains("")) {
            aliases.add("");
        }
        for (String alias : aliases) {
            HashMap<String, ColumnInfo> fMap = input.getFieldMap(alias);
            if (fMap == null) continue;
            for (Map.Entry<String, ColumnInfo> entry : fMap.entrySet()) {
                ColumnInfo colInfo = entry.getValue();
                String name = colInfo.getInternalName();
                String[] tmp = input.reverseLookup(name);
                if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol() || !regex.matcher(tmp[1]).matches()) continue;
                ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo.getType(), name, colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
                if (subQuery) {
                    output.checkColumn(tmp[0], tmp[1]);
                }
                col_list.add(expr);
                output.put(tmp[0], tmp[1], new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol()));
                pos = pos + 1;
                ++matched;
                if (!this.unparseTranslator.isEnabled()) continue;
                if (replacementText.length() > 0) {
                    replacementText.append(", ");
                }
                replacementText.append(HiveUtils.unparseIdentifier(tmp[0]));
                replacementText.append(".");
                replacementText.append(HiveUtils.unparseIdentifier(tmp[1]));
            }
        }
        if (matched == 0) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(sel));
        }
        if (this.unparseTranslator.isEnabled()) {
            this.unparseTranslator.addTranslation(sel, replacementText.toString());
        }
        return pos;
    }

    public static String getColumnInternalName(int pos) {
        return HiveConf.getColumnInternalName(pos);
    }

    private String getScriptProgName(String cmd) {
        int end = cmd.indexOf(" ");
        return end == -1 ? cmd : cmd.substring(0, end);
    }

    private String getScriptArgs(String cmd) {
        int end = cmd.indexOf(" ");
        return end == -1 ? "" : cmd.substring(end, cmd.length());
    }

    private static int getPositionFromInternalName(String internalName) {
        return HiveConf.getPositionFromInternalName(internalName);
    }

    private String fetchFilesNotInLocalFilesystem(String cmd) {
        SessionState ss = SessionState.get();
        String progName = this.getScriptProgName(cmd);
        if (SessionState.canDownloadResource(progName)) {
            String filePath = ss.add_resource(SessionState.ResourceType.FILE, progName, true);
            if (filePath == null) {
                throw new RuntimeException("Could not download the resource: " + progName);
            }
            Path p = new Path(filePath);
            String fileName = p.getName();
            String scriptArgs = this.getScriptArgs(cmd);
            String finalCmd = fileName + scriptArgs;
            return finalCmd;
        }
        return cmd;
    }

    private TableDesc getTableDescFromSerDe(ASTNode child, String cols, String colTypes, boolean defaultCols) throws SemanticException {
        if (child.getType() == 742) {
            String serdeName = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
            Class<?> serdeClass = null;
            try {
                serdeClass = Class.forName(serdeName, true, JavaUtils.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(e);
            }
            TableDesc tblDesc = PlanUtils.getTableDesc(serdeClass, Integer.toString(9), cols, colTypes, defaultCols);
            if (child.getChildCount() == 2) {
                ASTNode prop = (ASTNode)((ASTNode)child.getChild(1)).getChild(0);
                for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
                    String key = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
                    String value = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
                    tblDesc.getProperties().setProperty(key, value);
                }
            }
            return tblDesc;
        }
        if (child.getType() == 743) {
            TableDesc tblDesc = PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, defaultCols);
            int numChildRowFormat = child.getChildCount();
            block9: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 788: {
                        String fieldDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("field.delim", fieldDelim);
                        tblDesc.getProperties().setProperty("serialization.format", fieldDelim);
                        if (rowChild.getChildCount() < 2) continue block9;
                        String fieldEscape = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        tblDesc.getProperties().setProperty("escape.delim", fieldEscape);
                        continue block9;
                    }
                    case 787: {
                        tblDesc.getProperties().setProperty("colelction.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block9;
                    }
                    case 790: {
                        tblDesc.getProperties().setProperty("mapkey.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block9;
                    }
                    case 789: {
                        String lineDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("line.delim", lineDelim);
                        if (lineDelim.equals("\n") || lineDelim.equals("10")) continue block9;
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    default: {
                        assert (false);
                        continue block9;
                    }
                }
            }
            return tblDesc;
        }
        return null;
    }

    private void failIfColAliasExists(Set<String> nameSet, String name) throws SemanticException {
        if (nameSet.contains(name)) {
            throw new SemanticException(ErrorMsg.COLUMN_ALIAS_ALREADY_EXISTS.getMsg(name));
        }
        nameSet.add(name);
    }

    private Operator genScriptPlan(ASTNode trfm, QB qb, Operator input) throws SemanticException {
        Class<?> serde;
        int i;
        ArrayList<ColumnInfo> outputCols = new ArrayList<ColumnInfo>();
        int inputSerDeNum = 1;
        int inputRecordWriterNum = 2;
        int outputSerDeNum = 4;
        int outputRecordReaderNum = 5;
        int outputColsNum = 6;
        boolean outputColNames = false;
        boolean outputColSchemas = false;
        int execPos = 3;
        boolean defaultOutputCols = false;
        if (trfm.getChildCount() > outputColsNum) {
            ASTNode outCols = (ASTNode)trfm.getChild(outputColsNum);
            if (outCols.getType() == 552) {
                outputColNames = true;
            } else if (outCols.getType() == 772) {
                outputColSchemas = true;
            }
        }
        if (!outputColNames && !outputColSchemas) {
            String intName = SemanticAnalyzer.getColumnInternalName(0);
            ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("key");
            outputCols.add(colInfo);
            intName = SemanticAnalyzer.getColumnInternalName(1);
            colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("value");
            outputCols.add(colInfo);
            defaultOutputCols = true;
        } else {
            ASTNode collist = (ASTNode)trfm.getChild(outputColsNum);
            int ccount = collist.getChildCount();
            HashSet<String> colAliasNamesDuplicateCheck = new HashSet<String>();
            if (outputColNames) {
                for (i = 0; i < ccount; ++i) {
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)collist.getChild(i)).getText());
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoFactory.stringTypeInfo, null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            } else {
                for (i = 0; i < ccount; ++i) {
                    ASTNode child = (ASTNode)collist.getChild(i);
                    assert (child.getType() == 771);
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)child.getChild(0)).getText());
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoUtils.getTypeInfoFromTypeString(SemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1))), null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            }
        }
        RowResolver out_rwsch = new RowResolver();
        StringBuilder columns = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        for (i = 0; i < outputCols.size(); ++i) {
            if (i != 0) {
                columns.append(",");
                columnTypes.append(",");
            }
            columns.append(((ColumnInfo)outputCols.get(i)).getInternalName());
            columnTypes.append(((ColumnInfo)outputCols.get(i)).getType().getTypeName());
            out_rwsch.put(qb.getParseInfo().getAlias(), ((ColumnInfo)outputCols.get(i)).getAlias(), (ColumnInfo)outputCols.get(i));
        }
        StringBuilder inpColumns = new StringBuilder();
        StringBuilder inpColumnTypes = new StringBuilder();
        ArrayList<ColumnInfo> inputSchema = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        for (int i2 = 0; i2 < inputSchema.size(); ++i2) {
            if (i2 != 0) {
                inpColumns.append(",");
                inpColumnTypes.append(",");
            }
            inpColumns.append(inputSchema.get(i2).getInternalName());
            inpColumnTypes.append(inputSchema.get(i2).getType().getTypeName());
        }
        String defaultSerdeName = this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTSERDE);
        try {
            serde = Class.forName(defaultSerdeName, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
        int fieldSeparator = 9;
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESCRIPTESCAPE)) {
            fieldSeparator = 1;
        }
        TableDesc inInfo = trfm.getChild(inputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(inputSerDeNum)).getChild(0), inpColumns.toString(), inpColumnTypes.toString(), false) : PlanUtils.getTableDesc(serde, Integer.toString(fieldSeparator), inpColumns.toString(), inpColumnTypes.toString(), false, true);
        TableDesc outInfo = trfm.getChild(outputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(outputSerDeNum)).getChild(0), columns.toString(), columnTypes.toString(), false) : PlanUtils.getTableDesc(serde, Integer.toString(fieldSeparator), columns.toString(), columnTypes.toString(), defaultOutputCols);
        TableDesc errInfo = PlanUtils.getTableDesc(serde, Integer.toString(9), "KEY");
        Class<? extends RecordReader> outRecordReader = this.getRecordReader((ASTNode)trfm.getChild(outputRecordReaderNum));
        Class<? extends RecordWriter> inRecordWriter = this.getRecordWriter((ASTNode)trfm.getChild(inputRecordWriterNum));
        Class<? extends RecordReader> errRecordReader = this.getDefaultRecordReader();
        Operator<ScriptDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ScriptDesc(this.fetchFilesNotInLocalFilesystem(SemanticAnalyzer.stripQuotes(trfm.getChild(execPos).getText())), inInfo, inRecordWriter, outInfo, outRecordReader, errRecordReader, errInfo), new RowSchema(out_rwsch.getColumnInfos()), input), out_rwsch);
        return output;
    }

    private Class<? extends RecordReader> getRecordReader(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDREADER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    private Class<? extends RecordReader> getDefaultRecordReader() throws SemanticException {
        String name = this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDREADER);
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    private Class<? extends RecordWriter> getRecordWriter(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVESCRIPTRECORDWRITER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e);
        }
    }

    private List<Integer> getGroupingSetsForRollup(int size) {
        ArrayList<Integer> groupingSetKeys = new ArrayList<Integer>();
        for (int i = 0; i <= size; ++i) {
            groupingSetKeys.add((1 << i) - 1);
        }
        return groupingSetKeys;
    }

    private List<Integer> getGroupingSetsForCube(int size) {
        int count = 1 << size;
        ArrayList<Integer> results = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            results.add(i);
        }
        return results;
    }

    private ObjectPair<List<ASTNode>, List<Integer>> getGroupByGroupingSetsForClause(QBParseInfo parseInfo, String dest) throws SemanticException {
        List<Object> groupingSets = new ArrayList();
        List<ASTNode> groupByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        if (parseInfo.getDestRollups().contains(dest)) {
            groupingSets = this.getGroupingSetsForRollup(groupByExprs.size());
        } else if (parseInfo.getDestCubes().contains(dest)) {
            groupingSets = this.getGroupingSetsForCube(groupByExprs.size());
        } else if (parseInfo.getDestGroupingSets().contains(dest)) {
            groupingSets = this.getGroupingSets(groupByExprs, parseInfo, dest);
        }
        return new ObjectPair<List<ASTNode>, List<Integer>>(groupByExprs, groupingSets);
    }

    private List<Integer> getGroupingSets(List<ASTNode> groupByExpr, QBParseInfo parseInfo, String dest) throws SemanticException {
        HashMap<String, Integer> exprPos = new HashMap<String, Integer>();
        for (int i = 0; i < groupByExpr.size(); ++i) {
            ASTNode node = groupByExpr.get(i);
            exprPos.put(node.toStringTree(), i);
        }
        ASTNode root = parseInfo.getGroupByForClause(dest);
        ArrayList<Integer> result = new ArrayList<Integer>(root == null ? 0 : root.getChildCount());
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                ASTNode child = (ASTNode)root.getChild(i);
                if (child.getType() != 648) continue;
                int bitmap = 0;
                for (int j = 0; j < child.getChildCount(); ++j) {
                    String treeAsString = child.getChild(j).toStringTree();
                    Integer pos = (Integer)exprPos.get(treeAsString);
                    if (pos == null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(j), ErrorMsg.HIVE_GROUPING_SETS_EXPR_NOT_IN_GROUPBY.getErrorCodedMsg()));
                    }
                    bitmap = this.setBit(bitmap, pos);
                }
                result.add(bitmap);
            }
        }
        if (this.checkForNoAggr(result)) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOFUNC.getMsg());
        }
        return result;
    }

    private boolean checkForNoAggr(List<Integer> bitmaps) {
        boolean ret = true;
        for (int mask : bitmaps) {
            ret &= mask == 0;
        }
        return ret;
    }

    private int setBit(int bitmap, int bitIdx) {
        return bitmap | 1 << bitIdx;
    }

    static List<ASTNode> getGroupByForClause(QBParseInfo parseInfo, String dest) {
        if (parseInfo.getSelForClause(dest).getToken().getType() == 739) {
            ASTNode selectExprs = parseInfo.getSelForClause(dest);
            ArrayList<ASTNode> result = new ArrayList<ASTNode>(selectExprs == null ? 0 : selectExprs.getChildCount());
            if (selectExprs != null) {
                HashMap<String, ASTNode> windowingExprs = parseInfo.getWindowingExprsForClause(dest);
                for (int i = 0; i < selectExprs.getChildCount(); ++i) {
                    if (((ASTNode)selectExprs.getChild(i)).getToken().getType() == 652) continue;
                    ASTNode grpbyExpr = (ASTNode)selectExprs.getChild(i).getChild(0);
                    if (windowingExprs != null && windowingExprs.containsKey(grpbyExpr.toStringTree())) continue;
                    result.add(grpbyExpr);
                }
            }
            return result;
        }
        ASTNode grpByExprs = parseInfo.getGroupByForClause(dest);
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(grpByExprs == null ? 0 : grpByExprs.getChildCount());
        if (grpByExprs != null) {
            for (int i = 0; i < grpByExprs.getChildCount(); ++i) {
                ASTNode grpbyExpr = (ASTNode)grpByExprs.getChild(i);
                if (grpbyExpr.getType() == 648) continue;
                result.add(grpbyExpr);
            }
        }
        return result;
    }

    private static String[] getColAlias(ASTNode selExpr, String defaultName, RowResolver inputRR, boolean includeFuncName, int colNum) {
        String colAlias = null;
        String tabAlias = null;
        String[] colRef = new String[2];
        if (selExpr.getChildCount() == 2 || selExpr.getChildCount() == 3 && selExpr.getChild(2).getType() == 824) {
            colAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        ASTNode root = (ASTNode)selExpr.getChild(0);
        if (root.getType() == 794) {
            colAlias = BaseSemanticAnalyzer.unescapeIdentifier(root.getChild(0).getText());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        if (root.getType() == 17) {
            ASTNode col;
            String t;
            ASTNode tab = (ASTNode)root.getChild(0);
            if (tab.getType() == 794 && inputRR.hasTableAlias(t = SemanticAnalyzer.unescapeIdentifier(tab.getChild(0).getText()))) {
                tabAlias = t;
            }
            if ((col = (ASTNode)root.getChild(1)).getType() == 26) {
                colAlias = SemanticAnalyzer.unescapeIdentifier(col.getText());
            }
        }
        if (includeFuncName && root.getType() == 639) {
            String expr_flattened = root.toStringTree();
            String expr_no_tok = expr_flattened.replaceAll("TOK_\\S+", "");
            String expr_formatted = expr_no_tok.replaceAll("\\W", " ").trim().replaceAll("\\s+", "_");
            if (expr_formatted.length() > 20) {
                expr_formatted = expr_formatted.substring(0, 20);
            }
            colAlias = expr_formatted.concat("_" + colNum);
        }
        if (colAlias == null) {
            colAlias = defaultName + colNum;
        }
        colRef[0] = tabAlias;
        colRef[1] = colAlias;
        return colRef;
    }

    private static boolean isRegex(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.isLetterOrDigit(pattern.charAt(i)) || pattern.charAt(i) == '_') continue;
            return true;
        }
        return false;
    }

    private Operator<?> genSelectPlan(String dest, QB qb, Operator<?> input) throws SemanticException {
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        Operator<?> op = this.genSelectPlan(selExprList, qb, input, false);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created Select Plan for clause: " + dest));
        }
        return op;
    }

    private Operator<?> genSelectPlan(ASTNode selExprList, QB qb, Operator<?> input, boolean outerLV) throws SemanticException {
        int startPosn;
        boolean isInTransform;
        boolean hintPresent;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("tree: " + selExprList.toStringTree()));
        }
        ArrayList<ExprNodeDesc> col_list = new ArrayList<ExprNodeDesc>();
        RowResolver out_rwsch = new RowResolver();
        ASTNode trfm = null;
        Integer pos = 0;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        boolean selectStar = false;
        int posn = 0;
        boolean bl = hintPresent = selExprList.getChild(0).getType() == 652;
        if (hintPresent) {
            ++posn;
        }
        boolean subQuery = qb.getParseInfo().getIsSubQ();
        boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 809;
        if (isInTransform) {
            this.queryProperties.setUsesScript(true);
            this.globalLimitCtx.setHasTransformOrUDTF(true);
            trfm = (ASTNode)selExprList.getChild(posn).getChild(0);
        }
        boolean isUDTF = false;
        String udtfTableAlias = null;
        ArrayList<String> udtfColAliases = new ArrayList<String>();
        ASTNode udtfExpr = (ASTNode)selExprList.getChild(posn).getChild(0);
        GenericUDTF genericUDTF = null;
        int udtfExprType = udtfExpr.getType();
        if (udtfExprType == 639 || udtfExprType == 641) {
            String funcName = TypeCheckProcFactory.DefaultExprProcessor.getFunctionText(udtfExpr, true);
            FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcName);
            if (fi != null) {
                genericUDTF = fi.getGenericUDTF();
            }
            boolean bl3 = isUDTF = genericUDTF != null;
            if (isUDTF) {
                this.globalLimitCtx.setHasTransformOrUDTF(true);
            }
            if (isUDTF && !fi.isNative()) {
                this.unparseTranslator.addIdentifierTranslation((ASTNode)udtfExpr.getChild(0));
            }
            if (isUDTF && (selectStar = udtfExprType == 641)) {
                this.genColListRegex(".*", null, (ASTNode)udtfExpr.getChild(0), col_list, inputRR, pos, out_rwsch, qb.getAliases(), subQuery);
            }
        }
        if (isUDTF) {
            if (selExprList.getChildCount() > 1) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
            }
            ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
            block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                switch (selExprChild.getType()) {
                    case 26: {
                        udtfColAliases.add(SemanticAnalyzer.unescapeIdentifier(selExprChild.getText()));
                        this.unparseTranslator.addIdentifierTranslation(selExprChild);
                        continue block4;
                    }
                    case 770: {
                        assert (selExprChild.getChildCount() == 1);
                        udtfTableAlias = SemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                        qb.addAlias(udtfTableAlias);
                        this.unparseTranslator.addIdentifierTranslation((ASTNode)selExprChild.getChild(0));
                        continue block4;
                    }
                    default: {
                        assert (false);
                        continue block4;
                    }
                }
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("UDTF table alias is " + udtfTableAlias));
                this.LOG.debug((Object)("UDTF col aliases are " + udtfColAliases));
            }
        }
        ASTNode exprList = isInTransform ? (ASTNode)trfm.getChild(0) : (isUDTF ? udtfExpr : selExprList);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("genSelectPlan: input = " + inputRR.toString()));
        }
        int n = startPosn = isUDTF ? posn + 1 : posn;
        if (isInTransform) {
            startPosn = 0;
        }
        for (int i = startPosn; i < exprList.getChildCount(); ++i) {
            ASTNode expr;
            String colAlias;
            String tabAlias;
            boolean isWindowSpec;
            boolean hasAsClause;
            ASTNode child = (ASTNode)exprList.getChild(i);
            boolean bl4 = hasAsClause = !isInTransform && child.getChildCount() == 2;
            boolean bl5 = child.getChildCount() == 3 ? child.getChild(2).getType() == 824 : (isWindowSpec = false);
            if (!(isWindowSpec || isInTransform || isUDTF || child.getChildCount() <= 2)) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
            }
            if (isInTransform || isUDTF) {
                tabAlias = null;
                colAlias = this.autogenColAliasPrfxLbl + i;
                expr = child;
            } else {
                expr = (ASTNode)child.getChild(0);
                String[] colRef = SemanticAnalyzer.getColAlias(child, this.autogenColAliasPrfxLbl, inputRR, this.autogenColAliasPrfxIncludeFuncName, i);
                tabAlias = colRef[0];
                colAlias = colRef[1];
                if (hasAsClause) {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)child.getChild(1));
                }
            }
            if (expr.getType() == 553) {
                pos = this.genColListRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, col_list, inputRR, pos, out_rwsch, qb.getAliases(), subQuery);
                selectStar = true;
                continue;
            }
            if (expr.getType() == 794 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()))) {
                pos = this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, col_list, inputRR, pos, out_rwsch, qb.getAliases(), subQuery);
                continue;
            }
            if (expr.getType() == 17 && expr.getChild(0).getType() == 794 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()))) {
                pos = this.genColListRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, col_list, inputRR, pos, out_rwsch, qb.getAliases(), subQuery);
                continue;
            }
            TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR);
            tcCtx.setAllowStatefulFunctions(true);
            ExprNodeDesc exp = this.genExprNodeDesc(expr, inputRR, tcCtx);
            String recommended = this.recommendName(exp, colAlias);
            if (recommended != null && out_rwsch.get(null, recommended) == null) {
                colAlias = recommended;
            }
            col_list.add(exp);
            if (subQuery) {
                out_rwsch.checkColumn(tabAlias, colAlias);
            }
            ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getWritableObjectInspector(), tabAlias, false);
            colInfo.setSkewedCol(exp instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)exp).isSkewedCol() : false);
            out_rwsch.put(tabAlias, colAlias, colInfo);
            pos = pos + 1;
        }
        selectStar = selectStar && exprList.getChildCount() == posn + 1;
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < col_list.size(); ++i) {
            if (col_list.get(i) instanceof ExprNodeNullDesc) {
                col_list.set(i, new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, null));
            }
            String outputCol = SemanticAnalyzer.getColumnInternalName(i);
            colExprMap.put(outputCol, col_list.get(i));
            columnNames.add(outputCol);
        }
        Operator output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(col_list, columnNames, selectStar), new RowSchema(out_rwsch.getColumnInfos()), input), out_rwsch);
        output.setColumnExprMap(colExprMap);
        if (isInTransform) {
            output = this.genScriptPlan(trfm, qb, output);
        }
        if (isUDTF) {
            output = this.genUDTFPlan(genericUDTF, udtfTableAlias, udtfColAliases, qb, output, outerLV);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created Select Plan row schema: " + out_rwsch.toString()));
        }
        return output;
    }

    private String recommendName(ExprNodeDesc exp, String colAlias) {
        if (!colAlias.startsWith(this.autogenColAliasPrfxLbl)) {
            return null;
        }
        String column = ExprNodeDescUtils.recommendInputName(exp);
        if (column != null && !column.startsWith(this.autogenColAliasPrfxLbl)) {
            return column;
        }
        return null;
    }

    static ArrayList<TypeInfo> getTypeInfo(ArrayList<ExprNodeDesc> exprs) {
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (ExprNodeDesc expr : exprs) {
            result.add(expr.getTypeInfo());
        }
        return result;
    }

    static ArrayList<ObjectInspector> getWritableObjectInspector(ArrayList<ExprNodeDesc> exprs) {
        ArrayList<ObjectInspector> result = new ArrayList<ObjectInspector>();
        for (ExprNodeDesc expr : exprs) {
            result.add(expr.getWritableObjectInspector());
        }
        return result;
    }

    static ObjectInspector[] getStandardObjectInspector(ArrayList<TypeInfo> exprs) {
        ObjectInspector[] result = new ObjectInspector[exprs.size()];
        for (int i = 0; i < exprs.size(); ++i) {
            result[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(exprs.get(i));
        }
        return result;
    }

    static GenericUDAFEvaluator getGenericUDAFEvaluator(String aggName, ArrayList<ExprNodeDesc> aggParameters, ASTNode aggTree, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        ArrayList<ObjectInspector> originalParameterTypeInfos = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
        GenericUDAFEvaluator result = FunctionRegistry.getGenericUDAFEvaluator(aggName, originalParameterTypeInfos, isDistinct, isAllColumns);
        if (null == result) {
            String reason = "Looking for UDAF Evaluator\"" + aggName + "\" with parameters " + originalParameterTypeInfos;
            throw new SemanticException(ErrorMsg.INVALID_FUNCTION_SIGNATURE.getMsg((ASTNode)aggTree.getChild(0), reason));
        }
        return result;
    }

    static GenericUDAFInfo getGenericUDAFInfo(GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode emode, ArrayList<ExprNodeDesc> aggParameters) throws SemanticException {
        GenericUDAFInfo r = new GenericUDAFInfo();
        r.genericUDAFEvaluator = evaluator;
        ObjectInspector returnOI = null;
        try {
            ArrayList<ObjectInspector> aggOIs = SemanticAnalyzer.getWritableObjectInspector(aggParameters);
            ObjectInspector[] aggOIArray = new ObjectInspector[aggOIs.size()];
            for (int ii = 0; ii < aggOIs.size(); ++ii) {
                aggOIArray[ii] = aggOIs.get(ii);
            }
            returnOI = r.genericUDAFEvaluator.init(emode, aggOIArray);
            r.returnType = TypeInfoUtils.getTypeInfoFromObjectInspector(returnOI);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        r.convertedParameters = aggParameters;
        return r;
    }

    private static GenericUDAFEvaluator.Mode groupByDescModeToUDAFMode(GroupByDesc.Mode mode, boolean isDistinct) {
        switch (mode) {
            case COMPLETE: {
                return GenericUDAFEvaluator.Mode.COMPLETE;
            }
            case PARTIAL1: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case PARTIAL2: {
                return GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case PARTIALS: {
                return isDistinct ? GenericUDAFEvaluator.Mode.PARTIAL1 : GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case FINAL: {
                return GenericUDAFEvaluator.Mode.FINAL;
            }
            case HASH: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case MERGEPARTIAL: {
                return isDistinct ? GenericUDAFEvaluator.Mode.COMPLETE : GenericUDAFEvaluator.Mode.FINAL;
            }
        }
        throw new RuntimeException("internal error in groupByDescModeToUDAFMode");
    }

    private ExprNodeDesc isConstantParameterInAggregationParameters(String internalName, List<ExprNodeDesc> reduceValues) {
        ExprNodeDesc reduceValue;
        int pos;
        String[] terms = internalName.split("\\.");
        if (terms.length != 2 || reduceValues == null) {
            return null;
        }
        if (Utilities.ReduceField.VALUE.toString().equals(terms[0]) && (pos = SemanticAnalyzer.getPositionFromInternalName(terms[1])) >= 0 && pos < reduceValues.size() && (reduceValue = reduceValues.get(pos)) != null && reduceValue.getWritableObjectInspector() instanceof ConstantObjectInspector) {
            return reduceValue;
        }
        return null;
    }

    private Operator genGroupByPlanGroupByOperator(QBParseInfo parseInfo, String dest, Operator input, ReduceSinkOperator rs, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(input).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), exprInfo.getInternalName(), "", false));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(grpbyExpr, new ColumnInfo(field, exprInfo.getType(), null, false));
            colExprMap.put(field, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        String lastKeyColName = null;
        ArrayList<String> inputKeyCols = ((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames();
        if (inputKeyCols.size() > 0) {
            lastKeyColName = (String)inputKeyCols.get(inputKeyCols.size() - 1);
        }
        ArrayList<ExprNodeDesc> reduceValues = ((ReduceSinkDesc)rs.getConf()).getValueCols();
        int numDistinctUDFs = 0;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            boolean isDistinct = value.getType() == 640;
            boolean isAllColumns = value.getType() == 641;
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(paraExpr);
                if (paraExprInfo == null) {
                    throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(paraExpr));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                if (isDistinct && lastKeyColName != null) {
                    paraExpression = Utilities.ReduceField.KEY.name() + "." + lastKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(i - 1);
                }
                ExprNodeDesc expr = new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                ExprNodeDesc reduceValue = this.isConstantParameterInAggregationParameters(paraExprInfo.getInternalName(), reduceValues);
                if (reduceValue != null) {
                    expr = reduceValue;
                }
                aggParameters.add(expr);
            }
            if (isDistinct) {
                ++numDistinctUDFs;
            }
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, null, false, 0, numDistinctUDFs > 0), new RowSchema(groupByOutputRowResolver.getColumnInfos()), input), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void addGroupingSetKey(List<ExprNodeDesc> groupByKeys, RowResolver groupByInputRowResolver, RowResolver groupByOutputRowResolver, List<String> outputColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String groupingSetColumnName = groupByInputRowResolver.get(null, VirtualColumn.GROUPINGID.getName()).getInternalName();
        ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, groupingSetColumnName, null, false);
        groupByKeys.add(inputExpr);
        String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
        outputColumnNames.add(field);
        groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, TypeInfoFactory.stringTypeInfo, null, true));
        colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
    }

    private void processGroupingSetReduceSinkOperator(RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<ExprNodeDesc> reduceKeys, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String groupingSetColumnName = reduceSinkInputRowResolver.get(null, VirtualColumn.GROUPINGID.getName()).getInternalName();
        ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, groupingSetColumnName, null, false);
        reduceKeys.add(inputExpr);
        outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
        String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
        ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, true);
        reduceSinkOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), colInfo);
        colExprMap.put(colInfo.getInternalName(), inputExpr);
    }

    private Operator genGroupByPlanGroupByOperator1(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, boolean distPartAgg, List<Integer> groupingSets, boolean groupingSetsPresent, boolean groupingSetsNeedAdditionalMRJob) throws SemanticException {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        RowResolver groupByInputRowResolver = this.opParseCtx.get(reduceSinkOperatorInfo).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), exprInfo.getInternalName(), exprInfo.getTabAlias(), exprInfo.getIsVirtualCol()));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(grpbyExpr, new ColumnInfo(field, exprInfo.getType(), "", false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = 0;
        if (groupingSetsPresent) {
            if (!groupingSetsNeedAdditionalMRJob) {
                this.addGroupingSetKey(groupByKeys, groupByInputRowResolver, groupByOutputRowResolver, outputColumnNames, colExprMap);
            } else {
                groupingSetsPosition = groupByKeys.size();
                this.createNewGroupingKey(groupByKeys, outputColumnNames, groupByOutputRowResolver, colExprMap);
            }
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        String lastKeyColName = null;
        ArrayList<ExprNodeDesc> reduceValues = null;
        if (reduceSinkOperatorInfo.getConf() instanceof ReduceSinkDesc) {
            ArrayList<String> inputKeyCols = ((ReduceSinkDesc)reduceSinkOperatorInfo.getConf()).getOutputKeyColumnNames();
            if (inputKeyCols.size() > 0) {
                lastKeyColName = (String)inputKeyCols.get(inputKeyCols.size() - 1);
            }
            reduceValues = ((ReduceSinkDesc)reduceSinkOperatorInfo.getConf()).getValueCols();
        }
        int numDistinctUDFs = 0;
        boolean containsDistinctAggr = false;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            boolean partialAggDone;
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            boolean isDistinct = value.getType() == 640;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            boolean bl = partialAggDone = !distPartAgg && !isDistinct;
            if (!partialAggDone) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode paraExpr = (ASTNode)value.getChild(i);
                    ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(paraExpr);
                    if (paraExprInfo == null) {
                        throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(paraExpr));
                    }
                    String paraExpression = paraExprInfo.getInternalName();
                    assert (paraExpression != null);
                    if (isDistinct && lastKeyColName != null) {
                        paraExpression = Utilities.ReduceField.KEY.name() + "." + lastKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(i - 1);
                    }
                    ExprNodeDesc expr = new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                    ExprNodeDesc reduceValue = this.isConstantParameterInAggregationParameters(paraExprInfo.getInternalName(), reduceValues);
                    if (reduceValue != null) {
                        expr = reduceValue;
                    }
                    aggParameters.add(expr);
                }
            } else {
                ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(value);
                if (paraExprInfo == null) {
                    throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(value));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            }
            if (isDistinct) {
                ++numDistinctUDFs;
            }
            boolean isAllColumns = value.getType() == 641;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = null;
            if (distPartAgg) {
                genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
                assert (genericUDAFEvaluator != null);
                genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
            } else {
                genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
                assert (genericUDAFEvaluator != null);
            }
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != GroupByDesc.Mode.FINAL && isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, distPartAgg, groupByMemoryUsage, memoryThreshold, groupingSets, groupingSetsPresent && groupingSetsNeedAdditionalMRJob, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver.getColumnInfos()), reduceSinkOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void createNewGroupingKey(List<ExprNodeDesc> groupByKeys, List<String> outputColumnNames, RowResolver groupByOutputRowResolver, Map<String, ExprNodeDesc> colExprMap) {
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc("0");
        groupByKeys.add(constant);
        String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
        outputColumnNames.add(field);
        groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, TypeInfoFactory.stringTypeInfo, null, true));
        colExprMap.put(field, constant);
    }

    private Operator genGroupByPlanMapGroupByOperator(QB qb, String dest, List<ASTNode> grpByExprs, Operator inputOperatorInfo, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, List<Integer> groupingSetKeys, boolean groupingSetsPresent) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ExprNodeDesc grpByExprNode = this.genExprNodeDesc(grpbyExpr, groupByInputRowResolver);
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(grpbyExpr, new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = groupByKeys.size();
        if (groupingSetsPresent) {
            this.createNewGroupingKey(groupByKeys, outputColumnNames, groupByOutputRowResolver, colExprMap);
        }
        if (!parseInfo.getDistinctFuncExprsForClause(dest).isEmpty()) {
            List<ASTNode> list = parseInfo.getDistinctFuncExprsForClause(dest);
            for (ASTNode value : list) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)value.getChild(i);
                    if (groupByOutputRowResolver.getExpression(parameter) != null) continue;
                    ExprNodeDesc distExprNode = this.genExprNodeDesc(parameter, groupByInputRowResolver);
                    groupByKeys.add(distExprNode);
                    String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
                    outputColumnNames.add(field);
                    groupByOutputRowResolver.putExpression(parameter, new ColumnInfo(field, distExprNode.getTypeInfo(), "", false));
                    colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
                }
            }
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        boolean containsDistinctAggr = false;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            new ArrayList();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = value.getType() == 640;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            boolean isAllColumns = value.getType() == 641;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, groupingSetKeys, groupingSetsPresent, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private ReduceSinkOperator genGroupByPlanReduceSinkOperator(QB qb, String dest, Operator inputOperatorInfo, List<ASTNode> grpByExprs, int numPartitionFields, boolean changeNumPartitionFields, int numReducers, boolean mapAggrDone, boolean groupingSetsPresent) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> reduceKeys = this.getReduceKeysForReduceSink(grpByExprs, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        if (groupingSetsPresent) {
            this.processGroupingSetReduceSinkOperator(reduceSinkInputRowResolver, reduceSinkOutputRowResolver, reduceKeys, outputKeyColumnNames, colExprMap);
            if (changeNumPartitionFields) {
                ++numPartitionFields;
            }
        }
        List<List<Integer>> distinctColIndices = this.getDistinctColIndicesForReduceSink(parseInfo, dest, reduceKeys, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        if (!mapAggrDone) {
            this.getReduceValuesForReduceSinkNoMapAgg(parseInfo, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputValueColumnNames, reduceValues, colExprMap);
        } else {
            int inputField = reduceKeys.size();
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                TypeInfo type = reduceSinkInputRowResolver.getColumnInfos().get(inputField).getType();
                ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(type, SemanticAnalyzer.getColumnInternalName(inputField), "", false);
                reduceValues.add(exprDesc);
                ++inputField;
                outputValueColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                reduceSinkOutputRowResolver.putExpression(entry.getValue(), new ColumnInfo(field, type, null, false));
                colExprMap.put(field, exprDesc);
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, groupingSetsPresent ? grpByExprs.size() + 1 : grpByExprs.size(), reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, numPartitionFields, numReducers), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private ArrayList<ExprNodeDesc> getReduceKeysForReduceSink(List<ASTNode> grpByExprs, String dest, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ExprNodeDesc inputExpr = this.genExprNodeDesc(grpbyExpr, reduceSinkInputRowResolver);
            reduceKeys.add(inputExpr);
            if (reduceSinkOutputRowResolver.getExpression(grpbyExpr) != null) {
                throw new SemanticException(ErrorMsg.DUPLICATE_GROUPBY_KEY.getMsg(grpbyExpr));
            }
            outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, false);
            reduceSinkOutputRowResolver.putExpression(grpbyExpr, colInfo);
            colExprMap.put(colInfo.getInternalName(), inputExpr);
        }
        return reduceKeys;
    }

    private List<List<Integer>> getDistinctColIndicesForReduceSink(QBParseInfo parseInfo, String dest, List<ExprNodeDesc> reduceKeys, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        ArrayList<List<Integer>> distinctColIndices = new ArrayList<List<Integer>>();
        if (!parseInfo.getDistinctFuncExprsForClause(dest).isEmpty()) {
            List<ASTNode> distFuncs = parseInfo.getDistinctFuncExprsForClause(dest);
            String colName = SemanticAnalyzer.getColumnInternalName(reduceKeys.size());
            outputKeyColumnNames.add(colName);
            for (int i = 0; i < distFuncs.size(); ++i) {
                ASTNode value = distFuncs.get(i);
                int numExprs = 0;
                ArrayList<Integer> distinctIndices = new ArrayList<Integer>();
                for (int j = 1; j < value.getChildCount(); ++j) {
                    int ri;
                    ASTNode parameter = (ASTNode)value.getChild(j);
                    ExprNodeDesc expr = this.genExprNodeDesc(parameter, reduceSinkInputRowResolver);
                    for (ri = 0; ri < reduceKeys.size() && !reduceKeys.get(ri).getExprString().equals(expr.getExprString()); ++ri) {
                    }
                    if (ri == reduceKeys.size()) {
                        reduceKeys.add(expr);
                    }
                    distinctIndices.add(ri);
                    String name = SemanticAnalyzer.getColumnInternalName(numExprs);
                    String field = Utilities.ReduceField.KEY.toString() + "." + colName + ":" + i + "." + name;
                    ColumnInfo colInfo = new ColumnInfo(field, expr.getTypeInfo(), null, false);
                    reduceSinkOutputRowResolver.putExpression(parameter, colInfo);
                    colExprMap.put(field, expr);
                    ++numExprs;
                }
                distinctColIndices.add(distinctIndices);
            }
        }
        return distinctColIndices;
    }

    private void getReduceValuesForReduceSinkNoMapAgg(QBParseInfo parseInfo, String dest, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputValueColumnNames, ArrayList<ExprNodeDesc> reduceValues, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)value.getChild(i);
                if (reduceSinkOutputRowResolver.getExpression(parameter) != null) continue;
                ExprNodeDesc exprDesc = this.genExprNodeDesc(parameter, reduceSinkInputRowResolver);
                reduceValues.add(exprDesc);
                outputValueColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                reduceSinkOutputRowResolver.putExpression(parameter, new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), null, false));
                colExprMap.put(field, exprDesc);
            }
        }
    }

    private ReduceSinkOperator genCommonGroupByPlanReduceSinkOperator(QB qb, List<String> dests, Operator inputOperatorInfo) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        String dest = dests.get(0);
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        ArrayList<ExprNodeDesc> reduceKeys = this.getReduceKeysForReduceSink(grpByExprs, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        List<List<Integer>> distinctColIndices = this.getDistinctColIndicesForReduceSink(parseInfo, dest, reduceKeys, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        for (String destination : dests) {
            this.getReduceValuesForReduceSinkNoMapAgg(parseInfo, destination, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputValueColumnNames, reduceValues, colExprMap);
            ASTNode whereClause = parseInfo.getWhrForClause(destination);
            if (whereClause == null) continue;
            assert (whereClause.getChildCount() == 1);
            ASTNode predicates = (ASTNode)whereClause.getChild(0);
            Map<ASTNode, ExprNodeDesc> nodeOutputs = this.genAllExprNodeDesc(predicates, reduceSinkInputRowResolver);
            this.removeMappingForKeys(predicates, nodeOutputs, reduceKeys);
            for (Map.Entry<ASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
                ASTNode parameter = entry.getKey();
                ExprNodeDesc expression = entry.getValue();
                if (!(expression instanceof ExprNodeColumnDesc) || ExprNodeDescUtils.indexOf(expression, reduceValues) >= 0) continue;
                String internalName = SemanticAnalyzer.getColumnInternalName(reduceValues.size());
                String field = Utilities.ReduceField.VALUE.toString() + "." + internalName;
                reduceValues.add(expression);
                outputValueColumnNames.add(internalName);
                reduceSinkOutputRowResolver.putExpression(parameter, new ColumnInfo(field, expression.getTypeInfo(), null, false));
                colExprMap.put(field, expression);
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, grpByExprs.size(), reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, grpByExprs.size(), -1), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private void removeMappingForKeys(ASTNode predicate, Map<ASTNode, ExprNodeDesc> mapping, List<ExprNodeDesc> keys) {
        ExprNodeDesc expr = mapping.get(predicate);
        if (expr != null && ExprNodeDescUtils.indexOf(expr, keys) >= 0) {
            this.removeRecursively(predicate, mapping);
        } else {
            for (int i = 0; i < predicate.getChildCount(); ++i) {
                this.removeMappingForKeys((ASTNode)predicate.getChild(i), mapping, keys);
            }
        }
    }

    private void removeRecursively(ASTNode current, Map<ASTNode, ExprNodeDesc> mapping) {
        mapping.remove(current);
        for (int i = 0; i < current.getChildCount(); ++i) {
            this.removeRecursively((ASTNode)current.getChild(i), mapping);
        }
    }

    private Operator genGroupByPlanReduceSinkOperator2MR(QBParseInfo parseInfo, String dest, Operator groupByOperatorInfo, int numPartitionFields, int numReducers, boolean groupingSetsPresent) throws SemanticException {
        RowResolver reduceSinkInputRowResolver2 = this.opParseCtx.get(groupByOperatorInfo).getRowResolver();
        RowResolver reduceSinkOutputRowResolver2 = new RowResolver();
        reduceSinkOutputRowResolver2.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            TypeInfo typeInfo = reduceSinkInputRowResolver2.getExpression(grpbyExpr).getType();
            ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(typeInfo, field, "", false);
            reduceKeys.add(inputExpr);
            ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.KEY.toString() + "." + field, typeInfo, "", false);
            reduceSinkOutputRowResolver2.putExpression(grpbyExpr, colInfo);
            colExprMap.put(colInfo.getInternalName(), inputExpr);
        }
        if (groupingSetsPresent) {
            this.processGroupingSetReduceSinkOperator(reduceSinkInputRowResolver2, reduceSinkOutputRowResolver2, reduceKeys, outputColumnNames, colExprMap);
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        int inputField = reduceKeys.size();
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            String field = SemanticAnalyzer.getColumnInternalName(inputField);
            ASTNode t = entry.getValue();
            TypeInfo typeInfo = reduceSinkInputRowResolver2.getExpression(t).getType();
            ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(typeInfo, field, "", false);
            reduceValues.add(exprDesc);
            ++inputField;
            String col = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
            outputColumnNames.add(col);
            reduceSinkOutputRowResolver2.putExpression(t, new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + col, typeInfo, "", false));
            colExprMap.put(col, exprDesc);
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, numPartitionFields, numReducers), new RowSchema(reduceSinkOutputRowResolver2.getColumnInfos()), groupByOperatorInfo), reduceSinkOutputRowResolver2);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genGroupByPlanGroupByOperator2MR(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo2, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, boolean groupingSetsPresent) throws SemanticException {
        RowResolver groupByInputRowResolver2 = this.opParseCtx.get(reduceSinkOperatorInfo2).getRowResolver();
        RowResolver groupByOutputRowResolver2 = new RowResolver();
        groupByOutputRowResolver2.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver2.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(grpbyExpr));
            }
            String expression = exprInfo.getInternalName();
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), expression, exprInfo.getTabAlias(), exprInfo.getIsVirtualCol()));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver2.putExpression(grpbyExpr, new ColumnInfo(field, exprInfo.getType(), "", false));
            colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
        }
        if (groupingSetsPresent) {
            this.addGroupingSetKey(groupByKeys, groupByInputRowResolver2, groupByOutputRowResolver2, outputColumnNames, colExprMap);
        }
        HashMap<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        boolean containsDistinctAggr = false;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            ASTNode value = entry.getValue();
            ColumnInfo paraExprInfo = groupByInputRowResolver2.getExpression(value);
            if (paraExprInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(value));
            }
            String paraExpression = paraExprInfo.getInternalName();
            assert (paraExpression != null);
            aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            boolean isDistinct = value.getType() == 640;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            boolean isStar = value.getType() == 641;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != GroupByDesc.Mode.FINAL && value.getToken().getType() == 640, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver2.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, null, false, 0, containsDistinctAggr), new RowSchema(groupByOutputRowResolver2.getColumnInfos()), reduceSinkOperatorInfo2), groupByOutputRowResolver2);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlan1MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        int numReducers = -1;
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        if (!groupingSets.isEmpty()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs, grpByExprs.size(), false, numReducers, false, false);
        Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, reduceSinkOperatorInfo, GroupByDesc.Mode.COMPLETE, null);
        return groupByOperatorInfo;
    }

    private Operator genGroupByPlan1ReduceMultiGBY(List<String> dests, QB qb, Operator input) throws SemanticException {
        Operator forwardOp;
        QBParseInfo parseInfo = qb.getParseInfo();
        ExprNodeDesc previous = null;
        Operator<FilterDesc> selectInput = input;
        ArrayList<ExprNodeDesc.ExprNodeDescEqualityWrapper> whereExpressions = new ArrayList<ExprNodeDesc.ExprNodeDescEqualityWrapper>();
        for (String dest : dests) {
            ASTNode whereExpr = parseInfo.getWhrForClause(dest);
            if (whereExpr != null) {
                OpParseContext inputCtx = this.opParseCtx.get(input);
                RowResolver inputRR = inputCtx.getRowResolver();
                ExprNodeDesc current = this.genExprNodeDesc((ASTNode)whereExpr.getChild(0), inputRR);
                ExprNodeDesc.ExprNodeDescEqualityWrapper currentWrapped = new ExprNodeDesc.ExprNodeDescEqualityWrapper(current);
                if (whereExpressions.contains(currentWrapped)) continue;
                whereExpressions.add(currentWrapped);
                if (previous == null) {
                    previous = current;
                    continue;
                }
                GenericUDFOPOr or = new GenericUDFOPOr();
                ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(2);
                expressions.add(previous);
                expressions.add(current);
                ExprNodeGenericFuncDesc orExpr = new ExprNodeGenericFuncDesc(TypeInfoFactory.booleanTypeInfo, (GenericUDF)or, expressions);
                previous = orExpr;
                continue;
            }
            previous = null;
            break;
        }
        if (previous != null) {
            OpParseContext inputCtx = this.opParseCtx.get(input);
            RowResolver inputRR = inputCtx.getRowResolver();
            FilterDesc orFilterDesc = new FilterDesc(previous, false);
            selectInput = this.putOpInsertMap(OperatorFactory.getAndMakeChild(orFilterDesc, new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        }
        Operator select = this.insertSelectAllPlanForGroupBy(selectInput);
        ReduceSinkOperator reduceSinkOperatorInfo = this.genCommonGroupByPlanReduceSinkOperator(qb, dests, select);
        RowResolver reduceSinkOperatorInfoRR = this.opParseCtx.get(reduceSinkOperatorInfo).getRowResolver();
        Operator curr = forwardOp = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ForwardDesc(), new RowSchema(reduceSinkOperatorInfoRR.getColumnInfos()), reduceSinkOperatorInfo), reduceSinkOperatorInfoRR);
        for (String dest : dests) {
            curr = forwardOp;
            if (parseInfo.getWhrForClause(dest) != null) {
                curr = this.genFilterPlan(dest, qb, forwardOp);
            }
            Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, curr, reduceSinkOperatorInfo, GroupByDesc.Mode.COMPLETE, null);
            curr = this.genPostGroupByBodyPlan(groupByOperatorInfo, dest, qb);
        }
        return curr;
    }

    static ArrayList<GenericUDAFEvaluator> getUDAFEvaluators(ArrayList<AggregationDesc> aggs) {
        ArrayList<GenericUDAFEvaluator> result = new ArrayList<GenericUDAFEvaluator>();
        for (int i = 0; i < aggs.size(); ++i) {
            result.add(aggs.get(i).getGenericUDAFEvaluator());
        }
        return result;
    }

    private Operator genGroupByPlan2MRMultiGroupBy(String dest, QB qb, Operator input) throws SemanticException {
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        QBParseInfo parseInfo = qb.getParseInfo();
        Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator1(parseInfo, dest, input, GroupByDesc.Mode.HASH, genericUDAFEvaluators, true, null, false, false);
        int numReducers = -1;
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(parseInfo, dest);
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo, grpByExprs.size(), numReducers, false);
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, false);
        return groupByOperatorInfo2;
    }

    private Operator genGroupByPlan2MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        if (!groupingSets.isEmpty()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest).isEmpty() ? -1 : Integer.MAX_VALUE, false, -1, false, false);
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIAL1, genericUDAFEvaluators);
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo, grpByExprs.size(), numReducers, false);
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, false);
        return groupByOperatorInfo2;
    }

    private boolean optimizeMapAggrGroupBy(String dest, QB qb) {
        List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(qb.getParseInfo(), dest);
        if (grpByExprs != null && !grpByExprs.isEmpty()) {
            return false;
        }
        return qb.getParseInfo().getDistinctFuncExprsForClause(dest).isEmpty();
    }

    private static void extractColumns(Set<String> colNamesExprs, ExprNodeDesc exprNode) throws SemanticException {
        if (exprNode instanceof ExprNodeColumnDesc) {
            colNamesExprs.add(((ExprNodeColumnDesc)exprNode).getColumn());
            return;
        }
        if (exprNode instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)exprNode;
            for (ExprNodeDesc childExpr : funcDesc.getChildExprs()) {
                SemanticAnalyzer.extractColumns(colNamesExprs, childExpr);
            }
        }
    }

    private static boolean hasCommonElement(Set<String> set1, Set<String> set2) {
        for (String elem1 : set1) {
            if (!set2.contains(elem1)) continue;
            return true;
        }
        return false;
    }

    private void checkExpressionsForGroupingSet(List<ASTNode> grpByExprs, List<ASTNode> distinctGrpByExprs, Map<String, ASTNode> aggregationTrees, RowResolver inputRowResolver) throws SemanticException {
        HashSet<String> colNamesGroupByExprs = new HashSet<String>();
        HashSet<String> colNamesGroupByDistinctExprs = new HashSet<String>();
        HashSet<String> colNamesAggregateParameters = new HashSet<String>();
        for (ASTNode aSTNode : grpByExprs) {
            SemanticAnalyzer.extractColumns(colNamesGroupByExprs, this.genExprNodeDesc(aSTNode, inputRowResolver));
        }
        if (!distinctGrpByExprs.isEmpty()) {
            for (ASTNode aSTNode : distinctGrpByExprs) {
                for (int i = 1; i < aSTNode.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)aSTNode.getChild(i);
                    ExprNodeDesc distExprNode = this.genExprNodeDesc(parameter, inputRowResolver);
                    SemanticAnalyzer.extractColumns(colNamesGroupByDistinctExprs, distExprNode);
                }
                if (!SemanticAnalyzer.hasCommonElement(colNamesGroupByExprs, colNamesGroupByDistinctExprs)) continue;
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID.getMsg());
            }
        }
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            ASTNode value = (ASTNode)entry.getValue();
            ArrayList aggParameters = new ArrayList();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, inputRowResolver);
                SemanticAnalyzer.extractColumns(colNamesAggregateParameters, paraExprNode);
            }
            if (!SemanticAnalyzer.hasCommonElement(colNamesGroupByExprs, colNamesAggregateParameters)) continue;
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_EXPRESSION_INVALID.getMsg());
        }
    }

    private Operator genGroupByPlanMapAggrNoSkew(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        boolean isDistinct;
        QBParseInfo parseInfo = qb.getParseInfo();
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        boolean groupingSetsPresent = !groupingSets.isEmpty();
        int newMRJobGroupingSetsThreshold = this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
        if (groupingSetsPresent) {
            this.checkExpressionsForGroupingSet(grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest), parseInfo.getAggregationExprsForClause(dest), this.opParseCtx.get(inputOperatorInfo).getRowResolver());
        }
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        boolean groupingSetsNeedAdditionalMRJob = groupingSetsPresent && groupingSets.size() > newMRJobGroupingSetsThreshold;
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, grpByExprs, inputOperatorInfo, GroupByDesc.Mode.HASH, genericUDAFEvaluators, groupingSets, groupingSetsPresent && !groupingSetsNeedAdditionalMRJob);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRowResolver().getTableNames());
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        boolean bl = isDistinct = !qb.getParseInfo().getDistinctFuncExprsForClause(dest).isEmpty();
        if (groupingSetsNeedAdditionalMRJob && isDistinct) {
            String errorMsg = "The number of rows per input row due to grouping sets is " + groupingSets.size();
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_DISTINCTS.getMsg(errorMsg));
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, grpByExprs.size(), true, numReducers, true, groupingSetsPresent && !groupingSetsNeedAdditionalMRJob);
        if (!groupingSetsPresent || !groupingSetsNeedAdditionalMRJob) {
            return this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.MERGEPARTIAL, genericUDAFEvaluators, false, groupingSets, groupingSetsPresent, groupingSetsNeedAdditionalMRJob);
        }
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIALS, genericUDAFEvaluators, false, groupingSets, groupingSetsPresent, groupingSetsNeedAdditionalMRJob);
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size() + 1, numReducers, groupingSetsPresent);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, groupingSetsPresent);
    }

    private Operator genGroupByPlanMapAggr2MR(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        boolean groupingSetsPresent;
        QBParseInfo parseInfo = qb.getParseInfo();
        ObjectPair<List<ASTNode>, List<Integer>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List<ASTNode> grpByExprs = grpByExprsGroupingSets.getFirst();
        List<Integer> groupingSets = grpByExprsGroupingSets.getSecond();
        boolean bl = groupingSetsPresent = !groupingSets.isEmpty();
        if (groupingSetsPresent) {
            this.checkExpressionsForGroupingSet(grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest), parseInfo.getAggregationExprsForClause(dest), this.opParseCtx.get(inputOperatorInfo).getRowResolver());
            int newMRJobGroupingSetsThreshold = this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
            if (groupingSets.size() > newMRJobGroupingSetsThreshold) {
                String errorMsg = "The number of rows per input row due to grouping sets is " + groupingSets.size();
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
            }
        }
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, grpByExprs, inputOperatorInfo, GroupByDesc.Mode.HASH, genericUDAFEvaluators, groupingSets, groupingSetsPresent);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRowResolver().getTableNames());
        if (!this.optimizeMapAggrGroupBy(dest, qb)) {
            List<ASTNode> distinctFuncExprs = parseInfo.getDistinctFuncExprsForClause(dest);
            ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, distinctFuncExprs.isEmpty() ? -1 : Integer.MAX_VALUE, false, -1, true, groupingSetsPresent);
            Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIALS, genericUDAFEvaluators, false, groupingSets, groupingSetsPresent, false);
            int numReducers = -1;
            if (grpByExprs.isEmpty()) {
                numReducers = 1;
            }
            Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size(), numReducers, groupingSetsPresent);
            return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, groupingSetsPresent);
        }
        assert (!groupingSetsPresent);
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, grpByExprs.size(), false, 1, true, groupingSetsPresent);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.FINAL, genericUDAFEvaluators, false);
    }

    private Operator genConversionOps(String dest, QB qb, Operator input) throws SemanticException {
        Integer dest_type = qb.getMetaData().getDestTypeForAlias(dest);
        switch (dest_type) {
            case 1: {
                qb.getMetaData().getDestTableForAlias(dest);
                break;
            }
            case 2: {
                qb.getMetaData().getDestPartitionForAlias(dest).getTable();
                break;
            }
            default: {
                return input;
            }
        }
        return input;
    }

    private int getReducersBucketing(int totalFiles, int maxReducers) {
        int numFiles = (int)Math.ceil((double)totalFiles / (double)maxReducers);
        while (totalFiles % numFiles != 0) {
            ++numFiles;
        }
        return totalFiles / numFiles;
    }

    private Operator genBucketingSortingDest(String dest, Operator input, QB qb, TableDesc table_desc, Table dest_tab, SortBucketRSCtx ctx) throws SemanticException {
        boolean enforceBucketing = false;
        boolean enforceSorting = false;
        ArrayList<ExprNodeDesc> partnCols = new ArrayList();
        ArrayList<ExprNodeDesc> partnColsNoConvert = new ArrayList();
        ArrayList<ExprNodeDesc> sortCols = new ArrayList();
        ArrayList<Integer> sortOrders = new ArrayList<Integer>();
        boolean multiFileSpray = false;
        int numFiles = 1;
        int totalFiles = 1;
        if (dest_tab.getNumBuckets() > 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVEENFORCEBUCKETING)) {
            enforceBucketing = true;
            partnCols = this.getParitionColsFromBucketCols(dest, qb, dest_tab, table_desc, input, true);
            partnColsNoConvert = this.getParitionColsFromBucketCols(dest, qb, dest_tab, table_desc, input, false);
        }
        if (dest_tab.getSortCols() != null && dest_tab.getSortCols().size() > 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVEENFORCESORTING)) {
            enforceSorting = true;
            sortCols = this.getSortCols(dest, qb, dest_tab, table_desc, input, true);
            sortOrders = this.getSortOrders(dest, qb, dest_tab, input);
            if (!enforceBucketing) {
                partnCols = sortCols;
                partnColsNoConvert = this.getSortCols(dest, qb, dest_tab, table_desc, input, false);
            }
        }
        if (enforceBucketing || enforceSorting) {
            int numBuckets;
            int maxReducers = this.conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
            if (this.conf.getIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS) > 0) {
                maxReducers = this.conf.getIntVar(HiveConf.ConfVars.HADOOPNUMREDUCERS);
            }
            if ((numBuckets = dest_tab.getNumBuckets()) > maxReducers) {
                multiFileSpray = true;
                totalFiles = numBuckets;
                if (totalFiles % maxReducers == 0) {
                    numFiles = totalFiles / maxReducers;
                } else {
                    maxReducers = this.getReducersBucketing(totalFiles, maxReducers);
                    numFiles = totalFiles / maxReducers;
                }
            } else {
                maxReducers = numBuckets;
            }
            input = this.genReduceSinkPlanForSortingBucketing(dest_tab, input, sortCols, sortOrders, partnCols, maxReducers);
            ctx.setMultiFileSpray(multiFileSpray);
            ctx.setNumFiles(numFiles);
            ctx.setPartnCols(partnColsNoConvert);
            ctx.setTotalFiles(totalFiles);
        }
        return input;
    }

    private boolean checkHoldDDLTime(QB qb) {
        ASTNode hints = qb.getParseInfo().getHints();
        if (hints == null) {
            return false;
        }
        for (int pos = 0; pos < hints.getChildCount(); ++pos) {
            ASTNode hint = (ASTNode)hints.getChild(pos);
            if (((ASTNode)hint.getChild(0)).getToken().getType() != 653) continue;
            return true;
        }
        return false;
    }

    private Operator genFileSinkPlan(String dest, QB qb, Operator input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        QBMetaData qbm = qb.getMetaData();
        Integer dest_type = qbm.getDestTypeForAlias(dest);
        Table dest_tab = null;
        Partition dest_part = null;
        String queryTmpdir = null;
        Path dest_path = null;
        TableDesc table_desc = null;
        int currentTableId = 0;
        boolean isLocal = false;
        SortBucketRSCtx rsCtx = new SortBucketRSCtx();
        DynamicPartitionCtx dpCtx = null;
        LoadTableDesc ltd = null;
        boolean holdDDLTime = this.checkHoldDDLTime(qb);
        ListBucketingCtx lbCtx = null;
        switch (dest_type) {
            case 1: {
                boolean isNonNativeTable;
                dest_tab = qbm.getDestTableForAlias(dest);
                if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_INSERT_INTO_EXTERNAL_TABLES) && dest_tab.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
                    throw new SemanticException(ErrorMsg.INSERT_EXTERNAL_TABLE.getMsg(dest_tab.getTableName()));
                }
                Map<String, String> partSpec = qbm.getPartSpecForAlias(dest);
                dest_path = dest_tab.getPath();
                List<FieldSchema> parts = dest_tab.getPartitionKeys();
                if (parts != null && parts.size() > 0) {
                    if (partSpec == null || partSpec.size() == 0) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.NEED_PARTITION_ERROR.getMsg()));
                    }
                    if (holdDDLTime) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.HOLD_DDLTIME_ON_NONEXIST_PARTITIONS.getMsg()));
                    }
                    dpCtx = qbm.getDPCtx(dest);
                    if (dpCtx == null) {
                        Utilities.validatePartSpec(dest_tab, partSpec);
                        dpCtx = new DynamicPartitionCtx(dest_tab, partSpec, this.conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME), this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTSPERNODE));
                        qbm.setDPCtx(dest, dpCtx);
                    }
                    if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.DYNAMIC_PARTITION_DISABLED.getMsg()));
                    }
                    HiveConf.setBoolVar(this.conf, HiveConf.ConfVars.HIVEJOBPROGRESS, true);
                    if (dpCtx.getSPPath() != null) {
                        dest_path = new Path(dest_tab.getPath(), dpCtx.getSPPath());
                    }
                    if (dest_tab.getNumBuckets() > 0 && this.conf.getBoolVar(HiveConf.ConfVars.HIVEENFORCEBUCKETING)) {
                        dpCtx.setNumBuckets(dest_tab.getNumBuckets());
                    }
                }
                queryTmpdir = (isNonNativeTable = dest_tab.isNonNative()) ? dest_path.toUri().getPath() : this.ctx.getExternalTmpFileURI(dest_path.toUri());
                if (dpCtx != null) {
                    dpCtx.setRootPath(queryTmpdir);
                }
                table_desc = Utilities.getTableDesc(dest_tab);
                input = this.genBucketingSortingDest(dest, input, qb, table_desc, dest_tab, rsCtx);
                this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_tab.getTableName());
                currentTableId = this.destTableId++;
                lbCtx = this.constructListBucketingCtx(dest_tab.getSkewedColNames(), dest_tab.getSkewedColValues(), dest_tab.getSkewedColValueLocationMaps(), dest_tab.isStoredAsSubDirectories(), this.conf);
                if (!isNonNativeTable) {
                    ltd = new LoadTableDesc(queryTmpdir, this.ctx.getExternalTmpFileURI(dest_path.toUri()), table_desc, dpCtx);
                    ltd.setReplace(!qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName()));
                    ltd.setLbCtx(lbCtx);
                    if (holdDDLTime) {
                        this.LOG.info((Object)"this query will not update transient_lastDdlTime!");
                        ltd.setHoldDDLTime(true);
                    }
                    this.loadTableWork.add(ltd);
                }
                WriteEntity output = null;
                if (!(dpCtx != null && dpCtx.getNumDPCols() != 0 || this.outputs.add(output = new WriteEntity(dest_tab)))) {
                    throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getTableName()));
                }
                if (dpCtx != null && dpCtx.getNumDPCols() >= 0) {
                    if (dpCtx.getNumSPCols() == 0) {
                        output = new WriteEntity(dest_tab, false);
                        this.outputs.add(output);
                    } else {
                        try {
                            String ppath = dpCtx.getSPPath();
                            ppath = ppath.substring(0, ppath.length() - 1);
                            DummyPartition p = new DummyPartition(dest_tab, dest_tab.getDbName() + "@" + dest_tab.getTableName() + "@" + ppath, partSpec);
                            output = new WriteEntity(p, false);
                            this.outputs.add(output);
                        }
                        catch (HiveException e) {
                            throw new SemanticException(e.getMessage(), e);
                        }
                    }
                }
                this.ctx.getLoadTableOutputMap().put(ltd, output);
                break;
            }
            case 2: {
                dest_part = qbm.getDestPartitionForAlias(dest);
                dest_tab = dest_part.getTable();
                if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_INSERT_INTO_EXTERNAL_TABLES) && dest_tab.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
                    throw new SemanticException(ErrorMsg.INSERT_EXTERNAL_TABLE.getMsg(dest_tab.getTableName()));
                }
                Path tabPath = dest_tab.getPath();
                Path partPath = dest_part.getPartitionPath();
                dest_path = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                queryTmpdir = this.ctx.getExternalTmpFileURI(dest_path.toUri());
                table_desc = Utilities.getTableDesc(dest_tab);
                input = this.genBucketingSortingDest(dest, input, qb, table_desc, dest_tab, rsCtx);
                this.idToTableNameMap.put(String.valueOf(this.destTableId), dest_tab.getTableName());
                currentTableId = this.destTableId++;
                lbCtx = this.constructListBucketingCtx(dest_part.getSkewedColNames(), dest_part.getSkewedColValues(), dest_part.getSkewedColValueLocationMaps(), dest_part.isStoredAsSubDirectories(), this.conf);
                ltd = new LoadTableDesc(queryTmpdir, this.ctx.getExternalTmpFileURI(dest_path.toUri()), table_desc, dest_part.getSpec());
                ltd.setReplace(!qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName()));
                ltd.setLbCtx(lbCtx);
                if (holdDDLTime) {
                    try {
                        Partition part = this.db.getPartition(dest_tab, dest_part.getSpec(), false);
                        if (part == null) {
                            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.HOLD_DDLTIME_ON_NONEXIST_PARTITIONS.getMsg()));
                        }
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e);
                    }
                    this.LOG.info((Object)"this query will not update transient_lastDdlTime!");
                    ltd.setHoldDDLTime(true);
                }
                this.loadTableWork.add(ltd);
                if (this.outputs.add(new WriteEntity(dest_part))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getTableName() + "@" + dest_part.getName()));
            }
            case 5: {
                isLocal = true;
            }
            case 3: {
                dest_path = new Path(qbm.getDestFileForAlias(dest));
                String destStr = dest_path.toString();
                if (isLocal) {
                    queryTmpdir = this.ctx.getMRTmpFileURI();
                } else {
                    try {
                        Path qPath = FileUtils.makeQualified(dest_path, this.conf);
                        queryTmpdir = this.ctx.getExternalTmpFileURI(qPath.toUri());
                    }
                    catch (Exception e) {
                        throw new SemanticException("Error creating temporary folder on: " + dest_path, e);
                    }
                }
                String cols = "";
                String colTypes = "";
                ArrayList<ColumnInfo> colInfos = inputRR.getColumnInfos();
                ArrayList<FieldSchema> field_schemas = null;
                CreateTableDesc tblDesc = qb.getTableDesc();
                if (tblDesc != null) {
                    field_schemas = new ArrayList<FieldSchema>();
                }
                boolean first = true;
                for (ColumnInfo colInfo : colInfos) {
                    String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
                    if (nm[1] != null) {
                        colInfo.setAlias(nm[1]);
                    }
                    if (field_schemas != null) {
                        FieldSchema col = new FieldSchema();
                        if ("".equals(nm[0]) || nm[1] == null) {
                            col.setName(colInfo.getInternalName());
                        } else {
                            col.setName(SemanticAnalyzer.unescapeIdentifier(colInfo.getAlias()).toLowerCase());
                        }
                        col.setType(colInfo.getType().getTypeName());
                        field_schemas.add(col);
                    }
                    if (!first) {
                        cols = cols.concat(",");
                        colTypes = colTypes.concat(":");
                    }
                    first = false;
                    cols = cols.concat(colInfo.getInternalName());
                    String tName = colInfo.getType().getTypeName();
                    if (tName.equals("void")) {
                        colTypes = colTypes.concat("string");
                        continue;
                    }
                    colTypes = colTypes.concat(tName);
                }
                if (tblDesc != null) {
                    tblDesc.setCols(new ArrayList<FieldSchema>(field_schemas));
                }
                if (!this.ctx.isMRTmpFileURI(destStr)) {
                    this.idToTableNameMap.put(String.valueOf(this.destTableId), destStr);
                    currentTableId = this.destTableId++;
                }
                boolean isDfsDir = dest_type == 3;
                this.loadFileWork.add(new LoadFileDesc(tblDesc, queryTmpdir, destStr, isDfsDir, cols, colTypes));
                if (tblDesc == null) {
                    if (qb.getIsQuery()) {
                        String fileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                        table_desc = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, fileFormat);
                    } else {
                        table_desc = PlanUtils.getDefaultTableDesc(qb.getLLocalDirectoryDesc(), cols, colTypes);
                    }
                } else {
                    table_desc = PlanUtils.getTableDesc(tblDesc, cols, colTypes);
                }
                if (this.outputs.add(new WriteEntity(destStr, !isDfsDir))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(destStr));
            }
            default: {
                throw new SemanticException("Unknown destination type: " + dest_type);
            }
        }
        input = this.genConversionSelectOperator(dest, qb, input, table_desc, dpCtx);
        inputRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ColumnInfo> vecCol = new ArrayList<ColumnInfo>();
        try {
            StructObjectInspector rowObjectInspector = (StructObjectInspector)table_desc.getDeserializer().getObjectInspector();
            List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                vecCol.add(new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), "", false));
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), e);
        }
        RowSchema fsRS = new RowSchema(vecCol);
        boolean canBeMerged = dest_tab == null || (dest_tab.getNumBuckets() <= 0 || !this.conf.getBoolVar(HiveConf.ConfVars.HIVEENFORCEBUCKETING)) && (dest_tab.getSortCols() == null || dest_tab.getSortCols().size() <= 0 || !this.conf.getBoolVar(HiveConf.ConfVars.HIVEENFORCESORTING));
        FileSinkDesc fileSinkDesc = new FileSinkDesc(queryTmpdir, table_desc, this.conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT), currentTableId, rsCtx.isMultiFileSpray(), canBeMerged, rsCtx.getNumFiles(), rsCtx.getTotalFiles(), rsCtx.getPartnCols(), dpCtx);
        if (lbCtx != null) {
            lbCtx.processRowSkewedIndex(fsRS);
            lbCtx.calculateSkewedValueSubDirList();
        }
        fileSinkDesc.setLbCtx(lbCtx);
        fileSinkDesc.setStatsCollectRawDataSize(HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_RAWDATASIZE));
        fileSinkDesc.setStatsAggPrefix(fileSinkDesc.getDirName());
        if (dest_part != null) {
            try {
                String staticSpec = Warehouse.makePartPath(dest_part.getSpec());
                fileSinkDesc.setStaticSpec(staticSpec);
            }
            catch (MetaException e) {
                throw new SemanticException(e);
            }
        } else if (dpCtx != null) {
            fileSinkDesc.setStaticSpec(dpCtx.getSPPath());
        }
        Operator<FileSinkDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(fileSinkDesc, fsRS, input), inputRR);
        if (ltd != null && SessionState.get() != null) {
            SessionState.get().getLineageState().mapDirToFop(ltd.getSourceDir(), (FileSinkOperator)output);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created FileSink Plan for clause: " + dest + "dest_path: " + dest_path + " row schema: " + inputRR.toString()));
        }
        this.fsopToTable.put((FileSinkOperator)output, dest_tab);
        return output;
    }

    Operator genConversionSelectOperator(String dest, QB qb, Operator input, TableDesc table_desc, DynamicPartitionCtx dpCtx) throws SemanticException {
        int i;
        StructObjectInspector oi = null;
        try {
            Deserializer deserializer = table_desc.getDeserializerClass().newInstance();
            deserializer.initialize(this.conf, table_desc.getProperties());
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        List<? extends StructField> tableFields = oi.getAllStructFieldRefs();
        boolean dynPart = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING);
        ArrayList<ColumnInfo> rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        int inColumnCnt = rowFields.size();
        int outColumnCnt = tableFields.size();
        if (dynPart && dpCtx != null) {
            outColumnCnt += dpCtx.getNumDPCols();
        }
        if (inColumnCnt != outColumnCnt) {
            String reason = "Table " + dest + " has " + outColumnCnt + " columns, but query has " + inColumnCnt + " columns.";
            throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
        }
        if (dynPart && dpCtx != null) {
            dpCtx.mapInputToDP(rowFields.subList(tableFields.size(), rowFields.size()));
        }
        boolean converted = false;
        int columnNumber = tableFields.size();
        ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(columnNumber);
        boolean isMetaDataSerDe = table_desc.getDeserializerClass().equals(MetadataTypedColumnsetSerDe.class);
        boolean isLazySimpleSerDe = table_desc.getDeserializerClass().equals(LazySimpleSerDe.class);
        if (!isMetaDataSerDe) {
            for (i = 0; i < columnNumber; ++i) {
                ObjectInspector tableFieldOI = tableFields.get(i).getFieldObjectInspector();
                TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(tableFieldOI);
                TypeInfo rowFieldTypeInfo = rowFields.get(i).getType();
                ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(i).getInternalName(), "", false, rowFields.get(i).isSkewedCol());
                if (!(tableFieldTypeInfo.equals(rowFieldTypeInfo) || isLazySimpleSerDe && tableFieldTypeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && tableFieldTypeInfo.equals(TypeInfoFactory.stringTypeInfo))) {
                    converted = true;
                    column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)tableFieldTypeInfo);
                    if (column == null) {
                        String reason = "Cannot convert column " + i + " from " + rowFieldTypeInfo + " to " + tableFieldTypeInfo + ".";
                        throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
                    }
                }
                expressions.add(column);
            }
        }
        if (dynPart && dpCtx != null && dpCtx.getNumDPCols() > 0) {
            for (i = tableFields.size(); i < rowFields.size(); ++i) {
                TypeInfo rowFieldTypeInfo = rowFields.get(i).getType();
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(i).getInternalName(), "", false);
                expressions.add(column);
            }
        }
        if (converted) {
            RowResolver rowResolver = new RowResolver();
            ArrayList<String> colName = new ArrayList<String>();
            for (int i2 = 0; i2 < expressions.size(); ++i2) {
                String name = SemanticAnalyzer.getColumnInternalName(i2);
                rowResolver.put("", name, new ColumnInfo(name, expressions.get(i2).getTypeInfo(), "", false));
                colName.add(name);
            }
            Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(expressions, colName), new RowSchema(rowResolver.getColumnInfos()), input), rowResolver);
            return output;
        }
        return input;
    }

    private Operator genLimitPlan(String dest, QB qb, Operator input, int limit) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        LimitDesc limitDesc = new LimitDesc(limit);
        this.globalLimitCtx.setLastReduceLimitDesc(limitDesc);
        Operator<LimitDesc> limitMap = this.putOpInsertMap(OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created LimitOperator Plan for clause: " + dest + " row schema: " + inputRR.toString()));
        }
        return limitMap;
    }

    /*
     * WARNING - void declaration
     */
    private Operator genUDTFPlan(GenericUDTF genericUDTF, String outputTableAlias, ArrayList<String> colAliases, QB qb, Operator input, boolean outerLV) throws SemanticException {
        void var18_23;
        int numSuppliedAliases;
        QBParseInfo qbp = qb.getParseInfo();
        if (!qbp.getDestToGroupBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
        }
        if (!qbp.getDestToDistributeBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
        }
        if (!qbp.getDestToSortBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
        }
        if (!qbp.getDestToClusterBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
        }
        if (!qbp.getAliasToLateralViews().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Table alias: " + outputTableAlias + " Col aliases: " + colAliases));
        }
        RowResolver selectRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ColumnInfo> inputCols = selectRR.getColumnInfos();
        ArrayList<String> colNames = new ArrayList<String>();
        ObjectInspector[] colOIs = new ObjectInspector[inputCols.size()];
        for (int i = 0; i < inputCols.size(); ++i) {
            colNames.add(inputCols.get(i).getInternalName());
            colOIs[i] = inputCols.get(i).getObjectInspector();
        }
        StructObjectInspector outputOI = genericUDTF.initialize(colOIs);
        int numUdtfCols = outputOI.getAllStructFieldRefs().size();
        if (colAliases.isEmpty()) {
            for (StructField structField : outputOI.getAllStructFieldRefs()) {
                colAliases.add(structField.getFieldName());
            }
        }
        if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
            throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases " + "but got " + numSuppliedAliases));
        }
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        Iterator<String> colAliasesIter = colAliases.iterator();
        for (StructField structField : outputOI.getAllStructFieldRefs()) {
            String colAlias = colAliasesIter.next();
            assert (colAlias != null);
            ColumnInfo col = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), outputTableAlias, false);
            arrayList.add(col);
        }
        RowResolver out_rwsch = new RowResolver();
        boolean bl = false;
        while (var18_23 < arrayList.size()) {
            out_rwsch.put(outputTableAlias, colAliases.get((int)var18_23), (ColumnInfo)arrayList.get((int)var18_23));
            ++var18_23;
        }
        Operator<UDTFDesc> operator = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new UDTFDesc(genericUDTF, outerLV), new RowSchema(out_rwsch.getColumnInfos()), input), out_rwsch);
        return operator;
    }

    private Operator genLimitMapRedPlan(String dest, QB qb, Operator input, int limit, boolean extraMRStep) throws SemanticException {
        Operator curr = this.genLimitPlan(dest, qb, input, limit);
        if (!extraMRStep) {
            return curr;
        }
        curr = this.genReduceSinkPlan(dest, qb, curr, 1);
        return this.genLimitPlan(dest, qb, curr, limit);
    }

    private ArrayList<ExprNodeDesc> getParitionColsFromBucketCols(String dest, QB qb, Table tab, TableDesc table_desc, Operator input, boolean convert) throws SemanticException {
        List<String> tabBucketCols = tab.getBucketCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: for (String bucketCol : tabBucketCols) {
            int pos = 0;
            for (FieldSchema tabCol : tabCols) {
                if (bucketCol.equals(tabCol.getName())) {
                    posns.add(pos);
                    continue block0;
                }
                ++pos;
            }
        }
        return this.genConvertCol(dest, qb, tab, table_desc, input, posns, convert);
    }

    private ArrayList<ExprNodeDesc> genConvertCol(String dest, QB qb, Table tab, TableDesc table_desc, Operator input, List<Integer> posns, boolean convert) throws SemanticException {
        StructObjectInspector oi = null;
        try {
            Deserializer deserializer = table_desc.getDeserializerClass().newInstance();
            deserializer.initialize(this.conf, table_desc.getProperties());
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        List<? extends StructField> tableFields = oi.getAllStructFieldRefs();
        ArrayList<ColumnInfo> rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        int columnNumber = posns.size();
        ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(columnNumber);
        for (Integer posn : posns) {
            ObjectInspector tableFieldOI = tableFields.get(posn).getFieldObjectInspector();
            TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(tableFieldOI);
            TypeInfo rowFieldTypeInfo = rowFields.get(posn).getType();
            ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(posn).getInternalName(), rowFields.get(posn).getTabAlias(), rowFields.get(posn).getIsVirtualCol());
            if (convert && !tableFieldTypeInfo.equals(rowFieldTypeInfo) && (column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)tableFieldTypeInfo)) == null) {
                String reason = "Cannot convert column " + posn + " from " + rowFieldTypeInfo + " to " + tableFieldTypeInfo + ".";
                throw new SemanticException(ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(qb.getParseInfo().getDestForClause(dest), reason));
            }
            expressions.add(column);
        }
        return expressions;
    }

    private ArrayList<ExprNodeDesc> getSortCols(String dest, QB qb, Table tab, TableDesc table_desc, Operator input, boolean convert) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        List<Order> tabSortCols = tab.getSortCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: for (Order sortCol : tabSortCols) {
            int pos = 0;
            for (FieldSchema tabCol : tabCols) {
                if (sortCol.getCol().equals(tabCol.getName())) {
                    ColumnInfo colInfo = inputRR.getColumnInfos().get(pos);
                    posns.add(pos);
                    continue block0;
                }
                ++pos;
            }
        }
        return this.genConvertCol(dest, qb, tab, table_desc, input, posns, convert);
    }

    private ArrayList<Integer> getSortOrders(String dest, QB qb, Table tab, Operator input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        List<Order> tabSortCols = tab.getSortCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> orders = new ArrayList<Integer>();
        block0: for (Order sortCol : tabSortCols) {
            for (FieldSchema tabCol : tabCols) {
                if (!sortCol.getCol().equals(tabCol.getName())) continue;
                orders.add(sortCol.getOrder());
                continue block0;
            }
        }
        return orders;
    }

    private Operator genReduceSinkPlanForSortingBucketing(Table tab, Operator input, ArrayList<ExprNodeDesc> sortCols, List<Integer> sortOrders, ArrayList<ExprNodeDesc> partitionCols, int numReducers) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        for (ColumnInfo colInfo : inputRR.getColumnInfos()) {
            valueCols.add(new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol()));
            colExprMap.put(colInfo.getInternalName(), (ExprNodeDesc)valueCols.get(valueCols.size() - 1));
        }
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int i = 0; i < valueCols.size(); ++i) {
            outputColumns.add(SemanticAnalyzer.getColumnInternalName(i));
        }
        StringBuilder order = new StringBuilder();
        for (int sortOrder : sortOrders) {
            order.append(sortOrder == BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC ? (char)'+' : '-');
        }
        Operator<ReduceSinkDesc> interim = this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(sortCols, valueCols, outputColumns, false, -1, partitionCols, order.toString(), numReducers), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        interim.setColumnExprMap(colExprMap);
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting.add((ReduceSinkOperator)interim);
        RowResolver out_rwsch = new RowResolver();
        RowResolver interim_rwsch = inputRR;
        Integer pos = 0;
        for (ColumnInfo colInfo : interim_rwsch.getColumnInfos()) {
            String[] info = interim_rwsch.reverseLookup(colInfo.getInternalName());
            out_rwsch.put(info[0], info[1], new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), info[0], colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol()));
            pos = pos + 1;
        }
        Operator<ExtractDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ExtractDesc(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(out_rwsch.getColumnInfos()), interim), out_rwsch);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created ReduceSink Plan for table: " + tab.getTableName() + " row schema: " + out_rwsch.toString()));
        }
        return output;
    }

    private Operator genReduceSinkPlan(String dest, QB qb, Operator input, int numReducers) throws SemanticException {
        ASTNode sortExprs;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        ASTNode partitionExprs = qb.getParseInfo().getClusterByForClause(dest);
        if (partitionExprs == null) {
            partitionExprs = qb.getParseInfo().getDistributeByForClause(dest);
        }
        ArrayList<ExprNodeDesc> partitionCols = new ArrayList<ExprNodeDesc>();
        if (partitionExprs != null) {
            int ccount = partitionExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)partitionExprs.getChild(i);
                partitionCols.add(this.genExprNodeDesc(cl, inputRR));
            }
        }
        if ((sortExprs = qb.getParseInfo().getClusterByForClause(dest)) == null) {
            sortExprs = qb.getParseInfo().getSortByForClause(dest);
        }
        if (sortExprs == null && (sortExprs = qb.getParseInfo().getOrderByForClause(dest)) != null) {
            assert (numReducers == 1);
            Integer limit = qb.getParseInfo().getDestLimit(dest);
            if (this.conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("strict") && limit == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(sortExprs, ErrorMsg.NO_LIMIT_WITH_ORDERBY.getMsg()));
            }
        }
        ArrayList<ExprNodeDesc> sortCols = new ArrayList<ExprNodeDesc>();
        StringBuilder order = new StringBuilder();
        if (sortExprs != null) {
            int ccount = sortExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)sortExprs.getChild(i);
                if (cl.getType() == 798) {
                    order.append("+");
                    cl = (ASTNode)cl.getChild(0);
                } else if (cl.getType() == 799) {
                    order.append("-");
                    cl = (ASTNode)cl.getChild(0);
                } else {
                    order.append("+");
                }
                ExprNodeDesc exprNode = this.genExprNodeDesc(cl, inputRR);
                sortCols.add(exprNode);
            }
        }
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        for (ColumnInfo colInfo : inputRR.getColumnInfos()) {
            valueCols.add(new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol()));
            colExprMap.put(colInfo.getInternalName(), valueCols.get(valueCols.size() - 1));
        }
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int i = 0; i < valueCols.size(); ++i) {
            outputColumns.add(SemanticAnalyzer.getColumnInternalName(i));
        }
        Operator<ReduceSinkDesc> interim = this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(sortCols, valueCols, outputColumns, false, -1, partitionCols, order.toString(), numReducers), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        interim.setColumnExprMap(colExprMap);
        RowResolver out_rwsch = new RowResolver();
        RowResolver interim_rwsch = inputRR;
        Integer pos = 0;
        for (ColumnInfo colInfo : interim_rwsch.getColumnInfos()) {
            String[] info = interim_rwsch.reverseLookup(colInfo.getInternalName());
            out_rwsch.put(info[0], info[1], new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), info[0], colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol()));
            pos = pos + 1;
        }
        Operator<ExtractDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ExtractDesc(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(out_rwsch.getColumnInfos()), interim), out_rwsch);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created ReduceSink Plan for clause: " + dest + " row schema: " + out_rwsch.toString()));
        }
        return output;
    }

    private Operator genJoinOperatorChildren(QBJoinTree join, Operator left, Operator[] right, HashSet<Integer> omitOpts) throws SemanticException {
        RowResolver outputRS = new RowResolver();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        Operator[] rightOps = new Operator[right.length];
        int outputPos = 0;
        HashMap<String, Byte> reversedExprs = new HashMap<String, Byte>();
        HashMap<Byte, List<ExprNodeDesc>> exprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<Integer, Set<String>> posToAliasMap = new HashMap<Integer, Set<String>>();
        HashMap<Byte, List<ExprNodeDesc>> filterMap = new HashMap<Byte, List<ExprNodeDesc>>();
        for (int pos = 0; pos < right.length; ++pos) {
            Operator input = right[pos];
            if (input == null) {
                input = left;
            }
            ArrayList<ExprNodeColumnDesc> keyDesc = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ExprNodeDesc> filterDesc = new ArrayList<ExprNodeDesc>();
            Byte tag = (byte)((ReduceSinkDesc)input.getConf()).getTag();
            if (omitOpts == null || !omitOpts.contains(pos)) {
                RowResolver inputRS = this.opParseCtx.get(input).getRowResolver();
                Iterator<String> keysIter = inputRS.getTableNames().iterator();
                HashSet<String> aliases = (HashSet<String>)posToAliasMap.get(pos);
                if (aliases == null) {
                    aliases = new HashSet<String>();
                    posToAliasMap.put(pos, aliases);
                }
                while (keysIter.hasNext()) {
                    String key = keysIter.next();
                    aliases.add(key);
                    HashMap<String, ColumnInfo> map = inputRS.getFieldMap(key);
                    for (String field : map.keySet()) {
                        ColumnInfo valueInfo = inputRS.get(key, field);
                        keyDesc.add(new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol()));
                        if (outputRS.get(key, field) != null) continue;
                        String colName = SemanticAnalyzer.getColumnInternalName(outputPos);
                        ++outputPos;
                        outputColumnNames.add(colName);
                        colExprMap.put(colName, (ExprNodeDesc)keyDesc.get(keyDesc.size() - 1));
                        outputRS.put(key, field, new ColumnInfo(colName, valueInfo.getType(), key, valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol()));
                        reversedExprs.put(colName, tag);
                    }
                }
                for (ASTNode cond : join.getFilters().get(tag.byteValue())) {
                    filterDesc.add(this.genExprNodeDesc(cond, inputRS));
                }
            }
            exprMap.put(tag, keyDesc);
            filterMap.put(tag, filterDesc);
            rightOps[pos] = input;
        }
        JoinCondDesc[] joinCondns = new JoinCondDesc[join.getJoinCond().length];
        for (int i = 0; i < join.getJoinCond().length; ++i) {
            JoinCond condn = join.getJoinCond()[i];
            joinCondns[i] = new JoinCondDesc(condn);
        }
        JoinDesc desc = new JoinDesc(exprMap, outputColumnNames, join.getNoOuterJoin(), joinCondns, filterMap);
        desc.setReversedExprs(reversedExprs);
        desc.setFilterMap(join.getFilterMap());
        JoinOperator joinOp = (JoinOperator)OperatorFactory.getAndMakeChild(desc, new RowSchema(outputRS.getColumnInfos()), rightOps);
        joinOp.setColumnExprMap(colExprMap);
        joinOp.setPosToAliasMap(posToAliasMap);
        if (join.getNullSafes() != null) {
            boolean[] nullsafes = new boolean[join.getNullSafes().size()];
            for (int i = 0; i < nullsafes.length; ++i) {
                nullsafes[i] = join.getNullSafes().get(i);
            }
            desc.setNullSafes(nullsafes);
        }
        return this.putOpInsertMap(joinOp, outputRS);
    }

    private Operator genJoinReduceSinkChild(QB qb, QBJoinTree joinTree, Operator child, String srcName, int pos) throws SemanticException {
        RowResolver inputRS = this.opParseCtx.get(child).getRowResolver();
        RowResolver outputRS = new RowResolver();
        ArrayList<String> outputColumns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ASTNode> exprs = joinTree.getExpressions().get(pos);
        for (int i = 0; i < exprs.size(); ++i) {
            ASTNode expr = exprs.get(i);
            reduceKeys.add(this.genExprNodeDesc(expr, inputRS));
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        Iterator<String> tblNamesIter = inputRS.getTableNames().iterator();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        while (tblNamesIter.hasNext()) {
            String src = tblNamesIter.next();
            HashMap<String, ColumnInfo> fMap = inputRS.getFieldMap(src);
            for (Map.Entry<String, ColumnInfo> entry : fMap.entrySet()) {
                String field = entry.getKey();
                ColumnInfo valueInfo = entry.getValue();
                ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), valueInfo.getTabAlias(), valueInfo.getIsVirtualCol());
                reduceValues.add(inputExpr);
                if (outputRS.get(src, field) != null) continue;
                String col = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                outputColumns.add(col);
                ColumnInfo newColInfo = new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + col, valueInfo.getType(), src, valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol());
                colExprMap.put(newColInfo.getInternalName(), inputExpr);
                outputRS.put(src, field, newColInfo);
            }
        }
        int numReds = -1;
        if (reduceKeys.size() == 0) {
            numReds = 1;
            if (this.conf.getVar(HiveConf.ConfVars.HIVEMAPREDMODE).equalsIgnoreCase("strict")) {
                throw new SemanticException(ErrorMsg.NO_CARTESIAN_PRODUCT.getMsg());
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumns, false, joinTree.getNextTag(), reduceKeys.size(), numReds), new RowSchema(outputRS.getColumnInfos()), child), outputRS);
        rsOp.setColumnExprMap(colExprMap);
        rsOp.setInputAlias(srcName);
        return rsOp;
    }

    private Operator genJoinOperator(QB qb, QBJoinTree joinTree, Map<String, Operator> map) throws SemanticException {
        QBJoinTree leftChild = joinTree.getJoinSrc();
        Operator joinSrcOp = null;
        if (leftChild != null) {
            Operator joinOp = this.genJoinOperator(qb, leftChild, map);
            ArrayList<ASTNode> filter = joinTree.getFiltersForPushing().get(0);
            for (ASTNode cond : filter) {
                joinOp = this.genFilterPlan(qb, cond, joinOp);
            }
            joinSrcOp = this.genJoinReduceSinkChild(qb, joinTree, joinOp, null, 0);
        }
        Operator[] srcOps = new Operator[joinTree.getBaseSrc().length];
        HashSet<Integer> omitOpts = null;
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator srcOp = map.get(src.toLowerCase());
                ArrayList<ASTNode> fields = joinTree.getRHSSemijoinColumns(src);
                if (fields != null) {
                    if (omitOpts == null) {
                        omitOpts = new HashSet<Integer>();
                    }
                    omitOpts.add(pos);
                    srcOp = this.insertSelectForSemijoin(fields, srcOp);
                    srcOp = this.genMapGroupByForSemijoin(qb, fields, srcOp, GroupByDesc.Mode.HASH);
                }
                srcOps[pos] = this.genJoinReduceSinkChild(qb, joinTree, srcOp, src, pos);
                ++pos;
                continue;
            }
            assert (pos == 0);
            srcOps[pos++] = null;
        }
        this.genJoinOperatorTypeCheck(joinSrcOp, srcOps);
        JoinOperator joinOp = (JoinOperator)this.genJoinOperatorChildren(joinTree, joinSrcOp, srcOps, omitOpts);
        this.joinContext.put(joinOp, joinTree);
        return joinOp;
    }

    private Operator insertSelectForSemijoin(ArrayList<ASTNode> fields, Operator input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ASTNode field : fields) {
            ExprNodeColumnDesc exprNode = (ExprNodeColumnDesc)this.genExprNodeDesc(field, inputRR);
            colList.add(exprNode);
            columnNames.add(exprNode.getColumn());
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames, false), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        output.setColumnExprMap(input.getColumnExprMap());
        return output;
    }

    private Operator genMapGroupByForSemijoin(QB qb, ArrayList<ASTNode> fields, Operator inputOperatorInfo, GroupByDesc.Mode mode) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        qb.getParseInfo();
        groupByOutputRowResolver.setIsExprResolver(true);
        for (int i = 0; i < fields.size(); ++i) {
            ASTNode colName = fields.get(i);
            ExprNodeDesc grpByExprNode = this.genExprNodeDesc(colName, groupByInputRowResolver);
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo colInfo2 = new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false);
            groupByOutputRowResolver.putExpression(colName, colInfo2);
            colExprMap.put(field, grpByExprNode);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar(this.conf, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, null, false, 0, false), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void genJoinOperatorTypeCheck(Operator left, Operator[] right) throws SemanticException {
        Operator oi;
        int i;
        ArrayList<ArrayList<ExprNodeDesc>> keys = new ArrayList<ArrayList<ExprNodeDesc>>();
        int keyLength = 0;
        for (i = 0; i < right.length; ++i) {
            oi = i == 0 && right[i] == null ? left : right[i];
            ReduceSinkDesc now = (ReduceSinkDesc)((ReduceSinkOperator)oi).getConf();
            if (i == 0) {
                keyLength = now.getKeyCols().size();
            } else assert (keyLength == now.getKeyCols().size());
            keys.add(now.getKeyCols());
        }
        for (int k = 0; k < keyLength; ++k) {
            int i2;
            TypeInfo commonType = ((ExprNodeDesc)((ArrayList)keys.get(0)).get(k)).getTypeInfo();
            for (i2 = 1; i2 < right.length; ++i2) {
                TypeInfo a = commonType;
                TypeInfo b = ((ExprNodeDesc)((ArrayList)keys.get(i2)).get(k)).getTypeInfo();
                if ((commonType = FunctionRegistry.getCommonClassForComparison(a, b)) != null) continue;
                throw new SemanticException("Cannot do equality join on different types: " + a.getTypeName() + " and " + b.getTypeName());
            }
            for (i2 = 0; i2 < right.length; ++i2) {
                if (!TypeInfoUtils.isConversionRequiredForComparison(((ExprNodeDesc)((ArrayList)keys.get(i2)).get(k)).getTypeInfo(), commonType)) continue;
                ((ArrayList)keys.get(i2)).set(k, ParseUtils.createConversionCast((ExprNodeDesc)((ArrayList)keys.get(i2)).get(k), (PrimitiveTypeInfo)commonType));
            }
        }
        for (i = 0; i < right.length; ++i) {
            oi = i == 0 && right[i] == null ? left : right[i];
            ReduceSinkDesc now = (ReduceSinkDesc)((ReduceSinkOperator)oi).getConf();
            now.setKeySerializeInfo(PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(now.getKeyCols(), "joinkey"), now.getOrder()));
        }
    }

    private Operator genJoinPlan(QB qb, Map<String, Operator> map) throws SemanticException {
        QBJoinTree joinTree = qb.getQbJoinTree();
        Operator joinOp = this.genJoinOperator(qb, joinTree, map);
        return joinOp;
    }

    private void pushJoinFilters(QB qb, QBJoinTree joinTree, Map<String, Operator> map) throws SemanticException {
        if (joinTree.getJoinSrc() != null) {
            this.pushJoinFilters(qb, joinTree.getJoinSrc(), map);
        }
        ArrayList<ArrayList<ASTNode>> filters = joinTree.getFiltersForPushing();
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator srcOp = map.get(src);
                ArrayList<ASTNode> filter = filters.get(pos);
                for (ASTNode cond : filter) {
                    srcOp = this.genFilterPlan(qb, cond, srcOp);
                }
                map.put(src, srcOp);
            }
            ++pos;
        }
    }

    private List<String> getMapSideJoinTables(QB qb) {
        ArrayList<String> cols = new ArrayList<String>();
        ASTNode hints = qb.getParseInfo().getHints();
        for (int pos = 0; pos < hints.getChildCount(); ++pos) {
            ASTNode hint = (ASTNode)hints.getChild(pos);
            if (((ASTNode)hint.getChild(0)).getToken().getType() != 679) continue;
            if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEIGNOREMAPJOINHINT)) {
                ASTNode hintTblNames = (ASTNode)hint.getChild(1);
                int numCh = hintTblNames.getChildCount();
                for (int tblPos = 0; tblPos < numCh; ++tblPos) {
                    String tblName = ((ASTNode)hintTblNames.getChild(tblPos)).getText().toLowerCase();
                    if (cols.contains(tblName)) continue;
                    cols.add(tblName);
                }
                continue;
            }
            this.queryProperties.setMapJoinRemoved(true);
        }
        return cols;
    }

    private String getModifiedAlias(QB qb, String alias) {
        return QB.getAppendedAliasFromId(qb.getId(), alias);
    }

    private QBJoinTree genUniqueJoinTree(QB qb, ASTNode joinParseTree, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        QBJoinTree joinTree = new QBJoinTree();
        joinTree.setNoOuterJoin(false);
        joinTree.setExpressions(new ArrayList<ArrayList<ASTNode>>());
        joinTree.setFilters(new ArrayList<ArrayList<ASTNode>>());
        joinTree.setFiltersForPushing(new ArrayList<ArrayList<ASTNode>>());
        ArrayList<String> rightAliases = new ArrayList<String>();
        ArrayList<String> leftAliases = new ArrayList<String>();
        ArrayList<String> baseSrc = new ArrayList<String>();
        ArrayList<Boolean> preserved = new ArrayList<Boolean>();
        boolean lastPreserved = false;
        int cols = -1;
        block6: for (int i = 0; i < joinParseTree.getChildCount(); ++i) {
            ASTNode child = (ASTNode)joinParseTree.getChild(i);
            switch (child.getToken().getType()) {
                case 797: {
                    String alias;
                    String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)child.getChild(0));
                    String string = alias = child.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(child.getChild(child.getChildCount() - 1).getText().toLowerCase());
                    if (i == 0) {
                        leftAliases.add(alias);
                        joinTree.setLeftAlias(alias);
                    } else {
                        rightAliases.add(alias);
                    }
                    joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
                    joinTree.setId(qb.getId());
                    baseSrc.add(alias);
                    preserved.add(lastPreserved);
                    lastPreserved = false;
                    continue block6;
                }
                case 632: {
                    if (cols == -1 && child.getChildCount() != 0) {
                        cols = child.getChildCount();
                    } else if (child.getChildCount() != cols) {
                        throw new SemanticException("Tables with different or invalid number of keys in UNIQUEJOIN");
                    }
                    ArrayList<ASTNode> expressions = new ArrayList<ASTNode>();
                    ArrayList filt = new ArrayList();
                    ArrayList filters = new ArrayList();
                    for (Node exp : child.getChildren()) {
                        expressions.add((ASTNode)exp);
                    }
                    joinTree.getExpressions().add(expressions);
                    joinTree.getFilters().add(filt);
                    joinTree.getFiltersForPushing().add(filters);
                    continue block6;
                }
                case 180: {
                    lastPreserved = true;
                    continue block6;
                }
                case 767: {
                    throw new SemanticException("Subqueries are not supported in UNIQUEJOIN");
                }
                default: {
                    throw new SemanticException("Unexpected UNIQUEJOIN structure");
                }
            }
        }
        joinTree.setBaseSrc(baseSrc.toArray(new String[0]));
        joinTree.setLeftAliases(leftAliases.toArray(new String[0]));
        joinTree.setRightAliases(rightAliases.toArray(new String[0]));
        JoinCond[] condn = new JoinCond[preserved.size()];
        for (int i = 0; i < condn.length; ++i) {
            condn[i] = new JoinCond((Boolean)preserved.get(i));
        }
        joinTree.setJoinCond(condn);
        if (qb.getParseInfo().getHints() != null) {
            this.parseStreamTables(joinTree, qb);
        }
        return joinTree;
    }

    private QBJoinTree genJoinTree(QB qb, ASTNode joinParseTree, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String[] children;
        String[] leftAliases;
        String alias;
        String tableName;
        QBJoinTree joinTree = new QBJoinTree();
        JoinCond[] condn = new JoinCond[1];
        switch (joinParseTree.getToken().getType()) {
            case 669: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTOUTER);
                break;
            }
            case 734: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.RIGHTOUTER);
                break;
            }
            case 638: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.FULLOUTER);
                break;
            }
            case 670: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTSEMI);
                break;
            }
            default: {
                condn[0] = new JoinCond(0, 1, JoinType.INNER);
                joinTree.setNoOuterJoin(true);
            }
        }
        joinTree.setJoinCond(condn);
        ASTNode left = (ASTNode)joinParseTree.getChild(0);
        ASTNode right = (ASTNode)joinParseTree.getChild(1);
        if (left.getToken().getType() == 797 || left.getToken().getType() == 767 || left.getToken().getType() == 726) {
            tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)left.getChild(0)).toLowerCase();
            alias = left.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(left.getChild(left.getChildCount() - 1).getText().toLowerCase());
            alias = left.getToken().getType() == 726 ? SemanticAnalyzer.unescapeIdentifier(left.getChild(1).getText().toLowerCase()) : alias;
            joinTree.setLeftAlias(alias);
            leftAliases = new String[]{alias};
            joinTree.setLeftAliases(leftAliases);
            children = new String[2];
            children[0] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
        } else if (this.isJoinToken(left)) {
            QBJoinTree leftTree = this.genJoinTree(qb, left, aliasToOpInfo);
            joinTree.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            joinTree.setLeftAliases(leftAliases);
        } else assert (false);
        if (right.getToken().getType() == 797 || right.getToken().getType() == 767 || right.getToken().getType() == 726) {
            tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)right.getChild(0)).toLowerCase();
            alias = right.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(right.getChild(right.getChildCount() - 1).getText().toLowerCase());
            alias = right.getToken().getType() == 726 ? SemanticAnalyzer.unescapeIdentifier(right.getChild(1).getText().toLowerCase()) : alias;
            String[] rightAliases = new String[]{alias};
            joinTree.setRightAliases(rightAliases);
            children = joinTree.getBaseSrc();
            if (children == null) {
                children = new String[2];
            }
            children[1] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
            if (!joinTree.getNoSemiJoin()) {
                joinTree.addRHSSemijoin(alias);
            }
        } else assert (false);
        ArrayList<ArrayList<ASTNode>> expressions = new ArrayList<ArrayList<ASTNode>>();
        expressions.add(new ArrayList());
        expressions.add(new ArrayList());
        joinTree.setExpressions(expressions);
        ArrayList<Boolean> nullsafes = new ArrayList<Boolean>();
        joinTree.setNullSafes(nullsafes);
        ArrayList<ArrayList<ASTNode>> filters = new ArrayList<ArrayList<ASTNode>>();
        filters.add(new ArrayList());
        filters.add(new ArrayList());
        joinTree.setFilters(filters);
        joinTree.setFilterMap(new int[2][]);
        ArrayList<ArrayList<ASTNode>> filtersForPushing = new ArrayList<ArrayList<ASTNode>>();
        filtersForPushing.add(new ArrayList());
        filtersForPushing.add(new ArrayList());
        joinTree.setFiltersForPushing(filtersForPushing);
        ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
        ArrayList<String> leftSrc = new ArrayList<String>();
        this.parseJoinCondition(joinTree, joinCond, leftSrc);
        if (leftSrc.size() == 1) {
            joinTree.setLeftAlias(leftSrc.get(0));
        }
        if (qb.getParseInfo().getHints() != null) {
            List<String> mapSideTables = this.getMapSideJoinTables(qb);
            List<String> mapAliases = joinTree.getMapAliases();
            for (String mapTbl : mapSideTables) {
                boolean mapTable = false;
                for (String leftAlias : joinTree.getLeftAliases()) {
                    if (!mapTbl.equalsIgnoreCase(leftAlias)) continue;
                    mapTable = true;
                }
                for (String rightAlias : joinTree.getRightAliases()) {
                    if (!mapTbl.equalsIgnoreCase(rightAlias)) continue;
                    mapTable = true;
                }
                if (!mapTable) continue;
                if (mapAliases == null) {
                    mapAliases = new ArrayList<String>();
                }
                mapAliases.add(mapTbl);
                joinTree.setMapSideJoin(true);
            }
            joinTree.setMapAliases(mapAliases);
            this.parseStreamTables(joinTree, qb);
        }
        return joinTree;
    }

    private void parseStreamTables(QBJoinTree joinTree, QB qb) {
        List<String> streamAliases = joinTree.getStreamAliases();
        for (Node hintNode : qb.getParseInfo().getHints().getChildren()) {
            ASTNode hint = (ASTNode)hintNode;
            if (hint.getChild(0).getType() != 763) continue;
            for (int i = 0; i < hint.getChild(1).getChildCount(); ++i) {
                if (streamAliases == null) {
                    streamAliases = new ArrayList<String>();
                }
                streamAliases.add(hint.getChild(1).getChild(i).getText());
            }
        }
        joinTree.setStreamAliases(streamAliases);
    }

    private void mergeJoins(QB qb, QBJoinTree node, QBJoinTree target, int pos) {
        int i;
        int i2;
        int i3;
        String[] nodeRightAliases = node.getRightAliases();
        String[] trgtRightAliases = target.getRightAliases();
        String[] rightAliases = new String[nodeRightAliases.length + trgtRightAliases.length];
        for (i3 = 0; i3 < trgtRightAliases.length; ++i3) {
            rightAliases[i3] = trgtRightAliases[i3];
        }
        for (i3 = 0; i3 < nodeRightAliases.length; ++i3) {
            rightAliases[i3 + trgtRightAliases.length] = nodeRightAliases[i3];
        }
        target.setRightAliases(rightAliases);
        target.getAliasToOpInfo().putAll(node.getAliasToOpInfo());
        String[] nodeBaseSrc = node.getBaseSrc();
        String[] trgtBaseSrc = target.getBaseSrc();
        String[] baseSrc = new String[nodeBaseSrc.length + trgtBaseSrc.length - 1];
        for (i2 = 0; i2 < trgtBaseSrc.length; ++i2) {
            baseSrc[i2] = trgtBaseSrc[i2];
        }
        for (i2 = 1; i2 < nodeBaseSrc.length; ++i2) {
            baseSrc[i2 + trgtBaseSrc.length - 1] = nodeBaseSrc[i2];
        }
        target.setBaseSrc(baseSrc);
        ArrayList<ArrayList<ASTNode>> expr = target.getExpressions();
        for (int i4 = 0; i4 < nodeRightAliases.length; ++i4) {
            expr.add(node.getExpressions().get(i4 + 1));
        }
        ArrayList<Boolean> nns = node.getNullSafes();
        ArrayList<Boolean> tns = target.getNullSafes();
        for (int i5 = 0; i5 < tns.size(); ++i5) {
            tns.set(i5, tns.get(i5) & nns.get(i5));
        }
        ArrayList<ArrayList<ASTNode>> filters = target.getFilters();
        for (int i6 = 0; i6 < nodeRightAliases.length; ++i6) {
            filters.add(node.getFilters().get(i6 + 1));
        }
        if (node.getFilters().get(0).size() != 0) {
            ArrayList<ASTNode> filterPos = filters.get(pos);
            filterPos.addAll((Collection<ASTNode>)node.getFilters().get(0));
        }
        int[][] nmap = node.getFilterMap();
        int[][] tmap = target.getFilterMap();
        int[][] newmap = new int[tmap.length + nmap.length - 1][];
        for (int[] mapping : nmap) {
            if (mapping == null) continue;
            for (int i7 = 0; i7 < mapping.length; i7 += 2) {
                if (pos <= 0 && mapping[i7] <= 0) continue;
                int n = i7;
                mapping[n] = mapping[n] + trgtRightAliases.length;
            }
        }
        if (nmap[0] != null) {
            if (tmap[pos] == null) {
                tmap[pos] = nmap[0];
            } else {
                int[] appended = new int[tmap[pos].length + nmap[0].length];
                System.arraycopy(tmap[pos], 0, appended, 0, tmap[pos].length);
                System.arraycopy(nmap[0], 0, appended, tmap[pos].length, nmap[0].length);
                tmap[pos] = appended;
            }
        }
        System.arraycopy(tmap, 0, newmap, 0, tmap.length);
        System.arraycopy(nmap, 1, newmap, tmap.length, nmap.length - 1);
        target.setFilterMap(newmap);
        ArrayList<ArrayList<ASTNode>> filter = target.getFiltersForPushing();
        for (int i8 = 0; i8 < nodeRightAliases.length; ++i8) {
            filter.add(node.getFiltersForPushing().get(i8 + 1));
        }
        if (node.getFiltersForPushing().get(0).size() != 0) {
            ArrayList<ASTNode> filterPos = filter.get(pos);
            filterPos.addAll((Collection<ASTNode>)node.getFiltersForPushing().get(0));
        }
        if (node.getNoOuterJoin() && target.getNoOuterJoin()) {
            target.setNoOuterJoin(true);
        } else {
            target.setNoOuterJoin(false);
        }
        if (node.getNoSemiJoin() && target.getNoSemiJoin()) {
            target.setNoSemiJoin(true);
        } else {
            target.setNoSemiJoin(false);
        }
        target.mergeRHSSemijoin(node);
        JoinCond[] nodeCondns = node.getJoinCond();
        int nodeCondnsSize = nodeCondns.length;
        JoinCond[] targetCondns = target.getJoinCond();
        int targetCondnsSize = targetCondns.length;
        JoinCond[] newCondns = new JoinCond[nodeCondnsSize + targetCondnsSize];
        for (i = 0; i < targetCondnsSize; ++i) {
            newCondns[i] = targetCondns[i];
        }
        for (i = 0; i < nodeCondnsSize; ++i) {
            JoinCond nodeCondn = nodeCondns[i];
            if (nodeCondn.getLeft() == 0) {
                nodeCondn.setLeft(pos);
            } else {
                nodeCondn.setLeft(nodeCondn.getLeft() + targetCondnsSize);
            }
            nodeCondn.setRight(nodeCondn.getRight() + targetCondnsSize);
            newCondns[targetCondnsSize + i] = nodeCondn;
        }
        target.setJoinCond(newCondns);
        if (target.isMapSideJoin()) {
            assert (node.isMapSideJoin());
            List<String> mapAliases = target.getMapAliases();
            for (String mapTbl : node.getMapAliases()) {
                if (mapAliases.contains(mapTbl)) continue;
                mapAliases.add(mapTbl);
            }
            target.setMapAliases(mapAliases);
        }
    }

    private int findMergePos(QBJoinTree node, QBJoinTree target) {
        int i;
        int res = -1;
        String leftAlias = node.getLeftAlias();
        if (leftAlias == null) {
            return -1;
        }
        ArrayList<ASTNode> nodeCondn = node.getExpressions().get(0);
        ArrayList<ASTNode> targetCondn = null;
        if (leftAlias.equals(target.getLeftAlias())) {
            targetCondn = target.getExpressions().get(0);
            res = 0;
        } else {
            for (i = 0; i < target.getRightAliases().length; ++i) {
                if (!leftAlias.equals(target.getRightAliases()[i])) continue;
                targetCondn = target.getExpressions().get(i + 1);
                res = i + 1;
                break;
            }
        }
        if (targetCondn == null || nodeCondn.size() != targetCondn.size()) {
            return -1;
        }
        for (i = 0; i < nodeCondn.size(); ++i) {
            if (nodeCondn.get(i).toStringTree().equals(targetCondn.get(i).toStringTree())) continue;
            return -1;
        }
        return res;
    }

    private void mergeJoinTree(QB qb) {
        QBJoinTree tree = qb.getQbJoinTree();
        if (tree.getJoinSrc() == null) {
            return;
        }
        ArrayList<QBJoinTree> trees = new ArrayList<QBJoinTree>();
        while (tree != null) {
            trees.add(tree);
            tree = tree.getJoinSrc();
        }
        block1: for (int i = trees.size() - 1; i >= 0; --i) {
            QBJoinTree target = (QBJoinTree)trees.get(i);
            if (target == null) continue;
            JoinType prevType = null;
            for (int j = i - 1; j >= 0; --j) {
                QBJoinTree node = (QBJoinTree)trees.get(j);
                if (node == null) continue;
                JoinType currType = this.getType(node.getJoinCond());
                if (prevType != null && prevType != currType) continue block1;
                int pos = this.findMergePos(node, target);
                if (pos >= 0) {
                    if (!(node.getNoOuterJoin() && target.getNoOuterJoin() || node.getRightAliases().length + target.getRightAliases().length + 1 <= 16)) {
                        this.LOG.info((Object)ErrorMsg.JOINNODE_OUTERJOIN_MORETHAN_16);
                        continue;
                    }
                    this.mergeJoins(qb, node, target, pos);
                    trees.set(j, null);
                    continue;
                }
                if (prevType != null) continue;
                prevType = currType;
            }
        }
        QBJoinTree current = null;
        for (int i = 0; i < trees.size(); ++i) {
            QBJoinTree target = (QBJoinTree)trees.get(i);
            if (target == null) continue;
            if (current == null) {
                current = target;
                qb.setQbJoinTree(current);
                continue;
            }
            current.setJoinSrc(target);
            current = target;
        }
    }

    private JoinType getType(JoinCond[] conds) {
        JoinType type = conds[0].getJoinType();
        for (int k = 1; k < conds.length; ++k) {
            if (type == conds[k].getJoinType()) continue;
            return null;
        }
        return type;
    }

    private Operator insertSelectAllPlanForGroupBy(Operator input) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        ArrayList<ColumnInfo> columns = inputRR.getColumnInfos();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            colList.add(new ExprNodeColumnDesc(col.getType(), col.getInternalName(), col.getTabAlias(), col.getIsVirtualCol()));
            columnNames.add(col.getInternalName());
            columnExprMap.put(col.getInternalName(), new ExprNodeColumnDesc(col.getType(), col.getInternalName(), col.getTabAlias(), col.getIsVirtualCol()));
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames, true), new RowSchema(inputRR.getColumnInfos()), input), inputRR);
        output.setColumnExprMap(columnExprMap);
        return output;
    }

    private List<ASTNode> getCommonDistinctExprs(QB qb, Operator input) {
        QBParseInfo qbp = qb.getParseInfo();
        if (!(qbp.getDestCubes().isEmpty() && qbp.getDestRollups().isEmpty() && qbp.getDestToLateralView().isEmpty())) {
            return null;
        }
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        if (ks.size() <= 1) {
            return null;
        }
        List<ExprNodeDesc> oldList = null;
        ArrayList<ASTNode> oldASTList = null;
        for (String dest : ks) {
            List<ExprNodeDesc> currDestList;
            if (qbp.getWhrForClause(dest) != null) {
                return null;
            }
            if (qbp.getAggregationExprsForClause(dest).size() == 0 && SemanticAnalyzer.getGroupByForClause(qbp, dest).size() == 0) {
                return null;
            }
            List<ASTNode> list = qbp.getDistinctFuncExprsForClause(dest);
            if (list.isEmpty()) {
                return null;
            }
            try {
                currDestList = this.getDistinctExprs(qbp, dest, inputRR);
            }
            catch (SemanticException e) {
                return null;
            }
            ArrayList<ASTNode> currASTList = new ArrayList<ASTNode>();
            for (ASTNode value : list) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)value.getChild(i);
                    currASTList.add(parameter);
                }
                if (oldList == null) {
                    oldList = currDestList;
                    oldASTList = currASTList;
                    continue;
                }
                if (this.matchExprLists(oldList, currDestList)) continue;
                return null;
            }
        }
        return oldASTList;
    }

    private Operator createCommonReduceSink(QB qb, Operator input) throws SemanticException {
        List<ASTNode> distExprs = this.getCommonDistinctExprs(qb, input);
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (ASTNode distn : distExprs) {
            ExprNodeDesc distExpr = this.genExprNodeDesc(distn, inputRR);
            if (reduceSinkOutputRowResolver.getExpression(distn) != null) continue;
            reduceKeys.add(distExpr);
            outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), "", false);
            reduceSinkOutputRowResolver.putExpression(distn, colInfo);
            colExprMap.put(colInfo.getInternalName(), distExpr);
        }
        for (String dest : ks) {
            List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(qbp, dest);
            for (int i = 0; i < grpByExprs.size(); ++i) {
                ASTNode grpbyExpr = grpByExprs.get(i);
                if (reduceSinkOutputRowResolver.getExpression(grpbyExpr) != null) continue;
                ExprNodeDesc grpByExprNode = this.genExprNodeDesc(grpbyExpr, inputRR);
                reduceValues.add(grpByExprNode);
                String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                ColumnInfo colInfo = new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), "", false);
                reduceSinkOutputRowResolver.putExpression(grpbyExpr, colInfo);
                outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                colExprMap.put(field, grpByExprNode);
            }
            HashMap<String, ASTNode> aggregationTrees = qbp.getAggregationExprsForClause(dest);
            assert (aggregationTrees != null);
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                ASTNode value = entry.getValue();
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode paraExpr = (ASTNode)value.getChild(i);
                    if (reduceSinkOutputRowResolver.getExpression(paraExpr) != null) continue;
                    ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, inputRR);
                    reduceValues.add(paraExprNode);
                    String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                    ColumnInfo colInfo = new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), "", false);
                    reduceSinkOutputRowResolver.putExpression(paraExpr, colInfo);
                    outputColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                    colExprMap.put(field, paraExprNode);
                }
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, reduceKeys.size(), -1), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), input), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private List<List<String>> getCommonGroupByDestGroups(QB qb, Map<String, Operator<? extends OperatorDesc>> inputs) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        ArrayList<List<String>> commonGroupByDestGroups = new ArrayList<List<String>>();
        if (ks.size() <= 1) {
            ArrayList oneList = new ArrayList(1);
            if (ks.size() == 1) {
                oneList.add(ks.first());
            }
            commonGroupByDestGroups.add(oneList);
            return commonGroupByDestGroups;
        }
        ArrayList<Operator<? extends OperatorDesc>> inputOperators = new ArrayList<Operator<? extends OperatorDesc>>(ks.size());
        ArrayList<ArrayList<ExprNodeDesc>> sprayKeyLists = new ArrayList<ArrayList<ExprNodeDesc>>(ks.size());
        ArrayList<List<ExprNodeDesc>> distinctKeyLists = new ArrayList<List<ExprNodeDesc>>(ks.size());
        for (String dest : ks) {
            Operator<? extends OperatorDesc> input = inputs.get(dest);
            RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
            List<ExprNodeDesc> distinctKeys = this.getDistinctExprs(qbp, dest, inputRR);
            ArrayList<ExprNodeDesc> sprayKeys = new ArrayList<ExprNodeDesc>();
            List<ASTNode> grpByExprs = SemanticAnalyzer.getGroupByForClause(qbp, dest);
            for (ASTNode grpByExpr : grpByExprs) {
                ExprNodeDesc exprDesc = this.genExprNodeDesc(grpByExpr, inputRR);
                if (ExprNodeDescUtils.indexOf(exprDesc, sprayKeys) >= 0) continue;
                sprayKeys.add(exprDesc);
            }
            boolean found = false;
            for (int i = 0; i < sprayKeyLists.size(); ++i) {
                ArrayList<ExprNodeDesc> combinedList;
                if (!input.equals(inputOperators.get(i))) continue;
                if (distinctKeys.isEmpty()) {
                    combinedList = new ArrayList<ExprNodeDesc>();
                    this.combineExprNodeLists((List)sprayKeyLists.get(i), (List)distinctKeyLists.get(i), combinedList);
                    if (!this.matchExprLists(combinedList, sprayKeys)) {
                        continue;
                    }
                } else {
                    if (((List)distinctKeyLists.get(i)).isEmpty()) {
                        combinedList = new ArrayList();
                        this.combineExprNodeLists(sprayKeys, distinctKeys, combinedList);
                        if (!this.matchExprLists(combinedList, (List)sprayKeyLists.get(i))) continue;
                        distinctKeyLists.remove(i);
                        sprayKeyLists.remove(i);
                        distinctKeyLists.add(i, distinctKeys);
                        sprayKeyLists.add(i, sprayKeys);
                        ((List)commonGroupByDestGroups.get(i)).add(0, dest);
                        found = true;
                        break;
                    }
                    if (!this.matchExprLists((List)distinctKeyLists.get(i), distinctKeys) || !this.matchExprLists((List)sprayKeyLists.get(i), sprayKeys)) continue;
                }
                ((List)commonGroupByDestGroups.get(i)).add(dest);
                found = true;
                break;
            }
            if (found) continue;
            inputOperators.add(input);
            sprayKeyLists.add(sprayKeys);
            distinctKeyLists.add(distinctKeys);
            ArrayList<String> destGroup = new ArrayList<String>();
            destGroup.add(dest);
            commonGroupByDestGroups.add(destGroup);
        }
        return commonGroupByDestGroups;
    }

    private void combineExprNodeLists(List<ExprNodeDesc> list, List<ExprNodeDesc> list2, List<ExprNodeDesc> combinedList) {
        combinedList.addAll(list);
        for (ExprNodeDesc elem : list2) {
            if (combinedList.contains(elem)) continue;
            combinedList.add(elem);
        }
    }

    private boolean matchExprLists(List<ExprNodeDesc> list1, List<ExprNodeDesc> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (ExprNodeDesc exprNodeDesc : list1) {
            if (ExprNodeDescUtils.indexOf(exprNodeDesc, list2) >= 0) continue;
            return false;
        }
        return true;
    }

    private List<ExprNodeDesc> getDistinctExprs(QBParseInfo qbp, String dest, RowResolver inputRR) throws SemanticException {
        List<ASTNode> distinctAggExprs = qbp.getDistinctFuncExprsForClause(dest);
        ArrayList<ExprNodeDesc> distinctExprs = new ArrayList<ExprNodeDesc>();
        for (ASTNode distinctAggExpr : distinctAggExprs) {
            for (int i = 1; i < distinctAggExpr.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)distinctAggExpr.getChild(i);
                ExprNodeDesc expr = this.genExprNodeDesc(parameter, inputRR);
                if (ExprNodeDescUtils.indexOf(expr, distinctExprs) >= 0) continue;
                distinctExprs.add(expr);
            }
        }
        return distinctExprs;
    }

    private boolean distinctExprsExists(QB qb) {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>();
        ks.addAll(qbp.getClauseNames());
        for (String dest : ks) {
            List<ASTNode> list = qbp.getDistinctFuncExprsForClause(dest);
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Operator genBodyPlan(QB qb, Operator input) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>(qbp.getClauseNames());
        Map<String, Operator<? extends OperatorDesc>> inputs = this.createInputForDests(qb, input, ks);
        List<ASTNode> commonDistinctExprs = this.getCommonDistinctExprs(qb, input);
        boolean optimizeMultiGroupBy = commonDistinctExprs != null && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_MULTI_GROUPBY_COMMON_DISTINCTS);
        Operator curr = input;
        if (optimizeMultiGroupBy) {
            curr = this.createCommonReduceSink(qb, input);
            RowResolver currRR = this.opParseCtx.get(curr).getRowResolver();
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ForwardDesc(), new RowSchema(currRR.getColumnInfos()), curr), currRR);
            for (String dest : ks) {
                curr = input;
                curr = this.genGroupByPlan2MRMultiGroupBy(dest, qb, curr);
                curr = this.genSelectPlan(dest, qb, curr);
                Integer limit = qbp.getDestLimit(dest);
                if (limit != null) {
                    curr = this.genLimitMapRedPlan(dest, qb, curr, limit, true);
                    qb.getParseInfo().setOuterQueryLimit(limit);
                }
                curr = this.genFileSinkPlan(dest, qb, curr);
            }
        } else {
            List<List<String>> commonGroupByDestGroups = null;
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEMULTIGROUPBYSINGLEREDUCER)) {
                try {
                    commonGroupByDestGroups = this.getCommonGroupByDestGroups(qb, inputs);
                }
                catch (SemanticException e) {
                    this.LOG.error((Object)"Failed to group clauses by common spray keys.", (Throwable)e);
                }
            }
            if (commonGroupByDestGroups == null) {
                commonGroupByDestGroups = new ArrayList<List<String>>();
                commonGroupByDestGroups.add(new ArrayList<String>(ks));
            }
            if (!commonGroupByDestGroups.isEmpty()) {
                for (List<String> commonGroupByDestGroup : commonGroupByDestGroups) {
                    if (commonGroupByDestGroup.isEmpty()) continue;
                    String firstDest = commonGroupByDestGroup.get(0);
                    input = inputs.get(firstDest);
                    if (commonGroupByDestGroup.size() == 1 || qbp.getAggregationExprsForClause(firstDest).size() == 0 && SemanticAnalyzer.getGroupByForClause(qbp, firstDest).size() == 0 || this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) || !this.conf.getBoolVar(HiveConf.ConfVars.HIVEMULTIGROUPBYSINGLEREDUCER)) {
                        for (String dest : commonGroupByDestGroup) {
                            curr = inputs.get(dest);
                            if (qbp.getWhrForClause(dest) != null) {
                                curr = this.genFilterPlan(dest, qb, curr);
                            }
                            if (qbp.getAggregationExprsForClause(dest).size() != 0 || SemanticAnalyzer.getGroupByForClause(qbp, dest).size() > 0) {
                                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) && qbp.getDistinctFuncExprsForClause(dest).size() > 1) {
                                    throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
                                }
                                curr = this.insertSelectAllPlanForGroupBy(curr);
                                curr = this.conf.getBoolVar(HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE) ? (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? this.genGroupByPlanMapAggrNoSkew(dest, qb, curr) : this.genGroupByPlanMapAggr2MR(dest, qb, curr)) : (this.conf.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? this.genGroupByPlan2MR(dest, qb, curr) : this.genGroupByPlan1MR(dest, qb, curr));
                            }
                            curr = this.genPostGroupByBodyPlan(curr, dest, qb);
                        }
                        continue;
                    }
                    curr = this.genGroupByPlan1ReduceMultiGBY(commonGroupByDestGroup, qb, input);
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created Body Plan for Query Block " + qb.getId()));
        }
        return curr;
    }

    private Map<String, Operator<? extends OperatorDesc>> createInputForDests(QB qb, Operator<? extends OperatorDesc> input, Set<String> dests) throws SemanticException {
        HashMap<String, Operator<? extends OperatorDesc>> inputs = new HashMap<String, Operator<? extends OperatorDesc>>();
        for (String dest : dests) {
            inputs.put(dest, this.genLateralViewPlanForDest(dest, qb, input));
        }
        return inputs;
    }

    private Operator genPostGroupByBodyPlan(Operator curr, String dest, QB qb) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        if (qbp.getHavingForClause(dest) != null) {
            if (SemanticAnalyzer.getGroupByForClause(qbp, dest).size() == 0) {
                throw new SemanticException("HAVING specified without GROUP BY");
            }
            curr = this.genHavingPlan(dest, qb, curr);
        }
        if (this.queryProperties.hasWindowing() && qb.getWindowingSpec(dest) != null) {
            curr = this.genWindowingPlan(qb.getWindowingSpec(dest), curr);
        }
        curr = this.genSelectPlan(dest, qb, curr);
        Integer limit = qbp.getDestLimit(dest);
        boolean genReduceSink = false;
        if (qbp.getClusterByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getDistributeByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getOrderByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getSortByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (genReduceSink) {
            int numReducers = -1;
            if (qbp.getOrderByForClause(dest) != null) {
                numReducers = 1;
            }
            curr = this.genReduceSinkPlan(dest, qb, curr, numReducers);
        }
        if (qbp.getIsSubQ()) {
            if (limit != null) {
                curr = this.genLimitMapRedPlan(dest, qb, curr, limit, qbp.getOrderByForClause(dest) == null);
            }
        } else {
            curr = this.genConversionOps(dest, qb, curr);
            if (limit != null) {
                boolean extraMRStep = true;
                if (qbp.getOrderByForClause(dest) != null || qb.getIsQuery() && qbp.getClusterByForClause(dest) == null && qbp.getSortByForClause(dest) == null) {
                    extraMRStep = false;
                }
                curr = this.genLimitMapRedPlan(dest, qb, curr, limit, extraMRStep);
                qb.getParseInfo().setOuterQueryLimit(limit);
            }
            if (!SessionState.get().getHiveOperation().equals((Object)HiveOperation.CREATEVIEW)) {
                curr = this.genFileSinkPlan(dest, qb, curr);
            }
        }
        if (qb.getParseInfo().getAlias() != null) {
            RowResolver rr = this.opParseCtx.get(curr).getRowResolver();
            RowResolver newRR = new RowResolver();
            String alias = qb.getParseInfo().getAlias();
            for (ColumnInfo colInfo : rr.getColumnInfos()) {
                String name = colInfo.getInternalName();
                String[] tmp = rr.reverseLookup(name);
                if ("".equals(tmp[0]) || tmp[1] == null) {
                    tmp[1] = colInfo.getInternalName();
                }
                newRR.put(alias, tmp[1], colInfo);
            }
            this.opParseCtx.get(curr).setRowResolver(newRR);
        }
        return curr;
    }

    private Operator genUnionPlan(String unionalias, String leftalias, Operator leftOp, String rightalias, Operator rightOp) throws SemanticException {
        ASTNode tabref;
        RowResolver leftRR = this.opParseCtx.get(leftOp).getRowResolver();
        RowResolver rightRR = this.opParseCtx.get(rightOp).getRowResolver();
        HashMap<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
        HashMap<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
        ASTNode aSTNode = tabref = this.qb.getAliases().isEmpty() ? null : this.qb.getParseInfo().getSrcForAlias(this.qb.getAliases().get(0));
        if (leftmap.size() != rightmap.size()) {
            throw new SemanticException("Schema of both sides of union should match.");
        }
        for (Map.Entry<String, ColumnInfo> lEntry : leftmap.entrySet()) {
            String field = lEntry.getKey();
            ColumnInfo lInfo = lEntry.getValue();
            ColumnInfo rInfo = rightmap.get(field);
            if (rInfo == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match. " + rightalias + " does not have the field " + field));
            }
            if (lInfo == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match. " + leftalias + " does not have the field " + field));
            }
            if (!lInfo.getInternalName().equals(rInfo.getInternalName())) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match: field " + field + ":" + " appears on the left side of the UNION at column position: " + SemanticAnalyzer.getPositionFromInternalName(lInfo.getInternalName()) + ", and on the right side of the UNION at column position: " + SemanticAnalyzer.getPositionFromInternalName(rInfo.getInternalName()) + ". Column positions should match for a UNION"));
            }
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
            if (commonTypeInfo != null) continue;
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
        }
        RowResolver unionoutRR = new RowResolver();
        for (Map.Entry<String, ColumnInfo> lEntry : leftmap.entrySet()) {
            String field = lEntry.getKey();
            ColumnInfo lInfo = lEntry.getValue();
            ColumnInfo rInfo = rightmap.get(field);
            ColumnInfo unionColInfo = new ColumnInfo(lInfo);
            unionColInfo.setType(FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType()));
            unionoutRR.put(unionalias, field, unionColInfo);
        }
        if (!(leftOp instanceof UnionOperator)) {
            leftOp = this.genInputSelectForUnion(leftOp, leftmap, leftalias, unionoutRR, unionalias);
        }
        if (!(rightOp instanceof UnionOperator)) {
            rightOp = this.genInputSelectForUnion(rightOp, rightmap, rightalias, unionoutRR, unionalias);
        }
        if (leftOp instanceof UnionOperator || rightOp instanceof UnionOperator) {
            UnionDesc uDesc;
            List<Operator<OperatorDesc>> parent;
            ArrayList<Operator<? extends OperatorDesc>> child;
            if (leftOp instanceof UnionOperator) {
                child = new ArrayList<Operator<? extends OperatorDesc>>();
                child.add(leftOp);
                rightOp.setChildOperators(child);
                parent = leftOp.getParentOperators();
                parent.add(rightOp);
                uDesc = (UnionDesc)((UnionOperator)leftOp).getConf();
                uDesc.setNumInputs(uDesc.getNumInputs() + 1);
                return this.putOpInsertMap(leftOp, unionoutRR);
            }
            child = new ArrayList();
            child.add(rightOp);
            leftOp.setChildOperators(child);
            parent = rightOp.getParentOperators();
            parent.add(leftOp);
            uDesc = (UnionDesc)((UnionOperator)rightOp).getConf();
            uDesc.setNumInputs(uDesc.getNumInputs() + 1);
            return this.putOpInsertMap(rightOp, unionoutRR);
        }
        Operator<UnionDesc> unionforward = OperatorFactory.getAndMakeChild(new UnionDesc(), new RowSchema(unionoutRR.getColumnInfos()), new Operator[0]);
        ArrayList<Operator<? extends OperatorDesc>> child = new ArrayList<Operator<? extends OperatorDesc>>();
        child.add(unionforward);
        rightOp.setChildOperators(child);
        child = new ArrayList();
        child.add(unionforward);
        leftOp.setChildOperators(child);
        ArrayList<Operator<? extends OperatorDesc>> parent = new ArrayList<Operator<? extends OperatorDesc>>();
        parent.add(leftOp);
        parent.add(rightOp);
        unionforward.setParentOperators(parent);
        return this.putOpInsertMap(unionforward, unionoutRR);
    }

    private Operator<? extends OperatorDesc> genInputSelectForUnion(Operator<? extends OperatorDesc> origInputOp, Map<String, ColumnInfo> origInputFieldMap, String origInputAlias, RowResolver unionoutRR, String unionalias) throws SemanticException {
        ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
        boolean needsCast = false;
        for (Map.Entry<String, ColumnInfo> unionEntry : unionoutRR.getFieldMap(unionalias).entrySet()) {
            String field = unionEntry.getKey();
            ColumnInfo lInfo = origInputFieldMap.get(field);
            ExprNodeDesc column = new ExprNodeColumnDesc(lInfo.getType(), lInfo.getInternalName(), lInfo.getTabAlias(), lInfo.getIsVirtualCol(), lInfo.isSkewedCol());
            if (!lInfo.getType().equals(unionEntry.getValue().getType())) {
                needsCast = true;
                column = ParseUtils.createConversionCast(column, (PrimitiveTypeInfo)unionEntry.getValue().getType());
            }
            columns.add(column);
        }
        if (!needsCast) {
            return origInputOp;
        }
        RowResolver rowResolver = new RowResolver();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> colName = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            String name = SemanticAnalyzer.getColumnInternalName(i);
            ColumnInfo col = new ColumnInfo(name, ((ExprNodeDesc)columns.get(i)).getTypeInfo(), "", false);
            rowResolver.put(origInputAlias, name, col);
            colName.add(name);
            columnExprMap.put(name, (ExprNodeDesc)columns.get(i));
        }
        Operator<SelectDesc> newInputOp = OperatorFactory.getAndMakeChild(new SelectDesc(columns, colName), new RowSchema(rowResolver.getColumnInfos()), columnExprMap, origInputOp);
        return this.putOpInsertMap(newInputOp, rowResolver);
    }

    private ExprNodeDesc genSamplePredicate(TableSample ts, List<String> bucketCols, boolean useBucketCols, String alias, RowResolver rwsch, QBMetaData qbm, ExprNodeDesc planExpr) throws SemanticException {
        ExprNodeConstantDesc numeratorExpr = new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ts.getNumerator() - 1);
        ExprNodeConstantDesc denominatorExpr = new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, ts.getDenominator());
        ExprNodeConstantDesc intMaxExpr = new ExprNodeConstantDesc(TypeInfoFactory.intTypeInfo, Integer.MAX_VALUE);
        ArrayList<ExprNodeDesc> args = new ArrayList<ExprNodeDesc>();
        if (planExpr != null) {
            args.add(planExpr);
        } else if (useBucketCols) {
            for (String col : bucketCols) {
                ColumnInfo ci = rwsch.get(alias, col);
                args.add(new ExprNodeColumnDesc(ci.getType(), ci.getInternalName(), ci.getTabAlias(), ci.getIsVirtualCol()));
            }
        } else {
            for (ASTNode expr : ts.getExprs()) {
                args.add(this.genExprNodeDesc(expr, rwsch));
            }
        }
        ExprNodeDesc equalsExpr = null;
        ExprNodeGenericFuncDesc hashfnExpr = new ExprNodeGenericFuncDesc(TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFHash(), args);
        assert (hashfnExpr != null);
        this.LOG.info((Object)("hashfnExpr = " + hashfnExpr));
        ExprNodeDesc andExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("&", hashfnExpr, intMaxExpr);
        assert (andExpr != null);
        this.LOG.info((Object)("andExpr = " + andExpr));
        ExprNodeDesc modExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("%", andExpr, denominatorExpr);
        assert (modExpr != null);
        this.LOG.info((Object)("modExpr = " + modExpr));
        this.LOG.info((Object)("numeratorExpr = " + numeratorExpr));
        equalsExpr = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("==", modExpr, numeratorExpr);
        this.LOG.info((Object)("equalsExpr = " + equalsExpr));
        assert (equalsExpr != null);
        return equalsExpr;
    }

    private String getAliasId(String alias, QB qb) {
        return qb.getId() == null ? alias : qb.getId() + ":" + alias;
    }

    private Operator genTablePlan(String alias, QB qb) throws SemanticException {
        RowResolver rwsch;
        String alias_id = this.getAliasId(alias, qb);
        Table tab = qb.getMetaData().getSrcForAlias(alias);
        Operator<? extends OperatorDesc> top = this.topOps.get(alias_id);
        Operator<? extends OperatorDesc> dummySel = this.topSelOps.get(alias_id);
        if (dummySel != null) {
            top = dummySel;
        }
        if (top == null) {
            rwsch = new RowResolver();
            try {
                StructObjectInspector rowObjectInspector = (StructObjectInspector)tab.getDeserializer().getObjectInspector();
                List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    ColumnInfo colInfo = new ColumnInfo(fields.get(i).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()), alias, false);
                    colInfo.setSkewedCol(this.isSkewedCol(alias, qb, fields.get(i).getFieldName()));
                    rwsch.put(alias, fields.get(i).getFieldName(), colInfo);
                }
            }
            catch (SerDeException e) {
                throw new RuntimeException(e);
            }
            for (FieldSchema part_col : tab.getPartCols()) {
                this.LOG.trace((Object)("Adding partition col: " + part_col));
                rwsch.put(alias, part_col.getName(), new ColumnInfo(part_col.getName(), TypeInfoFactory.stringTypeInfo, alias, true));
            }
            Iterator<VirtualColumn> vcs = VirtualColumn.getRegistry(this.conf).iterator();
            ArrayList<VirtualColumn> vcList = new ArrayList<VirtualColumn>();
            while (vcs.hasNext()) {
                VirtualColumn vc = vcs.next();
                rwsch.put(alias, vc.getName(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), alias, true, vc.getIsHidden()));
                vcList.add(vc);
            }
            TableScanDesc tsDesc = new TableScanDesc(alias, vcList);
            this.setupStats(tsDesc, qb.getParseInfo(), tab, alias, rwsch);
            SplitSample sample = this.nameToSplitSample.get(alias_id);
            if (sample != null && sample.getRowCount() != null) {
                tsDesc.setRowLimit(sample.getRowCount());
                this.nameToSplitSample.remove(alias_id);
            }
            top = this.putOpInsertMap(OperatorFactory.get(tsDesc, new RowSchema(rwsch.getColumnInfos()), new Operator[0]), rwsch);
            this.topOps.put(alias_id, top);
            this.topToTable.put((TableScanOperator)top, tab);
            Map<String, String> props = qb.getTabPropsForAlias(alias);
            if (props != null) {
                this.topToTableProps.put((TableScanOperator)top, props);
            }
        } else {
            rwsch = this.opParseCtx.get(top).getRowResolver();
            top.setChildOperators(null);
        }
        Operator<? extends OperatorDesc> tableOp = top;
        TableSample ts = qb.getParseInfo().getTabSample(alias);
        if (ts != null) {
            int num = ts.getNumerator();
            int den = ts.getDenominator();
            ArrayList<ASTNode> sampleExprs = ts.getExprs();
            List<String> tabBucketCols = tab.getBucketCols();
            int numBuckets = tab.getNumBuckets();
            if (tabBucketCols.size() == 0 && sampleExprs.size() == 0) {
                throw new SemanticException(ErrorMsg.NON_BUCKETED_TABLE.getMsg() + " " + tab.getTableName());
            }
            if (num > den) {
                throw new SemanticException(ErrorMsg.BUCKETED_NUMERATOR_BIGGER_DENOMINATOR.getMsg() + " " + tab.getTableName());
            }
            boolean colsEqual = true;
            if (sampleExprs.size() != tabBucketCols.size() && sampleExprs.size() != 0) {
                colsEqual = false;
            }
            for (int i = 0; i < sampleExprs.size() && colsEqual; ++i) {
                boolean colFound = false;
                for (int j = 0; j < tabBucketCols.size() && !colFound && sampleExprs.get(i).getToken().getType() == 794; ++j) {
                    if (!((ASTNode)sampleExprs.get(i).getChild(0)).getText().equalsIgnoreCase(tabBucketCols.get(j))) continue;
                    colFound = true;
                }
                colsEqual = colsEqual && colFound;
            }
            ts.setInputPruning(sampleExprs == null || sampleExprs.size() == 0 || colsEqual);
            if (!(sampleExprs != null && sampleExprs.size() != 0 && !colsEqual || num != den && den % numBuckets != 0 && numBuckets % den != 0)) {
                this.LOG.info((Object)"No need for sample filter");
                ExprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, qb.getMetaData(), null);
                tableOp = OperatorFactory.getAndMakeChild(new FilterDesc(samplePredicate, true, new FilterDesc.sampleDesc(ts.getNumerator(), ts.getDenominator(), tabBucketCols, true)), new RowSchema(rwsch.getColumnInfos()), top);
            } else {
                this.LOG.info((Object)"Need sample filter");
                ExprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, qb.getMetaData(), null);
                tableOp = OperatorFactory.getAndMakeChild(new FilterDesc(samplePredicate, true), new RowSchema(rwsch.getColumnInfos()), top);
            }
        } else {
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODE);
            if (testMode) {
                String tabName = tab.getTableName();
                String unSampleTblList = this.conf.getVar(HiveConf.ConfVars.HIVETESTMODENOSAMPLE);
                String[] unSampleTbls = unSampleTblList.split(",");
                boolean unsample = false;
                for (String unSampleTbl : unSampleTbls) {
                    if (!tabName.equalsIgnoreCase(unSampleTbl)) continue;
                    unsample = true;
                }
                if (!unsample) {
                    int numBuckets = tab.getNumBuckets();
                    if (numBuckets > 0) {
                        TableSample tsSample = new TableSample(1, numBuckets);
                        tsSample.setInputPruning(true);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        ExprNodeDesc samplePred = this.genSamplePredicate(tsSample, tab.getBucketCols(), true, alias, rwsch, qb.getMetaData(), null);
                        tableOp = OperatorFactory.getAndMakeChild(new FilterDesc(samplePred, true, new FilterDesc.sampleDesc(tsSample.getNumerator(), tsSample.getDenominator(), tab.getBucketCols(), true)), new RowSchema(rwsch.getColumnInfos()), top);
                        this.LOG.info((Object)"No need for sample filter");
                    } else {
                        int freq = this.conf.getIntVar(HiveConf.ConfVars.HIVETESTMODESAMPLEFREQ);
                        TableSample tsSample = new TableSample(1, freq);
                        tsSample.setInputPruning(false);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        this.LOG.info((Object)"Need sample filter");
                        ExprNodeDesc randFunc = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new ExprNodeConstantDesc(460476415));
                        ExprNodeDesc samplePred = this.genSamplePredicate(tsSample, null, false, alias, rwsch, qb.getMetaData(), randFunc);
                        tableOp = OperatorFactory.getAndMakeChild(new FilterDesc(samplePred, true), new RowSchema(rwsch.getColumnInfos()), top);
                    }
                }
            }
        }
        Operator<? extends OperatorDesc> output = this.putOpInsertMap(tableOp, rwsch);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created Table Plan for " + alias + " " + tableOp.toString()));
        }
        return output;
    }

    private boolean isSkewedCol(String alias, QB qb, String colName) {
        boolean isSkewedCol = false;
        List<String> skewedCols = qb.getSkewedColumnNames(alias);
        for (String skewedCol : skewedCols) {
            if (!skewedCol.equalsIgnoreCase(colName)) continue;
            isSkewedCol = true;
        }
        return isSkewedCol;
    }

    private void setupStats(TableScanDesc tsDesc, QBParseInfo qbp, Table tab, String alias, RowResolver rwsch) throws SemanticException {
        if (!qbp.isAnalyzeCommand()) {
            tsDesc.setGatherStats(false);
        } else {
            tsDesc.setGatherStats(true);
            tsDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
            tsDesc.setMaxStatsKeyPrefixLength(this.conf.getIntVar(HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX_MAX_LENGTH));
            Iterator<VirtualColumn> vcs = VirtualColumn.getStatsRegistry(this.conf).iterator();
            ArrayList<VirtualColumn> vcList = new ArrayList<VirtualColumn>();
            while (vcs.hasNext()) {
                VirtualColumn vc = vcs.next();
                rwsch.put(alias, vc.getName(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), alias, true, vc.getIsHidden()));
                vcList.add(vc);
            }
            tsDesc.addVirtualCols(vcList);
            String tblName = tab.getTableName();
            BaseSemanticAnalyzer.tableSpec tblSpec = qbp.getTableSpec(alias);
            Map<String, String> partSpec = tblSpec.getPartSpec();
            if (partSpec != null) {
                ArrayList<String> cols = new ArrayList<String>();
                cols.addAll(partSpec.keySet());
                tsDesc.setPartColumns(cols);
            }
            String k = tblName + "/";
            tsDesc.setStatsAggPrefix(k);
            this.outputs.add(new WriteEntity(tab, true));
            if (tab.isPartitioned()) {
                if (partSpec == null) {
                    throw new SemanticException(ErrorMsg.NEED_PARTITION_SPECIFICATION.getMsg());
                }
                List<Partition> partitions = qbp.getTableSpec().partitions;
                if (partitions != null) {
                    for (Partition partn : partitions) {
                        this.outputs.add(new WriteEntity(partn, true));
                    }
                }
            }
        }
    }

    private Operator genPlan(QBExpr qbexpr) throws SemanticException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            return this.genPlan(qbexpr.getQB());
        }
        if (qbexpr.getOpcode() == QBExpr.Opcode.UNION) {
            Operator qbexpr1Ops = this.genPlan(qbexpr.getQBExpr1());
            Operator qbexpr2Ops = this.genPlan(qbexpr.getQBExpr2());
            return this.genUnionPlan(qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
        }
        return null;
    }

    public Operator genPlan(QB qb) throws SemanticException {
        HashMap<ASTNode, PTFInvocationSpec> ptfNodeToSpec;
        HashMap<String, Operator> aliasToOpInfo = new HashMap<String, Operator>();
        for (String alias : qb.getSubqAliases()) {
            QBExpr qbexpr = qb.getSubqForAlias(alias);
            aliasToOpInfo.put(alias, this.genPlan(qbexpr));
            qbexpr.setAlias(alias);
        }
        for (String alias : qb.getTabAliases()) {
            Operator op = this.genTablePlan(alias, qb);
            aliasToOpInfo.put(alias, op);
        }
        Operator srcOpInfo = null;
        Operator lastPTFOp = null;
        if (this.queryProperties.hasPTF() && (ptfNodeToSpec = qb.getPTFNodeToSpec()) != null) {
            for (Map.Entry<ASTNode, PTFInvocationSpec> entry : ptfNodeToSpec.entrySet()) {
                ASTNode ast = entry.getKey();
                PTFInvocationSpec spec = entry.getValue();
                String inputAlias = spec.getQueryInputName();
                Operator inOp = (Operator)aliasToOpInfo.get(inputAlias);
                if (inOp == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Cannot resolve input Operator for PTF invocation"));
                }
                lastPTFOp = this.genPTFPlan(spec, inOp);
                String ptfAlias = spec.getFunction().getAlias();
                if (ptfAlias == null) continue;
                aliasToOpInfo.put(ptfAlias, lastPTFOp);
            }
        }
        this.genLateralViewPlans(aliasToOpInfo, qb);
        if (qb.getParseInfo().getJoinExpr() != null) {
            QBJoinTree joinTree;
            ASTNode joinExpr = qb.getParseInfo().getJoinExpr();
            if (joinExpr.getToken().getType() == 814) {
                joinTree = this.genUniqueJoinTree(qb, joinExpr, aliasToOpInfo);
                qb.setQbJoinTree(joinTree);
            } else {
                joinTree = this.genJoinTree(qb, joinExpr, aliasToOpInfo);
                qb.setQbJoinTree(joinTree);
                this.mergeJoinTree(qb);
            }
            this.pushJoinFilters(qb, qb.getQbJoinTree(), aliasToOpInfo);
            srcOpInfo = this.genJoinPlan(qb, aliasToOpInfo);
        } else {
            srcOpInfo = (Operator)aliasToOpInfo.values().iterator().next();
            srcOpInfo = lastPTFOp != null ? lastPTFOp : srcOpInfo;
        }
        Operator bodyOpInfo = this.genBodyPlan(qb, srcOpInfo);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Created Plan for Query Block " + qb.getId()));
        }
        this.qb = qb;
        return bodyOpInfo;
    }

    void genLateralViewPlans(Map<String, Operator> aliasToOpInfo, QB qb) throws SemanticException {
        Map<String, ArrayList<ASTNode>> aliasToLateralViews = qb.getParseInfo().getAliasToLateralViews();
        for (Map.Entry<String, Operator> e : aliasToOpInfo.entrySet()) {
            String alias = e.getKey();
            ArrayList<ASTNode> lateralViews = aliasToLateralViews.get(alias);
            if (lateralViews == null) continue;
            Operator op = e.getValue();
            for (ASTNode lateralViewTree : aliasToLateralViews.get(alias)) {
                Operator lateralViewJoin;
                op = lateralViewJoin = this.genLateralViewPlan(qb, op, lateralViewTree);
            }
            e.setValue(op);
        }
    }

    private Operator genLateralViewPlanForDest(String dest, QB qb, Operator op) throws SemanticException {
        ASTNode lateralViewTree = qb.getParseInfo().getDestToLateralView().get(dest);
        if (lateralViewTree != null) {
            return this.genLateralViewPlan(qb, op, lateralViewTree);
        }
        return op;
    }

    private Operator genLateralViewPlan(QB qb, Operator op, ASTNode lateralViewTree) throws SemanticException {
        RowResolver lvForwardRR = new RowResolver();
        RowResolver source = this.opParseCtx.get(op).getRowResolver();
        for (ColumnInfo col : source.getColumnInfos()) {
            String[] tabCol = source.reverseLookup(col.getInternalName());
            lvForwardRR.put(tabCol[0], tabCol[1], col);
        }
        Operator<LateralViewForwardDesc> lvForward = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new LateralViewForwardDesc(), new RowSchema(lvForwardRR.getColumnInfos()), op), lvForwardRR);
        RowResolver allPathRR = this.opParseCtx.get(lvForward).getRowResolver();
        Operator<SelectDesc> allPath = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(true), new RowSchema(allPathRR.getColumnInfos()), lvForward), allPathRR);
        QB blankQb = new QB(null, null, false);
        Operator<?> udtfPath = this.genSelectPlan((ASTNode)lateralViewTree.getChild(0), blankQb, lvForward, lateralViewTree.getType() == 668);
        for (String udtfAlias : blankQb.getAliases()) {
            qb.addAlias(udtfAlias);
        }
        RowResolver udtfPathRR = this.opParseCtx.get(udtfPath).getRowResolver();
        RowResolver lateralViewRR = new RowResolver();
        ArrayList<String> outputInternalColNames = new ArrayList<String>();
        this.LVmergeRowResolvers(allPathRR, lateralViewRR, outputInternalColNames);
        this.LVmergeRowResolvers(udtfPathRR, lateralViewRR, outputInternalColNames);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        int i = 0;
        for (ColumnInfo c : allPathRR.getColumnInfos()) {
            String internalName = SemanticAnalyzer.getColumnInternalName(i);
            ++i;
            colExprMap.put(internalName, new ExprNodeColumnDesc(c.getType(), c.getInternalName(), c.getTabAlias(), c.getIsVirtualCol()));
        }
        Operator<LateralViewJoinDesc> lateralViewJoin = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new LateralViewJoinDesc(outputInternalColNames), new RowSchema(lateralViewRR.getColumnInfos()), allPath, udtfPath), lateralViewRR);
        lateralViewJoin.setColumnExprMap(colExprMap);
        return lateralViewJoin;
    }

    private void LVmergeRowResolvers(RowResolver source, RowResolver dest, ArrayList<String> outputInternalColNames) {
        for (ColumnInfo c : source.getColumnInfos()) {
            String internalName = SemanticAnalyzer.getColumnInternalName(outputInternalColNames.size());
            outputInternalColNames.add(internalName);
            ColumnInfo newCol = new ColumnInfo(internalName, c.getType(), c.getTabAlias(), c.getIsVirtualCol(), c.isHiddenVirtualCol());
            String[] tableCol = source.reverseLookup(c.getInternalName());
            String tableAlias = tableCol[0];
            String colAlias = tableCol[1];
            dest.put(tableAlias, colAlias, newCol);
        }
    }

    public Phase1Ctx initPhase1Ctx() {
        Phase1Ctx ctx_1 = new Phase1Ctx();
        ctx_1.nextNum = 0;
        ctx_1.dest = "reduce";
        return ctx_1;
    }

    @Override
    public void init() {
        QB qb;
        this.reset();
        this.qb = qb = new QB(null, null, false);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        Phase1Ctx ctx_1;
        ASTNode child = ast;
        this.ast = ast;
        this.viewsExpanded = new ArrayList();
        this.LOG.info((Object)"Starting Semantic Analysis");
        this.processPositionAlias(ast);
        if (ast.getToken().getType() == 599) {
            child = this.analyzeCreateTable(ast, this.qb);
            if (child == null) {
                return;
            }
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_INSERT_DEST_VOLUME) && this.qb.isCTAS()) {
                String dest_path = this.getCTASTableLocation();
                this.ctx.changeDFSScratchDir(dest_path + "/" + this.conf.getVar(HiveConf.ConfVars.HIVE_SCRATCH_DIR_IN_DEST));
            }
        } else {
            SessionState.get().setCommandType(HiveOperation.QUERY);
        }
        if (ast.getToken().getType() == 600 || ast.getToken().getType() == 581) {
            child = this.analyzeCreateView(ast, this.qb);
            SessionState.get().setCommandType(HiveOperation.CREATEVIEW);
            if (child == null) {
                return;
            }
            this.viewSelect = child;
            this.viewsExpanded.add(SessionState.get().getCurrentDatabase() + "." + this.createVwDesc.getViewName());
        }
        if (!this.doPhase1(child, this.qb, ctx_1 = this.initPhase1Ctx())) {
            return;
        }
        this.LOG.info((Object)"Completed phase 1 of Semantic Analysis");
        this.getMetaData(this.qb);
        this.LOG.info((Object)"Completed getting MetaData in Semantic Analysis");
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_INSERT_DEST_VOLUME) && this.isInsertQueryForOptimize) {
            String destClause = this.destClauseForInsertOptimizer;
            QBMetaData qbm = this.qb.getMetaData();
            Integer dest_type = qbm.getDestTypeForAlias(destClause);
            String scratchDir = "/" + this.conf.getVar(HiveConf.ConfVars.HIVE_SCRATCH_DIR_IN_DEST);
            switch (dest_type) {
                case 1: {
                    Table dest_tab = qbm.getDestTableForAlias(destClause);
                    if (dest_tab.isNonNative()) break;
                    this.ctx.changeDFSScratchDir(dest_tab.getPath().toString() + scratchDir);
                    break;
                }
                case 2: {
                    Partition dest_part = qbm.getDestPartitionForAlias(destClause);
                    Table dest_tab = dest_part.getTable();
                    Path tabPath = dest_tab.getPath();
                    Path partPath = dest_part.getPartitionPath();
                    Path dest_path = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                    this.ctx.changeDFSScratchDir(dest_path.toString() + scratchDir);
                    break;
                }
                case 3: {
                    Path dest_path = new Path(qbm.getDestFileForAlias(destClause));
                    this.ctx.changeDFSScratchDir(dest_path.toString() + scratchDir);
                    break;
                }
                default: {
                    this.LOG.error((Object)"Unknown destination type");
                }
            }
        }
        Operator sinkOp = this.genPlan(this.qb);
        this.resultSchema = this.convertRowSchemaToViewSchema(this.opParseCtx.get(sinkOp).getRowResolver());
        if (this.createVwDesc != null) {
            this.saveViewDefinition();
            this.validateCreateView(this.createVwDesc);
            this.ctx.setResDir(null);
            this.ctx.setResFile(null);
            return;
        }
        ParseContext pCtx = new ParseContext(this.conf, this.qb, child, this.opToPartPruner, this.opToPartList, this.topOps, this.topSelOps, this.opParseCtx, this.joinContext, this.smbMapJoinContext, this.topToTable, this.topToTableProps, this.fsopToTable, this.loadTableWork, this.loadFileWork, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.groupOpToInputTables, this.prunedPartitions, this.opToSamplePruner, this.globalLimitCtx, this.nameToSplitSample, this.inputs, this.rootTasks, this.opToPartToSkewedPruner, this.viewAliasToInput, this.reduceSinkOperatorsAddedByEnforceBucketingSorting, this.queryProperties);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_TABLEKEYS)) {
            TableAccessAnalyzer tableAccessAnalyzer = new TableAccessAnalyzer(pCtx);
            this.setTableAccessInfo(tableAccessAnalyzer.analyzeTableAccess());
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Before logical optimization\n" + Operator.toString(pCtx.getTopOps().values())));
        }
        Optimizer optm = new Optimizer();
        optm.setPctx(pCtx);
        optm.initialize(this.conf);
        pCtx = optm.optimize();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("After logical optimization\n" + Operator.toString(pCtx.getTopOps().values())));
        }
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            ColumnAccessAnalyzer columnAccessAnalyzer = new ColumnAccessAnalyzer(pCtx);
            this.setColumnAccessInfo(columnAccessAnalyzer.analyzeColumnAccess());
        }
        if (!this.ctx.getExplainLogical()) {
            MapReduceCompiler compiler = new MapReduceCompiler();
            compiler.init(this.conf, this.console, this.db);
            compiler.compile(pCtx, this.rootTasks, this.inputs, this.outputs);
            this.fetchTask = pCtx.getFetchTask();
        }
        this.LOG.info((Object)"Completed plan generation");
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.resultSchema;
    }

    private String getCTASTableLocation() throws SemanticException {
        if (this.qb.getTableDesc() == null) {
            return null;
        }
        String location = this.qb.getTableDesc().getLocation();
        if (location == null) {
            Path targetPath;
            try {
                Table dumpTable = this.db.newTable(this.qb.getTableDesc().getTableName());
                if (!this.db.databaseExists(dumpTable.getDbName())) {
                    throw new SemanticException("ERROR: The database " + dumpTable.getDbName() + " does not exist.");
                }
                Warehouse wh = new Warehouse((Configuration)this.conf);
                targetPath = wh.getTablePath(this.db.getDatabase(dumpTable.getDbName()), dumpTable.getTableName());
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            catch (MetaException e) {
                throw new SemanticException(e);
            }
            location = targetPath.toString();
        }
        return location;
    }

    private void saveViewDefinition() throws SemanticException {
        int derivedColCount;
        int explicitColCount;
        ArrayList<FieldSchema> derivedSchema = new ArrayList<FieldSchema>(this.resultSchema);
        ParseUtils.validateColumnNameUniqueness(derivedSchema);
        List<FieldSchema> imposedSchema = this.createVwDesc.getSchema();
        if (imposedSchema != null && (explicitColCount = imposedSchema.size()) != (derivedColCount = derivedSchema.size())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(this.viewSelect, ErrorMsg.VIEW_COL_MISMATCH.getMsg()));
        }
        String originalText = this.ctx.getTokenRewriteStream().toString(this.viewSelect.getTokenStartIndex(), this.viewSelect.getTokenStopIndex());
        this.createVwDesc.setViewOriginalText(originalText);
        this.unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
        String expandedText = this.ctx.getTokenRewriteStream().toString(this.viewSelect.getTokenStartIndex(), this.viewSelect.getTokenStopIndex());
        if (imposedSchema != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            int n = derivedSchema.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                FieldSchema fieldSchema = (FieldSchema)derivedSchema.get(i);
                fieldSchema = new FieldSchema(fieldSchema);
                derivedSchema.set(i, fieldSchema);
                sb.append(HiveUtils.unparseIdentifier(fieldSchema.getName()));
                sb.append(" AS ");
                String imposedName = imposedSchema.get(i).getName();
                sb.append(HiveUtils.unparseIdentifier(imposedName));
                fieldSchema.setName(imposedName);
                fieldSchema.setComment(imposedSchema.get(i).getComment());
            }
            sb.append(" FROM (");
            sb.append(expandedText);
            sb.append(") ");
            sb.append(HiveUtils.unparseIdentifier(this.createVwDesc.getViewName()));
            expandedText = sb.toString();
        }
        if (this.createVwDesc.getPartColNames() != null) {
            List<String> partColNames = this.createVwDesc.getPartColNames();
            if (partColNames.size() > derivedSchema.size()) {
                throw new SemanticException(ErrorMsg.VIEW_PARTITION_MISMATCH.getMsg());
            }
            List partitionColumns = derivedSchema.subList(derivedSchema.size() - partColNames.size(), derivedSchema.size());
            Iterator<String> colNameIter = partColNames.iterator();
            Iterator schemaIter = partitionColumns.iterator();
            while (colNameIter.hasNext()) {
                String colName = colNameIter.next();
                FieldSchema fieldSchema = (FieldSchema)schemaIter.next();
                if (fieldSchema.getName().equals(colName)) continue;
                throw new SemanticException(ErrorMsg.VIEW_PARTITION_MISMATCH.getMsg());
            }
            if (partColNames.size() == derivedSchema.size()) {
                throw new SemanticException(ErrorMsg.VIEW_PARTITION_TOTAL.getMsg());
            }
            this.createVwDesc.setPartCols(new ArrayList<FieldSchema>(partitionColumns));
            partitionColumns.clear();
        }
        this.createVwDesc.setSchema(derivedSchema);
        this.createVwDesc.setViewExpandedText(expandedText);
    }

    private List<FieldSchema> convertRowSchemaToViewSchema(RowResolver rr) {
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        for (ColumnInfo colInfo : rr.getColumnInfos()) {
            if (colInfo.isHiddenVirtualCol()) continue;
            String colName = rr.reverseLookup(colInfo.getInternalName())[1];
            fieldSchemas.add(new FieldSchema(colName, colInfo.getType().getTypeName(), null));
        }
        return fieldSchemas;
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input);
        return this.genExprNodeDesc(expr, input, tcCtx);
    }

    public Map<ASTNode, ExprNodeDesc> genAllExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input);
        return this.genAllExprNodeDesc(expr, input, tcCtx);
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        ExprNodeDesc cached = this.getExprNodeDescCached(expr, input);
        if (cached == null) {
            Map<ASTNode, ExprNodeDesc> allExprs = this.genAllExprNodeDesc(expr, input, tcCtx);
            return allExprs.get(expr);
        }
        return cached;
    }

    private ExprNodeDesc getExprNodeDescCached(ASTNode expr, RowResolver input) throws SemanticException {
        ColumnInfo colInfo = input.getExpression(expr);
        if (colInfo != null) {
            ASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                this.unparseTranslator.addCopyTranslation(expr, source);
            }
            return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
        }
        return null;
    }

    public Map<ASTNode, ExprNodeDesc> genAllExprNodeDesc(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        Map<ASTNode, ExprNodeDesc> nodeOutputs = TypeCheckProcFactory.genExprNode(expr, tcCtx);
        ExprNodeDesc desc = nodeOutputs.get(expr);
        if (desc == null) {
            String errMsg = tcCtx.getError();
            if (errMsg == null) {
                errMsg = "Error in parsing ";
            }
            throw new SemanticException(errMsg);
        }
        if (desc instanceof ExprNodeColumnListDesc) {
            throw new SemanticException("TOK_ALLCOLREF is not supported in current context");
        }
        if (!this.unparseTranslator.isEnabled()) {
            return nodeOutputs;
        }
        for (Map.Entry<ASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
            if (!(entry.getValue() instanceof ExprNodeColumnDesc)) continue;
            ASTNode node = entry.getKey();
            ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)entry.getValue();
            if (columnDesc.getTabAlias() == null || columnDesc.getTabAlias().length() == 0) continue;
            String[] tmp = input.reverseLookup(columnDesc.getColumn());
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(tmp[0]));
            replacementText.append(".");
            replacementText.append(HiveUtils.unparseIdentifier(tmp[1]));
            this.unparseTranslator.addTranslation(node, replacementText.toString());
        }
        return nodeOutputs;
    }

    @Override
    public void validate() throws SemanticException {
        Partition p;
        Table tbl;
        Entity.Type type;
        this.LOG.debug((Object)"validation start");
        for (ReadEntity readEntity : this.getInputs()) {
            type = readEntity.getType();
            if (type != Entity.Type.TABLE && type != Entity.Type.PARTITION) continue;
            tbl = readEntity.getTable();
            p = readEntity.getPartition();
            if (tbl.isOffline()) {
                throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg("Table " + tbl.getTableName()));
            }
            if (type != Entity.Type.PARTITION || p == null || !p.isOffline()) continue;
            throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg("Table " + tbl.getTableName() + " Partition " + p.getName()));
        }
        for (WriteEntity writeEntity : this.getOutputs()) {
            type = writeEntity.getType();
            if (type == Entity.Type.PARTITION || type == Entity.Type.DUMMYPARTITION) {
                String conflictingArchive;
                try {
                    Partition usedp = writeEntity.getPartition();
                    Table tbl2 = usedp.getTable();
                    this.LOG.debug((Object)("validated " + usedp.getName()));
                    this.LOG.debug((Object)usedp.getTable());
                    conflictingArchive = ArchiveUtils.conflictingArchiveNameOrNull(this.db, tbl2, usedp.getSpec());
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                if (conflictingArchive != null) {
                    String message = String.format("Insert conflict with existing archive: %s", conflictingArchive);
                    throw new SemanticException(message);
                }
            }
            if (type != Entity.Type.TABLE && type != Entity.Type.PARTITION) {
                this.LOG.debug((Object)"not validating writeEntity, because entity is neither table nor partition");
                continue;
            }
            if (type == Entity.Type.PARTITION) {
                Partition inputPartition = writeEntity.getPartition();
                try {
                    p = Hive.get().getPartition(inputPartition.getTable(), inputPartition.getSpec(), false);
                    tbl = p != null ? p.getTable() : inputPartition.getTable();
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                if (type == Entity.Type.PARTITION && p != null && p.isOffline()) {
                    throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg(" Table " + tbl.getTableName() + " Partition " + p.getName()));
                }
            } else {
                this.LOG.debug((Object)"Not a partition.");
                tbl = writeEntity.getTable();
            }
            if (!tbl.isOffline()) continue;
            throw new SemanticException(ErrorMsg.OFFLINE_TABLE_OR_PARTITION.getMsg("Table " + tbl.getTableName()));
        }
        boolean reworkMapredWork = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_REWORK_MAPREDWORK);
        for (Task rootTask : this.rootTasks) {
            this.validate(rootTask, reworkMapredWork);
        }
    }

    private void validate(Task<? extends Serializable> task, boolean reworkMapredWork) throws SemanticException {
        Utilities.reworkMapRedWork(task, reworkMapredWork, this.conf);
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            this.validate(childTask, reworkMapredWork);
        }
    }

    public RowResolver getRowResolver(Operator opt) {
        return this.opParseCtx.get(opt).getRowResolver();
    }

    private Map<String, String> addDefaultProperties(Map<String, String> tblProp) {
        Map<String, String> retValue = tblProp == null ? new HashMap<String, String>() : tblProp;
        String paraString = HiveConf.getVar(this.conf, HiveConf.ConfVars.NEWTABLEDEFAULTPARA);
        if (paraString != null && !paraString.isEmpty()) {
            for (String keyValuePair : paraString.split(",")) {
                String[] keyValue = keyValuePair.split("=", 2);
                if (keyValue.length != 2 || retValue.containsKey(keyValue[0])) continue;
                retValue.put(keyValue[0], keyValue[1]);
            }
        }
        return retValue;
    }

    private ASTNode analyzeCreateTable(ASTNode ast, QB qb) throws SemanticException {
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String likeTableName = null;
        List<Object> cols = new ArrayList();
        ArrayList<FieldSchema> partCols = new ArrayList();
        List<Object> bucketCols = new ArrayList();
        List<Order> sortCols = new ArrayList<Order>();
        int numBuckets = -1;
        String comment = null;
        String location = null;
        Map<String, String> tblProps = null;
        boolean ifNotExists = false;
        boolean isExt = false;
        ASTNode selectStmt = null;
        boolean CREATE_TABLE = false;
        boolean CTLT = true;
        int CTAS = 2;
        int command_type = 0;
        List<String> skewedColNames = new ArrayList<String>();
        ArrayList<List<String>> skewedValues = new ArrayList<List<String>>();
        HashMap listBucketColValuesMapping = new HashMap();
        boolean storedAsDirs = false;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        BaseSemanticAnalyzer.StorageFormat storageFormat = new BaseSemanticAnalyzer.StorageFormat();
        BaseSemanticAnalyzer.AnalyzeCreateCommonVars shared = new BaseSemanticAnalyzer.AnalyzeCreateCommonVars();
        this.LOG.info((Object)("Creating table " + tableName + " position=" + ast.getCharPositionInLine()));
        int numCh = ast.getChildCount();
        block25: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child, shared)) continue;
            switch (child.getToken().getType()) {
                case 655: {
                    ifNotExists = true;
                    continue block25;
                }
                case 96: {
                    isExt = true;
                    continue block25;
                }
                case 672: {
                    if (child.getChildCount() <= 0) continue block25;
                    likeTableName = SemanticAnalyzer.getUnescapedName((ASTNode)child.getChild(0));
                    if (likeTableName != null) {
                        if (command_type == 2) {
                            throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                        }
                        if (cols.size() != 0) {
                            throw new SemanticException(ErrorMsg.CTLT_COLLST_COEXISTENCE.getMsg());
                        }
                    }
                    command_type = 1;
                    continue block25;
                }
                case 727: {
                    if (command_type == 1) {
                        throw new SemanticException(ErrorMsg.CTAS_CTLT_COEXISTENCE.getMsg());
                    }
                    if (cols.size() != 0) {
                        throw new SemanticException(ErrorMsg.CTAS_COLLST_COEXISTENCE.getMsg());
                    }
                    if (partCols.size() != 0 || bucketCols.size() != 0) {
                        boolean dynPart = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING);
                        if (!dynPart) {
                            throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                        }
                        throw new SemanticException(ErrorMsg.CTAS_PARCOL_COEXISTENCE.getMsg());
                    }
                    if (isExt) {
                        throw new SemanticException(ErrorMsg.CTAS_EXTTBL_COEXISTENCE.getMsg());
                    }
                    command_type = 2;
                    selectStmt = child;
                    continue block25;
                }
                case 772: {
                    cols = this.getColumns(child);
                    continue block25;
                }
                case 779: {
                    comment = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block25;
                }
                case 782: {
                    partCols = SemanticAnalyzer.getColumns((ASTNode)child.getChild(0), false);
                    continue block25;
                }
                case 777: {
                    bucketCols = this.getColumnNames((ASTNode)child.getChild(0));
                    if (child.getChildCount() == 2) {
                        numBuckets = Integer.valueOf(child.getChild(1).getText());
                        continue block25;
                    }
                    sortCols = this.getColumnNamesOrder((ASTNode)child.getChild(1));
                    numBuckets = Integer.valueOf(child.getChild(2).getText());
                    continue block25;
                }
                case 786: {
                    rowFormatParams.analyzeRowFormat(shared, child);
                    continue block25;
                }
                case 781: {
                    location = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    location = EximUtil.relativeToAbsolutePath(this.conf, location);
                    continue block25;
                }
                case 783: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block25;
                }
                case 791: {
                    child = (ASTNode)child.getChild(0);
                    shared.serde = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    if (child.getChildCount() != 2) continue block25;
                    SemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), shared.serdeProps);
                    continue block25;
                }
                case 635: {
                    this.handleGenericFileFormat(child);
                    continue block25;
                }
                case 792: {
                    HiveConf hiveConf = SessionState.get().getConf();
                    skewedColNames = this.analyzeSkewedTablDDLColNames(skewedColNames, child);
                    this.analyzeDDLSkewedValues(skewedValues, child);
                    storedAsDirs = this.analyzeStoredAdDirs(child);
                    continue block25;
                }
                default: {
                    assert (false);
                    continue block25;
                }
            }
        }
        storageFormat.fillDefaultStorageFormat(shared);
        if (command_type == 2 && storageFormat.storageHandler != null) {
            throw new SemanticException(ErrorMsg.CREATE_NON_NATIVE_AS.getMsg());
        }
        if (ifNotExists) {
            try {
                Table table = this.db.getTable(tableName, false);
                if (table != null) {
                    return null;
                }
            }
            catch (HiveException e) {
                e.printStackTrace();
            }
        }
        CreateTableDesc crtTblDesc = null;
        switch (command_type) {
            case 0: {
                tblProps = this.addDefaultProperties(tblProps);
                crtTblDesc = new CreateTableDesc(tableName, isExt, cols, partCols, bucketCols, sortCols, numBuckets, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.collItemDelim, rowFormatParams.mapKeyDelim, rowFormatParams.lineDelim, comment, storageFormat.inputFormat, storageFormat.outputFormat, location, shared.serde, storageFormat.storageHandler, shared.serdeProps, tblProps, ifNotExists, skewedColNames, skewedValues);
                crtTblDesc.setStoredAsSubDirectories(storedAsDirs);
                crtTblDesc.validate();
                SessionState.get().setCommandType(HiveOperation.CREATETABLE);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblDesc), this.conf, new Task[0]));
                break;
            }
            case 1: {
                tblProps = this.addDefaultProperties(tblProps);
                CreateTableLikeDesc crtTblLikeDesc = new CreateTableLikeDesc(tableName, isExt, storageFormat.inputFormat, storageFormat.outputFormat, location, shared.serde, shared.serdeProps, tblProps, ifNotExists, likeTableName);
                SessionState.get().setCommandType(HiveOperation.CREATETABLE);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtTblLikeDesc), this.conf, new Task[0]));
                break;
            }
            case 2: {
                String databaseName;
                try {
                    Table dumpTable = this.db.newTable(tableName);
                    databaseName = dumpTable.getDbName();
                    if (null == this.db.getDatabase(dumpTable.getDbName())) {
                        throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(dumpTable.getDbName()));
                    }
                    if (null != this.db.getTable(dumpTable.getDbName(), dumpTable.getTableName(), false)) {
                        throw new SemanticException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(tableName));
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(e);
                }
                tblProps = this.addDefaultProperties(tblProps);
                crtTblDesc = new CreateTableDesc(databaseName, tableName, isExt, cols, partCols, bucketCols, sortCols, numBuckets, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.collItemDelim, rowFormatParams.mapKeyDelim, rowFormatParams.lineDelim, comment, storageFormat.inputFormat, storageFormat.outputFormat, location, shared.serde, storageFormat.storageHandler, shared.serdeProps, tblProps, ifNotExists, skewedColNames, skewedValues);
                crtTblDesc.setStoredAsSubDirectories(storedAsDirs);
                qb.setTableDesc(crtTblDesc);
                SessionState.get().setCommandType(HiveOperation.CREATETABLE_AS_SELECT);
                return selectStmt;
            }
            default: {
                throw new SemanticException("Unrecognized command.");
            }
        }
        return null;
    }

    private ASTNode analyzeCreateView(ASTNode ast, QB qb) throws SemanticException {
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<FieldSchema> cols = null;
        boolean ifNotExists = false;
        boolean orReplace = false;
        boolean isAlterViewAs = false;
        String comment = null;
        ASTNode selectStmt = null;
        HashMap<String, String> tblProps = null;
        List<String> partColNames = null;
        this.LOG.info((Object)("Creating view " + tableName + " position=" + ast.getCharPositionInLine()));
        int numCh = ast.getChildCount();
        block9: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 655: {
                    ifNotExists = true;
                    continue block9;
                }
                case 706: {
                    orReplace = true;
                    continue block9;
                }
                case 727: {
                    selectStmt = child;
                    continue block9;
                }
                case 773: {
                    cols = this.getColumns(child);
                    continue block9;
                }
                case 779: {
                    comment = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block9;
                }
                case 783: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block9;
                }
                case 820: {
                    partColNames = this.getColumnNames((ASTNode)child.getChild(0));
                    continue block9;
                }
                default: {
                    assert (false);
                    continue block9;
                }
            }
        }
        if (ifNotExists && orReplace) {
            throw new SemanticException("Can't combine IF NOT EXISTS and OR REPLACE.");
        }
        if (ast.getToken().getType() == 581) {
            isAlterViewAs = true;
            orReplace = true;
        }
        this.createVwDesc = new CreateViewDesc(tableName, cols, comment, tblProps, partColNames, ifNotExists, orReplace, isAlterViewAs);
        this.unparseTranslator.enable();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), this.createVwDesc), this.conf, new Task[0]));
        return selectStmt;
    }

    private void validateCreateView(CreateViewDesc createVwDesc) throws SemanticException {
        block7: {
            try {
                Table oldView = this.db.getTable(createVwDesc.getViewName(), false);
                if (createVwDesc.getIsAlterViewAs() && oldView == null) {
                    String viewNotExistErrorMsg = "The following view does not exist: " + createVwDesc.getViewName();
                    throw new SemanticException(ErrorMsg.ALTER_VIEW_AS_SELECT_NOT_EXIST.getMsg(viewNotExistErrorMsg));
                }
                if (!createVwDesc.getOrReplace() || oldView == null) break block7;
                if (!oldView.getTableType().equals((Object)TableType.VIRTUAL_VIEW)) {
                    String tableNotViewErrorMsg = "The following is an existing table, not a view: " + createVwDesc.getViewName();
                    throw new SemanticException(ErrorMsg.EXISTING_TABLE_IS_NOT_VIEW.getMsg(tableNotViewErrorMsg));
                }
                String partitionViewErrorMsg = "The following view has partition, it could not be replaced: " + createVwDesc.getViewName();
                try {
                    if (!(createVwDesc.getPartCols() != null && !createVwDesc.getPartCols().isEmpty() && ((Object)createVwDesc.getPartCols()).equals(oldView.getPartCols()) || oldView.getPartCols().isEmpty() || this.db.getPartitions(oldView).isEmpty())) {
                        throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_PARTITION.getMsg(partitionViewErrorMsg));
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException(ErrorMsg.REPLACE_VIEW_WITH_PARTITION.getMsg(partitionViewErrorMsg));
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage());
            }
        }
    }

    private void processPositionAlias(ASTNode ast) throws SemanticException {
        int child_pos;
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_GROUPBY_ORDERBY_POSITION_ALIAS)) {
            return;
        }
        if (ast.getChildCount() == 0) {
            return;
        }
        ASTNode selectNode = null;
        ASTNode groupbyNode = null;
        ASTNode orderbyNode = null;
        int child_count = ast.getChildCount();
        for (child_pos = 0; child_pos < child_count; ++child_pos) {
            ASTNode node = (ASTNode)ast.getChild(child_pos);
            int type = node.getToken().getType();
            if (type == 738) {
                selectNode = node;
                continue;
            }
            if (type == 646) {
                groupbyNode = node;
                continue;
            }
            if (type != 705) continue;
            orderbyNode = node;
        }
        if (selectNode != null) {
            int selectExpCnt = selectNode.getChildCount();
            if (groupbyNode != null) {
                for (int child_pos2 = 0; child_pos2 < groupbyNode.getChildCount(); ++child_pos2) {
                    ASTNode node = (ASTNode)groupbyNode.getChild(child_pos2);
                    if (node.getToken().getType() != 276) continue;
                    int pos = Integer.parseInt(node.getText());
                    if (pos > 0 && pos <= selectExpCnt) {
                        groupbyNode.setChild(child_pos2, (Tree)((BaseTree)selectNode.getChild(pos - 1).getChild(0)));
                        continue;
                    }
                    throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_GROUPBY.getMsg("Position alias: " + pos + " does not exist\n" + "The Select List is indexed from 1 to " + selectExpCnt));
                }
            }
            if (orderbyNode != null) {
                int child_pos3;
                boolean isAllCol = false;
                for (child_pos3 = 0; child_pos3 < selectNode.getChildCount(); ++child_pos3) {
                    ASTNode node = (ASTNode)selectNode.getChild(child_pos3).getChild(0);
                    if (node.getToken().getType() != 553) continue;
                    isAllCol = true;
                }
                for (child_pos3 = 0; child_pos3 < orderbyNode.getChildCount(); ++child_pos3) {
                    ASTNode colNode = (ASTNode)orderbyNode.getChild(child_pos3);
                    ASTNode node = (ASTNode)colNode.getChild(0);
                    if (node.getToken().getType() != 276) continue;
                    if (!isAllCol) {
                        int pos = Integer.parseInt(node.getText());
                        if (pos > 0 && pos <= selectExpCnt) {
                            colNode.setChild(0, (Tree)((BaseTree)selectNode.getChild(pos - 1).getChild(0)));
                            continue;
                        }
                        throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\n" + "The Select List is indexed from 1 to " + selectExpCnt));
                    }
                    throw new SemanticException(ErrorMsg.NO_SUPPORTED_ORDERBY_ALLCOLREF_POS.getMsg());
                }
            }
        }
        for (child_pos = 0; child_pos < child_count; ++child_pos) {
            this.processPositionAlias((ASTNode)ast.getChild(child_pos));
        }
    }

    protected void processPartialScanCommand(ASTNode tree) throws SemanticException {
        this.checkPartialScan(tree);
        if (this.partialscan) {
            this.validateAnalyzePartialscan(tree);
        }
    }

    protected void processNoScanCommand(ASTNode tree) throws SemanticException {
        this.checkNoScan(tree);
        if (this.noscan) {
            this.validateAnalyzeNoscan(tree);
        }
    }

    private void validateAnalyzeNoscan(ASTNode tree) throws SemanticException {
        Table tbl;
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_NOSCAN_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private void validateAnalyzePartialscan(ASTNode tree) throws SemanticException {
        Table tbl;
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        try {
            tbl = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_NON_NATIVE.getMsg(tbl.getTableName()));
        }
        if (tbl.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_EXTERNAL_TABLE.getMsg(tbl.getTableName()));
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_AUTOGATHER.getMsg());
        }
    }

    private void checkNoScan(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 769 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 796 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 156) {
            this.noscan = true;
        }
    }

    private void checkPartialScan(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 769 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 796 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 173) {
            this.partialscan = true;
        }
    }

    public QB getQB() {
        return this.qb;
    }

    public void setQB(QB qb) {
        this.qb = qb;
    }

    private PTFInvocationSpec.PTFInputSpec processPTFSource(QB qb, ASTNode inputNode) throws SemanticException {
        PTFInvocationSpec.PTFInputSpec qInSpec = null;
        int type = inputNode.getType();
        switch (type) {
            case 797: {
                String alias = this.processTable(qb, inputNode);
                qInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.TABLE);
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 767: {
                String alias = this.processSubQuery(qb, inputNode);
                qInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.SUBQUERY);
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 726: {
                qInSpec = this.processPTFChain(qb, inputNode);
                break;
            }
            default: {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(inputNode, "Unknown input type to PTF"));
            }
        }
        qInSpec.setAstNode(inputNode);
        return qInSpec;
    }

    private PTFInvocationSpec.PartitionedTableFunctionSpec processPTFChain(QB qb, ASTNode ptf) throws SemanticException {
        ASTNode pSpecNode;
        int child_count = ptf.getChildCount();
        if (child_count < 2) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ptf, "Not enough Children " + child_count));
        }
        PTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = new PTFInvocationSpec.PartitionedTableFunctionSpec();
        ptfSpec.setAstNode(ptf);
        ASTNode nameNode = (ASTNode)ptf.getChild(0);
        ptfSpec.setName(nameNode.getText());
        int inputIdx = 1;
        ASTNode secondChild = (ASTNode)ptf.getChild(1);
        if (secondChild.getType() == 26) {
            ptfSpec.setAlias(secondChild.getText());
            ++inputIdx;
        }
        ASTNode inputNode = (ASTNode)ptf.getChild(inputIdx);
        ptfSpec.setInput(this.processPTFSource(qb, inputNode));
        int argStartIdx = inputIdx + 1;
        int pSpecIdx = inputIdx + 1;
        ASTNode aSTNode = pSpecNode = ptf.getChildCount() > inputIdx ? (ASTNode)ptf.getChild(pSpecIdx) : null;
        if (pSpecNode != null && pSpecNode.getType() == 707) {
            PTFInvocationSpec.PartitioningSpec partitioning = this.processPTFPartitionSpec(pSpecNode);
            ptfSpec.setPartitioning(partitioning);
            ++argStartIdx;
        }
        for (int i = argStartIdx; i < ptf.getChildCount(); ++i) {
            ptfSpec.addArg((ASTNode)ptf.getChild(i));
        }
        return ptfSpec;
    }

    private void processPTF(QB qb, ASTNode ptf) throws SemanticException {
        PTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = this.processPTFChain(qb, ptf);
        if (ptfSpec.getAlias() != null) {
            qb.addAlias(ptfSpec.getAlias());
        }
        PTFInvocationSpec spec = new PTFInvocationSpec();
        spec.setFunction(ptfSpec);
        qb.addPTFNodeToSpec(ptf, spec);
    }

    private void handleQueryWindowClauses(QB qb, Phase1Ctx ctx_1, ASTNode node) throws SemanticException {
        WindowingSpec spec = qb.getWindowingSpec(ctx_1.dest);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.processQueryWindowClause(spec, (ASTNode)node.getChild(i));
        }
    }

    private PTFInvocationSpec.PartitionSpec processPartitionSpec(ASTNode node) {
        PTFInvocationSpec.PartitionSpec pSpec = new PTFInvocationSpec.PartitionSpec();
        int exprCnt = node.getChildCount();
        for (int i = 0; i < exprCnt; ++i) {
            PTFInvocationSpec.PartitionExpression exprSpec = new PTFInvocationSpec.PartitionExpression();
            exprSpec.setExpression((ASTNode)node.getChild(i));
            pSpec.addExpression(exprSpec);
        }
        return pSpec;
    }

    private PTFInvocationSpec.OrderSpec processOrderSpec(ASTNode sortNode) {
        PTFInvocationSpec.OrderSpec oSpec = new PTFInvocationSpec.OrderSpec();
        int exprCnt = sortNode.getChildCount();
        for (int i = 0; i < exprCnt; ++i) {
            PTFInvocationSpec.OrderExpression exprSpec = new PTFInvocationSpec.OrderExpression();
            exprSpec.setExpression((ASTNode)sortNode.getChild(i).getChild(0));
            if (sortNode.getChild(i).getType() == 798) {
                exprSpec.setOrder(PTFInvocationSpec.Order.ASC);
            } else {
                exprSpec.setOrder(PTFInvocationSpec.Order.DESC);
            }
            oSpec.addExpression(exprSpec);
        }
        return oSpec;
    }

    private PTFInvocationSpec.PartitioningSpec processPTFPartitionSpec(ASTNode pSpecNode) {
        PTFInvocationSpec.PartitioningSpec partitioning = new PTFInvocationSpec.PartitioningSpec();
        ASTNode firstChild = (ASTNode)pSpecNode.getChild(0);
        int type = firstChild.getType();
        if (type == 618 || type == 591) {
            ASTNode sortNode;
            PTFInvocationSpec.PartitionSpec pSpec = this.processPartitionSpec(firstChild);
            partitioning.setPartSpec(pSpec);
            ASTNode aSTNode = sortNode = pSpecNode.getChildCount() > 1 ? (ASTNode)pSpecNode.getChild(1) : null;
            if (sortNode != null) {
                PTFInvocationSpec.OrderSpec oSpec = this.processOrderSpec(sortNode);
                partitioning.setOrderSpec(oSpec);
            }
        } else if (type == 760 || type == 705) {
            ASTNode sortNode = firstChild;
            PTFInvocationSpec.OrderSpec oSpec = this.processOrderSpec(sortNode);
            partitioning.setOrderSpec(oSpec);
        }
        return partitioning;
    }

    private WindowingSpec.WindowFunctionSpec processWindowFunction(ASTNode node, ASTNode wsNode) throws SemanticException {
        WindowingSpec.WindowFunctionSpec wfSpec = new WindowingSpec.WindowFunctionSpec();
        switch (node.getType()) {
            case 641: {
                wfSpec.setStar(true);
                break;
            }
            case 640: {
                wfSpec.setDistinct(true);
            }
        }
        if (wfSpec.isDistinct()) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(node, "Count/Sum distinct not supported with Windowing"));
        }
        wfSpec.setExpression(node);
        ASTNode nameNode = (ASTNode)node.getChild(0);
        wfSpec.setName(nameNode.getText());
        for (int i = 1; i < node.getChildCount() - 1; ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            wfSpec.addArg(child);
        }
        if (wsNode != null) {
            WindowingSpec.WindowSpec ws = this.processWindowSpec(wsNode);
            wfSpec.setWindowSpec(ws);
        }
        return wfSpec;
    }

    private boolean containsLeadLagUDF(ASTNode expressionTree) {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 639) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(0).getType() == 26) {
                String functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if ("lag".equals(functionName = functionName.toLowerCase()) || "lead".equals(functionName)) {
                    return true;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            if (!this.containsLeadLagUDF((ASTNode)expressionTree.getChild(i))) continue;
            return true;
        }
        return false;
    }

    private void processQueryWindowClause(WindowingSpec spec, ASTNode node) throws SemanticException {
        ASTNode nameNode = (ASTNode)node.getChild(0);
        ASTNode wsNode = (ASTNode)node.getChild(1);
        if (spec.getWindowSpecs() != null && spec.getWindowSpecs().containsKey(nameNode.getText())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(nameNode, "Duplicate definition of window " + nameNode.getText() + " is not allowed"));
        }
        WindowingSpec.WindowSpec ws = this.processWindowSpec(wsNode);
        spec.addWindowSpec(nameNode.getText(), ws);
    }

    private WindowingSpec.WindowSpec processWindowSpec(ASTNode node) throws SemanticException {
        Object sourceId = null;
        Object partition = null;
        Object order = null;
        Object windowFrame = null;
        boolean hasSrcId = false;
        boolean hasPartSpec = false;
        boolean hasWF = false;
        int srcIdIdx = -1;
        int partIdx = -1;
        int wfIdx = -1;
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            int type = node.getChild(i).getType();
            switch (type) {
                case 26: {
                    hasSrcId = true;
                    srcIdIdx = i;
                    continue block5;
                }
                case 707: {
                    hasPartSpec = true;
                    partIdx = i;
                    continue block5;
                }
                case 823: 
                case 825: {
                    hasWF = true;
                    wfIdx = i;
                }
            }
        }
        WindowingSpec.WindowSpec ws = new WindowingSpec.WindowSpec();
        if (hasSrcId) {
            ASTNode nameNode = (ASTNode)node.getChild(srcIdIdx);
            ws.setSourceId(nameNode.getText());
        }
        if (hasPartSpec) {
            ASTNode partNode = (ASTNode)node.getChild(partIdx);
            PTFInvocationSpec.PartitioningSpec partitioning = this.processPTFPartitionSpec(partNode);
            ws.setPartitioning(partitioning);
        }
        if (hasWF) {
            ASTNode wfNode = (ASTNode)node.getChild(wfIdx);
            WindowingSpec.WindowFrameSpec wfSpec = this.processWindowFrame(wfNode);
            ws.setWindowFrame(wfSpec);
        }
        return ws;
    }

    private WindowingSpec.WindowFrameSpec processWindowFrame(ASTNode node) throws SemanticException {
        int type = node.getType();
        WindowingSpec.BoundarySpec start = null;
        WindowingSpec.BoundarySpec end = null;
        start = this.processBoundary(type, (ASTNode)node.getChild(0));
        if (node.getChildCount() > 1) {
            end = this.processBoundary(type, (ASTNode)node.getChild(1));
        }
        return new WindowingSpec.WindowFrameSpec(start, end);
    }

    private WindowingSpec.BoundarySpec processBoundary(int frameType, ASTNode node) throws SemanticException {
        WindowingSpec.BoundarySpec bs = frameType == 823 ? new WindowingSpec.RangeBoundarySpec() : new WindowingSpec.ValueBoundarySpec();
        int type = node.getType();
        boolean hasAmt = true;
        switch (type) {
            case 179: {
                bs.setDirection(WindowingSpec.Direction.PRECEDING);
                break;
            }
            case 103: {
                bs.setDirection(WindowingSpec.Direction.FOLLOWING);
                break;
            }
            case 63: {
                bs = new WindowingSpec.CurrentRowSpec();
                hasAmt = false;
            }
        }
        if (hasAmt) {
            ASTNode amtNode = (ASTNode)node.getChild(0);
            if (amtNode.getType() == 245) {
                bs.setAmt(WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT);
            } else {
                int amt = Integer.parseInt(amtNode.getText());
                if (amt < 0) {
                    throw new SemanticException("Window Frame Boundary Amount must be a +ve integer, amount provide is: " + amt);
                }
                bs.setAmt(amt);
            }
        }
        return bs;
    }

    private boolean isValidGroupBySelectList(QB currQB, String clause) {
        ConstantExprCheck constantExprCheck = new ConstantExprCheck();
        AggregationExprCheck aggrExprCheck = new AggregationExprCheck(currQB.getParseInfo().getAggregationExprsForClause(clause));
        TreeWizard tw = new TreeWizard(ParseDriver.adaptor, HiveParser.tokenNames);
        ASTNode selectNode = currQB.getParseInfo().getSelForClause(clause);
        if (selectNode != null && selectNode.getType() == 739) {
            return true;
        }
        for (int i = 0; selectNode != null && i < selectNode.getChildCount(); ++i) {
            ASTNode selectExpr = (ASTNode)selectNode.getChild(i);
            if (selectExpr.getType() != 740) continue;
            constantExprCheck.reset();
            PTFTranslator.visit(selectExpr.getChild(0), constantExprCheck);
            if (constantExprCheck.isConstant()) continue;
            aggrExprCheck.reset();
            PTFTranslator.visit(selectExpr.getChild(0), aggrExprCheck);
            if (aggrExprCheck.isAggr()) continue;
            return false;
        }
        return true;
    }

    private PTFDesc translatePTFInvocationSpec(PTFInvocationSpec ptfQSpec, RowResolver inputRR) throws SemanticException {
        PTFDesc ptfDesc = null;
        PTFTranslator translator = new PTFTranslator();
        ptfDesc = translator.translate(ptfQSpec, this, this.conf, inputRR, this.unparseTranslator);
        return ptfDesc;
    }

    Operator genPTFPlan(PTFInvocationSpec ptfQSpec, Operator input) throws SemanticException {
        ArrayList<PTFInvocationSpec> componentQueries = PTFTranslator.componentize(ptfQSpec);
        for (PTFInvocationSpec ptfSpec : componentQueries) {
            input = this.genPTFPlanForComponentQuery(ptfSpec, input);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"Created PTF Plan ");
        }
        return input;
    }

    void buildPTFReduceSinkDetails(PTFDesc.PartitionedTableFunctionDef tabDef, RowResolver inputRR, ArrayList<ExprNodeDesc> partCols, ArrayList<ExprNodeDesc> valueCols, ArrayList<ExprNodeDesc> orderCols, Map<String, ExprNodeDesc> colExprMap, List<String> outputColumnNames, StringBuilder orderString, RowResolver rsOpRR, RowResolver extractRR) throws SemanticException {
        String[] alias;
        ArrayList<PTFDesc.PTFExpressionDef> partColList = tabDef.getPartition().getExpressions();
        for (PTFDesc.PTFExpressionDef colDef : partColList) {
            partCols.add(colDef.getExprNode());
            orderCols.add(colDef.getExprNode());
            orderString.append('+');
        }
        ArrayList<PTFDesc.OrderExpressionDef> orderColList = tabDef.getOrder().getExpressions();
        for (int i = 0; i < orderColList.size(); ++i) {
            PTFDesc.OrderExpressionDef colDef = orderColList.get(i);
            PTFInvocationSpec.Order order = colDef.getOrder();
            if (order.name().equals("ASC")) {
                orderString.append('+');
            } else {
                orderString.append('-');
            }
            orderCols.add(colDef.getExprNode());
        }
        ArrayList<ColumnInfo> colInfoList = inputRR.getColumnInfos();
        int pos = 0;
        for (ColumnInfo colInfo : colInfoList) {
            ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
            valueCols.add(exprNodeColumnDesc);
            colExprMap.put(colInfo.getInternalName(), exprNodeColumnDesc);
            String outColName = SemanticAnalyzer.getColumnInternalName(pos++);
            outputColumnNames.add(outColName);
            String[] alias2 = inputRR.reverseLookup(colInfo.getInternalName());
            ColumnInfo newColInfo = new ColumnInfo(outColName, colInfo.getType(), alias2[0], colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
            rsOpRR.put(alias2[0], alias2[1], newColInfo);
        }
        LinkedHashMap<String[], ColumnInfo> colsAddedByHaving = new LinkedHashMap<String[], ColumnInfo>();
        pos = 0;
        for (ColumnInfo columnInfo : colInfoList) {
            alias = inputRR.reverseLookup(columnInfo.getInternalName());
            if (colsAddedByHaving.containsKey(alias)) continue;
            ASTNode astNode = PTFTranslator.getASTNode(columnInfo, inputRR);
            ColumnInfo eColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos++), columnInfo.getType(), alias[0], columnInfo.getIsVirtualCol(), columnInfo.isHiddenVirtualCol());
            if (astNode == null) {
                extractRR.put(alias[0], alias[1], eColInfo);
                continue;
            }
            extractRR.putExpression(astNode, eColInfo);
            if (astNode.toStringTree().toLowerCase().equals(alias[1])) continue;
            colsAddedByHaving.put(alias, eColInfo);
        }
        for (Map.Entry entry : colsAddedByHaving.entrySet()) {
            alias = (String[])entry.getKey();
            ColumnInfo eColInfo = (ColumnInfo)entry.getValue();
            extractRR.put(alias[0], alias[1], eColInfo);
        }
    }

    private Operator genPTFPlanForComponentQuery(PTFInvocationSpec ptfQSpec, Operator input) throws SemanticException {
        RowResolver rr = this.opParseCtx.get(input).getRowResolver();
        PTFDesc ptfDesc = this.translatePTFInvocationSpec(ptfQSpec, rr);
        RowResolver rsOpRR = new RowResolver();
        RowResolver extractOpRR = new RowResolver();
        PTFDesc.PartitionedTableFunctionDef tabDef = ptfDesc.getStartOfChain();
        if (tabDef.isTransformsRawInput()) {
            RowResolver ptfMapRR = tabDef.getRawInputShape().getRr();
            ptfDesc.setMapSide(true);
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfMapRR.getColumnInfos()), input), ptfMapRR);
            rr = this.opParseCtx.get(input).getRowResolver();
        }
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> orderCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        StringBuilder orderString = new StringBuilder();
        this.buildPTFReduceSinkDetails(tabDef, rr, partCols, valueCols, orderCols, colExprMap, outputColumnNames, orderString, rsOpRR, extractOpRR);
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(orderCols, valueCols, outputColumnNames, false, -1, partCols, orderString.toString(), -1), new RowSchema(rsOpRR.getColumnInfos()), input), rsOpRR);
        input.setColumnExprMap(colExprMap);
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ExtractDesc(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(extractOpRR.getColumnInfos()), input), extractOpRR);
        rr = this.opParseCtx.get(input).getRowResolver();
        ptfDesc = this.translatePTFInvocationSpec(ptfQSpec, rr);
        RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), input), ptfOpRR);
        return input;
    }

    Operator genWindowingPlan(WindowingSpec wSpec, Operator input) throws SemanticException {
        wSpec.validateAndMakeEffective();
        WindowingComponentizer groups = new WindowingComponentizer(wSpec);
        RowResolver rr = this.opParseCtx.get(input).getRowResolver();
        while (groups.hasNext()) {
            wSpec = groups.next(this.conf, this, this.unparseTranslator, rr);
            input = this.genReduceSinkPlanForWindowing(wSpec, rr, input);
            rr = this.opParseCtx.get(input).getRowResolver();
            PTFTranslator translator = new PTFTranslator();
            PTFDesc ptfDesc = translator.translate(wSpec, this, this.conf, rr, this.unparseTranslator);
            RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), input), ptfOpRR);
            rr = ptfOpRR;
        }
        return input;
    }

    private Operator genReduceSinkPlanForWindowing(WindowingSpec spec, RowResolver inputRR, Operator input) throws SemanticException {
        String[] alias;
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> orderCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        StringBuilder orderString = new StringBuilder();
        ArrayList<PTFInvocationSpec.PartitionExpression> partColList = spec.getQueryPartitionSpec().getExpressions();
        for (PTFInvocationSpec.PartitionExpression partCol : partColList) {
            ExprNodeDesc partExpr = this.genExprNodeDesc(partCol.getExpression(), inputRR);
            partCols.add(partExpr);
            orderCols.add(partExpr);
            orderString.append('+');
        }
        ArrayList<Object> orderColList = spec.getQueryOrderSpec() == null ? new ArrayList() : spec.getQueryOrderSpec().getExpressions();
        for (int i = 0; i < orderColList.size(); ++i) {
            PTFInvocationSpec.OrderExpression orderCol = (PTFInvocationSpec.OrderExpression)orderColList.get(i);
            PTFInvocationSpec.Order order = orderCol.getOrder();
            if (order.name().equals("ASC")) {
                orderString.append('+');
            } else {
                orderString.append('-');
            }
            ExprNodeDesc orderExpr = this.genExprNodeDesc(orderCol.getExpression(), inputRR);
            orderCols.add(orderExpr);
        }
        ArrayList<ColumnInfo> colInfoList = inputRR.getColumnInfos();
        RowResolver rsNewRR = new RowResolver();
        int pos = 0;
        for (ColumnInfo colInfo : colInfoList) {
            ExprNodeColumnDesc valueColExpr = new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol());
            valueCols.add(valueColExpr);
            colExprMap.put(colInfo.getInternalName(), valueColExpr);
            String string = SemanticAnalyzer.getColumnInternalName(pos++);
            outputColumnNames.add(string);
            alias = inputRR.reverseLookup(colInfo.getInternalName());
            ColumnInfo newColInfo = new ColumnInfo(string, colInfo.getType(), alias[0], colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
            rsNewRR.put(alias[0], alias[1], newColInfo);
        }
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(orderCols, valueCols, outputColumnNames, false, -1, partCols, orderString.toString(), -1), new RowSchema(rsNewRR.getColumnInfos()), input), rsNewRR);
        input.setColumnExprMap(colExprMap);
        RowResolver extractRR = new RowResolver();
        LinkedHashMap<String[], ColumnInfo> colsAddedByHaving = new LinkedHashMap<String[], ColumnInfo>();
        pos = 0;
        for (ColumnInfo columnInfo : colInfoList) {
            alias = inputRR.reverseLookup(columnInfo.getInternalName());
            if (colsAddedByHaving.containsKey(alias)) continue;
            ASTNode astNode = PTFTranslator.getASTNode(columnInfo, inputRR);
            ColumnInfo eColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos++), columnInfo.getType(), alias[0], columnInfo.getIsVirtualCol(), columnInfo.isHiddenVirtualCol());
            if (astNode == null) {
                extractRR.put(alias[0], alias[1], eColInfo);
                continue;
            }
            extractRR.putExpression(astNode, eColInfo);
            if (astNode.toStringTree().toLowerCase().equals(alias[1])) continue;
            colsAddedByHaving.put(alias, eColInfo);
        }
        for (Map.Entry entry : colsAddedByHaving.entrySet()) {
            alias = (String[])entry.getKey();
            ColumnInfo eColInfo = (ColumnInfo)entry.getValue();
            extractRR.put(alias[0], alias[1], eColInfo);
        }
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ExtractDesc(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(inputRR.getColumnInfos()), input), extractRR);
        return input;
    }

    public static ArrayList<WindowingSpec.WindowExpressionSpec> parseSelect(String selectExprStr) throws SemanticException {
        ASTNode selNode = null;
        try {
            ParseDriver pd = new ParseDriver();
            selNode = pd.parseSelect(selectExprStr, null);
        }
        catch (ParseException pe) {
            throw new SemanticException(pe);
        }
        ArrayList<WindowingSpec.WindowExpressionSpec> selSpec = new ArrayList<WindowingSpec.WindowExpressionSpec>();
        int childCount = selNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ASTNode selExpr = (ASTNode)selNode.getChild(i);
            if (selExpr.getType() != 740) {
                throw new SemanticException(String.format("Only Select expressions supported in dynamic select list: %s", selectExprStr));
            }
            ASTNode expr = (ASTNode)selExpr.getChild(0);
            if (expr.getType() == 553) {
                throw new SemanticException(String.format("'%s' column not allowed in dynamic select list", selectExprStr));
            }
            ASTNode aliasNode = selExpr.getChildCount() > 1 && selExpr.getChild(1).getType() == 26 ? (ASTNode)selExpr.getChild(1) : null;
            String alias = null;
            if (aliasNode != null) {
                alias = aliasNode.getText();
            } else {
                String[] tabColAlias = SemanticAnalyzer.getColAlias(selExpr, null, null, true, -1);
                alias = tabColAlias[1];
            }
            WindowingSpec.WindowExpressionSpec exprSpec = new WindowingSpec.WindowExpressionSpec();
            exprSpec.setAlias(alias);
            exprSpec.setExpression(expr);
            selSpec.add(exprSpec);
        }
        return selSpec;
    }

    private static class AggregationExprCheck
    implements TreeWizard.ContextVisitor {
        HashMap<String, ASTNode> destAggrExprs;
        boolean isAggr = false;

        public AggregationExprCheck(HashMap<String, ASTNode> destAggrExprs) {
            this.destAggrExprs = destAggrExprs;
        }

        public void visit(Object t, Object parent, int childIndex, Map labels) {
            if (this.isAggr) {
                return;
            }
            if (this.destAggrExprs.values().contains(t)) {
                this.isAggr = true;
            }
        }

        public void reset() {
            this.isAggr = false;
        }

        protected boolean isAggr() {
            return this.isAggr;
        }
    }

    private static class ConstantExprCheck
    implements TreeWizard.ContextVisitor {
        boolean isConstant = true;

        private ConstantExprCheck() {
        }

        public void visit(Object t, Object parent, int childIndex, Map labels) {
            if (!this.isConstant) {
                return;
            }
            ASTNode node = (ASTNode)t;
            if (ParseDriver.adaptor.getType(t) == 794) {
                this.isConstant = false;
            }
        }

        public void reset() {
            this.isConstant = true;
        }

        protected boolean isConstant() {
            return this.isConstant;
        }
    }

    private static class SortBucketRSCtx {
        ArrayList<ExprNodeDesc> partnCols = null;
        boolean multiFileSpray = false;
        int numFiles = 1;
        int totalFiles = 1;

        public ArrayList<ExprNodeDesc> getPartnCols() {
            return this.partnCols;
        }

        public void setPartnCols(ArrayList<ExprNodeDesc> partnCols) {
            this.partnCols = partnCols;
        }

        public boolean isMultiFileSpray() {
            return this.multiFileSpray;
        }

        public void setMultiFileSpray(boolean multiFileSpray) {
            this.multiFileSpray = multiFileSpray;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public void setNumFiles(int numFiles) {
            this.numFiles = numFiles;
        }

        public int getTotalFiles() {
            return this.totalFiles;
        }

        public void setTotalFiles(int totalFiles) {
            this.totalFiles = totalFiles;
        }
    }

    static class GenericUDAFInfo {
        ArrayList<ExprNodeDesc> convertedParameters;
        GenericUDAFEvaluator genericUDAFEvaluator;
        TypeInfo returnType;

        GenericUDAFInfo() {
        }
    }

    private static class Phase1Ctx {
        String dest;
        int nextNum;

        private Phase1Ctx() {
        }
    }
}

