/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;

@Description(name="avg", value="_FUNC_(x) - Returns the mean of a set of numbers")
public class GenericUDAFAverage
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFAverage.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case TIMESTAMP: {
                return new GenericUDAFAverageEvaluatorDouble();
            }
            case DECIMAL: {
                return new GenericUDAFAverageEvaluatorDecimal();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static abstract class AbstractGenericUDAFAverageEvaluator<TYPE>
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private StructObjectInspector soi;
        private StructField countField;
        private StructField sumField;
        private LongObjectInspector countFieldOI;
        private ObjectInspector sumFieldOI;
        protected Object[] partialResult;
        private boolean warned = false;

        protected abstract ObjectInspector getSumFieldJavaObjectInspector();

        protected abstract ObjectInspector getSumFieldWritableObjectInspector();

        protected abstract void doIterate(AverageAggregationBuffer<TYPE> var1, PrimitiveObjectInspector var2, Object var3);

        protected abstract void doMerge(AverageAggregationBuffer<TYPE> var1, Long var2, ObjectInspector var3, Object var4);

        protected abstract void doTerminatePartial(AverageAggregationBuffer<TYPE> var1);

        protected abstract Object doTerminate(AverageAggregationBuffer<TYPE> var1);

        protected abstract void doReset(AverageAggregationBuffer<TYPE> var1) throws HiveException;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.countField = this.soi.getStructFieldRef("count");
                this.sumField = this.soi.getStructFieldRef("sum");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.sumFieldOI = this.sumField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(this.getSumFieldWritableObjectInspector());
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("count");
                fname.add("sum");
                this.partialResult = new Object[2];
                this.partialResult[0] = new LongWritable(0L);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            return this.getSumFieldWritableObjectInspector();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer aggregation) throws HiveException {
            this.doReset((AverageAggregationBuffer)aggregation);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer aggregation, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                Object parameter = parameters[0];
                if (parameter != null) {
                    AverageAggregationBuffer averageAggregation = (AverageAggregationBuffer)aggregation;
                    try {
                        this.doIterate(averageAggregation, this.inputOI, parameter);
                    }
                    catch (NumberFormatException e) {
                        if (this.warned) break block4;
                        this.warned = true;
                        LOG.warn((Object)("Ignoring similar exceptions: " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer aggregation) throws HiveException {
            this.doTerminatePartial((AverageAggregationBuffer)aggregation);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer aggregation, Object partial) throws HiveException {
            if (partial != null) {
                this.doMerge((AverageAggregationBuffer)aggregation, this.countFieldOI.get(this.soi.getStructFieldData(partial, this.countField)), this.sumFieldOI, this.soi.getStructFieldData(partial, this.sumField));
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer aggregation) throws HiveException {
            return this.doTerminate((AverageAggregationBuffer)aggregation);
        }
    }

    private static class AverageAggregationBuffer<TYPE>
    implements GenericUDAFEvaluator.AggregationBuffer {
        private long count;
        private TYPE sum;

        private AverageAggregationBuffer() {
        }
    }

    public static class GenericUDAFAverageEvaluatorDecimal
    extends AbstractGenericUDAFAverageEvaluator<HiveDecimal> {
        @Override
        public void doReset(AverageAggregationBuffer<HiveDecimal> aggregation) throws HiveException {
            ((AverageAggregationBuffer)aggregation).count = 0L;
            ((AverageAggregationBuffer)aggregation).sum = HiveDecimal.ZERO;
        }

        @Override
        protected ObjectInspector getSumFieldJavaObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaHiveDecimalObjectInspector;
        }

        @Override
        protected ObjectInspector getSumFieldWritableObjectInspector() {
            return PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector;
        }

        @Override
        protected void doIterate(AverageAggregationBuffer<HiveDecimal> aggregation, PrimitiveObjectInspector oi, Object parameter) {
            HiveDecimal value = PrimitiveObjectInspectorUtils.getHiveDecimal(parameter, oi);
            ((AverageAggregationBuffer)aggregation).count++;
            if (((AverageAggregationBuffer)aggregation).sum != null) {
                try {
                    ((AverageAggregationBuffer)aggregation).sum = ((HiveDecimal)((AverageAggregationBuffer)aggregation).sum).add(value);
                }
                catch (NumberFormatException e) {
                    ((AverageAggregationBuffer)aggregation).sum = null;
                }
            }
        }

        @Override
        protected void doMerge(AverageAggregationBuffer<HiveDecimal> aggregation, Long partialCount, ObjectInspector sumFieldOI, Object partialSum) {
            HiveDecimal value = ((HiveDecimalObjectInspector)sumFieldOI).getPrimitiveJavaObject(partialSum);
            if (value == null) {
                ((AverageAggregationBuffer)aggregation).sum = null;
            }
            ((AverageAggregationBuffer)aggregation).count += partialCount;
            if (((AverageAggregationBuffer)aggregation).sum != null) {
                try {
                    ((AverageAggregationBuffer)aggregation).sum = ((HiveDecimal)((AverageAggregationBuffer)aggregation).sum).add(value);
                }
                catch (NumberFormatException e) {
                    ((AverageAggregationBuffer)aggregation).sum = null;
                }
            }
        }

        @Override
        protected void doTerminatePartial(AverageAggregationBuffer<HiveDecimal> aggregation) {
            if (this.partialResult[1] == null && ((AverageAggregationBuffer)aggregation).sum != null) {
                this.partialResult[1] = new HiveDecimalWritable(HiveDecimal.ZERO);
            }
            ((LongWritable)this.partialResult[0]).set(((AverageAggregationBuffer)aggregation).count);
            if (((AverageAggregationBuffer)aggregation).sum != null) {
                ((HiveDecimalWritable)this.partialResult[1]).set((HiveDecimal)((AverageAggregationBuffer)aggregation).sum);
            } else {
                this.partialResult[1] = null;
            }
        }

        @Override
        protected Object doTerminate(AverageAggregationBuffer<HiveDecimal> aggregation) {
            if (((AverageAggregationBuffer)aggregation).count == 0L || ((AverageAggregationBuffer)aggregation).sum == null) {
                return null;
            }
            HiveDecimalWritable result = new HiveDecimalWritable(HiveDecimal.ZERO);
            try {
                result.set(((HiveDecimal)((AverageAggregationBuffer)aggregation).sum).divide(new HiveDecimal(((AverageAggregationBuffer)aggregation).count)));
            }
            catch (NumberFormatException e) {
                result = null;
            }
            return result;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            AverageAggregationBuffer result = new AverageAggregationBuffer();
            this.reset(result);
            return result;
        }
    }

    public static class GenericUDAFAverageEvaluatorDouble
    extends AbstractGenericUDAFAverageEvaluator<Double> {
        @Override
        public void doReset(AverageAggregationBuffer<Double> aggregation) throws HiveException {
            ((AverageAggregationBuffer)aggregation).count = 0L;
            ((AverageAggregationBuffer)aggregation).sum = new Double(0.0);
        }

        @Override
        protected ObjectInspector getSumFieldJavaObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }

        @Override
        protected ObjectInspector getSumFieldWritableObjectInspector() {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        protected void doIterate(AverageAggregationBuffer<Double> aggregation, PrimitiveObjectInspector oi, Object parameter) {
            double value = PrimitiveObjectInspectorUtils.getDouble(parameter, oi);
            ((AverageAggregationBuffer)aggregation).count++;
            AverageAggregationBuffer<Double> averageAggregationBuffer = aggregation;
            ((AverageAggregationBuffer)averageAggregationBuffer).sum = (Double)((AverageAggregationBuffer)averageAggregationBuffer).sum + value;
        }

        @Override
        protected void doMerge(AverageAggregationBuffer<Double> aggregation, Long partialCount, ObjectInspector sumFieldOI, Object partialSum) {
            double value = ((DoubleObjectInspector)sumFieldOI).get(partialSum);
            ((AverageAggregationBuffer)aggregation).count += partialCount;
            AverageAggregationBuffer<Double> averageAggregationBuffer = aggregation;
            ((AverageAggregationBuffer)averageAggregationBuffer).sum = (Double)((AverageAggregationBuffer)averageAggregationBuffer).sum + value;
        }

        @Override
        protected void doTerminatePartial(AverageAggregationBuffer<Double> aggregation) {
            if (this.partialResult[1] == null) {
                this.partialResult[1] = new DoubleWritable(0.0);
            }
            ((LongWritable)this.partialResult[0]).set(((AverageAggregationBuffer)aggregation).count);
            ((DoubleWritable)this.partialResult[1]).set((Double)((AverageAggregationBuffer)aggregation).sum);
        }

        @Override
        protected Object doTerminate(AverageAggregationBuffer<Double> aggregation) {
            if (((AverageAggregationBuffer)aggregation).count == 0L) {
                return null;
            }
            DoubleWritable result = new DoubleWritable(0.0);
            result.set((Double)((AverageAggregationBuffer)aggregation).sum / (double)((AverageAggregationBuffer)aggregation).count);
            return result;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            AverageAggregationBuffer result = new AverageAggregationBuffer();
            this.reset(result);
            return result;
        }
    }
}

