/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class MapJoinRowContainer<Row>
extends AbstractRowContainer<Row> {
    private List<Row> list = new ArrayList<Row>(1);
    private int index = 0;

    @Override
    public void add(Row t) throws HiveException {
        this.list.add(t);
    }

    @Override
    public Row first() throws HiveException {
        this.index = 0;
        if (this.index < this.list.size()) {
            return this.list.get(this.index);
        }
        return null;
    }

    @Override
    public Row next() throws HiveException {
        ++this.index;
        if (this.index < this.list.size()) {
            return this.list.get(this.index);
        }
        return null;
    }

    @Override
    public long size() {
        return this.list.size();
    }

    @Override
    public void clear() throws HiveException {
        this.list.clear();
        this.index = 0;
    }

    public List<Row> getList() {
        return this.list;
    }

    public void setList(List<Row> list) {
        this.list = list;
    }

    public void reset(MapJoinRowContainer<Object[]> other) throws HiveException {
        this.list.clear();
        Object[] obj = other.first();
        while (obj != null) {
            ArrayList<Object> ele = new ArrayList<Object>(obj.length);
            for (int i = 0; i < obj.length; ++i) {
                ele.add(obj[i]);
            }
            this.list.add(ele);
            obj = other.next();
        }
    }
}

