/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="inline", value="_FUNC_( ARRAY( STRUCT()[,STRUCT()] - explodes and array and struct into a table")
public class GenericUDTFInline
extends GenericUDTF {
    private Object[] forwardObj;
    private ListObjectInspector li;
    private StructObjectInspector daStruct;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] ois) throws UDFArgumentException {
        if (ois.length != 1) {
            throw new UDFArgumentException("UDF tables only one argument");
        }
        if (ois[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("Top level object must be an array but was " + ois[0].getTypeName());
        }
        this.li = (ListObjectInspector)ois[0];
        ObjectInspector sub = this.li.getListElementObjectInspector();
        if (sub.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new UDFArgumentException("The sub element must be struct, but was " + sub.getTypeName());
        }
        this.daStruct = (StructObjectInspector)sub;
        this.forwardObj = new Object[this.daStruct.getAllStructFieldRefs().size()];
        return this.daStruct;
    }

    @Override
    public void process(Object[] os) throws HiveException {
        List<?> l = this.li.getList(os);
        List<? extends StructField> fields = this.daStruct.getAllStructFieldRefs();
        for (Object linner : l) {
            List innerList = (List)linner;
            for (List rowList : innerList) {
                int i = 0;
                for (StructField structField : fields) {
                    GenericUDFUtils.ReturnObjectInspectorResolver res = new GenericUDFUtils.ReturnObjectInspectorResolver();
                    res.update(structField.getFieldObjectInspector());
                    this.forwardObj[i] = res.convertIfNecessary(rowList.get(i), structField.getFieldObjectInspector());
                    ++i;
                }
                this.forward(this.forwardObj);
            }
        }
    }

    @Override
    public void close() throws HiveException {
    }

    public String toString() {
        return "inline";
    }
}

