/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.Map;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.PrunerExpressionOperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.ppr.ExprProcCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public final class ExprProcFactory
extends PrunerExpressionOperatorFactory {
    private ExprProcFactory() {
    }

    public static NodeProcessor getColumnProcessor() {
        return new PPRColumnExprProcessor();
    }

    public static ExprNodeDesc genPruner(String tabAlias, ExprNodeDesc pred, boolean hasNonPartCols) throws SemanticException {
        ExprProcCtx pprCtx = new ExprProcCtx(tabAlias);
        Map<Node, Object> outputMap = PrunerUtils.walkExprTree(pred, pprCtx, ExprProcFactory.getColumnProcessor(), ExprProcFactory.getFieldProcessor(), ExprProcFactory.getGenericFuncProcessor(), ExprProcFactory.getDefaultExprProcessor());
        hasNonPartCols = pprCtx.getHasNonPartCols();
        return (ExprNodeDesc)outputMap.get(pred);
    }

    public static class PPRColumnExprProcessor
    extends PrunerExpressionOperatorFactory.ColumnExprProcessor {
        @Override
        protected ExprNodeDesc processColumnDesc(NodeProcessorCtx procCtx, ExprNodeColumnDesc cd) {
            ExprNodeDesc newcd;
            ExprProcCtx epc = (ExprProcCtx)procCtx;
            if (cd.getTabAlias().equalsIgnoreCase(epc.getTabAlias()) && cd.getIsPartitionColOrVirtualCol()) {
                newcd = cd.clone();
            } else {
                newcd = new ExprNodeConstantDesc(cd.getTypeInfo(), null);
                epc.setHasNonPartCols(true);
            }
            return newcd;
        }
    }
}

