/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;

public class CommonJoinResolver
implements PhysicalPlanResolver {
    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        CommonJoinTaskDispatcher disp = new CommonJoinTaskDispatcher(pctx);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.rootTasks);
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    class CommonJoinTaskDispatcher
    implements Dispatcher {
        HashMap<String, Long> aliasToSize = null;
        private final PhysicalContext physicalContext;

        public CommonJoinTaskDispatcher(PhysicalContext context) {
            this.physicalContext = context;
        }

        private int getPosition(MapredWork work, Operator<? extends OperatorDesc> joinOp, String alias) {
            Operator<? extends OperatorDesc> parentOp = work.getAliasToWork().get(alias);
            while (parentOp.getChildOperators() != null && !parentOp.getChildOperators().isEmpty()) {
                parentOp = parentOp.getChildOperators().get(0);
            }
            return joinOp.getParentOperators().indexOf(parentOp);
        }

        private void mergeMapJoinTaskWithChildMapJoinTask(MapRedTask task, Configuration conf) {
            boolean convertToSingleJob;
            Long tabSize;
            MapRedTask childTask = (MapRedTask)task.getChildTasks().get(0);
            MapredWork work = (MapredWork)task.getWork();
            MapredLocalWork localWork = work.getMapLocalWork();
            MapredWork childWork = (MapredWork)childTask.getWork();
            MapredLocalWork childLocalWork = childWork.getMapLocalWork();
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = work.getAliasToWork();
            if (aliasToWork.size() > 1) {
                return;
            }
            Operator<OperatorDesc> op = (Operator<OperatorDesc>)aliasToWork.values().iterator().next();
            while (op.getChildOperators() != null) {
                if (op.getChildOperators().size() > 1) {
                    return;
                }
                op = op.getChildOperators().get(0);
            }
            if (!(op instanceof FileSinkOperator)) {
                return;
            }
            FileSinkOperator fop = (FileSinkOperator)op;
            String workDir = ((FileSinkDesc)fop.getConf()).getDirName();
            LinkedHashMap<String, ArrayList<String>> childPathToAliases = childWork.getPathToAliases();
            if (childPathToAliases.size() > 1) {
                return;
            }
            if (!((String)childPathToAliases.keySet().iterator().next()).equals(workDir)) {
                return;
            }
            if (localWork.getBucketMapjoinContext() != null || childLocalWork.getBucketMapjoinContext() != null) {
                return;
            }
            if (childWork.getAliasToWork().size() > 1) {
                return;
            }
            long mapJoinSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
            long localTableTotalSize = 0L;
            for (String alias : localWork.getAliasToWork().keySet()) {
                tabSize = this.aliasToSize.get(alias);
                if (tabSize == null) {
                    return;
                }
                localTableTotalSize += tabSize.longValue();
            }
            for (String alias : childLocalWork.getAliasToWork().keySet()) {
                tabSize = this.aliasToSize.get(alias);
                if (tabSize == null) {
                    return;
                }
                if ((localTableTotalSize += tabSize.longValue()) <= mapJoinSize) continue;
                return;
            }
            Operator<? extends OperatorDesc> childAliasOp = childWork.getAliasToWork().values().iterator().next();
            if (fop.getParentOperators().size() > 1) {
                return;
            }
            Operator<OperatorDesc> parentFOp = fop.getParentOperators().get(0);
            parentFOp.getChildOperators().remove(fop);
            parentFOp.getChildOperators().add(childAliasOp);
            ArrayList<Operator<? extends OperatorDesc>> parentOps = new ArrayList<Operator<? extends OperatorDesc>>();
            parentOps.add(parentFOp);
            childAliasOp.setParentOperators(parentOps);
            work.getAliasToPartnInfo().putAll(childWork.getAliasToPartnInfo());
            for (Map.Entry<String, PartitionDesc> childWorkEntry : childWork.getPathToPartitionInfo().entrySet()) {
                if (!childWork.getAliasToPartnInfo().containsValue(childWorkEntry.getKey())) continue;
                work.getPathToPartitionInfo().put(childWorkEntry.getKey(), childWorkEntry.getValue());
            }
            localWork.getAliasToFetchWork().putAll(childLocalWork.getAliasToFetchWork());
            localWork.getAliasToWork().putAll(childLocalWork.getAliasToWork());
            List<Task<? extends Serializable>> oldChildTasks = childTask.getChildTasks();
            task.setChildTasks(oldChildTasks);
            if (oldChildTasks != null) {
                for (Task<? extends Serializable> oldChildTask : oldChildTasks) {
                    oldChildTask.getParentTasks().remove(childTask);
                    oldChildTask.getParentTasks().add(task);
                }
            }
            if (convertToSingleJob = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEOPTIMIZEMAPJOINFOLLOWEDBYMR)) {
                this.copyReducerConf(task, childTask);
            }
        }

        private void copyReducerConf(MapRedTask task, MapRedTask childTask) {
            MapredWork childWork = (MapredWork)childTask.getWork();
            Operator<?> childReducer = childWork.getReducer();
            MapredWork work = (MapredWork)task.getWork();
            if (childReducer == null) {
                return;
            }
            work.setReducer(childReducer);
            work.setNumReduceTasks(childWork.getNumReduceTasks());
            work.setJoinTree(childWork.getJoinTree());
            work.setNeedsTagging(childWork.getNeedsTagging());
            work.getTagToValueDesc().clear();
            GenMapRedUtils.setKeyAndValueDescForTaskTree(task);
        }

        private ObjectPair<MapRedTask, String> convertTaskToMapJoinTask(MapredWork newWork, int bigTablePosition) throws SemanticException {
            MapRedTask newTask = (MapRedTask)TaskFactory.get(newWork, this.physicalContext.getParseContext().getConf(), new Task[0]);
            JoinOperator newJoinOp = this.getJoinOp(newTask);
            String bigTableAlias = MapJoinProcessor.genMapJoinOpAndLocalWork(newWork, newJoinOp, bigTablePosition);
            return new ObjectPair<MapRedTask, String>(newTask, bigTableAlias);
        }

        private void mergeMapJoinTaskWithMapReduceTask(MapRedTask mapJoinTask, Configuration conf) {
            if (mapJoinTask.getChildTasks() == null || mapJoinTask.getChildTasks().size() > 1) {
                return;
            }
            Task<Serializable> firstChildTask = mapJoinTask.getChildTasks().get(0);
            if (!(firstChildTask instanceof MapRedTask)) {
                return;
            }
            MapRedTask childTask = (MapRedTask)firstChildTask;
            MapredWork mapJoinWork = (MapredWork)mapJoinTask.getWork();
            MapredWork childWork = (MapredWork)childTask.getWork();
            Operator<?> childReducer = childWork.getReducer();
            if (childReducer == null) {
                return;
            }
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = mapJoinWork.getAliasToWork();
            if (aliasToWork.size() > 1) {
                return;
            }
            LinkedHashMap<String, ArrayList<String>> childPathToAliases = childWork.getPathToAliases();
            if (childPathToAliases.size() > 1) {
                return;
            }
            Operator<OperatorDesc> mapJoinLeafOperator = (Operator<OperatorDesc>)aliasToWork.values().iterator().next();
            while (mapJoinLeafOperator.getChildOperators() != null) {
                if (mapJoinLeafOperator.getChildOperators().size() > 1) {
                    return;
                }
                mapJoinLeafOperator = mapJoinLeafOperator.getChildOperators().get(0);
            }
            assert (mapJoinLeafOperator instanceof FileSinkOperator);
            if (!(mapJoinLeafOperator instanceof FileSinkOperator)) {
                return;
            }
            FileSinkOperator mapJoinTaskFileSinkOperator = (FileSinkOperator)mapJoinLeafOperator;
            String workDir = ((FileSinkDesc)mapJoinTaskFileSinkOperator.getConf()).getDirName();
            if (!((String)childPathToAliases.keySet().iterator().next()).equals(workDir)) {
                return;
            }
            MapredLocalWork mapJoinLocalWork = mapJoinWork.getMapLocalWork();
            MapredLocalWork childLocalWork = childWork.getMapLocalWork();
            if (mapJoinLocalWork != null && mapJoinLocalWork.getBucketMapjoinContext() != null || childLocalWork != null && childLocalWork.getBucketMapjoinContext() != null) {
                return;
            }
            if (childWork.getAliasToWork().size() > 1) {
                return;
            }
            Operator<? extends OperatorDesc> childAliasOp = childWork.getAliasToWork().values().iterator().next();
            if (mapJoinTaskFileSinkOperator.getParentOperators().size() > 1) {
                return;
            }
            Operator<OperatorDesc> parentFOp = mapJoinTaskFileSinkOperator.getParentOperators().get(0);
            parentFOp.getChildOperators().remove(mapJoinTaskFileSinkOperator);
            parentFOp.getChildOperators().add(childAliasOp);
            ArrayList<Operator<? extends OperatorDesc>> parentOps = new ArrayList<Operator<? extends OperatorDesc>>();
            parentOps.add(parentFOp);
            childAliasOp.setParentOperators(parentOps);
            mapJoinWork.getAliasToPartnInfo().putAll(childWork.getAliasToPartnInfo());
            for (Map.Entry<String, PartitionDesc> childWorkEntry : childWork.getPathToPartitionInfo().entrySet()) {
                if (!childWork.getAliasToPartnInfo().containsValue(childWorkEntry.getKey())) continue;
                mapJoinWork.getPathToPartitionInfo().put(childWorkEntry.getKey(), childWorkEntry.getValue());
            }
            if (mapJoinLocalWork != null && childLocalWork != null) {
                mapJoinLocalWork.getAliasToFetchWork().putAll(childLocalWork.getAliasToFetchWork());
                mapJoinLocalWork.getAliasToWork().putAll(childLocalWork.getAliasToWork());
            }
            List<Task<? extends Serializable>> oldChildTasks = childTask.getChildTasks();
            mapJoinTask.setChildTasks(oldChildTasks);
            if (oldChildTasks != null) {
                for (Task<? extends Serializable> oldChildTask : oldChildTasks) {
                    oldChildTask.getParentTasks().remove(childTask);
                    oldChildTask.getParentTasks().add(mapJoinTask);
                }
            }
            this.copyReducerConf(mapJoinTask, childTask);
        }

        private Task<? extends Serializable> processCurrentTask(MapRedTask currTask, ConditionalTask conditionalTask, Context context) throws SemanticException {
            JoinOperator joinOp = this.getJoinOp(currTask);
            if (joinOp == null || ((JoinDesc)joinOp.getConf()).isFixedAsSorted()) {
                return null;
            }
            currTask.setTaskTag(1);
            MapredWork currWork = (MapredWork)currTask.getWork();
            Configuration conf = context.getConf();
            long ThresholdOfSmallTblSizeSum = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
            long mapJoinSize = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
            long pseudoSize = Math.max(ThresholdOfSmallTblSizeSum, mapJoinSize) + 1L;
            ArrayList listWorks = new ArrayList();
            ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
            HashMap<String, Task<? extends Serializable>> aliasToTask = new HashMap<String, Task<? extends Serializable>>();
            LinkedHashMap<String, ArrayList<String>> pathToAliases = currWork.getPathToAliases();
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = currWork.getAliasToWork();
            ParseContext parseCtx = this.physicalContext.getParseContext();
            QBJoinTree joinTree = parseCtx.getJoinContext().get(joinOp);
            JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
            Byte[] order = joinDesc.getTagOrder();
            int numAliases = order.length;
            long aliasTotalKnownInputSize = 0L;
            if (this.aliasToSize == null) {
                this.aliasToSize = new HashMap();
            }
            try {
                Utilities.getInputSummary(context, currWork, null).getLength();
                Hive db = Hive.get(new HiveConf());
                for (Map.Entry entry : ((HashMap)pathToAliases).entrySet()) {
                    String path = (String)entry.getKey();
                    List aliasList = (List)entry.getValue();
                    ContentSummary cs = context.getCS(path);
                    if (cs == null) continue;
                    for (String alias : aliasList) {
                        long size = cs.getLength();
                        Table tableDesc = null;
                        try {
                            tableDesc = db.getTable(alias);
                            if (tableDesc.getStorageHandler() != null) {
                                size = pseudoSize;
                            }
                        }
                        catch (InvalidTableException ex) {
                            // empty catch block
                        }
                        aliasTotalKnownInputSize += size;
                        Long es = this.aliasToSize.get(alias);
                        if (es == null) {
                            es = new Long(0L);
                        }
                        es = es + size;
                        this.aliasToSize.put(alias, es);
                    }
                }
                HashSet<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(joinDesc.getConds());
                if (bigTableCandidates == null) {
                    return null;
                }
                boolean convertJoinMapJoin = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK);
                int bigTablePosition = -1;
                if (convertJoinMapJoin) {
                    boolean bigTableFound = false;
                    long largestBigTableCandidateSize = -1L;
                    long sumTableSizes = 0L;
                    for (String alias : aliasToWork.keySet()) {
                        int tablePosition = this.getPosition(currWork, joinOp, alias);
                        boolean bigTableCandidate = bigTableCandidates.contains(tablePosition);
                        Long size = this.aliasToSize.get(alias);
                        if (size == null || size > mapJoinSize) {
                            if (bigTableFound || (sumTableSizes += largestBigTableCandidateSize) > mapJoinSize || !bigTableCandidate) {
                                convertJoinMapJoin = false;
                                break;
                            }
                            bigTableFound = true;
                            bigTablePosition = tablePosition;
                            largestBigTableCandidateSize = mapJoinSize + 1L;
                            continue;
                        }
                        if (bigTableCandidate && size > largestBigTableCandidateSize) {
                            bigTablePosition = tablePosition;
                            sumTableSizes += largestBigTableCandidateSize;
                            largestBigTableCandidateSize = size;
                        } else {
                            sumTableSizes += size.longValue();
                        }
                        if (sumTableSizes <= mapJoinSize) continue;
                        convertJoinMapJoin = false;
                        break;
                    }
                }
                String bigTableAlias = null;
                currWork.setOpParseCtxMap(parseCtx.getOpParseCtx());
                currWork.setJoinTree(joinTree);
                if (convertJoinMapJoin) {
                    MapRedTask newTask = this.convertTaskToMapJoinTask(currWork, bigTablePosition).getFirst();
                    newTask.setTaskTag(6);
                    this.replaceTask(currTask, newTask, this.physicalContext);
                    if (newTask.getChildTasks() != null && newTask.getChildTasks().size() == 1) {
                        boolean convertToSingleJob;
                        if (newTask.getChildTasks().get(0).getTaskTag() == 6) {
                            this.mergeMapJoinTaskWithChildMapJoinTask(newTask, conf);
                        }
                        if (convertToSingleJob = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEOPTIMIZEMAPJOINFOLLOWEDBYMR)) {
                            this.mergeMapJoinTaskWithMapReduceTask(newTask, conf);
                        }
                    }
                    return newTask;
                }
                String xml = currWork.toXML();
                for (int i = 0; i < numAliases; ++i) {
                    long smallTblTotalKnownSize;
                    if (!bigTableCandidates.contains(i)) continue;
                    ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                    MapredWork newWork = Utilities.deserializeMapRedWork(in, this.physicalContext.getConf());
                    ObjectPair<MapRedTask, String> newTaskAlias = this.convertTaskToMapJoinTask(newWork, i);
                    MapRedTask newTask = newTaskAlias.getFirst();
                    bigTableAlias = newTaskAlias.getSecond();
                    Long aliasKnownSize = this.aliasToSize.get(bigTableAlias);
                    if (aliasKnownSize != null && aliasKnownSize > 0L && (smallTblTotalKnownSize = aliasTotalKnownInputSize - aliasKnownSize) > ThresholdOfSmallTblSizeSum) continue;
                    listWorks.add(newTask.getWork());
                    listTasks.add(newTask);
                    newTask.setTaskTag(2);
                    newTask.setBackupTask(currTask);
                    newTask.setBackupChildrenTasks(currTask.getChildTasks());
                    aliasToTask.put(bigTableAlias, newTask);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SemanticException("Generate Map Join Task Error: " + e.getMessage());
            }
            listWorks.add(currTask.getWork());
            listTasks.add(currTask);
            currWork.setOpParseCtxMap(null);
            currWork.setJoinTree(null);
            ConditionalWork cndWork = new ConditionalWork(listWorks);
            ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, parseCtx.getConf(), new Task[0]);
            cndTsk.setListTasks(listTasks);
            cndTsk.setResolver(new ConditionalResolverCommonJoin());
            ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx resolverCtx = new ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx();
            resolverCtx.setPathToAliases(pathToAliases);
            resolverCtx.setAliasToKnownSize(this.aliasToSize);
            resolverCtx.setAliasToTask(aliasToTask);
            resolverCtx.setCommonJoinTask(currTask);
            resolverCtx.setLocalTmpDir(context.getLocalScratchDir(false));
            resolverCtx.setHdfsTmpDir(context.getMRScratchDir());
            cndTsk.setResolverCtx(resolverCtx);
            this.replaceTaskWithConditionalTask(currTask, cndTsk, this.physicalContext);
            return cndTsk;
        }

        private void replaceTaskWithConditionalTask(Task<? extends Serializable> currTask, ConditionalTask cndTsk, PhysicalContext physicalContext) {
            List<Task<Serializable>> parentTasks = currTask.getParentTasks();
            currTask.setParentTasks(null);
            if (parentTasks != null) {
                for (Task<Serializable> tsk : parentTasks) {
                    tsk.addDependentTask(cndTsk);
                    tsk.removeDependentTask(currTask);
                }
            } else {
                physicalContext.removeFromRootTask(currTask);
                physicalContext.addToRootTask(cndTsk);
            }
            List<Task<Serializable>> oldChildTasks = currTask.getChildTasks();
            if (oldChildTasks != null) {
                for (Task<? extends Serializable> tsk : cndTsk.getListTasks()) {
                    if (tsk.equals(currTask)) continue;
                    for (Task<Serializable> oldChild : oldChildTasks) {
                        tsk.addDependentTask(oldChild);
                    }
                }
            }
        }

        private void replaceTask(Task<? extends Serializable> currTask, Task<? extends Serializable> newTask, PhysicalContext physicalContext) {
            List<Task<Serializable>> parentTasks = currTask.getParentTasks();
            currTask.setParentTasks(null);
            if (parentTasks != null) {
                for (Task<Serializable> tsk : parentTasks) {
                    tsk.removeDependentTask(currTask);
                    tsk.addDependentTask(newTask);
                }
            } else {
                physicalContext.removeFromRootTask(currTask);
                physicalContext.addToRootTask(newTask);
            }
            List<Task<Serializable>> oldChildTasks = currTask.getChildTasks();
            currTask.setChildTasks(null);
            if (oldChildTasks != null) {
                for (Task<Serializable> tsk : oldChildTasks) {
                    tsk.getParentTasks().remove(currTask);
                    newTask.addDependentTask(tsk);
                }
            }
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            if (nodeOutputs == null || nodeOutputs.length == 0) {
                throw new SemanticException("No Dispatch Context");
            }
            TaskGraphWalker.TaskGraphWalkerContext walkerCtx = (TaskGraphWalker.TaskGraphWalkerContext)nodeOutputs[0];
            Task currTask = (Task)nd;
            if (currTask.isMapRedTask()) {
                if (currTask instanceof ConditionalTask) {
                    List<Task<? extends Serializable>> taskList = ((ConditionalTask)currTask).getListTasks();
                    for (Task<? extends Serializable> tsk : taskList) {
                        if (!tsk.isMapRedTask()) continue;
                        Task<? extends Serializable> newTask = this.processCurrentTask((MapRedTask)tsk, (ConditionalTask)currTask, this.physicalContext.getContext());
                        walkerCtx.addToDispatchList(newTask);
                    }
                } else {
                    Task<? extends Serializable> newTask = this.processCurrentTask((MapRedTask)currTask, null, this.physicalContext.getContext());
                    walkerCtx.addToDispatchList(newTask);
                }
            }
            return null;
        }

        private boolean checkOperatorOKMapJoinConversion(Operator<? extends OperatorDesc> op) {
            if (!op.opAllowedConvertMapJoin()) {
                return false;
            }
            if (op.getChildOperators() == null) {
                return true;
            }
            for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
                if (this.checkOperatorOKMapJoinConversion(childOp)) continue;
                return false;
            }
            return true;
        }

        private JoinOperator getJoinOp(MapRedTask task) throws SemanticException {
            MapredWork work = (MapredWork)task.getWork();
            if (work == null) {
                return null;
            }
            Operator<?> reducerOp = work.getReducer();
            if (reducerOp instanceof JoinOperator) {
                LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = work.getAliasToWork();
                for (Operator op : aliasToWork.values()) {
                    if (this.checkOperatorOKMapJoinConversion(op)) continue;
                    return null;
                }
                return (JoinOperator)reducerOp;
            }
            return null;
        }
    }
}

