/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.ReflectionUtils;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)MapJoinOperator.class.getName());
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Mapside join exceeds available memory. Please try removing the mapjoin hint."};
    private transient MapJoinTableContainer[] mapJoinTables;
    private transient MapJoinTableContainerSerDe[] mapJoinTableSerdes;
    private transient boolean hashTblInitedOnce;
    private transient MapJoinKey key;

    public MapJoinOperator() {
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        int tagLen = ((MapJoinDesc)this.conf).getTagLength();
        this.mapJoinTables = new MapJoinTableContainer[tagLen];
        this.mapJoinTableSerdes = new MapJoinTableContainerSerDe[tagLen];
        this.hashTblInitedOnce = false;
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator " + this.getOperatorId() + " (id=" + this.id + "): " + FATAL_ERR_MSG[(int)counterCode]);
    }

    public void generateMapMetaData() throws HiveException, SerDeException {
        TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
        SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
        keySerializer.initialize(null, keyTableDesc.getProperties());
        MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerializer, false);
        for (int pos = 0; pos < this.order.length; ++pos) {
            if (pos == this.posBigTable) continue;
            TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getNoOuterJoin() ? ((MapJoinDesc)this.conf).getValueTblDescs().get(pos) : ((MapJoinDesc)this.conf).getValueFilteredTblDescs().get(pos);
            SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
            valueSerDe.initialize(null, valueTableDesc.getProperties());
            MapJoinObjectSerDeContext valueContext = new MapJoinObjectSerDeContext(valueSerDe, this.hasFilter(pos));
            this.mapJoinTableSerdes[pos] = new MapJoinTableContainerSerDe(keyContext, valueContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHashTable() throws HiveException {
        if (!this.getExecContext().getLocalWork().getInputFileChangeSensitive()) {
            if (this.hashTblInitedOnce) {
                return;
            }
            this.hashTblInitedOnce = true;
        }
        String baseDir = null;
        String currentInputFile = this.getExecContext().getCurrentInputFile();
        LOG.info((Object)("******* Load from HashTable File: input : " + currentInputFile));
        String fileName = this.getExecContext().getLocalWork().getBucketFileName(currentInputFile);
        try {
            if (ShimLoader.getHadoopShims().isLocalMode(this.hconf)) {
                baseDir = this.getExecContext().getLocalWork().getTmpFileURI();
            } else {
                String stageID = this.getExecContext().getLocalWork().getStageID();
                String suffix = Utilities.generateTarFileName(stageID);
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.hconf);
                Path[] localArchives = DistributedCache.getLocalCacheArchives((Configuration)this.hconf);
                for (int j = 0; j < localArchives.length; ++j) {
                    Path archive = localArchives[j];
                    if (!archive.getName().endsWith(suffix)) continue;
                    Path archiveLocalLink = archive.makeQualified((FileSystem)localFs);
                    baseDir = archiveLocalLink.toUri().getPath();
                }
            }
            for (int pos = 0; pos < this.mapJoinTables.length; ++pos) {
                if (pos == this.posBigTable) continue;
                if (baseDir == null) {
                    throw new IllegalStateException("baseDir cannot be null");
                }
                String filePath = Utilities.generatePath(baseDir, ((MapJoinDesc)this.conf).getDumpFilePrefix(), (byte)pos, fileName);
                Path path = new Path(filePath);
                LOG.info((Object)("\tLoad back 1 hashtable file from tmp file uri:" + path));
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path.toUri().getPath()), 4096));
                try {
                    this.mapJoinTables[pos] = this.mapJoinTableSerdes[pos].load(in);
                    continue;
                }
                finally {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        try {
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.loadHashTable();
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int pos;
            if (this.firstRow) {
                this.generateMapMetaData();
                this.firstRow = false;
            }
            this.alias = (byte)tag;
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            this.key = JoinUtil.computeMapJoinKeys(this.key, row, this.joinKeys[this.alias], this.joinKeysObjectInspectors[this.alias]);
            boolean joinNeeded = false;
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == this.alias) continue;
                MapJoinRowContainer rowContainer = this.mapJoinTables[pos].get(this.key);
                if (rowContainer == null || this.key.hasAnyNulls(this.nullsafes)) {
                    if (!this.noOuterJoin) {
                        joinNeeded = true;
                        this.storage[pos] = this.dummyObjVectors[pos];
                        continue;
                    }
                    this.storage[pos] = this.emptyList;
                    continue;
                }
                joinNeeded = true;
                this.storage[pos] = rowContainer.copy();
                this.aliasFilterTags[pos] = rowContainer.getAliasFilter();
            }
            if (joinNeeded) {
                ArrayList<Object> value = this.getFilteredValue(this.alias, row);
                this.storage[this.alias].add(value);
                this.checkAndGenObject();
            }
            this.storage[tag].clear();
            for (pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
                if (pos == tag) continue;
                this.storage[pos] = null;
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.mapJoinTables != null) {
            for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
                if (tableContainer == null) continue;
                tableContainer.clear();
            }
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return MapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

