/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionHandler;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class HashTableSinkOperator
extends TerminalOperator<HashTableSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)HashTableSinkOperator.class.getName());
    private transient List<ExprNodeEvaluator>[] joinKeys;
    private transient List<ObjectInspector>[] joinKeysObjectInspectors;
    private transient int posBigTableAlias = -1;
    transient int mapJoinRowsKey;
    private transient List<ExprNodeEvaluator>[] joinFilters;
    private transient int[][] filterMaps;
    private transient List<ExprNodeEvaluator>[] joinValues;
    private transient List<ObjectInspector>[] joinValuesObjectInspectors;
    private transient List<ObjectInspector>[] joinFilterObjectInspectors;
    private transient Byte[] order;
    private Configuration hconf;
    private transient Byte alias;
    private transient MapJoinTableContainer[] mapJoinTables;
    private transient MapJoinTableContainerSerDe[] mapJoinTableSerdes;
    private transient boolean noOuterJoin;
    private long rowNumber = 0L;
    private transient SessionState.LogHelper console;
    private long hashTableScale;
    private MapJoinMemoryExhaustionHandler memoryExhaustionHandler;

    public HashTableSinkOperator() {
    }

    public HashTableSinkOperator(MapJoinOperator mjop) {
        this.conf = new HashTableSinkDesc((MapJoinDesc)mjop.getConf());
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        boolean isSilent = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVESESSIONSILENT);
        this.console = new SessionState.LogHelper(LOG, isSilent);
        this.memoryExhaustionHandler = new MapJoinMemoryExhaustionHandler(this.console, ((HashTableSinkDesc)this.conf).getHashtableMemoryUsage());
        this.posBigTableAlias = ((HashTableSinkDesc)this.conf).getPosBigTable();
        this.order = ((HashTableSinkDesc)this.conf).getTagOrder();
        this.hconf = hconf;
        this.noOuterJoin = ((HashTableSinkDesc)this.conf).isNoOuterJoin();
        this.filterMaps = ((HashTableSinkDesc)this.conf).getFilterMap();
        int tagLen = ((HashTableSinkDesc)this.conf).getTagLength();
        this.joinKeys = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinKeys, ((HashTableSinkDesc)this.conf).getKeys(), this.posBigTableAlias);
        this.joinKeysObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        this.joinValues = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinValues, ((HashTableSinkDesc)this.conf).getExprs(), this.posBigTableAlias);
        this.joinValuesObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinValues, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        this.joinFilters = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinFilters, ((HashTableSinkDesc)this.conf).getFilters(), this.posBigTableAlias);
        this.joinFilterObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinFilters, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        if (!this.noOuterJoin) {
            List[] rowContainerObjectInspectors = new List[tagLen];
            for (Byte alias : this.order) {
                if (alias == this.posBigTableAlias) continue;
                List<ObjectInspector> rcOIs = this.joinValuesObjectInspectors[alias];
                if (this.filterMaps != null && this.filterMaps[alias] != null) {
                    rcOIs = new ArrayList<ObjectInspector>(rcOIs);
                    rcOIs.add(PrimitiveObjectInspectorFactory.writableShortObjectInspector);
                }
                rowContainerObjectInspectors[alias.byteValue()] = rcOIs;
            }
        }
        this.mapJoinTables = new MapJoinTableContainer[tagLen];
        this.mapJoinTableSerdes = new MapJoinTableContainerSerDe[tagLen];
        int hashTableThreshold = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD);
        float hashTableLoadFactor = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR);
        this.hashTableScale = HiveConf.getLongVar(hconf, HiveConf.ConfVars.HIVEHASHTABLESCALE);
        if (this.hashTableScale <= 0L) {
            this.hashTableScale = 1L;
        }
        try {
            TableDesc keyTableDesc = ((HashTableSinkDesc)this.conf).getKeyTblDesc();
            SerDe keySerde = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
            keySerde.initialize(null, keyTableDesc.getProperties());
            MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerde, false);
            for (Byte pos : this.order) {
                if (pos == this.posBigTableAlias) continue;
                this.mapJoinTables[pos.byteValue()] = new HashMapWrapper(hashTableThreshold, hashTableLoadFactor);
                TableDesc valueTableDesc = ((HashTableSinkDesc)this.conf).getValueTblFilteredDescs().get(pos.byteValue());
                SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
                valueSerDe.initialize(null, valueTableDesc.getProperties());
                this.mapJoinTableSerdes[pos.byteValue()] = new MapJoinTableContainerSerDe(keyContext, new MapJoinObjectSerDeContext(valueSerDe, this.hasFilter(pos.byteValue())));
            }
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    private static List<ObjectInspector>[] getStandardObjectInspectors(List<ObjectInspector>[] aliasToObjectInspectors, int maxTag) {
        List[] result = new List[maxTag];
        for (int alias = 0; alias < aliasToObjectInspectors.length; alias = (int)((byte)(alias + 1))) {
            List<ObjectInspector> oiList = aliasToObjectInspectors[alias];
            if (oiList == null) continue;
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>(oiList.size());
            for (int i = 0; i < oiList.size(); ++i) {
                fieldOIList.add(ObjectInspectorUtils.getStandardObjectInspector(oiList.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            result[alias] = fieldOIList;
        }
        return result;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        this.alias = (byte)tag;
        MapJoinKey key = JoinUtil.computeMapJoinKeys(null, row, this.joinKeys[this.alias], this.joinKeysObjectInspectors[this.alias]);
        Object[] value = JoinUtil.computeMapJoinValues(row, this.joinValues[this.alias], this.joinValuesObjectInspectors[this.alias], this.joinFilters[this.alias], this.joinFilterObjectInspectors[this.alias], this.filterMaps == null ? null : this.filterMaps[this.alias]);
        MapJoinTableContainer tableContainer = this.mapJoinTables[this.alias];
        MapJoinRowContainer rowContainer = tableContainer.get(key);
        if (rowContainer == null) {
            rowContainer = new MapJoinRowContainer();
            rowContainer.add(value);
            ++this.rowNumber;
            if (this.rowNumber > this.hashTableScale && this.rowNumber % this.hashTableScale == 0L) {
                this.memoryExhaustionHandler.checkMemoryStatus(tableContainer.size(), this.rowNumber);
            }
            tableContainer.put(key, rowContainer);
        } else {
            rowContainer.add(value);
        }
    }

    private boolean hasFilter(int alias) {
        return this.filterMaps != null && this.filterMaps[alias] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            if (this.mapJoinTables != null) {
                String tmpURI = this.getExecContext().getLocalWork().getTmpFileURI();
                LOG.info((Object)("Temp URI for side table: " + tmpURI));
                for (byte tag = 0; tag < this.mapJoinTables.length; tag = (byte)((byte)(tag + 1))) {
                    MapJoinTableContainer tableContainer = this.mapJoinTables[tag];
                    if (tableContainer == null) continue;
                    String bigBucketFileName = this.getExecContext().getCurrentBigBucketFile();
                    String fileName = this.getExecContext().getLocalWork().getBucketFileName(bigBucketFileName);
                    String dumpFilePrefix = ((HashTableSinkDesc)this.conf).getDumpFilePrefix();
                    String tmpURIPath = Utilities.generatePath(tmpURI, dumpFilePrefix, tag, fileName);
                    this.console.printInfo(Utilities.now() + "\tDump the side-table into file: " + tmpURIPath);
                    Path path = new Path(tmpURIPath);
                    FileSystem fs = path.getFileSystem(this.hconf);
                    ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream((OutputStream)fs.create(path), 4096));
                    try {
                        this.mapJoinTableSerdes[tag].persist(out, tableContainer);
                    }
                    finally {
                        out.close();
                    }
                    tableContainer.clear();
                    this.console.printInfo(Utilities.now() + "\tUpload 1 File to: " + tmpURIPath);
                }
            }
            super.closeOp(abort);
        }
        catch (Exception e) {
            LOG.error((Object)"Error generating side-table", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return HashTableSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "HASHTABLESINK";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.HASHTABLESINK;
    }
}

