/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class ColumnAccessAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)ColumnAccessAnalyzer.class.getName());
    private final ParseContext pGraphContext;

    public ColumnAccessAnalyzer() {
        this.pGraphContext = null;
    }

    public ColumnAccessAnalyzer(ParseContext pactx) {
        this.pGraphContext = pactx;
    }

    public ColumnAccessInfo analyzeColumnAccess() throws SemanticException {
        ColumnAccessInfo columnAccessInfo = new ColumnAccessInfo();
        HashMap<TableScanOperator, Table> topOps = this.pGraphContext.getTopToTable();
        for (TableScanOperator op : topOps.keySet()) {
            Table table = (Table)topOps.get(op);
            String tableName = table.getCompleteName();
            List<FieldSchema> tableCols = table.getAllCols();
            for (int i : op.getNeededColumnIDs()) {
                columnAccessInfo.add(tableName, tableCols.get(i).getName());
            }
        }
        return columnAccessInfo;
    }
}

