/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class BucketingSortingCtx
implements NodeProcessorCtx {
    Map<Operator<? extends OperatorDesc>, List<BucketCol>> bucketedColsByOp = new HashMap<Operator<? extends OperatorDesc>, List<BucketCol>>();
    Map<String, List<BucketCol>> bucketedColsByDirectory = new HashMap<String, List<BucketCol>>();
    Map<Operator<? extends OperatorDesc>, List<SortCol>> sortedColsByOp = new HashMap<Operator<? extends OperatorDesc>, List<SortCol>>();
    Map<String, List<SortCol>> sortedColsByDirectory = new HashMap<String, List<SortCol>>();

    public List<BucketCol> getBucketedCols(Operator<? extends OperatorDesc> op) {
        return this.bucketedColsByOp.get(op);
    }

    public void setBucketedCols(Operator<? extends OperatorDesc> op, List<BucketCol> bucketCols) {
        this.bucketedColsByOp.put(op, bucketCols);
    }

    public Map<String, List<BucketCol>> getBucketedColsByDirectory() {
        return this.bucketedColsByDirectory;
    }

    public void setBucketedColsByDirectory(Map<String, List<BucketCol>> bucketedColsByDirectory) {
        this.bucketedColsByDirectory = bucketedColsByDirectory;
    }

    public List<SortCol> getSortedCols(Operator<? extends OperatorDesc> op) {
        return this.sortedColsByOp.get(op);
    }

    public void setSortedCols(Operator<? extends OperatorDesc> op, List<SortCol> sortedCols) {
        this.sortedColsByOp.put(op, sortedCols);
    }

    public Map<String, List<SortCol>> getSortedColsByDirectory() {
        return this.sortedColsByDirectory;
    }

    public void setSortedColsByDirectory(Map<String, List<SortCol>> sortedColsByDirectory) {
        this.sortedColsByDirectory = sortedColsByDirectory;
    }

    public static final class SortCol
    implements BucketSortCol,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> names = new ArrayList<String>();
        private final List<Integer> indexes = new ArrayList<Integer>();
        private final char sortOrder;

        public SortCol(String name, int index, char sortOrder) {
            this(sortOrder);
            this.addAlias(name, index);
        }

        public SortCol(char sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public List<Integer> getIndexes() {
            return this.indexes;
        }

        @Override
        public void addAlias(String name, Integer index) {
            this.names.add(name);
            this.indexes.add(index);
        }

        public char getSortOrder() {
            return this.sortOrder;
        }

        public String toString() {
            return "name: " + this.names.get(0) + " index: " + this.indexes.get(0) + " order: " + this.sortOrder;
        }
    }

    public static final class BucketCol
    implements BucketSortCol,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> names = new ArrayList<String>();
        private final List<Integer> indexes = new ArrayList<Integer>();

        public BucketCol(String name, int index) {
            this.addAlias(name, index);
        }

        public BucketCol() {
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public List<Integer> getIndexes() {
            return this.indexes;
        }

        @Override
        public void addAlias(String name, Integer index) {
            this.names.add(name);
            this.indexes.add(index);
        }

        public String toString() {
            return "name: " + this.names.get(0) + " index: " + this.indexes.get(0);
        }
    }

    public static interface BucketSortCol {
        public List<String> getNames();

        public List<Integer> getIndexes();

        public void addAlias(String var1, Integer var2);
    }
}

