/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

public class ReduceSinkDeDuplication
implements Transform {
    private static final String RS = ReduceSinkOperator.getOperatorName();
    private static final String GBY = GroupByOperator.getOperatorName();
    private static final String JOIN = JoinOperator.getOperatorName();
    protected ParseContext pGraphContext;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pGraphContext = pctx;
        ReduceSinkDeduplicateProcCtx cppCtx = new ReduceSinkDeduplicateProcCtx(this.pGraphContext);
        boolean mergeJoins = !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", RS + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getReducerReducerProc());
        opRules.put(new RuleRegExp("R2", RS + "%" + GBY + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getGroupbyReducerProc());
        if (mergeJoins) {
            opRules.put(new RuleRegExp("R3", JOIN + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getJoinReducerProc());
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ReduceSinkDeduplicateProcFactory.getDefaultProc(), opRules, cppCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }

    static class ReducerReducerProc
    extends AbsctractReducerReducerProc {
        ReducerReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ParseContext context) throws SemanticException {
            ReduceSinkOperator pRS = this.findPossibleParent(cRS, ReduceSinkOperator.class, this.trustScript());
            if (pRS != null && this.merge(cRS, pRS, this.minReducer())) {
                this.replaceReduceSinkWithSelectOperator(cRS, context);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ParseContext context) throws SemanticException {
            Operator<?> start = this.getStartForGroupBy(cRS);
            ReduceSinkOperator pRS = this.findPossibleParent(start, ReduceSinkOperator.class, this.trustScript());
            if (pRS != null && this.merge(cRS, pRS, this.minReducer())) {
                this.removeReduceSinkForGroupBy(cRS, cGBY, context);
                return true;
            }
            return false;
        }
    }

    static class JoinReducerProc
    extends AbsctractReducerReducerProc {
        JoinReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ParseContext context) throws SemanticException {
            JoinOperator pJoin = this.findPossibleParent(cRS, JoinOperator.class, this.trustScript());
            if (pJoin != null && this.merge(cRS, pJoin, this.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                this.replaceReduceSinkWithSelectOperator(cRS, context);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ParseContext context) throws SemanticException {
            Operator<?> start = this.getStartForGroupBy(cRS);
            JoinOperator pJoin = this.findPossibleParent(start, JoinOperator.class, this.trustScript());
            if (pJoin != null && this.merge(cRS, pJoin, this.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                this.removeReduceSinkForGroupBy(cRS, cGBY, context);
                return true;
            }
            return false;
        }
    }

    static class GroupbyReducerProc
    extends AbsctractReducerReducerProc {
        GroupbyReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ParseContext context) throws SemanticException {
            GroupByOperator pGBY = this.findPossibleParent(cRS, GroupByOperator.class, this.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = this.findPossibleParent(pGBY, ReduceSinkOperator.class, this.trustScript());
            if (pRS != null && this.merge(cRS, pRS, this.minReducer())) {
                this.replaceReduceSinkWithSelectOperator(cRS, context);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ParseContext context) throws SemanticException {
            Operator<?> start = this.getStartForGroupBy(cRS);
            GroupByOperator pGBY = this.findPossibleParent(start, GroupByOperator.class, this.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = this.getSingleParent(pGBY, ReduceSinkOperator.class);
            if (pRS != null && this.merge(cRS, pRS, this.minReducer())) {
                this.removeReduceSinkForGroupBy(cRS, cGBY, context);
                return true;
            }
            return false;
        }
    }

    public static abstract class AbsctractReducerReducerProc
    implements NodeProcessor {
        ReduceSinkDeduplicateProcCtx dedupCtx;

        protected boolean trustScript() {
            return this.dedupCtx.trustScript;
        }

        protected int minReducer() {
            return this.dedupCtx.minReducer;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            this.dedupCtx = (ReduceSinkDeduplicateProcCtx)procCtx;
            if (this.dedupCtx.contains((Operator)nd)) {
                return false;
            }
            ReduceSinkOperator cRS = (ReduceSinkOperator)nd;
            Operator<?> child = this.getSingleChild(cRS);
            if (child instanceof JoinOperator) {
                return false;
            }
            ParseContext pctx = this.dedupCtx.getPctx();
            if (child instanceof GroupByOperator) {
                GroupByOperator cGBY = (GroupByOperator)child;
                if (!this.hasGroupingSet(cRS) && !((GroupByDesc)cGBY.getConf()).isGroupingSetsPresent()) {
                    return this.process(cRS, cGBY, pctx);
                }
                return false;
            }
            if (child instanceof ExtractOperator) {
                return this.process(cRS, pctx);
            }
            return false;
        }

        private boolean hasGroupingSet(ReduceSinkOperator cRS) {
            GroupByOperator cGBYm = this.getSingleParent(cRS, GroupByOperator.class);
            return cGBYm != null && ((GroupByDesc)cGBYm.getConf()).isGroupingSetsPresent();
        }

        protected Operator<?> getSingleParent(Operator<?> operator) {
            List<Operator<OperatorDesc>> parents = operator.getParentOperators();
            if (parents != null && parents.size() == 1) {
                return parents.get(0);
            }
            return null;
        }

        protected Operator<?> getSingleChild(Operator<?> operator) {
            List<Operator<OperatorDesc>> children = operator.getChildOperators();
            if (children != null && children.size() == 1) {
                return children.get(0);
            }
            return null;
        }

        protected <T> T getSingleParent(Operator<?> operator, Class<T> type) {
            Operator<?> parent = this.getSingleParent(operator);
            return (T)(type.isInstance(parent) ? parent : null);
        }

        protected abstract Object process(ReduceSinkOperator var1, ParseContext var2) throws SemanticException;

        protected abstract Object process(ReduceSinkOperator var1, GroupByOperator var2, ParseContext var3) throws SemanticException;

        protected Operator<?> getStartForGroupBy(ReduceSinkOperator cRS) {
            ReduceSinkOperator parent = this.getSingleParent(cRS);
            return parent instanceof GroupByOperator ? parent : cRS;
        }

        protected boolean merge(ReduceSinkOperator cRS, JoinOperator pJoin, int minReducer) throws SemanticException {
            List<Operator<OperatorDesc>> parents = pJoin.getParentOperators();
            Operator[] pRSs = parents.toArray(new ReduceSinkOperator[parents.size()]);
            ReduceSinkDesc cRSc = (ReduceSinkDesc)cRS.getConf();
            ReduceSinkDesc pRS0c = (ReduceSinkDesc)pRSs[0].getConf();
            if (cRSc.getKeyCols().size() > pRS0c.getKeyCols().size()) {
                return false;
            }
            if (cRSc.getPartitionCols().size() > pRS0c.getPartitionCols().size()) {
                return false;
            }
            Integer moveReducerNumTo = this.checkNumReducer(cRSc.getNumReducers(), pRS0c.getNumReducers());
            if (moveReducerNumTo == null || moveReducerNumTo > 0 && cRSc.getNumReducers() < minReducer) {
                return false;
            }
            Integer moveRSOrderTo = this.checkOrder(cRSc.getOrder(), pRS0c.getOrder());
            if (moveRSOrderTo == null) {
                return false;
            }
            boolean[] sorted = this.getSortedTags(pJoin);
            int cKeySize = cRSc.getKeyCols().size();
            for (int i = 0; i < cKeySize; ++i) {
                ExprNodeDesc cexpr = cRSc.getKeyCols().get(i);
                ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
                for (int tag = 0; tag < pRSs.length; ++tag) {
                    pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getKeyCols().get(i);
                }
                int found = this.indexOf(cexpr, pexprs, cRS, pRSs, sorted);
                if (found >= 0) continue;
                return false;
            }
            int cPartSize = cRSc.getPartitionCols().size();
            for (int i = 0; i < cPartSize; ++i) {
                ExprNodeDesc cexpr = cRSc.getPartitionCols().get(i);
                ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
                for (int tag = 0; tag < pRSs.length; ++tag) {
                    pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getPartitionCols().get(i);
                }
                int found = this.indexOf(cexpr, pexprs, cRS, pRSs, sorted);
                if (found >= 0) continue;
                return false;
            }
            if (moveReducerNumTo > 0) {
                for (Operator pRS : pRSs) {
                    ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
                }
            }
            return true;
        }

        private boolean[] getSortedTags(JoinOperator joinOp) {
            boolean[] result = new boolean[joinOp.getParentOperators().size()];
            for (int tag = 0; tag < result.length; ++tag) {
                result[tag] = this.isSortedTag(joinOp, tag);
            }
            return result;
        }

        private boolean isSortedTag(JoinOperator joinOp, int tag) {
            block5: for (JoinCondDesc cond : ((JoinDesc)joinOp.getConf()).getConds()) {
                switch (cond.getType()) {
                    case 1: {
                        if (cond.getRight() != tag) continue block5;
                        return false;
                    }
                    case 2: {
                        if (cond.getLeft() != tag) continue block5;
                        return false;
                    }
                    case 3: {
                        if (cond.getLeft() != tag && cond.getRight() != tag) continue block5;
                        return false;
                    }
                }
            }
            return true;
        }

        private int indexOf(ExprNodeDesc cexpr, ExprNodeDesc[] pexprs, Operator child, Operator[] parents, boolean[] sorted) throws SemanticException {
            for (int tag = 0; tag < parents.length; ++tag) {
                if (!sorted[tag] || !pexprs[tag].isSame(ExprNodeDescUtils.backtrack(cexpr, child, parents[tag]))) continue;
                return tag;
            }
            return -1;
        }

        protected boolean merge(ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
            ArrayList<ExprNodeDesc> parentPCs;
            int[] result = this.checkStatus(cRS, pRS, minReducer);
            if (result == null) {
                return false;
            }
            if (result[0] > 0) {
                ArrayList<ExprNodeDesc> childKCs = ((ReduceSinkDesc)cRS.getConf()).getKeyCols();
                ((ReduceSinkDesc)pRS.getConf()).setKeyCols(ExprNodeDescUtils.backtrack(childKCs, cRS, pRS));
            }
            if (result[1] < 0) {
                ArrayList<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
                if (childPCs != null && !childPCs.isEmpty()) {
                    ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
                }
            } else if (result[1] > 0 && ((parentPCs = ((ReduceSinkDesc)pRS.getConf()).getPartitionCols()) == null || parentPCs.isEmpty())) {
                ArrayList<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
                ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
            }
            if (result[2] > 0) {
                if (result[0] <= 0) {
                    throw new SemanticException("Sorting columns and order don't match. Try set " + (Object)((Object)HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION) + "=false;");
                }
                ((ReduceSinkDesc)pRS.getConf()).setOrder(((ReduceSinkDesc)cRS.getConf()).getOrder());
            }
            if (result[3] > 0) {
                ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
            }
            return true;
        }

        private int[] checkStatus(ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
            ArrayList<ExprNodeDesc> ppars;
            ArrayList<ExprNodeDesc> pkeys;
            ReduceSinkDesc cConf = (ReduceSinkDesc)cRS.getConf();
            ReduceSinkDesc pConf = (ReduceSinkDesc)pRS.getConf();
            Integer moveRSOrderTo = this.checkOrder(cConf.getOrder(), pConf.getOrder());
            if (moveRSOrderTo == null) {
                return null;
            }
            Integer moveReducerNumTo = this.checkNumReducer(cConf.getNumReducers(), pConf.getNumReducers());
            if (moveReducerNumTo == null || moveReducerNumTo > 0 && cConf.getNumReducers() < minReducer) {
                return null;
            }
            ArrayList<ExprNodeDesc> ckeys = cConf.getKeyCols();
            Integer moveKeyColTo = this.checkExprs(ckeys, pkeys = pConf.getKeyCols(), cRS, pRS);
            if (moveKeyColTo == null) {
                return null;
            }
            ArrayList<ExprNodeDesc> cpars = cConf.getPartitionCols();
            Integer movePartitionColTo = this.checkExprs(cpars, ppars = pConf.getPartitionCols(), cRS, pRS);
            if (movePartitionColTo == null) {
                return null;
            }
            return new int[]{moveKeyColTo, movePartitionColTo, moveRSOrderTo, moveReducerNumTo};
        }

        private Integer checkExprs(List<ExprNodeDesc> ckeys, List<ExprNodeDesc> pkeys, ReduceSinkOperator cRS, ReduceSinkOperator pRS) throws SemanticException {
            Integer moveKeyColTo = 0;
            if (ckeys == null || ckeys.isEmpty()) {
                if (pkeys != null && !pkeys.isEmpty()) {
                    moveKeyColTo = -1;
                }
            } else if (pkeys == null || pkeys.isEmpty()) {
                for (ExprNodeDesc ckey : ckeys) {
                    if (ExprNodeDescUtils.backtrack(ckey, cRS, pRS) != null) continue;
                    return null;
                }
                moveKeyColTo = 1;
            } else {
                moveKeyColTo = this.sameKeys(ckeys, pkeys, cRS, pRS);
            }
            return moveKeyColTo;
        }

        protected Integer sameKeys(List<ExprNodeDesc> cexprs, List<ExprNodeDesc> pexprs, Operator<?> child, Operator<?> parent) throws SemanticException {
            int i;
            int common = Math.min(cexprs.size(), pexprs.size());
            int limit = Math.max(cexprs.size(), pexprs.size());
            for (i = 0; i < common; ++i) {
                ExprNodeDesc cexpr;
                ExprNodeDesc pexpr = pexprs.get(i);
                if (pexpr.isSame(cexpr = ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent))) continue;
                return null;
            }
            while (i < limit) {
                if (cexprs.size() > pexprs.size() && ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent) == null) {
                    return null;
                }
                ++i;
            }
            return Integer.valueOf(cexprs.size()).compareTo(pexprs.size());
        }

        protected Integer checkOrder(String corder, String porder) {
            if (corder == null || corder.trim().equals("")) {
                if (porder == null || porder.trim().equals("")) {
                    return 0;
                }
                return -1;
            }
            if (porder == null || porder.trim().equals("")) {
                return 1;
            }
            corder = corder.trim();
            porder = porder.trim();
            int target = Math.min(corder.length(), porder.length());
            if (!corder.substring(0, target).equals(porder.substring(0, target))) {
                return null;
            }
            return Integer.valueOf(corder.length()).compareTo(porder.length());
        }

        protected Integer checkNumReducer(int creduce, int preduce) {
            if (creduce < 0) {
                if (preduce < 0) {
                    return 0;
                }
                return -1;
            }
            if (preduce < 0) {
                return 1;
            }
            if (creduce != preduce) {
                return null;
            }
            return 0;
        }

        protected <T extends Operator<?>> T findPossibleParent(Operator<?> start, Class<T> target, boolean trustScript) throws SemanticException {
            Operator[] parents = this.findPossibleParents(start, target, trustScript);
            return (T)(parents != null && parents.length == 1 ? parents[0] : null);
        }

        protected <T extends Operator<?>> T[] findPossibleParents(Operator<?> start, Class<T> target, boolean trustScript) {
            Operator<?> cursor = this.getSingleParent(start);
            while (cursor != null) {
                if (target.isAssignableFrom(cursor.getClass())) {
                    Operator[] array = (Operator[])Array.newInstance(target, 1);
                    array[0] = cursor;
                    return array;
                }
                if (cursor instanceof JoinOperator) {
                    return this.findParents((JoinOperator)cursor, target);
                }
                if (cursor instanceof ScriptOperator && !trustScript) {
                    return null;
                }
                if (!(cursor instanceof SelectOperator || cursor instanceof FilterOperator || cursor instanceof ExtractOperator || cursor instanceof ForwardOperator || cursor instanceof ScriptOperator || cursor instanceof ReduceSinkOperator)) {
                    return null;
                }
                cursor = this.getSingleParent(cursor);
            }
            return null;
        }

        private <T extends Operator<?>> T[] findParents(JoinOperator join, Class<T> target) {
            List<Operator<OperatorDesc>> parents = join.getParentOperators();
            Operator[] result = (Operator[])Array.newInstance(target, parents.size());
            for (int tag = 0; tag < result.length; ++tag) {
                Operator<OperatorDesc> cursor = parents.get(tag);
                while (cursor != null) {
                    if (target.isAssignableFrom(cursor.getClass())) {
                        result[tag] = cursor;
                        break;
                    }
                    cursor = this.getSingleParent(cursor);
                }
                if (result[tag] != null) continue;
                throw new IllegalStateException("failed to find " + target.getSimpleName() + " from " + join + " on tag " + tag);
            }
            return result;
        }

        protected SelectOperator replaceReduceSinkWithSelectOperator(ReduceSinkOperator childRS, ParseContext context) throws SemanticException {
            SelectOperator select = this.replaceOperatorWithSelect(childRS, context);
            ((SelectDesc)select.getConf()).setOutputColumnNames(((ReduceSinkDesc)childRS.getConf()).getOutputValueColumnNames());
            ((SelectDesc)select.getConf()).setColList(((ReduceSinkDesc)childRS.getConf()).getValueCols());
            return select;
        }

        private SelectOperator replaceOperatorWithSelect(Operator<?> operator, ParseContext context) throws SemanticException {
            RowResolver inputRR = context.getOpParseCtx().get(operator).getRowResolver();
            SelectDesc select = new SelectDesc(null, null);
            Operator<?> parent = this.getSingleParent(operator);
            Operator<?> child = this.getSingleChild(operator);
            parent.getChildOperators().clear();
            SelectOperator sel = (SelectOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(inputRR.getColumnInfos()), parent), inputRR, context);
            sel.setColumnExprMap(operator.getColumnExprMap());
            sel.setChildOperators(operator.getChildOperators());
            for (Operator<OperatorDesc> ch : operator.getChildOperators()) {
                ch.replaceParent(operator, sel);
            }
            if (child instanceof ExtractOperator) {
                this.removeOperator(child, this.getSingleChild(child), sel, context);
                this.dedupCtx.addRemovedOperator(child);
            }
            operator.setChildOperators(null);
            operator.setParentOperators(null);
            this.dedupCtx.addRemovedOperator(operator);
            return sel;
        }

        protected void removeReduceSinkForGroupBy(ReduceSinkOperator cRS, GroupByOperator cGBYr, ParseContext context) throws SemanticException {
            Operator<?> parent = this.getSingleParent(cRS);
            if (parent instanceof GroupByOperator) {
                GroupByOperator cGBYm = (GroupByOperator)parent;
                ((GroupByDesc)cGBYr.getConf()).setKeys(((GroupByDesc)cGBYm.getConf()).getKeys());
                ((GroupByDesc)cGBYr.getConf()).setAggregators(((GroupByDesc)cGBYm.getConf()).getAggregators());
                for (AggregationDesc aggr : ((GroupByDesc)cGBYm.getConf()).getAggregators()) {
                    aggr.setMode(GenericUDAFEvaluator.Mode.COMPLETE);
                }
                cGBYr.setColumnExprMap(cGBYm.getColumnExprMap());
                cGBYr.setSchema(cGBYm.getSchema());
                RowResolver resolver = context.getOpParseCtx().get(cGBYm).getRowResolver();
                context.getOpParseCtx().get(cGBYr).setRowResolver(resolver);
            } else {
                ((GroupByDesc)cGBYr.getConf()).setKeys(ExprNodeDescUtils.backtrack(((GroupByDesc)cGBYr.getConf()).getKeys(), cGBYr, cRS));
                for (AggregationDesc aggr : ((GroupByDesc)cGBYr.getConf()).getAggregators()) {
                    aggr.setParameters(ExprNodeDescUtils.backtrack(aggr.getParameters(), cGBYr, cRS));
                }
                Map<String, ExprNodeDesc> oldMap = cGBYr.getColumnExprMap();
                RowResolver oldRR = context.getOpParseCtx().get(cGBYr).getRowResolver();
                HashMap<String, ExprNodeDesc> newMap = new HashMap<String, ExprNodeDesc>();
                RowResolver newRR = new RowResolver();
                ArrayList<String> outputCols = ((GroupByDesc)cGBYr.getConf()).getOutputColumnNames();
                for (int i = 0; i < outputCols.size(); ++i) {
                    String colName = (String)outputCols.get(i);
                    String[] nm = oldRR.reverseLookup(colName);
                    ColumnInfo colInfo = oldRR.get(nm[0], nm[1]);
                    newRR.put(nm[0], nm[1], colInfo);
                    ExprNodeDesc colExpr = ExprNodeDescUtils.backtrack(oldMap.get(colName), cGBYr, cRS);
                    if (colExpr == null) continue;
                    newMap.put(colInfo.getInternalName(), colExpr);
                }
                cGBYr.setColumnExprMap(newMap);
                cGBYr.setSchema(new RowSchema(newRR.getColumnInfos()));
                context.getOpParseCtx().get(cGBYr).setRowResolver(newRR);
            }
            ((GroupByDesc)cGBYr.getConf()).setMode(GroupByDesc.Mode.COMPLETE);
            this.removeOperator(cRS, cGBYr, parent, context);
            this.dedupCtx.addRemovedOperator(cRS);
            if (parent instanceof GroupByOperator) {
                this.removeOperator(parent, cGBYr, this.getSingleParent(parent), context);
                this.dedupCtx.addRemovedOperator(cGBYr);
            }
        }

        private void removeOperator(Operator<?> target, Operator<?> child, Operator<?> parent, ParseContext context) {
            for (Operator<OperatorDesc> aparent : target.getParentOperators()) {
                aparent.replaceChild(target, child);
            }
            for (Operator<OperatorDesc> achild : target.getChildOperators()) {
                achild.replaceParent(target, parent);
            }
            target.setChildOperators(null);
            target.setParentOperators(null);
            context.getOpParseCtx().remove(target);
        }

        private Operator<? extends Serializable> putOpInsertMap(Operator<?> op, RowResolver rr, ParseContext context) {
            OpParseContext ctx = new OpParseContext(rr);
            context.getOpParseCtx().put(op, ctx);
            return op;
        }
    }

    static class DefaultProc
    implements NodeProcessor {
        DefaultProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    static class ReduceSinkDeduplicateProcFactory {
        ReduceSinkDeduplicateProcFactory() {
        }

        public static NodeProcessor getReducerReducerProc() {
            return new ReducerReducerProc();
        }

        public static NodeProcessor getGroupbyReducerProc() {
            return new GroupbyReducerProc();
        }

        public static NodeProcessor getJoinReducerProc() {
            return new JoinReducerProc();
        }

        public static NodeProcessor getDefaultProc() {
            return new DefaultProc();
        }
    }

    class ReduceSinkDeduplicateProcCtx
    implements NodeProcessorCtx {
        ParseContext pctx;
        boolean trustScript;
        int minReducer;
        Set<Operator<?>> removedOps = new HashSet();

        public ReduceSinkDeduplicateProcCtx(ParseContext pctx) {
            this.trustScript = pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVESCRIPTOPERATORTRUST);
            this.minReducer = pctx.getConf().getIntVar(HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATIONMINREDUCER);
            this.pctx = pctx;
        }

        public boolean contains(Operator<?> rsOp) {
            return this.removedOps.contains(rsOp);
        }

        public boolean addRemovedOperator(Operator<?> rsOp) {
            return this.removedOps.add(rsOp);
        }

        public ParseContext getPctx() {
            return this.pctx;
        }

        public void setPctx(ParseContext pctx) {
            this.pctx = pctx;
        }
    }
}

