/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.SizeBasedBigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class TableSizeBasedBigTableSelectorForAutoSMJ
extends SizeBasedBigTableSelectorForAutoSMJ
implements BigTableSelectorForAutoSMJ {
    @Override
    public int getBigTablePosition(ParseContext parseCtx, JoinOperator joinOp) throws SemanticException {
        int bigTablePos = 0;
        long maxSize = -1L;
        HiveConf conf = parseCtx.getConf();
        try {
            ArrayList<TableScanOperator> topOps = new ArrayList<TableScanOperator>();
            this.getListTopOps(joinOp, topOps);
            int currentPos = 0;
            for (TableScanOperator topOp : topOps) {
                if (topOp == null) {
                    return -1;
                }
                Table table = parseCtx.getTopToTable().get(topOp);
                long currentSize = 0L;
                if (!table.isPartitioned()) {
                    currentSize = this.getSize(conf, table);
                } else {
                    PrunedPartitionList partsList = PartitionPruner.prune(parseCtx.getTopToTable().get(topOp), parseCtx.getOpToPartPruner().get(topOp), parseCtx.getConf(), null, parseCtx.getPrunedPartitions());
                    for (Partition part : partsList.getNotDeniedPartns()) {
                        currentSize += this.getSize(conf, part);
                    }
                }
                if (currentSize > maxSize) {
                    maxSize = currentSize;
                    bigTablePos = currentPos;
                }
                ++currentPos;
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage());
        }
        return bigTablePos;
    }
}

