/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.BitFieldReader;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.DynamicByteArray;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReader;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

class RecordReaderImpl
implements RecordReader {
    private final FSDataInputStream file;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = 0;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    private final TreeReader reader;
    private final OrcProto.RowIndex[] indexes;

    RecordReaderImpl(Iterable<StripeInformation> stripes, FileSystem fileSystem, Path path, long offset, long length, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, boolean[] included, long strideRate) throws IOException {
        this.file = fileSystem.open(path);
        this.codec = codec;
        this.bufferSize = bufferSize;
        this.included = included;
        long rows = 0L;
        long skippedRows = 0L;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= offset + length) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        this.reader = RecordReaderImpl.createTreeReader(0, types, included);
        this.indexes = new OrcProto.RowIndex[types.size()];
        this.rowIndexStride = strideRate;
        if (this.stripes.size() > 0) {
            this.readStripe();
        }
    }

    private static TreeReader createTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: {
                return new BooleanTreeReader(columnId);
            }
            case BYTE: {
                return new ByteTreeReader(columnId);
            }
            case DOUBLE: {
                return new DoubleTreeReader(columnId);
            }
            case FLOAT: {
                return new FloatTreeReader(columnId);
            }
            case SHORT: {
                return new ShortTreeReader(columnId);
            }
            case INT: {
                return new IntTreeReader(columnId);
            }
            case LONG: {
                return new LongTreeReader(columnId);
            }
            case STRING: {
                return new StringTreeReader(columnId);
            }
            case BINARY: {
                return new BinaryTreeReader(columnId);
            }
            case TIMESTAMP: {
                return new TimestampTreeReader(columnId);
            }
            case DECIMAL: {
                return new DecimalTreeReader(columnId);
            }
            case STRUCT: {
                return new StructTreeReader(columnId, types, included);
            }
            case LIST: {
                return new ListTreeReader(columnId, types, included);
            }
            case MAP: {
                return new MapTreeReader(columnId, types, included);
            }
            case UNION: {
                return new UnionTreeReader(columnId, types, included);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type.getKind());
    }

    OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
        int tailLength = (int)stripe.getFooterLength();
        ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
        this.file.seek(offset);
        this.file.readFully(tailBuf.array(), tailBuf.arrayOffset(), tailLength);
        return OrcProto.StripeFooter.parseFrom(InStream.create("footer", tailBuf, this.codec, this.bufferSize));
    }

    private void readStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        long offset = stripe.getOffset();
        this.streams.clear();
        if (this.included == null) {
            byte[] buffer = new byte[(int)stripe.getDataLength()];
            this.file.seek(offset + stripe.getIndexLength());
            this.file.readFully(buffer, 0, buffer.length);
            int sectionOffset = 0;
            for (OrcProto.Stream section : this.stripeFooter.getStreamsList()) {
                if (StreamName.getArea(section.getKind()) != StreamName.Area.DATA) continue;
                int sectionLength = (int)section.getLength();
                ByteBuffer sectionBuffer = ByteBuffer.wrap(buffer, sectionOffset, sectionLength);
                StreamName name = new StreamName(section.getColumn(), section.getKind());
                this.streams.put(name, InStream.create(name.toString(), sectionBuffer, this.codec, this.bufferSize));
                sectionOffset += sectionLength;
            }
        } else {
            int currentSection;
            List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
            for (currentSection = 0; currentSection < streamList.size() && StreamName.getArea(streamList.get(currentSection).getKind()) != StreamName.Area.DATA; ++currentSection) {
            }
            long sectionOffset = stripe.getIndexLength();
            while (currentSection < streamList.size()) {
                int excluded;
                int bytes = 0;
                for (excluded = currentSection; excluded < streamList.size() && this.included[streamList.get(excluded).getColumn()]; ++excluded) {
                    bytes = (int)((long)bytes + streamList.get(excluded).getLength());
                }
                if (bytes != 0) {
                    byte[] buffer = new byte[bytes];
                    this.file.seek(offset + sectionOffset);
                    this.file.readFully(buffer, 0, bytes);
                    sectionOffset += (long)bytes;
                    bytes = 0;
                    while (currentSection < excluded) {
                        OrcProto.Stream section = streamList.get(currentSection);
                        StreamName name = new StreamName(section.getColumn(), section.getKind());
                        this.streams.put(name, InStream.create(name.toString(), ByteBuffer.wrap(buffer, bytes, (int)section.getLength()), this.codec, this.bufferSize));
                        ++currentSection;
                        bytes = (int)((long)bytes + section.getLength());
                    }
                }
                while (currentSection < streamList.size() && !this.included[streamList.get(currentSection).getColumn()]) {
                    sectionOffset += streamList.get(currentSection).getLength();
                    ++currentSection;
                }
            }
        }
        this.reader.startStripe(this.streams, this.stripeFooter.getColumnsList());
        this.rowInStripe = 0L;
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.rowInStripe < this.rowCountInStripe || this.currentStripe < this.stripes.size() - 1;
    }

    @Override
    public Object next(Object previous) throws IOException {
        if (this.rowInStripe >= this.rowCountInStripe) {
            ++this.currentStripe;
            this.readStripe();
        }
        ++this.rowInStripe;
        return this.reader.next(previous);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    private int findStripe(long rowNumber) {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        rowNumber -= this.firstRow;
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    private void readRowIndex() throws IOException {
        long offset = this.stripes.get(this.currentStripe).getOffset();
        for (OrcProto.Stream stream : this.stripeFooter.getStreamsList()) {
            if (stream.getKind() == OrcProto.Stream.Kind.ROW_INDEX) {
                int col = stream.getColumn();
                if ((this.included == null || this.included[col]) && this.indexes[col] == null) {
                    byte[] buffer = new byte[(int)stream.getLength()];
                    this.file.seek(offset);
                    this.file.readFully(buffer);
                    this.indexes[col] = OrcProto.RowIndex.parseFrom(InStream.create("index", ByteBuffer.wrap(buffer), this.codec, this.bufferSize));
                }
            }
            offset += stream.getLength();
        }
    }

    private void seekToRowEntry(int rowEntry) throws IOException {
        PositionProvider[] index = new PositionProvider[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            index[i] = new PositionProviderImpl(this.indexes[i].getEntry(rowEntry));
        }
        this.reader.seek(index);
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        int rightStripe = this.findStripe(rowNumber);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.readRowIndex();
        this.rowInStripe = rowNumber - this.rowBaseInStripe;
        if (this.rowIndexStride != 0L) {
            long entry = this.rowInStripe / this.rowIndexStride;
            this.seekToRowEntry((int)entry);
            this.reader.skipRows(this.rowInStripe - entry * this.rowIndexStride);
        } else {
            this.reader.skipRows(this.rowInStripe);
        }
    }

    private static class MapTreeReader
    extends TreeReader {
        private final TreeReader keyReader;
        private final TreeReader valueReader;
        private RunLengthIntegerReader lengths;

        MapTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            int keyColumn = type.getSubtypes(0);
            int valueColumn = type.getSubtypes(1);
            this.keyReader = included == null || included[keyColumn] ? RecordReaderImpl.createTreeReader(keyColumn, types, included) : null;
            this.valueReader = included == null || included[valueColumn] ? RecordReaderImpl.createTreeReader(valueColumn, types, included) : null;
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.keyReader.seek(index);
            this.valueReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            HashMap<Object, Object> result = null;
            if (this.valuePresent) {
                result = previous == null ? new HashMap<Object, Object>() : (HashMap<Object, Object>)previous;
                result.clear();
                int length = (int)this.lengths.next();
                for (int i = 0; i < length; ++i) {
                    result.put(this.keyReader.next(null), this.valueReader.next(null));
                }
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.lengths = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
            if (this.keyReader != null) {
                this.keyReader.startStripe(streams, encodings);
            }
            if (this.valueReader != null) {
                this.valueReader.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.keyReader.skipRows(childSkip);
            this.valueReader.skipRows(childSkip);
        }
    }

    private static class ListTreeReader
    extends TreeReader {
        private final TreeReader elementReader;
        private RunLengthIntegerReader lengths;

        ListTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            this.elementReader = RecordReaderImpl.createTreeReader(type.getSubtypes(0), types, included);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.elementReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ArrayList<Object> result = null;
            if (this.valuePresent) {
                int i;
                result = previous == null ? new ArrayList<Object>() : (ArrayList<Object>)previous;
                int prevLength = result.size();
                int length = (int)this.lengths.next();
                for (i = prevLength; i < length; ++i) {
                    result.add(null);
                }
                for (i = 0; i < length; ++i) {
                    result.set(i, this.elementReader.next(i < prevLength ? result.get(i) : null));
                }
                for (i = prevLength - 1; i >= length; --i) {
                    result.remove(i);
                }
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.lengths = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
            if (this.elementReader != null) {
                this.elementReader.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.elementReader.skipRows(childSkip);
        }
    }

    private static class UnionTreeReader
    extends TreeReader {
        private final TreeReader[] fields;
        private RunLengthByteReader tags;

        UnionTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new TreeReader[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included != null && !included[subtype]) continue;
                this.fields[i] = RecordReaderImpl.createTreeReader(subtype, types, included);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.tags.seek(index[this.columnId]);
            for (TreeReader kid : this.fields) {
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcUnion result = null;
            if (this.valuePresent) {
                result = previous == null ? new OrcUnion() : (OrcUnion)previous;
                byte tag = this.tags.next();
                Object previousVal = result.getObject();
                result.set(tag, this.fields[tag].next(tag == result.getTag() ? previousVal : null));
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.tags = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long[] counts = new long[this.fields.length];
            int i = 0;
            while ((long)i < items) {
                byte by = this.tags.next();
                counts[by] = counts[by] + 1L;
                ++i;
            }
            for (i = 0; i < counts.length; ++i) {
                this.fields[i].skipRows(counts[i]);
            }
        }
    }

    private static class StructTreeReader
    extends TreeReader {
        private final TreeReader[] fields;
        private final String[] fieldNames;

        StructTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getFieldNamesCount();
            this.fields = new TreeReader[fieldCount];
            this.fieldNames = new String[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included == null || included[subtype]) {
                    this.fields[i] = RecordReaderImpl.createTreeReader(subtype, types, included);
                }
                this.fieldNames[i] = type.getFieldNames(i);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            for (TreeReader kid : this.fields) {
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcStruct result = null;
            if (this.valuePresent) {
                if (previous == null) {
                    result = new OrcStruct(this.fields.length);
                } else {
                    result = (OrcStruct)previous;
                    if (result.getNumFields() != this.fields.length) {
                        result.setNumFields(this.fields.length);
                    }
                }
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.fields[i] == null) continue;
                    result.setFieldValue(i, this.fields[i].next(result.getFieldValue(i)));
                }
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, encodings);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (TreeReader field : this.fields) {
                field.skipRows(items);
            }
        }
    }

    private static class StringTreeReader
    extends TreeReader {
        private DynamicByteArray dictionaryBuffer = null;
        private int dictionarySize;
        private int[] dictionaryOffsets;
        private RunLengthIntegerReader reader;

        StringTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.dictionarySize = encodings.get(this.columnId).getDictionarySize();
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
            InStream in = streams.get(name);
            if (in.available() > 0) {
                this.dictionaryBuffer = new DynamicByteArray(64, in.available());
                this.dictionaryBuffer.readAll(in);
            } else {
                this.dictionaryBuffer = null;
            }
            in.close();
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH);
            in = streams.get(name);
            RunLengthIntegerReader lenReader = new RunLengthIntegerReader(in, false);
            int offset = 0;
            if (this.dictionaryOffsets == null || this.dictionaryOffsets.length < this.dictionarySize + 1) {
                this.dictionaryOffsets = new int[this.dictionarySize + 1];
            }
            for (int i = 0; i < this.dictionarySize; ++i) {
                this.dictionaryOffsets[i] = offset;
                offset += (int)lenReader.next();
            }
            this.dictionaryOffsets[this.dictionarySize] = offset;
            in.close();
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = new RunLengthIntegerReader(streams.get(name), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                int entry = (int)this.reader.next();
                result = previous == null ? new Text() : (Text)previous;
                int offset = this.dictionaryOffsets[entry];
                int length = entry < this.dictionaryOffsets.length - 1 ? this.dictionaryOffsets[entry + 1] - offset : this.dictionaryBuffer.size() - offset;
                if (this.dictionaryBuffer != null) {
                    this.dictionaryBuffer.setText(result, offset, length);
                } else {
                    result.clear();
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class DecimalTreeReader
    extends TreeReader {
        private InStream valueStream;
        private RunLengthIntegerReader scaleStream;

        DecimalTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.valueStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA));
            this.scaleStream = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.valueStream.seek(index[this.columnId]);
            this.scaleStream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            if (this.valuePresent) {
                return new HiveDecimal(SerializationUtils.readBigInteger(this.valueStream), (int)this.scaleStream.next());
            }
            return null;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readBigInteger(this.valueStream);
                ++i;
            }
            this.scaleStream.skip(items);
        }
    }

    private static class TimestampTreeReader
    extends TreeReader {
        private RunLengthIntegerReader data;
        private RunLengthIntegerReader nanos;

        TimestampTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.data = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), true);
            this.nanos = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.data.seek(index[this.columnId]);
            this.nanos.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Timestamp result = null;
            if (this.valuePresent) {
                result = previous == null ? new Timestamp(0L) : (Timestamp)previous;
                long millis = (this.data.next() + WriterImpl.BASE_TIMESTAMP) * 1000L;
                int newNanos = TimestampTreeReader.parseNanos(this.nanos.next());
                millis = millis >= 0L ? (millis += (long)(newNanos / 1000000)) : (millis -= (long)(newNanos / 1000000));
                result.setTime(millis);
                result.setNanos(newNanos);
            }
            return result;
        }

        private static int parseNanos(long serialized) {
            int zeros = 7 & (int)serialized;
            int result = (int)serialized >>> 3;
            if (zeros != 0) {
                for (int i = 0; i <= zeros; ++i) {
                    result *= 10;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.data.skip(items);
            this.nanos.skip(items);
        }
    }

    private static class BinaryTreeReader
    extends TreeReader {
        private InStream stream;
        private RunLengthIntegerReader lengths;

        BinaryTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = new RunLengthIntegerReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
            this.lengths.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BytesWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BytesWritable() : (BytesWritable)previous;
                int len = (int)this.lengths.next();
                result.setSize(len);
                int offset = 0;
                while (len > 0) {
                    int written = this.stream.read(result.getBytes(), offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            this.stream.skip(lengthToSkip);
        }
    }

    private static class DoubleTreeReader
    extends TreeReader {
        private InStream stream;

        DoubleTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            DoubleWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new DoubleWritable() : (DoubleWritable)previous;
                result.set(SerializationUtils.readDouble(this.stream));
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.stream.skip(items * 8L);
        }
    }

    private static class FloatTreeReader
    extends TreeReader {
        private InStream stream;

        FloatTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.stream.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            FloatWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set(SerializationUtils.readFloat(this.stream));
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readFloat(this.stream);
                ++i;
            }
        }
    }

    private static class LongTreeReader
    extends TreeReader {
        private RunLengthIntegerReader reader = null;

        LongTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = new RunLengthIntegerReader(streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            LongWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new LongWritable() : (LongWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class IntTreeReader
    extends TreeReader {
        private RunLengthIntegerReader reader = null;

        IntTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = new RunLengthIntegerReader(streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            IntWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new IntWritable() : (IntWritable)previous;
                result.set((int)this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class ShortTreeReader
    extends TreeReader {
        private RunLengthIntegerReader reader = null;

        ShortTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = new RunLengthIntegerReader(streams.get(name), true);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ShortWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ShortWritable() : (ShortWritable)previous;
                result.set((short)this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class ByteTreeReader
    extends TreeReader {
        private RunLengthByteReader reader = null;

        ByteTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.reader = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ByteWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ByteWritable() : (ByteWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    private static class BooleanTreeReader
    extends TreeReader {
        private BitFieldReader reader = null;

        BooleanTreeReader(int columnId) {
            super(columnId);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings) throws IOException {
            super.startStripe(streams, encodings);
            this.reader = new BitFieldReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), 1);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.reader.seek(index[this.columnId]);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BooleanWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BooleanWritable() : (BooleanWritable)previous;
                result.set(this.reader.next() == 1);
            }
            return result;
        }
    }

    private static abstract class TreeReader {
        protected final int columnId;
        private BitFieldReader present = null;
        protected boolean valuePresent = false;

        TreeReader(int columnId) {
            this.columnId = columnId;
        }

        void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encoding) throws IOException {
            InStream in = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.PRESENT));
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
        }

        void seek(PositionProvider[] index) throws IOException {
            if (this.present != null) {
                this.present.seek(index[this.columnId]);
            }
        }

        protected long countNonNulls(long rows) throws IOException {
            if (this.present != null) {
                long result = 0L;
                for (long c = 0L; c < rows; ++c) {
                    if (this.present.next() != 1) continue;
                    ++result;
                }
                return result;
            }
            return rows;
        }

        abstract void skipRows(long var1) throws IOException;

        Object next(Object previous) throws IOException {
            if (this.present != null) {
                this.valuePresent = this.present.next() == 1;
            }
            return previous;
        }
    }

    private static final class PositionProviderImpl
    implements PositionProvider {
        private final OrcProto.RowIndexEntry entry;
        private int index = 0;

        PositionProviderImpl(OrcProto.RowIndexEntry entry) {
            this.entry = entry;
        }

        @Override
        public long getNext() {
            return this.entry.getPositions(this.index++);
        }
    }
}

