/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.CommonToken;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.HiveInterruptCallback;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.ReworkMapredInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.Graph;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.datanucleus.sco.backed.List;

public final class Utilities {
    public static String HADOOP_LOCAL_FS = "file:///";
    private static Map<String, MapredWork> gWorkMap = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog((String)Utilities.class.getName());
    public static TableDesc defaultTd = PlanUtils.getDefaultTableDesc("1");
    public static final int carriageReturnCode = 13;
    public static final int newLineCode = 10;
    public static final int tabCode = 9;
    public static final int ctrlaCode = 1;
    public static final String INDENT = "  ";
    public static String nullStringStorage = "\\N";
    public static String nullStringOutput = "NULL";
    public static Random randGen = new Random();
    public static final String NSTR = "";
    private static final String tmpPrefix = "_tmp.";
    private static final String taskTmpPrefix = "_task_tmp.";
    private static final Pattern FILE_NAME_TO_TASK_ID_REGEX = Pattern.compile("^.*?([0-9]+)(_[0-9]{1,3})?(\\..*)?$");
    private static final Pattern FILE_NAME_PREFIXED_TASK_ID_REGEX = Pattern.compile("^.*?((\\(.*\\))?[0-9]+)(_[0-9]{1,3})?(\\..*)?$");
    private static final Pattern PREFIXED_TASK_ID_REGEX = Pattern.compile("^(.*?\\(.*\\))?([0-9]+)$");
    public static Object getInputSummaryLock = new Object();
    public static String suffix = ".hashtable";
    public static final char sqlEscapeChar = '\\';

    private Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMapRedWork(Configuration job) {
        try {
            Path planPath = new Path(HiveConf.getVar(job, HiveConf.ConfVars.PLAN));
            FileSystem fs = planPath.getFileSystem(job);
            if (fs.exists(planPath)) {
                try {
                    fs.delete(planPath, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            String jobID = Utilities.getHiveJobID(job);
            if (jobID != null) {
                gWorkMap.remove(jobID);
            }
        }
    }

    public static MapredWork getMapRedWork(Configuration job) {
        MapredWork gWork = null;
        try {
            String jobID = Utilities.getHiveJobID(job);
            assert (jobID != null);
            gWork = gWorkMap.get(jobID);
            if (gWork == null) {
                MapredWork ret;
                String path;
                String jtConf = ShimLoader.getHadoopShims().getJobLauncherRpcAddress(job);
                if (jtConf.equals("local")) {
                    String planPath = HiveConf.getVar(job, HiveConf.ConfVars.PLAN);
                    path = new Path(planPath).toUri().getPath();
                } else {
                    path = "HIVE_PLAN" + jobID;
                }
                FileInputStream in = new FileInputStream(path);
                gWork = ret = Utilities.deserializeMapRedWork(in, job);
                gWork.initialize();
                gWorkMap.put(jobID, gWork);
            }
            return gWork;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void setWorkflowAdjacencies(Configuration conf, QueryPlan plan) {
        try {
            Graph stageGraph = plan.getQueryPlan().getStageGraph();
            if (stageGraph == null) {
                return;
            }
            java.util.List<Adjacency> adjList = stageGraph.getAdjacencyList();
            if (adjList == null) {
                return;
            }
            for (Adjacency adj : adjList) {
                java.util.List<String> children = adj.getChildren();
                if (children == null || children.isEmpty()) {
                    return;
                }
                conf.setStrings("mapreduce.workflow.adjacency." + adj.getNode(), children.toArray(new String[children.size()]));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static java.util.List<String> getFieldSchemaString(java.util.List<FieldSchema> fl) {
        if (fl == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (FieldSchema f : fl) {
            ret.add(f.getName() + " " + f.getType() + (f.getComment() != null ? " " + f.getComment() : NSTR));
        }
        return ret;
    }

    public static void setMapRedWork(Configuration job, MapredWork w, String hiveScratchDir) {
        try {
            String jobID = UUID.randomUUID().toString();
            Path planPath = new Path(hiveScratchDir, jobID);
            HiveConf.setVar(job, HiveConf.ConfVars.PLAN, planPath.toUri().toString());
            FileSystem fs = planPath.getFileSystem(job);
            FSDataOutputStream out = fs.create(planPath);
            Utilities.serializeMapRedWork(w, (OutputStream)out);
            if (!ShimLoader.getHadoopShims().isLocalMode(job)) {
                DistributedCache.createSymlink((Configuration)job);
                String uriWithLink = planPath.toUri().toString() + "#HIVE_PLAN" + jobID;
                DistributedCache.addCacheFile((URI)new URI(uriWithLink), (Configuration)job);
                short replication = (short)job.getInt("mapred.submit.replication", 10);
                fs.setReplication(planPath, replication);
            }
            w.initialize();
            gWorkMap.put(jobID, w);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String getHiveJobID(Configuration job) {
        String planPath = HiveConf.getVar(job, HiveConf.ConfVars.PLAN);
        if (planPath != null && !planPath.isEmpty()) {
            return new Path(planPath).getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serializeExpression(ExprNodeDesc expr) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(baos);
        encoder.setPersistenceDelegate(java.sql.Date.class, new DatePersistenceDelegate());
        encoder.setPersistenceDelegate(Timestamp.class, new TimestampPersistenceDelegate());
        try {
            encoder.writeObject(expr);
        }
        finally {
            encoder.close();
        }
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExprNodeDesc deserializeExpression(String s, Configuration conf) {
        byte[] bytes;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        XMLDecoder decoder = new XMLDecoder(bais, null, null);
        try {
            ExprNodeDesc expr;
            ExprNodeDesc exprNodeDesc = expr = (ExprNodeDesc)decoder.readObject();
            return exprNodeDesc;
        }
        finally {
            decoder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeTasks(Task<? extends Serializable> t, OutputStream out) {
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(out);
            e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
            e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
            e.setPersistenceDelegate(Operator.ProgressCounter.class, new EnumDelegate());
            e.setPersistenceDelegate(java.sql.Date.class, new DatePersistenceDelegate());
            e.setPersistenceDelegate(Timestamp.class, new TimestampPersistenceDelegate());
            e.writeObject(t);
        }
        finally {
            if (null != e) {
                e.close();
            }
        }
    }

    public static void serializeQueryPlan(QueryPlan plan, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                LOG.warn((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                throw new RuntimeException("Cannot serialize the query plan", e);
            }
        });
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
        e.setPersistenceDelegate(Operator.ProgressCounter.class, new EnumDelegate());
        e.setPersistenceDelegate(java.sql.Date.class, new DatePersistenceDelegate());
        e.setPersistenceDelegate(Timestamp.class, new TimestampPersistenceDelegate());
        e.setPersistenceDelegate(org.datanucleus.sco.backed.Map.class, new MapDelegate());
        e.setPersistenceDelegate(List.class, new ListDelegate());
        e.setPersistenceDelegate(CommonToken.class, new CommonTokenDelegate());
        e.writeObject(plan);
        e.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryPlan deserializeQueryPlan(InputStream in, Configuration conf) {
        XMLDecoder d = null;
        try {
            QueryPlan ret;
            d = new XMLDecoder(in, null, null);
            QueryPlan queryPlan = ret = (QueryPlan)d.readObject();
            return queryPlan;
        }
        finally {
            if (null != d) {
                d.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeMapRedWork(MapredWork w, OutputStream out) {
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(out);
            e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
            e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
            e.setPersistenceDelegate(java.sql.Date.class, new DatePersistenceDelegate());
            e.setPersistenceDelegate(Timestamp.class, new TimestampPersistenceDelegate());
            e.writeObject(w);
        }
        finally {
            if (null != e) {
                e.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapredWork deserializeMapRedWork(InputStream in, Configuration conf) {
        XMLDecoder d = null;
        try {
            MapredWork ret;
            d = new XMLDecoder(in, null, null);
            MapredWork mapredWork = ret = (MapredWork)d.readObject();
            return mapredWork;
        }
        finally {
            if (null != d) {
                d.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeMapRedLocalWork(MapredLocalWork w, OutputStream out) {
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(out);
            e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
            e.setPersistenceDelegate(GroupByDesc.Mode.class, new EnumDelegate());
            e.setPersistenceDelegate(java.sql.Date.class, new DatePersistenceDelegate());
            e.setPersistenceDelegate(Timestamp.class, new TimestampPersistenceDelegate());
            e.writeObject(w);
        }
        finally {
            if (null != e) {
                e.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapredLocalWork deserializeMapRedLocalWork(InputStream in, Configuration conf) {
        XMLDecoder d = null;
        try {
            MapredLocalWork ret;
            d = new XMLDecoder(in, null, null);
            MapredLocalWork mapredLocalWork = ret = (MapredLocalWork)d.readObject();
            return mapredLocalWork;
        }
        finally {
            if (null != d) {
                d.close();
            }
        }
    }

    public static String getTaskId(Configuration hconf) {
        String taskid;
        String string = taskid = hconf == null ? null : hconf.get("mapred.task.id");
        if (taskid == null || taskid.equals(NSTR)) {
            return NSTR + Math.abs(randGen.nextInt());
        }
        String ret = taskid.replaceAll(".*_[mr]_", NSTR).replaceAll(".*_(map|reduce)_", NSTR);
        return ret;
    }

    public static HashMap makeMap(Object ... olist) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (int i = 0; i < olist.length; i += 2) {
            ret.put(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static Properties makeProperties(String ... olist) {
        Properties ret = new Properties();
        for (int i = 0; i < olist.length; i += 2) {
            ret.setProperty(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static ArrayList makeList(Object ... olist) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object element : olist) {
            ret.add(element);
        }
        return ret;
    }

    public static TableDesc getTableDesc(Table tbl) {
        return new TableDesc(tbl.getDeserializer().getClass(), tbl.getInputFormatClass(), tbl.getOutputFormatClass(), tbl.getMetadata());
    }

    public static TableDesc getTableDesc(String cols, String colTypes) {
        return new TableDesc(LazySimpleSerDe.class, SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", cols, "columns.types", colTypes));
    }

    public static PartitionDesc getPartitionDesc(Partition part) throws HiveException {
        return new PartitionDesc(part);
    }

    public static PartitionDesc getPartitionDescFromTableDesc(TableDesc tblDesc, Partition part) throws HiveException {
        return new PartitionDesc(part, tblDesc);
    }

    private static String getOpTreeSkel_helper(Operator<?> op, String indent) {
        if (op == null) {
            return NSTR;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(op.toString());
        sb.append("\n");
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                sb.append(Utilities.getOpTreeSkel_helper(child, indent + INDENT));
            }
        }
        return sb.toString();
    }

    public static String getOpTreeSkel(Operator<?> op) {
        return Utilities.getOpTreeSkel_helper(op, NSTR);
    }

    private static boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    public static boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) throws IOException {
        try {
            int c2;
            int c1;
            if (is1 == is2 || is1 == null && is2 == null) {
                return true;
            }
            if (is1 == null || is2 == null) {
                return false;
            }
            do {
                c1 = is1.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c1)) {
                    c1 = is1.read();
                }
                c2 = is2.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c2)) {
                    c2 = is2.read();
                }
                if (c1 != -1 || c2 != -1) continue;
                return true;
            } while (c1 == c2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String abbreviate(String str, int max) {
        str = str.trim();
        int len = str.length();
        int suffixlength = 20;
        if (len <= max) {
            return str;
        }
        suffixlength = Math.min(suffixlength, (max - 3) / 2);
        String rev = StringUtils.reverse(str);
        String suffix = WordUtils.abbreviate(rev, 0, suffixlength, NSTR);
        suffix = StringUtils.reverse(suffix);
        String prefix = StringUtils.abbreviate(str, max - suffix.length());
        return prefix + suffix;
    }

    public static StreamStatus readColumn(DataInput in, OutputStream out) throws IOException {
        boolean foundCrChar = false;
        while (true) {
            byte b;
            try {
                b = in.readByte();
            }
            catch (EOFException e) {
                return StreamStatus.EOF;
            }
            if (Shell.WINDOWS) {
                if (foundCrChar && b != 10) {
                    out.write(13);
                    foundCrChar = false;
                }
                if (b == 13) {
                    foundCrChar = true;
                    continue;
                }
            }
            if (b == 10) {
                return StreamStatus.TERMINATED;
            }
            out.write(b);
        }
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createCompressedStream(jc, out, isCompressed);
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out, boolean isCompressed) throws IOException {
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
            return codec.createOutputStream(out);
        }
        return out;
    }

    @Deprecated
    public static String getFileExtension(JobConf jc, boolean isCompressed) {
        return Utilities.getFileExtension(jc, isCompressed, new HiveIgnoreKeyTextOutputFormat());
    }

    public static String getFileExtension(JobConf jc, boolean isCompressed, HiveOutputFormat<?, ?> hiveOutputFormat) {
        String extension = HiveConf.getVar((Configuration)jc, HiveConf.ConfVars.OUTPUT_FILE_EXTENSION);
        if (!StringUtils.isEmpty(extension)) {
            return extension;
        }
        if (hiveOutputFormat instanceof HiveIgnoreKeyTextOutputFormat && isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
            return codec.getDefaultExtension();
        }
        return NSTR;
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createSequenceWriter(jc, fs, file, keyClass, valClass, isCompressed);
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, boolean isCompressed) throws IOException {
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        Class codecClass = null;
        if (isCompressed) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType((JobConf)jc);
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        }
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)jc, (Path)file, keyClass, valClass, (SequenceFile.CompressionType)compressionType, codec);
    }

    public static RCFile.Writer createRCFileWriter(JobConf jc, FileSystem fs, Path file, boolean isCompressed) throws IOException {
        CompressionCodec codec = null;
        Class codecClass = null;
        if (isCompressed) {
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        }
        return new RCFile.Writer(fs, (Configuration)jc, file, null, codec);
    }

    public static String realFile(String newFile, Configuration conf) throws IOException {
        Path path = new Path(newFile);
        URI pathURI = path.toUri();
        Object fs = pathURI.getScheme() == null ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem(conf);
        if (!fs.exists(path)) {
            return null;
        }
        String file = path.makeQualified((FileSystem)fs).toString();
        if (StringUtils.startsWith(file, "file:/") && !StringUtils.startsWith(file, "file:///")) {
            file = "file:///" + file.substring("file:/".length());
        }
        return file;
    }

    public static java.util.List<String> mergeUniqElems(java.util.List<String> src, java.util.List<String> dest) {
        if (dest == null) {
            return src;
        }
        if (src == null) {
            return dest;
        }
        for (int pos = 0; pos < dest.size(); ++pos) {
            if (src.contains(dest.get(pos))) continue;
            src.add(dest.get(pos));
        }
        return src;
    }

    public static Path toTaskTempPath(Path orig) {
        if (orig.getName().indexOf(taskTmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), taskTmpPrefix + orig.getName());
    }

    public static Path toTaskTempPath(String orig) {
        return Utilities.toTaskTempPath(new Path(orig));
    }

    public static Path toTempPath(Path orig) {
        if (orig.getName().indexOf(tmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), tmpPrefix + orig.getName());
    }

    public static Path toTempPath(String orig) {
        return Utilities.toTempPath(new Path(orig));
    }

    public static boolean isTempPath(FileStatus file) {
        String name = file.getPath().getName();
        return name.startsWith("_task") || name.startsWith(tmpPrefix);
    }

    public static void rename(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.rename(src, dst)) {
            throw new HiveException("Unable to move: " + src + " to: " + dst);
        }
    }

    public static void renameOrMoveFiles(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.exists(dst)) {
            if (!fs.rename(src, dst)) {
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        } else {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(src)) {
                Path srcFilePath = file.getPath();
                String fileName = srcFilePath.getName();
                Path dstFilePath = new Path(dst, fileName);
                if (file.isDir()) {
                    Utilities.renameOrMoveFiles(fs, srcFilePath, dstFilePath);
                    continue;
                }
                if (fs.exists(dstFilePath)) {
                    int suffix = 0;
                    while (fs.exists(dstFilePath = new Path(dst, fileName + "_" + ++suffix))) {
                    }
                }
                if (fs.rename(srcFilePath, dstFilePath)) continue;
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        }
    }

    public static String getTaskIdFromFilename(String filename) {
        return Utilities.getIdFromFilename(filename, FILE_NAME_TO_TASK_ID_REGEX);
    }

    public static String getPrefixedTaskIdFromFilename(String filename) {
        return Utilities.getIdFromFilename(filename, FILE_NAME_PREFIXED_TASK_ID_REGEX);
    }

    private static String getIdFromFilename(String filename, Pattern pattern) {
        Matcher m;
        String taskId = filename;
        int dirEnd = filename.lastIndexOf("/");
        if (dirEnd != -1) {
            taskId = filename.substring(dirEnd + 1);
        }
        if (!(m = pattern.matcher(taskId)).matches()) {
            LOG.warn((Object)("Unable to get task id from file name: " + filename + ". Using last component" + taskId + " as task id."));
        } else {
            taskId = m.group(1);
        }
        LOG.debug((Object)("TaskId for " + filename + " = " + taskId));
        return taskId;
    }

    public static String getFileNameFromDirName(String dirName) {
        int dirEnd = dirName.lastIndexOf("/");
        if (dirEnd != -1) {
            return dirName.substring(dirEnd + 1);
        }
        return dirName;
    }

    public static String replaceTaskIdFromFilename(String filename, int bucketNum) {
        return Utilities.replaceTaskIdFromFilename(filename, String.valueOf(bucketNum));
    }

    public static String replaceTaskIdFromFilename(String filename, String fileId) {
        String taskId = Utilities.getTaskIdFromFilename(filename);
        String newTaskId = Utilities.replaceTaskId(taskId, fileId);
        String ret = Utilities.replaceTaskIdFromFilename(filename, taskId, newTaskId);
        return ret;
    }

    private static String replaceTaskId(String taskId, int bucketNum) {
        return Utilities.replaceTaskId(taskId, String.valueOf(bucketNum));
    }

    private static String replaceTaskId(String taskId, String strBucketNum) {
        Matcher m = PREFIXED_TASK_ID_REGEX.matcher(strBucketNum);
        if (!m.matches()) {
            LOG.warn((Object)("Unable to determine bucket number from file ID: " + strBucketNum + ". Using " + "file ID as bucket number."));
            return Utilities.adjustBucketNumLen(strBucketNum, taskId);
        }
        String adjustedBucketNum = Utilities.adjustBucketNumLen(m.group(2), taskId);
        return (m.group(1) == null ? NSTR : m.group(1)) + adjustedBucketNum;
    }

    private static String adjustBucketNumLen(String bucketNum, String taskId) {
        int bucketNumLen = bucketNum.length();
        int taskIdLen = taskId.length();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < taskIdLen - bucketNumLen; ++i) {
            s.append("0");
        }
        return s.toString() + bucketNum;
    }

    private static String replaceTaskIdFromFilename(String filename, String oldTaskId, String newTaskId) {
        String[] spl = filename.split(oldTaskId);
        if (spl.length == 0 || spl.length == 1) {
            return filename.replaceAll(oldTaskId, newTaskId);
        }
        StringBuffer snew = new StringBuffer();
        for (int idx = 0; idx < spl.length - 1; ++idx) {
            if (idx > 0) {
                snew.append(oldTaskId);
            }
            snew.append(spl[idx]);
        }
        snew.append(newTaskId);
        snew.append(spl[spl.length - 1]);
        return snew.toString();
    }

    public static FileStatus[] getFileStatusRecurse(Path path, int level, FileSystem fs) throws IOException {
        StringBuilder sb = new StringBuilder(path.toUri().getPath());
        for (int i = 0; i < level; ++i) {
            sb.append("/").append("*");
        }
        Path pathPattern = new Path(path, sb.toString());
        return fs.globStatus(pathPattern);
    }

    public static void mvFileToFinalPath(String specPath, Configuration hconf, boolean success, Log log, DynamicPartitionCtx dpCtx, FileSinkDesc conf, Reporter reporter) throws IOException, HiveException {
        FileSystem fs = new Path(specPath).getFileSystem(hconf);
        Path tmpPath = Utilities.toTempPath(specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(specPath);
        Path intermediatePath = new Path(tmpPath.getParent(), tmpPath.getName() + ".intermediate");
        Path finalPath = new Path(specPath);
        if (success) {
            if (fs.exists(tmpPath)) {
                log.info((Object)("Moving tmp dir: " + tmpPath + " to: " + intermediatePath));
                Utilities.rename(fs, tmpPath, intermediatePath);
                ArrayList<String> emptyBuckets = Utilities.removeTempOrDuplicateFiles(fs, intermediatePath, dpCtx);
                if (emptyBuckets.size() > 0) {
                    Utilities.createEmptyBuckets(hconf, emptyBuckets, conf, reporter);
                }
                log.info((Object)("Moving tmp dir: " + intermediatePath + " to: " + finalPath));
                Utilities.renameOrMoveFiles(fs, intermediatePath, finalPath);
                if (fs.exists(intermediatePath)) {
                    fs.delete(intermediatePath, true);
                }
            }
        } else {
            fs.delete(tmpPath, true);
        }
        fs.delete(taskTmpPath, true);
    }

    private static void createEmptyBuckets(Configuration hconf, ArrayList<String> paths, FileSinkDesc conf, Reporter reporter) throws HiveException, IOException {
        JobConf jc = hconf instanceof JobConf ? new JobConf(hconf) : new JobConf(hconf, ExecDriver.class);
        HiveOutputFormat hiveOutputFormat = null;
        Class<? extends Writable> outputClass = null;
        boolean isCompressed = conf.getCompressed();
        TableDesc tableInfo = conf.getTableInfo();
        try {
            Serializer serializer = (Serializer)((Object)tableInfo.getDeserializerClass().newInstance());
            serializer.initialize(null, tableInfo.getProperties());
            outputClass = serializer.getSerializedClass();
            hiveOutputFormat = conf.getTableInfo().getOutputFileFormatClass().newInstance();
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        catch (InstantiationException e) {
            throw new HiveException(e);
        }
        catch (IllegalAccessException e) {
            throw new HiveException(e);
        }
        for (String p : paths) {
            Path path = new Path(p);
            FileSinkOperator.RecordWriter writer = HiveFileFormatUtils.getRecordWriter(jc, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), path, reporter);
            writer.close(false);
            LOG.info((Object)("created empty bucket for enforcing bucketing at " + path));
        }
    }

    public static void removeTempOrDuplicateFiles(FileSystem fs, Path path) throws IOException {
        Utilities.removeTempOrDuplicateFiles(fs, path, null);
    }

    public static ArrayList<String> removeTempOrDuplicateFiles(FileSystem fs, Path path, DynamicPartitionCtx dpCtx) throws IOException {
        if (path == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (dpCtx != null) {
            FileStatus[] parts = Utilities.getFileStatusRecurse(path, dpCtx.getNumDPCols(), fs);
            HashMap<String, FileStatus> taskIDToFile = null;
            for (int i = 0; i < parts.length; ++i) {
                assert (parts[i].isDir()) : "dynamic partition " + parts[i].getPath() + " is not a direcgtory";
                FileStatus[] items = fs.listStatus(parts[i].getPath());
                if (items.length == 0 && !fs.delete(parts[i].getPath(), true)) {
                    LOG.error((Object)("Cannot delete empty directory " + parts[i].getPath()));
                    throw new IOException("Cannot delete empty directory " + parts[i].getPath());
                }
                taskIDToFile = Utilities.removeTempOrDuplicateFiles(items, fs);
                if (dpCtx.getNumBuckets() <= 0 || taskIDToFile == null) continue;
                items = fs.listStatus(parts[i].getPath());
                String taskID1 = taskIDToFile.keySet().iterator().next();
                Path bucketPath = taskIDToFile.values().iterator().next().getPath();
                for (int j = 0; j < dpCtx.getNumBuckets(); ++j) {
                    String taskID2 = Utilities.replaceTaskId(taskID1, j);
                    if (taskIDToFile.containsKey(taskID2)) continue;
                    String path2 = Utilities.replaceTaskIdFromFilename(bucketPath.toUri().getPath().toString(), j);
                    result.add(path2);
                }
            }
        } else {
            FileStatus[] items = fs.listStatus(path);
            Utilities.removeTempOrDuplicateFiles(items, fs);
        }
        return result;
    }

    public static HashMap<String, FileStatus> removeTempOrDuplicateFiles(FileStatus[] items, FileSystem fs) throws IOException {
        if (items == null || fs == null) {
            return null;
        }
        HashMap<String, FileStatus> taskIdToFile = new HashMap<String, FileStatus>();
        for (FileStatus one : items) {
            if (Utilities.isTempPath(one)) {
                if (fs.delete(one.getPath(), true)) continue;
                throw new IOException("Unable to delete tmp file: " + one.getPath());
            }
            String taskId = Utilities.getPrefixedTaskIdFromFilename(one.getPath().getName());
            FileStatus otherFile = taskIdToFile.get(taskId);
            if (otherFile == null) {
                taskIdToFile.put(taskId, one);
                continue;
            }
            FileStatus toDelete = null;
            if (otherFile.getLen() >= one.getLen()) {
                toDelete = one;
            } else {
                toDelete = otherFile;
                taskIdToFile.put(taskId, one);
            }
            long len1 = toDelete.getLen();
            long len2 = taskIdToFile.get(taskId).getLen();
            if (!fs.delete(toDelete.getPath(), true)) {
                throw new IOException("Unable to delete duplicate file: " + toDelete.getPath() + ". Existing file: " + taskIdToFile.get(taskId).getPath());
            }
            LOG.warn((Object)("Duplicate taskid file removed: " + toDelete.getPath() + " with length " + len1 + ". Existing file: " + taskIdToFile.get(taskId).getPath() + " with length " + len2));
        }
        return taskIdToFile;
    }

    public static String getNameMessage(Exception e) {
        return e.getClass().getName() + "(" + e.getMessage() + ")";
    }

    public static String getResourceFiles(Configuration conf, SessionState.ResourceType t) {
        Set<String> files;
        SessionState ss = SessionState.get();
        Set<String> set = files = ss == null ? null : ss.list_resource(t, null);
        if (files != null) {
            ArrayList<String> realFiles = new ArrayList<String>(files.size());
            for (String one : files) {
                try {
                    realFiles.add(Utilities.realFile(one, conf));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot validate file " + one + "due to exception: " + e.getMessage(), e);
                }
            }
            return StringUtils.join(realFiles, ",");
        }
        return NSTR;
    }

    public static ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        URLClassLoader loader = (URLClassLoader)cloader;
        java.util.List<URL> curPath = Arrays.asList(loader.getURLs());
        ArrayList<URL> newPath = new ArrayList<URL>();
        for (URL onePath : curPath) {
            newPath.add(onePath);
        }
        curPath = newPath;
        for (String onestr : newPaths) {
            URL oneurl;
            if (StringUtils.indexOf(onestr, "file://") == 0) {
                onestr = StringUtils.substring(onestr, 7);
            }
            if (curPath.contains(oneurl = new File(onestr).toURL())) continue;
            curPath.add(oneurl);
        }
        return new URLClassLoader(curPath.toArray(new URL[0]), (ClassLoader)loader);
    }

    public static void removeFromClassPath(String[] pathsToRemove) throws Exception {
        Thread curThread = Thread.currentThread();
        URLClassLoader loader = (URLClassLoader)curThread.getContextClassLoader();
        HashSet<URL> newPath = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        for (String onestr : pathsToRemove) {
            if (StringUtils.indexOf(onestr, "file://") == 0) {
                onestr = StringUtils.substring(onestr, 7);
            }
            URL oneurl = new File(onestr).toURL();
            newPath.remove(oneurl);
        }
        loader = new URLClassLoader(newPath.toArray(new URL[0]));
        curThread.setContextClassLoader(loader);
        SessionState.get().getConf().setClassLoader(loader);
    }

    public static String formatBinaryString(byte[] array, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            sb.append("x");
            sb.append(array[i] < 0 ? array[i] + 256 : array[i] + 0);
        }
        return sb.toString();
    }

    public static java.util.List<String> getColumnNamesFromSortCols(java.util.List<Order> sortCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (Order o : sortCols) {
            names.add(o.getCol());
        }
        return names;
    }

    public static java.util.List<String> getColumnNamesFromFieldSchema(java.util.List<FieldSchema> partCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (FieldSchema o : partCols) {
            names.add(o.getName());
        }
        return names;
    }

    public static java.util.List<String> getColumnNames(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns");
        String[] cols = colNames.trim().split(",");
        if (cols != null) {
            for (String col : cols) {
                if (col == null || col.trim().equals(NSTR)) continue;
                names.add(col);
            }
        }
        return names;
    }

    public static java.util.List<String> getColumnTypes(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns.types");
        String[] cols = colNames.trim().split(",");
        if (cols != null) {
            for (String col : cols) {
                if (col == null || col.trim().equals(NSTR)) continue;
                names.add(col);
            }
        }
        return names;
    }

    public static void validateColumnNames(java.util.List<String> colNames, java.util.List<String> checkCols) throws SemanticException {
        for (String toCheck : checkCols) {
            boolean found = false;
            for (String colName : colNames) {
                if (!toCheck.equalsIgnoreCase(colName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
        }
    }

    public static int getDefaultNotificationInterval(Configuration hconf) {
        Integer expInterval = Integer.decode(hconf.get("mapred.tasktracker.expiry.interval"));
        int notificationInterval = expInterval != null ? expInterval / 2 : 300000;
        return notificationInterval;
    }

    public static void copyTableJobPropertiesToConf(TableDesc tbl, JobConf job) {
        Map<String, String> jobProperties = tbl.getJobProperties();
        if (jobProperties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
            job.set(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSummary getInputSummary(Context ctx, MapredWork work, PathFilter filter) throws IOException {
        long[] summary = new long[]{0L, 0L, 0L};
        ArrayList<String> pathNeedProcess = new ArrayList<String>();
        Object object = getInputSummaryLock;
        synchronized (object) {
            ContentSummary contentSummary;
            ThreadPoolExecutor executor;
            for (String path : work.getPathToAliases().keySet()) {
                Path p = new Path(path);
                if (filter != null && !filter.accept(p)) continue;
                ContentSummary cs = ctx.getCS(path);
                if (cs == null) {
                    if (path == null) continue;
                    pathNeedProcess.add(path);
                    continue;
                }
                summary[0] = summary[0] + cs.getLength();
                summary[1] = summary[1] + cs.getFileCount();
                summary[2] = summary[2] + cs.getDirectoryCount();
            }
            final ConcurrentHashMap resultMap = new ConcurrentHashMap();
            ArrayList results = new ArrayList();
            int maxThreads = ctx.getConf().getInt("mapred.dfsclient.parallelism.max", 0);
            if (pathNeedProcess.size() > 1 && maxThreads > 1) {
                int numExecutors = Math.min(pathNeedProcess.size(), maxThreads);
                LOG.info((Object)("Using " + numExecutors + " threads for getContentSummary"));
                executor = new ThreadPoolExecutor(numExecutors, numExecutors, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            } else {
                executor = null;
            }
            HiveInterruptCallback interrup = HiveInterruptUtils.add(new HiveInterruptCallback(){

                @Override
                public void interrupt() {
                    if (executor != null) {
                        executor.shutdownNow();
                    }
                }
            });
            try {
                Configuration conf = ctx.getConf();
                JobConf jobConf = new JobConf(conf);
                for (String string : pathNeedProcess) {
                    final Path p = new Path(string);
                    final String pathStr = string;
                    final Configuration myConf = conf;
                    final JobConf myJobConf = jobConf;
                    final PartitionDesc partDesc = work.getPathToPartitionInfo().get(p.toString());
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ContentSummary resultCs;
                                Class<? extends InputFormat> inputFormatCls = partDesc.getInputFileFormatClass();
                                InputFormat<WritableComparable, Writable> inputFormatObj = HiveInputFormat.getInputFormatFromCache(inputFormatCls, myJobConf);
                                if (inputFormatObj instanceof ContentSummaryInputFormat) {
                                    resultCs = ((ContentSummaryInputFormat)inputFormatObj).getContentSummary(p, myJobConf);
                                } else {
                                    FileSystem fs = p.getFileSystem(myConf);
                                    resultCs = fs.getContentSummary(p);
                                }
                                resultMap.put(pathStr, resultCs);
                            }
                            catch (IOException e) {
                                LOG.info((Object)("Cannot get size of " + pathStr + ". Safely ignored."));
                            }
                        }
                    };
                    if (executor == null) {
                        r.run();
                        continue;
                    }
                    Future<?> result = executor.submit(r);
                    results.add(result);
                }
                if (executor != null) {
                    block11: for (Future future : results) {
                        boolean executorDone = false;
                        do {
                            try {
                                future.get();
                                executorDone = true;
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)"Interrupted when waiting threads: ", (Throwable)e);
                                Thread.currentThread().interrupt();
                                continue block11;
                            }
                            catch (ExecutionException e) {
                                throw new IOException(e);
                            }
                        } while (!executorDone);
                    }
                    executor.shutdown();
                }
                HiveInterruptUtils.checkInterrupted();
                for (Map.Entry entry : resultMap.entrySet()) {
                    ContentSummary cs = (ContentSummary)entry.getValue();
                    summary[0] = summary[0] + cs.getLength();
                    summary[1] = summary[1] + cs.getFileCount();
                    summary[2] = summary[2] + cs.getDirectoryCount();
                    ctx.addCS((String)entry.getKey(), cs);
                    LOG.info((Object)("Cache Content Summary for " + (String)entry.getKey() + " length: " + cs.getLength() + " file count: " + cs.getFileCount() + " directory count: " + cs.getDirectoryCount()));
                }
                contentSummary = new ContentSummary(summary[0], summary[1], summary[2]);
            }
            catch (Throwable throwable) {
                HiveInterruptUtils.remove(interrup);
                throw throwable;
            }
            HiveInterruptUtils.remove(interrup);
            return contentSummary;
        }
    }

    public static boolean isEmptyPath(JobConf job, String dirPath, Context ctx) throws Exception {
        ContentSummary cs = ctx.getCS(dirPath);
        if (cs != null) {
            LOG.info((Object)("Content Summary " + dirPath + "length: " + cs.getLength() + " num files: " + cs.getFileCount() + " num directories: " + cs.getDirectoryCount()));
            return cs.getLength() == 0L && cs.getFileCount() == 0L && cs.getDirectoryCount() <= 1L;
        }
        LOG.info((Object)("Content Summary not cached for " + dirPath));
        Path p = new Path(dirPath);
        return Utilities.isEmptyPath(job, p);
    }

    public static boolean isEmptyPath(JobConf job, Path dirPath) throws Exception {
        FileStatus[] fStats;
        FileSystem inpFs = dirPath.getFileSystem((Configuration)job);
        return !inpFs.exists(dirPath) || (fStats = inpFs.listStatus(dirPath)).length <= 0;
    }

    public static java.util.List<ExecDriver> getMRTasks(java.util.List<Task<? extends Serializable>> tasks) {
        ArrayList<ExecDriver> mrTasks = new ArrayList<ExecDriver>();
        if (tasks != null) {
            Utilities.getMRTasks(tasks, mrTasks);
        }
        return mrTasks;
    }

    private static void getMRTasks(java.util.List<Task<? extends Serializable>> tasks, java.util.List<ExecDriver> mrTasks) {
        for (Task<? extends Serializable> task : tasks) {
            if (task instanceof ExecDriver && !mrTasks.contains((ExecDriver)task)) {
                mrTasks.add((ExecDriver)task);
            }
            if (task.getDependentTasks() == null) continue;
            Utilities.getMRTasks(task.getDependentTasks(), mrTasks);
        }
    }

    public static java.util.List<LinkedHashMap<String, String>> getFullDPSpecs(Configuration conf, DynamicPartitionCtx dpCtx) throws HiveException {
        try {
            Path loadPath = new Path(dpCtx.getRootPath());
            FileSystem fs = loadPath.getFileSystem(conf);
            int numDPCols = dpCtx.getNumDPCols();
            FileStatus[] status = Utilities.getFileStatusRecurse(loadPath, numDPCols, fs);
            if (status.length == 0) {
                LOG.warn((Object)"No partition is generated by dynamic partitioning");
                return null;
            }
            Map<String, String> partSpec = dpCtx.getPartSpec();
            ArrayList<LinkedHashMap<String, String>> fullPartSpecs = new ArrayList<LinkedHashMap<String, String>>();
            for (int i = 0; i < status.length; ++i) {
                Path partPath = status[i].getPath();
                assert (fs.getFileStatus(partPath).isDir()) : "partitions " + partPath + " is not a directory !";
                LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(partSpec);
                Warehouse.makeSpecFromName(fullPartSpec, (Path)partPath);
                fullPartSpecs.add(fullPartSpec);
            }
            return fullPartSpecs;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public static StatsPublisher getStatsPublisher(JobConf jc) {
        String statsImplementationClass = HiveConf.getVar((Configuration)jc, HiveConf.ConfVars.HIVESTATSDBCLASS);
        if (StatsFactory.setImplementation(statsImplementationClass, (Configuration)jc)) {
            return StatsFactory.getStatsPublisher();
        }
        return null;
    }

    public static String getHashedStatsPrefix(String statsPrefix, int maxPrefixLength) {
        String ret = statsPrefix;
        if (maxPrefixLength >= 0 && statsPrefix.length() > maxPrefixLength) {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                digester.update(statsPrefix.getBytes());
                ret = new String(digester.digest()) + "/";
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    public static void setColumnNameList(JobConf jobConf, Operator op) {
        RowSchema rowSchema = op.getSchema();
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnNames = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (columnNames.length() > 0) {
                columnNames.append(",");
            }
            columnNames.append(colInfo.getInternalName());
        }
        String columnNamesString = columnNames.toString();
        jobConf.set("columns", columnNamesString);
    }

    public static void setColumnTypeList(JobConf jobConf, Operator op) {
        RowSchema rowSchema = op.getSchema();
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnTypes = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (columnTypes.length() > 0) {
                columnTypes.append(",");
            }
            columnTypes.append(colInfo.getType().getTypeName());
        }
        String columnTypesString = columnTypes.toString();
        jobConf.set("columns.types", columnTypesString);
    }

    public static void validatePartSpec(Table tbl, Map<String, String> partSpec) throws SemanticException {
        java.util.List<FieldSchema> parts = tbl.getPartitionKeys();
        HashSet<String> partCols = new HashSet<String>(parts.size());
        for (FieldSchema fieldSchema : parts) {
            partCols.add(fieldSchema.getName());
        }
        for (String string : partSpec.keySet()) {
            if (partCols.contains(string)) continue;
            throw new SemanticException(ErrorMsg.NONEXISTPARTCOL.getMsg(string));
        }
    }

    public static String generatePath(String baseURI, String dumpFilePrefix, Byte tag, String bigBucketFileName) {
        String path = new String(baseURI + "/" + "MapJoin-" + dumpFilePrefix + tag + "-" + bigBucketFileName + suffix);
        return path;
    }

    public static String generateFileName(Byte tag, String bigBucketFileName) {
        String fileName = new String("MapJoin-" + tag + "-" + bigBucketFileName + suffix);
        return fileName;
    }

    public static String generateTmpURI(String baseURI, String id) {
        String tmpFileURI = new String(baseURI + "/" + "HashTable-" + id);
        return tmpFileURI;
    }

    public static String generateTarURI(String baseURI, String filename) {
        String tmpFileURI = new String(baseURI + "/" + filename + ".tar.gz");
        return tmpFileURI;
    }

    public static String generateTarURI(Path baseURI, String filename) {
        String tmpFileURI = new String(baseURI + "/" + filename + ".tar.gz");
        return tmpFileURI;
    }

    public static String generateTarFileName(String name) {
        String tmpFileURI = new String(name + ".tar.gz");
        return tmpFileURI;
    }

    public static String generatePath(Path baseURI, String filename) {
        String path = new String(baseURI + "/" + filename);
        return path;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return sdf.format(cal.getTime());
    }

    public static double showTime(long time) {
        double result = (double)time / 1000.0;
        return result;
    }

    private static boolean supportedJDOFuncs(GenericUDF func) {
        return func instanceof GenericUDFOPEqual || func instanceof GenericUDFOPAnd || func instanceof GenericUDFOPOr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkJDOPushDown(Table tab, ExprNodeDesc expr) {
        if (expr instanceof ExprNodeConstantDesc) {
            Object value = ((ExprNodeConstantDesc)expr).getValue();
            if (!(value instanceof String)) return "Constant " + value + " is not string type";
            return null;
        }
        if (expr instanceof ExprNodeColumnDesc) {
            TypeInfo type = expr.getTypeInfo();
            if (!type.getTypeName().equals("string")) return "Column " + expr.getExprString() + " is not string type";
            String colName = ((ExprNodeColumnDesc)expr).getColumn();
            for (FieldSchema fs : tab.getPartCols()) {
                if (!fs.getName().equals(colName)) continue;
                if (!fs.getType().equals("string")) return "Partition column " + fs.getName() + " is not string type";
                return null;
            }
            assert (false);
            return "Expression " + expr.getExprString() + " cannot be evaluated";
        }
        if (!(expr instanceof ExprNodeGenericFuncDesc)) return "Expression " + expr.getExprString() + " cannot be evaluated";
        ExprNodeGenericFuncDesc funcDesc = (ExprNodeGenericFuncDesc)expr;
        GenericUDF func = funcDesc.getGenericUDF();
        if (!Utilities.supportedJDOFuncs(func)) {
            return "Expression " + expr.getExprString() + " cannot be evaluated";
        }
        boolean allChildrenConstant = true;
        java.util.List<ExprNodeDesc> children = funcDesc.getChildExprs();
        for (ExprNodeDesc child : children) {
            String message;
            if (!(child instanceof ExprNodeConstantDesc)) {
                allChildrenConstant = false;
            }
            if ((message = Utilities.checkJDOPushDown(tab, child)) == null) continue;
            return message;
        }
        if (!allChildrenConstant) return null;
        return "Expression " + expr.getExprString() + " has only constants as children.";
    }

    public static void reworkMapRedWork(Task<? extends Serializable> task, boolean reworkMapredWork, HiveConf conf) throws SemanticException {
        if (reworkMapredWork && task instanceof MapRedTask) {
            try {
                MapredWork mapredWork = (MapredWork)((MapRedTask)task).getWork();
                HashSet<Class<? extends InputFormat>> reworkInputFormats = new HashSet<Class<? extends InputFormat>>();
                for (PartitionDesc partitionDesc : mapredWork.getPathToPartitionInfo().values()) {
                    Class<? extends InputFormat> inputFormatCls = partitionDesc.getInputFileFormatClass();
                    if (!ReworkMapredInputFormat.class.isAssignableFrom(inputFormatCls)) continue;
                    reworkInputFormats.add(inputFormatCls);
                }
                if (reworkInputFormats.size() > 0) {
                    for (Class clazz : reworkInputFormats) {
                        ReworkMapredInputFormat inst = (ReworkMapredInputFormat)ReflectionUtils.newInstance((Class)clazz, null);
                        inst.rework(conf, mapredWork);
                    }
                }
            }
            catch (IOException e) {
                throw new SemanticException(e);
            }
        }
    }

    public static <T> T executeWithRetry(SQLCommand<T> cmd, PreparedStatement stmt, int baseWindow, int maxRetries) throws SQLException {
        Random r = new Random();
        T result = null;
        int failures = 0;
        while (true) {
            try {
                result = cmd.run(stmt);
                return result;
            }
            catch (SQLTransientException e) {
                LOG.warn((Object)("Failure and retry #" + failures + " with exception " + e.getMessage()));
                if (failures >= maxRetries) {
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(baseWindow, failures, r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException iex) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static Connection connectWithRetry(String connectionString, int waitWindow, int maxRetries) throws SQLException {
        Random r = new Random();
        int failures = 0;
        while (true) {
            try {
                Connection conn = DriverManager.getConnection(connectionString);
                return conn;
            }
            catch (SQLTransientException e) {
                if (failures >= maxRetries) {
                    LOG.error((Object)("Error during JDBC connection. " + e));
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(waitWindow, failures, r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static PreparedStatement prepareWithRetry(Connection conn, String stmt, int waitWindow, int maxRetries) throws SQLException {
        Random r = new Random();
        int failures = 0;
        while (true) {
            try {
                return conn.prepareStatement(stmt);
            }
            catch (SQLTransientException e) {
                if (failures >= maxRetries) {
                    LOG.error((Object)("Error preparing JDBC Statement " + stmt + " :" + e));
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(waitWindow, failures, r);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static long getRandomWaitTime(int baseWindow, int failures, Random r) {
        return (long)((double)(baseWindow * failures) + (double)(baseWindow * (failures + 1)) * r.nextDouble());
    }

    public static String escapeSqlLike(String key) {
        StringBuffer sb = new StringBuffer(key.length());
        for (char c : key.toCharArray()) {
            switch (c) {
                case '%': 
                case '\\': 
                case '_': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String formatMsecToStr(long msec) {
        long day = -1L;
        long hour = -1L;
        long minute = -1L;
        long second = -1L;
        long ms = msec % 1000L;
        long timeLeft = msec / 1000L;
        if (timeLeft > 0L) {
            second = timeLeft % 60L;
            if ((timeLeft /= 60L) > 0L) {
                minute = timeLeft % 60L;
                if ((timeLeft /= 60L) > 0L) {
                    hour = timeLeft % 24L;
                    day = timeLeft / 24L;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (day != -1L) {
            sb.append(day + " days ");
        }
        if (hour != -1L) {
            sb.append(hour + " hours ");
        }
        if (minute != -1L) {
            sb.append(minute + " minutes ");
        }
        if (second != -1L) {
            sb.append(second + " seconds ");
        }
        sb.append(ms + " msec");
        return sb.toString();
    }

    public static class SQLCommand<T> {
        public T run(PreparedStatement stmt) throws SQLException {
            return null;
        }
    }

    public static enum StreamStatus {
        EOF,
        TERMINATED;

    }

    public static class StreamPrinter
    extends Thread {
        InputStream is;
        String type;
        PrintStream os;

        public StreamPrinter(InputStream is, String type, PrintStream os) {
            this.is = is;
            this.type = type;
            this.os = os;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = null;
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                br = new BufferedReader(isr);
                String line = null;
                if (this.type != null) {
                    while ((line = br.readLine()) != null) {
                        this.os.println(this.type + ">" + line);
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        this.os.println(line);
                    }
                }
                br.close();
                br = null;
                IOUtils.closeStream((Closeable)br);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                IOUtils.closeStream(br);
            }
        }
    }

    public static class CollectionPersistenceDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", null);
        }

        protected void initialize(Class type, Object oldInstance, Object newInstance, Encoder out) {
            Iterator ite = ((Collection)oldInstance).iterator();
            while (ite.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{ite.next()}));
            }
        }
    }

    public static class CommonTokenDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            CommonToken ct = (CommonToken)oldInstance;
            Object[] args = new Object[]{ct.getType(), ct.getText()};
            return new Expression(ct, ct.getClass(), "new", args);
        }
    }

    public static class TimestampPersistenceDelegate
    extends DatePersistenceDelegate {
        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Timestamp ts = (Timestamp)oldInstance;
            Object[] args = new Object[]{ts.getNanos()};
            Statement stmt = new Statement(oldInstance, "setNanos", args);
            out.writeStatement(stmt);
        }
    }

    public static class DatePersistenceDelegate
    extends PersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Date dateVal = (Date)oldInstance;
            Object[] args = new Object[]{dateVal.getTime()};
            return new Expression(dateVal, dateVal.getClass(), "new", args);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            if (oldInstance == null || newInstance == null) {
                return false;
            }
            return oldInstance.getClass() == newInstance.getClass();
        }
    }

    public static class ListDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            java.util.List oldList = (java.util.List)oldInstance;
            ArrayList newList = new ArrayList(oldList);
            return new Expression(newList, ArrayList.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class SetDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Set oldSet = (Set)oldInstance;
            HashSet newSet = new HashSet(oldSet);
            return new Expression(newSet, HashSet.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class MapDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Map oldMap = (Map)oldInstance;
            HashMap newMap = new HashMap(oldMap);
            return new Expression(newMap, HashMap.class, "new", new Object[0]);
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return false;
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                out.writeStatement(new Statement(oldInstance, "clear", new Object[0]));
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                out.writeStatement(new Statement(oldInstance, "add", new Object[]{i.next()}));
            }
        }
    }

    public static class EnumDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(Enum.class, "valueOf", new Object[]{oldInstance.getClass(), ((Enum)oldInstance).name()});
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }
    }

    public static enum ReduceField {
        KEY,
        VALUE,
        ALIAS;

    }
}

