/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class DelegatedStructObjectInspector
extends StructObjectInspector {
    private StructObjectInspector delegate;
    private List<DelegatedStructField> fields;

    public DelegatedStructObjectInspector(StructObjectInspector delegate) {
        this.delegate = delegate;
    }

    public void reset(StructObjectInspector current) {
        this.delegate = current;
        if (this.fields != null) {
            int index = 0;
            List<? extends StructField> newFields = this.delegate.getAllStructFieldRefs();
            for (DelegatedStructField field : this.fields) {
                field.field = newFields.get(index++);
            }
        }
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        if (this.fields != null || this.delegate.getAllStructFieldRefs() == null) {
            return this.fields;
        }
        List<? extends StructField> fields = this.delegate.getAllStructFieldRefs();
        ArrayList<DelegatedStructField> delegate = new ArrayList<DelegatedStructField>(fields.size());
        for (StructField structField : fields) {
            delegate.add(new DelegatedStructField(structField));
        }
        this.fields = delegate;
        return this.fields;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        StructField field = this.delegate.getStructFieldRef(fieldName);
        return field == null ? null : new DelegatedStructField(field);
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        return this.delegate.getStructFieldData(data, ((DelegatedStructField)fieldRef).field);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        return this.delegate.getStructFieldsDataAsList(data);
    }

    @Override
    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return this.delegate.getCategory();
    }

    private static class DelegatedStructField
    implements StructField {
        private StructField field;

        public DelegatedStructField(StructField field) {
            this.field = field;
        }

        @Override
        public String getFieldName() {
            return this.field.getFieldName();
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.field.getFieldObjectInspector();
        }

        @Override
        public String getFieldComment() {
            return this.field.getFieldComment();
        }
    }
}

