/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class OperatorUtils {
    public static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperator(start, clazz, new HashSet());
    }

    public static <T> Set<T> findOperators(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            OperatorUtils.findOperator(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperator(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                OperatorUtils.findOperator(child, clazz, found);
            }
        }
        return found;
    }
}

