/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="in_file", value="_FUNC_(str, filename) - Returns true if str appears in the file")
public class GenericUDFInFile
extends GenericUDF {
    HashSet<String> set;
    ObjectInspector strObjectInspector;
    ObjectInspector fileObjectInspector;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("IN_FILE() accepts exactly 2 arguments.");
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (String.class.equals(PrimitiveObjectInspectorUtils.getJavaPrimitiveClassFromObjectInspector(arguments[i]))) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of function IN_FILE must be a string but " + arguments[i].toString() + " was given.");
        }
        this.strObjectInspector = arguments[0];
        this.fileObjectInspector = arguments[1];
        if (!ObjectInspectorUtils.isConstantObjectInspector(this.fileObjectInspector)) {
            throw new UDFArgumentTypeException(1, "The second argument of IN_FILE() must be a constant string but " + this.fileObjectInspector.toString() + " was given.");
        }
        return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
    }

    @Override
    public String[] getRequiredFiles() {
        return new String[]{ObjectInspectorUtils.getWritableConstantValue(this.fileObjectInspector).toString()};
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        String str = (String)ObjectInspectorUtils.copyToStandardJavaObject(arguments[0].get(), this.strObjectInspector);
        if (this.set == null) {
            String fileName = (String)ObjectInspectorUtils.copyToStandardJavaObject(arguments[1].get(), this.fileObjectInspector);
            try {
                this.load(new FileInputStream(new File(fileName).getName()));
            }
            catch (FileNotFoundException e) {
                throw new HiveException(e);
            }
        }
        return this.set.contains(str);
    }

    public void load(InputStream is) throws HiveException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.set = new HashSet();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.set.add(line);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return "in_file(" + children[0] + ", " + children[1] + ")";
    }
}

