/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

@Explain(displayName="Group By Operator")
public class GroupByDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private Mode mode;
    private boolean groupKeyNotReductionKey;
    private boolean bucketGroup;
    private ArrayList<ExprNodeDesc> keys;
    private List<Integer> listGroupingSets;
    private boolean groupingSetsPresent;
    private int groupingSetPosition;
    private ArrayList<AggregationDesc> aggregators;
    private ArrayList<String> outputColumnNames;
    private float groupByMemoryUsage;
    private float memoryThreshold;
    private transient boolean isDistinct;

    public GroupByDesc() {
    }

    public GroupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<ExprNodeDesc> keys, ArrayList<AggregationDesc> aggregators, boolean groupKeyNotReductionKey, float groupByMemoryUsage, float memoryThreshold, List<Integer> listGroupingSets, boolean groupingSetsPresent, int groupingSetsPosition, boolean isDistinct) {
        this(mode, outputColumnNames, keys, aggregators, groupKeyNotReductionKey, false, groupByMemoryUsage, memoryThreshold, listGroupingSets, groupingSetsPresent, groupingSetsPosition, isDistinct);
    }

    public GroupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<ExprNodeDesc> keys, ArrayList<AggregationDesc> aggregators, boolean groupKeyNotReductionKey, boolean bucketGroup, float groupByMemoryUsage, float memoryThreshold, List<Integer> listGroupingSets, boolean groupingSetsPresent, int groupingSetsPosition, boolean isDistinct) {
        this.mode = mode;
        this.outputColumnNames = outputColumnNames;
        this.keys = keys;
        this.aggregators = aggregators;
        this.groupKeyNotReductionKey = groupKeyNotReductionKey;
        this.bucketGroup = bucketGroup;
        this.groupByMemoryUsage = groupByMemoryUsage;
        this.memoryThreshold = memoryThreshold;
        this.listGroupingSets = listGroupingSets;
        this.groupingSetsPresent = groupingSetsPresent;
        this.groupingSetPosition = groupingSetsPosition;
        this.isDistinct = isDistinct;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Explain(displayName="mode")
    public String getModeString() {
        switch (this.mode) {
            case COMPLETE: {
                return "complete";
            }
            case PARTIAL1: {
                return "partial1";
            }
            case PARTIAL2: {
                return "partial2";
            }
            case PARTIALS: {
                return "partials";
            }
            case HASH: {
                return "hash";
            }
            case FINAL: {
                return "final";
            }
            case MERGEPARTIAL: {
                return "mergepartial";
            }
        }
        return "unknown";
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Explain(displayName="keys")
    public ArrayList<ExprNodeDesc> getKeys() {
        return this.keys;
    }

    public void setKeys(ArrayList<ExprNodeDesc> keys) {
        this.keys = keys;
    }

    @Explain(displayName="outputColumnNames")
    public ArrayList<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(ArrayList<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public float getGroupByMemoryUsage() {
        return this.groupByMemoryUsage;
    }

    public void setGroupByMemoryUsage(float groupByMemoryUsage) {
        this.groupByMemoryUsage = groupByMemoryUsage;
    }

    public float getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(float memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @Explain(displayName="aggregations")
    public ArrayList<AggregationDesc> getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(ArrayList<AggregationDesc> aggregators) {
        this.aggregators = aggregators;
    }

    public boolean getGroupKeyNotReductionKey() {
        return this.groupKeyNotReductionKey;
    }

    public void setGroupKeyNotReductionKey(boolean groupKeyNotReductionKey) {
        this.groupKeyNotReductionKey = groupKeyNotReductionKey;
    }

    @Explain(displayName="bucketGroup")
    public boolean getBucketGroup() {
        return this.bucketGroup;
    }

    public void setBucketGroup(boolean bucketGroup) {
        this.bucketGroup = bucketGroup;
    }

    public boolean isDistinctLike() {
        ArrayList<AggregationDesc> aggregators = this.getAggregators();
        for (AggregationDesc ad : aggregators) {
            GenericUDAFEvaluator udafEval;
            UDFType annot;
            if (ad.getDistinct() || (annot = (udafEval = ad.getGenericUDAFEvaluator()).getClass().getAnnotation(UDFType.class)) != null && annot.distinctLike()) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getListGroupingSets() {
        return this.listGroupingSets;
    }

    public void setListGroupingSets(List<Integer> listGroupingSets) {
        this.listGroupingSets = listGroupingSets;
    }

    public boolean isGroupingSetsPresent() {
        return this.groupingSetsPresent;
    }

    public void setGroupingSetsPresent(boolean groupingSetsPresent) {
        this.groupingSetsPresent = groupingSetsPresent;
    }

    public int getGroupingSetPosition() {
        return this.groupingSetPosition;
    }

    public void setGroupingSetPosition(int groupingSetPosition) {
        this.groupingSetPosition = groupingSetPosition;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public static enum Mode {
        COMPLETE,
        PARTIAL1,
        PARTIAL2,
        PARTIALS,
        FINAL,
        HASH,
        MERGEPARTIAL;

    }
}

