/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.util.ObjectPair;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.hadoop.util.ReflectionUtils;

public class SMBMapJoinOperator
extends AbstractMapJoinOperator<SMBJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)SMBMapJoinOperator.class.getName());
    private MapredLocalWork localWork = null;
    private Map<String, MergeQueue> aliasToMergeQueue = Collections.emptyMap();
    transient ArrayList<Object>[] keyWritables;
    transient ArrayList<Object>[] nextKeyWritables;
    RowContainer<ArrayList<Object>>[] nextGroupStorage;
    RowContainer<ArrayList<Object>>[] candidateStorage;
    transient Map<Byte, String> tagToAlias;
    private transient boolean[] fetchDone;
    private transient boolean[] foundNextKeyGroup;
    transient boolean firstFetchHappened = false;
    private transient boolean inputFileChanged = false;
    transient boolean localWorkInited = false;
    transient boolean closeCalled = false;

    public SMBMapJoinOperator() {
    }

    public SMBMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mapJoinOp) {
        super(mapJoinOp);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.firstRow = true;
        this.closeCalled = false;
        this.firstFetchHappened = false;
        this.inputFileChanged = false;
        byte maxAlias = 0;
        for (Byte alias : this.order) {
            if (alias <= maxAlias) continue;
            maxAlias = alias;
        }
        this.nextGroupStorage = new RowContainer[++maxAlias];
        this.candidateStorage = new RowContainer[maxAlias];
        this.keyWritables = new ArrayList[maxAlias];
        this.nextKeyWritables = new ArrayList[maxAlias];
        this.fetchDone = new boolean[maxAlias];
        this.foundNextKeyGroup = new boolean[maxAlias];
        int bucketSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
        byte storePos = 0;
        for (Byte alias : this.order) {
            RowContainer candidateRC;
            RowContainer rc;
            this.nextGroupStorage[storePos] = rc = JoinUtil.getRowContainer(hconf, (List)this.rowContainerStandardObjectInspectors.get(storePos), alias, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(storePos), this.reporter);
            this.candidateStorage[alias.byteValue()] = candidateRC = JoinUtil.getRowContainer(hconf, (List)this.rowContainerStandardObjectInspectors.get(storePos), alias, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(storePos), this.reporter);
            storePos = (byte)(storePos + 1);
        }
        this.tagToAlias = ((SMBJoinDesc)this.conf).getTagToAlias();
        for (Byte alias : this.order) {
            if (alias != (byte)this.posBigTable) {
                this.fetchDone[alias.byteValue()] = false;
            }
            this.foundNextKeyGroup[alias.byteValue()] = false;
        }
    }

    @Override
    public void initializeLocalWork(Configuration hconf) throws HiveException {
        this.initializeMapredLocalWork((MapJoinDesc)this.getConf(), hconf, ((SMBJoinDesc)this.getConf()).getLocalWork(), LOG);
        super.initializeLocalWork(hconf);
    }

    public void initializeMapredLocalWork(MapJoinDesc conf, Configuration hconf, MapredLocalWork localWork, Log l4j) throws HiveException {
        if (localWork == null || this.localWorkInited) {
            return;
        }
        this.localWorkInited = true;
        this.localWork = localWork;
        this.aliasToMergeQueue = new HashMap<String, MergeQueue>();
        LinkedHashMap<String, FetchWork> aliasToFetchWork = localWork.getAliasToFetchWork();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = localWork.getAliasToWork();
        for (Map.Entry entry : aliasToFetchWork.entrySet()) {
            String alias = (String)entry.getKey();
            FetchWork fetchWork = (FetchWork)entry.getValue();
            Operator forwardOp = (Operator)aliasToWork.get(alias);
            forwardOp.setExecContext(this.getExecContext());
            JobConf jobClone = this.cloneJobConf(hconf, forwardOp);
            FetchOperator fetchOp = new FetchOperator(fetchWork, jobClone);
            forwardOp.initialize((Configuration)jobClone, new ObjectInspector[]{fetchOp.getOutputObjectInspector()});
            fetchOp.clearFetchContext();
            MergeQueue mergeQueue = new MergeQueue(alias, fetchWork, jobClone);
            this.aliasToMergeQueue.put(alias, mergeQueue);
            l4j.info((Object)("fetch operators for " + alias + " initialized"));
        }
    }

    private JobConf cloneJobConf(Configuration hconf, Operator<?> op) {
        JobConf jobClone = new JobConf(hconf);
        if (op instanceof TableScanOperator) {
            ArrayList<Integer> list = ((TableScanOperator)op).getNeededColumnIDs();
            if (list != null) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobClone, list);
            }
        } else {
            ColumnProjectionUtils.setFullyReadColumns((Configuration)jobClone);
        }
        return jobClone;
    }

    private byte tagForAlias(String alias) {
        for (Map.Entry<Byte, String> entry : this.tagToAlias.entrySet()) {
            if (!entry.getValue().equals(alias)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.inputFileChanged = true;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (tag == this.posBigTable && this.inputFileChanged) {
            if (this.firstFetchHappened) {
                this.joinFinalLeftData();
            }
            for (Map.Entry<String, MergeQueue> entry : this.aliasToMergeQueue.entrySet()) {
                String alias = entry.getKey();
                MergeQueue mergeQueue = entry.getValue();
                this.setUpFetchContexts(alias, mergeQueue);
            }
            this.firstFetchHappened = false;
            this.inputFileChanged = false;
        }
        if (!this.firstFetchHappened) {
            this.firstFetchHappened = true;
            for (Byte t : this.order) {
                if (t == (byte)this.posBigTable) continue;
                this.fetchNextGroup(t);
            }
        }
        byte alias = (byte)tag;
        ArrayList<Object> key = JoinUtil.computeKeys(row, (List)this.joinKeys.get(alias), (List)this.joinKeysObjectInspectors.get(alias));
        ArrayList<Object> value = JoinUtil.computeValues(row, (List)this.joinValues.get(alias), (List)this.joinValuesObjectInspectors.get(alias), (List)this.joinFilters.get(alias), (List)this.joinFilterObjectInspectors.get(alias), this.filterMap == null ? null : this.filterMap[alias]);
        boolean nextKeyGroup = this.processKey(alias, key);
        if (nextKeyGroup) {
            this.nextGroupStorage[alias].add(value);
            this.foundNextKeyGroup[tag] = true;
            if (tag != this.posBigTable) {
                return;
            }
        }
        this.reportProgress();
        ++this.numMapRowsRead;
        if (nextKeyGroup) {
            assert (tag == (byte)this.posBigTable);
            List<Byte> smallestPos = null;
            while ((smallestPos = this.joinOneGroup()) != null && smallestPos.size() > 0 && !smallestPos.contains((byte)this.posBigTable)) {
            }
            return;
        }
        assert (!nextKeyGroup);
        this.candidateStorage[tag].add(value);
    }

    private void joinFinalLeftData() throws HiveException {
        List<Byte> ret;
        RowContainer<ArrayList<Object>> bigTblRowContainer = this.candidateStorage[this.posBigTable];
        boolean allFetchDone = this.allFetchDone();
        while (bigTblRowContainer != null && bigTblRowContainer.size() > 0L && !allFetchDone) {
            this.joinOneGroup();
            bigTblRowContainer = this.candidateStorage[this.posBigTable];
            allFetchDone = this.allFetchDone();
        }
        while (!allFetchDone && (ret = this.joinOneGroup()) != null && ret.size() != 0) {
            this.reportProgress();
            ++this.numMapRowsRead;
            allFetchDone = this.allFetchDone();
        }
        boolean dataInCache = true;
        block2: while (dataInCache) {
            int i$;
            Byte[] arr$ = this.order;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                byte t = arr$[i$];
                if (!this.foundNextKeyGroup[t] || this.nextKeyWritables[t] == null) continue;
                this.promoteNextGroupToCandidate(t);
            }
            this.joinOneGroup();
            dataInCache = false;
            arr$ = this.order;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                byte r = arr$[i$];
                if (this.candidateStorage[r].size() <= 0L) continue;
                dataInCache = true;
                continue block2;
            }
        }
    }

    private boolean allFetchDone() {
        boolean allFetchDone = true;
        for (Byte tag : this.order) {
            if (tag == (byte)this.posBigTable) continue;
            allFetchDone = allFetchDone && this.fetchDone[tag];
        }
        return allFetchDone;
    }

    private List<Byte> joinOneGroup() throws HiveException {
        int[] smallestPos = this.findSmallestKey();
        List<Byte> listOfNeedFetchNext = null;
        if (smallestPos != null && (listOfNeedFetchNext = this.joinObject(smallestPos)).size() > 0) {
            for (Byte b : listOfNeedFetchNext) {
                this.fetchNextGroup(b);
            }
        }
        return listOfNeedFetchNext;
    }

    private List<Byte> joinObject(int[] smallestPos) throws HiveException {
        byte index;
        ArrayList<Byte> needFetchList = new ArrayList<Byte>();
        for (index = (byte)(smallestPos.length - 1); index >= 0; index = (byte)(index - 1)) {
            if (smallestPos[index] > 0 || this.keyWritables[index] == null) {
                this.putDummyOrEmpty(index);
                continue;
            }
            this.storage.put(index, this.candidateStorage[index]);
            needFetchList.add(index);
            if (smallestPos[index] < 0) break;
        }
        for (index = (byte)(index - 1); index >= 0; index = (byte)(index - 1)) {
            this.putDummyOrEmpty(index);
        }
        this.checkAndGenObject();
        for (Byte pos : needFetchList) {
            this.candidateStorage[pos].clear();
            this.keyWritables[pos.byteValue()] = null;
        }
        return needFetchList;
    }

    private void fetchNextGroup(Byte t) throws HiveException {
        if (this.foundNextKeyGroup[t]) {
            if (this.nextKeyWritables[t] != null) {
                this.promoteNextGroupToCandidate(t);
            } else {
                this.keyWritables[t.byteValue()] = null;
                this.candidateStorage[t.byteValue()] = null;
                this.nextGroupStorage[t.byteValue()] = null;
            }
            this.foundNextKeyGroup[t.byteValue()] = false;
        }
        if (t == (byte)this.posBigTable) {
            return;
        }
        while (!this.foundNextKeyGroup[t] && !this.fetchDone[t]) {
            this.fetchOneRow(t);
        }
        if (!this.foundNextKeyGroup[t] && this.fetchDone[t]) {
            this.nextKeyWritables[t.byteValue()] = null;
        }
    }

    private void promoteNextGroupToCandidate(Byte t) throws HiveException {
        this.keyWritables[t.byteValue()] = this.nextKeyWritables[t];
        this.nextKeyWritables[t.byteValue()] = null;
        RowContainer<ArrayList<Object>> oldRowContainer = this.candidateStorage[t];
        oldRowContainer.clear();
        this.candidateStorage[t.byteValue()] = this.nextGroupStorage[t];
        this.nextGroupStorage[t.byteValue()] = oldRowContainer;
    }

    private int compareKeys(List<Object> k1, List<Object> k2) {
        int ret = 0;
        ret = k1.size() - k2.size();
        if (ret != 0) {
            return ret;
        }
        for (int i = 0; i < k1.size(); ++i) {
            WritableComparable key_1 = (WritableComparable)k1.get(i);
            WritableComparable key_2 = (WritableComparable)k2.get(i);
            if (key_1 == null && key_2 == null) {
                return this.nullsafes != null && this.nullsafes[i] ? 0 : -1;
            }
            if (key_1 == null) {
                return -1;
            }
            if (key_2 == null) {
                return 1;
            }
            ret = WritableComparator.get(key_1.getClass()).compare(key_1, key_2);
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }

    private void putDummyOrEmpty(Byte i) {
        if (this.noOuterJoin) {
            this.storage.put(i, this.emptyList);
        } else {
            this.storage.put(i, this.dummyObjVectors[i.intValue()]);
        }
    }

    private int[] findSmallestKey() {
        int[] result = new int[this.order.length];
        ArrayList<Object> smallestOne = null;
        Byte[] arr$ = this.order;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte i = arr$[i$];
            ArrayList<Object> key = this.keyWritables[i];
            if (key == null) continue;
            if (smallestOne == null) {
                smallestOne = key;
                result[i] = -1;
                continue;
            }
            result[i] = this.compareKeys(key, smallestOne);
            if (result[i] >= 0) continue;
            smallestOne = key;
        }
        return smallestOne == null ? null : result;
    }

    private boolean processKey(byte alias, ArrayList<Object> key) throws HiveException {
        ArrayList<Object> keyWritable = this.keyWritables[alias];
        if (keyWritable == null) {
            this.keyWritables[alias] = key;
            return false;
        }
        int cmp = this.compareKeys(key, keyWritable);
        if (cmp != 0) {
            this.nextKeyWritables[alias] = key;
            return true;
        }
        return false;
    }

    private void setUpFetchContexts(String alias, MergeQueue mergeQueue) throws HiveException {
        mergeQueue.clearFetchContext();
        String currentInputFile = this.getExecContext().getCurrentInputFile();
        BucketMapJoinContext bucketMatcherCxt = this.localWork.getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = (BucketMatcher)ReflectionUtils.newInstance(bucketMatcherCls, null);
        this.getExecContext().setFileId(bucketMatcherCxt.createFileId(currentInputFile));
        LOG.info((Object)("set task id: " + this.getExecContext().getFileId()));
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputFile, bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        mergeQueue.setupContext(aliasFiles);
    }

    private void fetchOneRow(byte tag) {
        String table = this.tagToAlias.get(tag);
        MergeQueue mergeQueue = this.aliasToMergeQueue.get(table);
        Operator<? extends OperatorDesc> forwardOp = this.localWork.getAliasToWork().get(table);
        try {
            InspectableObject row = mergeQueue.getNextRow();
            if (row == null) {
                this.fetchDone[tag] = true;
                return;
            }
            forwardOp.process(row.o, 0);
            if (forwardOp.getDone()) {
                this.fetchDone[tag] = true;
            }
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map local work failed", e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        MergeQueue mergeQueue;
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        if (this.inputFileChanged || !this.firstFetchHappened) {
            for (Map.Entry<String, MergeQueue> entry : this.aliasToMergeQueue.entrySet()) {
                String alias = entry.getKey();
                mergeQueue = entry.getValue();
                this.setUpFetchContexts(alias, mergeQueue);
            }
            this.firstFetchHappened = true;
            for (Byte t : this.order) {
                if (t == (byte)this.posBigTable) continue;
                this.fetchNextGroup(t);
            }
            this.inputFileChanged = false;
        }
        this.joinFinalLeftData();
        for (Byte alias : this.order) {
            if (alias != (byte)this.posBigTable) {
                this.fetchDone[alias.byteValue()] = false;
            }
            this.foundNextKeyGroup[alias.byteValue()] = false;
        }
        this.localWorkInited = false;
        super.closeOp(abort);
        for (Map.Entry<String, MergeQueue> entry : this.aliasToMergeQueue.entrySet()) {
            String alias = entry.getKey();
            mergeQueue = entry.getValue();
            Operator<? extends OperatorDesc> forwardOp = this.localWork.getAliasToWork().get(alias);
            forwardOp.close(abort);
            mergeQueue.clearFetchContext();
        }
    }

    @Override
    protected boolean allInitializedParentsAreClosed() {
        return true;
    }

    @Override
    public String getName() {
        return SMBMapJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    private class MergeQueue
    extends PriorityQueue<Integer> {
        private final String alias;
        private final FetchWork fetchWork;
        private final JobConf jobConf;
        transient int counter;
        transient FetchOperator[] segments;
        transient List<ExprNodeEvaluator> keyFields;
        transient List<ObjectInspector> keyFieldOIs;
        transient Integer currentMinSegment;
        transient ObjectPair<List<Object>, InspectableObject>[] keys;

        public MergeQueue(String alias, FetchWork fetchWork, JobConf jobConf) {
            this.alias = alias;
            this.fetchWork = fetchWork;
            this.jobConf = jobConf;
        }

        public void setupContext(List<Path> paths) throws HiveException {
            int i;
            int segmentLen = paths.size();
            FetchOperator[] segments = this.segmentsForSize(segmentLen);
            for (i = 0; i < segmentLen; ++i) {
                Path path = paths.get(i);
                if (segments[i] == null) {
                    segments[i] = new FetchOperator(this.fetchWork, new JobConf((Configuration)this.jobConf));
                }
                segments[i].setupContext(Arrays.asList(path));
            }
            this.initialize(segmentLen);
            for (i = 0; i < segmentLen; ++i) {
                if (!this.nextHive(i)) continue;
                this.put(i);
            }
            this.counter = 0;
        }

        private FetchOperator[] segmentsForSize(int segmentLen) {
            if (this.segments == null || this.segments.length < segmentLen) {
                FetchOperator[] newSegments = new FetchOperator[segmentLen];
                ObjectPair[] newKeys = new ObjectPair[segmentLen];
                if (this.segments != null) {
                    System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
                    System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
                }
                this.segments = newSegments;
                this.keys = newKeys;
            }
            return this.segments;
        }

        public void clearFetchContext() throws HiveException {
            if (this.segments != null) {
                for (FetchOperator op : this.segments) {
                    if (op == null) continue;
                    op.clearFetchContext();
                }
            }
        }

        protected boolean lessThan(Object a, Object b) {
            return SMBMapJoinOperator.this.compareKeys(this.keys[(Integer)a].getFirst(), this.keys[(Integer)b].getFirst()) < 0;
        }

        public final InspectableObject getNextRow() throws IOException {
            Integer current;
            if (this.currentMinSegment != null) {
                this.adjustPriorityQueue(this.currentMinSegment);
            }
            if ((current = (Integer)this.top()) == null) {
                LOG.info((Object)("MergeQueue forwarded " + this.counter + " rows"));
                return null;
            }
            ++this.counter;
            this.currentMinSegment = current;
            return this.keys[this.currentMinSegment].getSecond();
        }

        private void adjustPriorityQueue(Integer current) throws IOException {
            if (this.nextIO(current)) {
                this.adjustTop();
            } else {
                this.pop();
            }
        }

        private boolean nextHive(Integer current) throws HiveException {
            try {
                return this.next(current);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }

        private boolean nextIO(Integer current) throws IOException {
            try {
                return this.next(current);
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }

        private boolean next(Integer current) throws IOException, HiveException {
            InspectableObject nextRow;
            if (this.keyFields == null) {
                byte tag = SMBMapJoinOperator.this.tagForAlias(this.alias);
                this.keyFields = (List)SMBMapJoinOperator.this.joinKeys.get(tag);
                this.keyFieldOIs = (List)SMBMapJoinOperator.this.joinKeysObjectInspectors.get(tag);
            }
            if ((nextRow = this.segments[current].getNextRow()) != null) {
                if (this.keys[current] == null) {
                    this.keys[current.intValue()] = new ObjectPair();
                }
                this.keys[current].setFirst(JoinUtil.computeKeys(nextRow.o, this.keyFields, this.keyFieldOIs));
                this.keys[current].setSecond(nextRow);
                return true;
            }
            this.keys[current.intValue()] = null;
            return false;
        }
    }
}

